#pragma once

//! @file Mix/Matrix4x4.h
//! @brief 4x4sNXCN[ht@C

#include "Mix/Vector3.h"

namespace Mix{

	//! @class Matrix4x4
	//! @brief 4x4sNX
	class _MIX_DLL_API Matrix4x4
	{
	public:
		union
		{
			struct
			{
				Float32 m00;	//!< vf ( 0, 0 ) ̒l
				Float32 m01;	//!< vf ( 0, 1 ) ̒l
				Float32 m02;	//!< vf ( 0, 2 ) ̒l
				Float32 m03;	//!< vf ( 0, 3 ) ̒l
				Float32 m10;	//!< vf ( 1, 0 ) ̒l
				Float32 m11;	//!< vf ( 1, 1 ) ̒l
				Float32 m12;	//!< vf ( 1, 2 ) ̒l
				Float32 m13;	//!< vf ( 1, 3 ) ̒l
				Float32 m20;	//!< vf ( 2, 0 ) ̒l
				Float32 m21;	//!< vf ( 2, 1 ) ̒l
				Float32 m22;	//!< vf ( 2, 2 ) ̒l
				Float32 m23;	//!< vf ( 2, 3 ) ̒l
				Float32 m30;	//!< vf ( 3, 0 ) ̒l
				Float32 m31;	//!< vf ( 3, 1 ) ̒l
				Float32 m32;	//!< vf ( 3, 2 ) ̒l
				Float32 m33;	//!< vf ( 3, 3 ) ̒l
			};

			Float32 m[4][4];	//!< s̗vf
		};

	public:
		//! @brief RXgN^
		Matrix4x4( void );

		//! @brief RXgN^
		//! @param[in] r ]\ Mix::Quaternion NX
		Matrix4x4( const Mix::Quaternion& r );
		//! @brief RXgN^
		//! @param[in] r ]\ Mix::Quaternion NX
		//! @param[in] t ʒu\ Mix::Vector3 NX
		Matrix4x4( const Mix::Quaternion& r, const Mix::Vector3& t );
		//! @brief RXgN^
		//! @param[in] s XP[\ Mix::Vector3 NX
		//! @param[in] r ]\ Mix::Quaternion NX
		//! @param[in] t ʒu\ Mix::Vector3 NX
		Matrix4x4( const Mix::Vector3& s, const Mix::Quaternion& r, const Mix::Vector3& t );

		//! @brief RXgN^
		//! @param[in] _m00 m[0][0] ̒l
		//! @param[in] _m01 m[0][1] ̒l
		//! @param[in] _m02 m[0][2] ̒l
		//! @param[in] _m03 m[0][3] ̒l
		//! @param[in] _m10 m[1][0] ̒l
		//! @param[in] _m11 m[1][1] ̒l
		//! @param[in] _m12 m[1][2] ̒l
		//! @param[in] _m13 m[1][3] ̒l
		//! @param[in] _m20 m[2][0] ̒l
		//! @param[in] _m21 m[2][1] ̒l
		//! @param[in] _m22 m[2][2] ̒l
		//! @param[in] _m23 m[2][3] ̒l
		//! @param[in] _m30 m[3][0] ̒l
		//! @param[in] _m31 m[3][1] ̒l
		//! @param[in] _m32 m[3][2] ̒l
		//! @param[in] _m33 m[3][3] ̒l
		Matrix4x4( Float32 _m00, Float32 _m01, Float32 _m02, Float32 _m03,
				   Float32 _m10, Float32 _m11, Float32 _m12, Float32 _m13,
				   Float32 _m20, Float32 _m21, Float32 _m22, Float32 _m23,
				   Float32 _m30, Float32 _m31, Float32 _m32, Float32 _m33 );
		//! @brief Rs[RXgN^
		//! @param[in] mm s
		Matrix4x4( const Matrix4x4& mm );

	public:
		//! @brief XP[擾܂
		//! @return XP[\ Mix::Vector3 NX
		Mix::Vector3 GetScaling( void ) const;
		//! @brief XP[ݒ肵܂
		//! @param[in] s XP[l
		void SetScaling( Float32 s );
		//! @brief XP[ݒ肵܂
		//! @param[in] sx X̃XP[l
		//! @param[in] sy ỸXP[l
		//! @param[in] sz Z̃XP[l
		void SetScaling( Float32 sx, Float32 sy, Float32 sz );
		//! @brief XP[ݒ肵܂
		//! @param[in] s XP[
		void SetScaling( const Vector3& s );

		//! @brief ]擾܂
		//! @return ]\ Mix::Matrix4x4 NXԂ܂
		Mix::Quaternion GetRotation( void ) const;
		//! @brief ]ݒ肵܂
		//! @param[in] rot ]\ Mix::Quaternion NX
		void SetRotation( const Mix::Quaternion& rot );
		//! @brief X]ݒ肵܂
		//! @param[in] r ]p( WAP )
		void SetRotationX( Float32 r );
		//! @brief Y]ݒ肵܂
		//! @param[in] r ]p( WAP )
		void SetRotationY( Float32 r );
		//! @brief Z]ݒ肵܂
		//! @param[in] r ]p( WAP )
		void SetRotationZ( Float32 r );

		//! @brief sړ擾܂
		//! @return sړ\ Mix::Vector3 NX
		Mix::Vector3 GetTranslation( void ) const;
		//! @brief sړݒ肵܂
		//! @param[in] tx Ẍړ
		//! @param[in] ty Ÿړ
		//! @param[in] tz Z̈ړ
		void SetTranslation( Float32 tx, Float32 ty, Float32 tz );
		//! @brief sړݒ肵܂
		//! @param[in] t ړ
		void SetTranslation( const Vector3& t );

		//! @brief w肵̃xNg擾܂
		//! @param[in] index s̃CfbNX( 0`3 )
		//! @return ̃xNg\ Mix::Vector4 NXԂ܂
		Mix::Vector4 GetColumn( UInt32 index ) const;
		//! @brief w肵ɃxNgݒ肵܂
		//! @param[in] index ̃CfbNX( 0`3 )
		//! @param[in] v ݒ肷xNg\ Mix::Vector4 NX
		void SetColumn( UInt32 index, const Mix::Vector4& v );

		//! @brief w肵s̃xNg擾܂
		//! @param[in] index s̃CfbNX( 0`3 )
		//! @return s̃xNg\ Mix::Vector4 NXԂ܂
		Mix::Vector4 GetRow( UInt32 index ) const;
		//! @brief w肵sɃxNgݒ肵܂
		//! @param[in] index s̃CfbNX( 0`3 )
		//! @param[in] v ݒ肷xNg\ Mix::Vector4 NX
		void SetRow( UInt32 index, const Mix::Vector4& v );

		//! @brief gtsɂ܂
		void Inverse( void );
		//! @brief g̋tsԂ܂
		//! @return g̋ts\ Mix::Matrix4x4 NX
		Mix::Matrix4x4 ToInverse( void ) const;

		//! @brief g]usɂ܂
		void Transpose( void );
		//! @brief g̓]usԂ܂
		//! @return g̋ts\ Mix::Matrix4x4 NX
		Mix::Matrix4x4 ToTranspose( void ) const;

		//! @brief IC[p(XYZ)ɕϊ܂
		//! @return IC[pɕϊe̊px\ Mix::Vector3 NXԂ܂
		Mix::Vector3 ToEulerXYZ( void ) const;
		//! @brief IC[p(XZY)ɕϊ܂
		//! @return IC[pɕϊe̊px\ Mix::Vector3 NXԂ܂
		Mix::Vector3 ToEulerXZY( void ) const;
		//! @brief IC[p(YXZ)ɕϊ܂
		//! @return IC[pɕϊe̊px\ Mix::Vector3 NXԂ܂
		Mix::Vector3 ToEulerYXZ( void ) const;
		//! @brief IC[p(YZX)ɕϊ܂
		//! @return IC[pɕϊe̊px\ Mix::Vector3 NXԂ܂
		Mix::Vector3 ToEulerYZX( void ) const;
		//! @brief IC[p(ZXY)ɕϊ܂
		//! @return IC[pɕϊe̊px\ Mix::Vector3 NXԂ܂
		Mix::Vector3 ToEulerZXY( void ) const;
		//! @brief IC[p(ZYX)ɕϊ܂
		//! @return IC[pɕϊe̊px\ Mix::Vector3 NXԂ܂
		Mix::Vector3 ToEulerZYX( void ) const;

		//! @brief ̃xNg܂Ƃ߂ĕϊ܂
		//! @param[in,out] vectors ϊxNg\ Mix::Vector3 NX̔z
		//! @param[in] numVector ϊxNg̐
		void Transform( Mix::Vector3* vectors, UInt32 numVector ) const;
		//! @brief ̃xNg܂Ƃ߂ĕϊ܂
		//! @param[in] srcVectors ϊxNg\ Mix::Vector3 NX̔z
		//! @param[in] dstVectors ϊxNg Mix::Vector3 NX̔z
		//! @param[in] numVector ϊxNg̐
		void Transform( const Mix::Vector3* srcVectors, Mix::Vector3* dstVectors, UInt32 numVector ) const;

		//! @brief ̃xNg܂Ƃ߂ĕϊ܂
		//! @param[in,out] vectors ϊxNg\ Mix::Vector4 NX̔z
		//! @param[in] numVector ϊxNg̐
		void Transform( Mix::Vector4* vectors, UInt32 numVector ) const;
		//! @brief ̃xNg܂Ƃ߂ĕϊ܂
		//! @param[in] srcVectors ϊxNg\ Mix::Vector4 NX̔z
		//! @param[in] dstVectors ϊxNg Mix::Vector4 NX̔z
		//! @param[in] numVector ϊxNg̐
		void Transform( const Mix::Vector4* srcVectors, Mix::Vector4* dstVectors, UInt32 numVector ) const;

		//! @brief xNgϊ܂( ړ͍s܂ )
		//! @param[in] v ϊxNg\ Mix::Vector3 NX
		//! @return ϊ̃xNg\ Mix::Vector3 NX Ԃ܂
		Mix::Vector3 TransformSR( const Mix::Vector3& v ) const;
		//! @brief xNg܂Ƃ߂ĕϊ܂( ړ͍s܂ )
		//! @param[in,out] vectors ϊxNg\ Mix::Vector3 NX̔z
		//! @param[in] numVector ϊxNg̐
		void TransformSR( Mix::Vector3* vectors, UInt32 numVector ) const;
		//! @brief ̃xNg܂Ƃ߂ĕϊ܂( ړ͍s܂ )
		//! @param[in] srcVectors ϊxNg\ Mix::Vector3 NX̔z
		//! @param[in] dstVectors ϊxNg Mix::Vector3 NX̔z
		//! @param[in] numVector ϊxNg̐
		void TransformSR( const Mix::Vector3* srcVectors, Mix::Vector3* dstVectors, UInt32 numVector ) const;

		//! @brief xNgϊ܂( ړ͍s܂ )
		//! @param[in] v ϊxNg\ Mix::Vector4 NX
		//! @return ϊ̃xNg\ Mix::Vector4 NX Ԃ܂
		Mix::Vector4 TransformSR( const Mix::Vector4& v ) const;
		//! @brief xNg܂Ƃ߂ĕϊ܂( ړ͍s܂ )
		//! @param[in,out] vectors ϊxNg\ Mix::Vector4 NX̔z
		//! @param[in] numVector ϊxNg̐
		void TransformSR( Mix::Vector4* vectors, UInt32 numVector ) const;
		//! @brief ̃xNg܂Ƃ߂ĕϊ܂( ړ͍s܂ )
		//! @param[in] srcVectors ϊxNg\ Mix::Vector4 NX̔z
		//! @param[in] dstVectors ϊxNg Mix::Vector4 NX̔z
		//! @param[in] numVector ϊxNg̐
		void TransformSR( const Mix::Vector4* srcVectors, Mix::Vector4* dstVectors, UInt32 numVector ) const;

		//! @brief XP[OA[e[VAgX[Vw肵čs\܂
		//! @param[out] s XP[O\ Mix::Vector3 NX
		//! @param[out] r [e[V\ Mix::Quaternion NX
		//! @param[out] t gX[V\ Mix::Vector3 NX
		void Compose( const Mix::Vector3& s, const Mix::Quaternion& r, const Mix::Vector3& t );

		//! @brief XP[OA[e[VAgX[Vɕ܂
		//! @param[out] s XP[O\ Mix::Vector3 NX
		//! @param[out] r [e[V\ Mix::Quaternion NX
		//! @param[out] t gX[V\ Mix::Vector3 NX
		//! @return ꍇ True Ԃ܂
		//! @note
		//! XP[OXYZ 0.0f ܂܂ꍇA<br>
		//! ̃\bh [e[Vɑ΂ ( 0.0f, 0.0f, 0.0f, 1.0f ) ݒ肵 False Ԃ܂B<bt>
		//! XP[OAgX[Vɑ΂Ă͐̒l̂܂ܓn܂B
		Boolean Decompose( Mix::Vector3& s, Mix::Quaternion& r, Mix::Vector3& t ) const;

		//! @brief w肵ōsč\܂
		//! @param[in] bScaling XP[O܂ޏꍇ True
		//! @param[in] bRotation [e[V܂ޏꍇ True
		//! @param[in] bTranslation gX[V܂ޏꍇ True
		//! @return č\s\ Mix::Matrix4x4 NXԂ܂
		Mix::Matrix4x4 Remake( Boolean bScaling, Boolean bRotation, Boolean bTranslation ) const;

		//! @brief r
		//! @param[in] mat rs
		//! @return lꍇ True Ԃ܂
		Boolean operator == ( const Matrix4x4& mat ) const;
		//! @brief r
		//! @param[in] mat rs
		//! @return lȂꍇ True Ԃ܂
		Boolean operator != ( const Matrix4x4& mat ) const;

		//! @brief s܂
		//! @param[in] m s
		//! @return 
		Matrix4x4& operator = ( const Matrix4x4& m );
		//! @brief s񓯎mZ܂
		//! @param[in] m Zs
		//! @return 
		Matrix4x4& operator *= ( const Matrix4x4& m );
		//! @brief s񓯎mZ܂
		//! @param[in] m Z
		//! @return 
		Matrix4x4 operator * ( const Matrix4x4& m ) const;
		//! @brief xNgϊ܂
		//! @param[in] v ϊxNg
		//! @return 
		Vector3 operator * ( const Vector3& v ) const;
		//! @brief xNgϊ܂
		//! @param[in] v ϊxNg
		//! @return 
		Vector4 operator * ( const Vector4& v ) const;
		//! @brief xNgϊ܂
		//! @param[in] v ϊxNg
		//! @param[in] m ϊs
		//! @return 
		friend const Vector3 operator * ( const Vector3& v, const Matrix4x4& m )
		{
			return m * v;
		}

	public:
		//! @brief Wñr[s쐬܂
		//! @param[in] eye _\ Mix::Vector3 NX
		//! @param[in] at _\ Mix::Vector3 NX
		//! @param[in] up \ Mix::Vector3 NX
		//! @param[out] mat 쐬ꂽr[s\ Mix::Matrix4x4 NX
		static void LookAtLH( const Mix::Vector3& eye, const Mix::Vector3& at, const Mix::Vector3& up, Mix::Matrix4x4& mat );
		//! @brief Wñr[s쐬܂
		//! @param[in] rot ]\ Mix::Quaternion NX
		//! @param[in] at _\ Mix::Vector3 NX
		//! @param[in] dist _王_܂ł̋
		//! @param[out] mat 쐬ꂽr[s\ Mix::Matrix4x4 NX
		static void LookAtLH( const Mix::Quaternion& rot, const Mix::Vector3& at, Float32 dist, Mix::Matrix4x4& mat );
		//! @brief Wn̎ˉes쐬܂
		//! @param[in] fovY Yւ̎p( WAP )
		//! @param[in] aspect AXyNg( r[̍𕝂ŏZl )
		//! @param[in] nearZ ŏZl
		//! @param[in] farZ őZl
		//! @param[out] mat 쐬ꂽˉes\ Mix::Matrix4x4 NX
		static void PerspectiveFovLH( Float32 fovY, Float32 aspect, Float32 nearZ, Float32 farZ, Mix::Matrix4x4& mat );
		//! @brief Wn̐ˉes쐬܂
		//! @param[in] width 
		//! @param[in] height 
		//! @param[in] nearZ ŏZl
		//! @param[in] farZ őZl
		//! @param[out] mat 쐬ꂽˉes\ Mix::Matrix4x4 NX
		static void OrthoLH( Float32 width, Float32 height, Float32 nearZ, Float32 farZ, Mix::Matrix4x4& mat );
		//! @brief Wn̐ˉes쐬܂
		//! @param[in] min ŏl\ Mix::Vector3 NX
		//! @param[in] max ől\ Mix::Vector3 NX
		//! @param[out] mat 쐬ꂽˉes\ Mix::Matrix4x4 NX
		static void OrthoOffCenterLH( const Mix::Vector3& min, const Mix::Vector3& max, Mix::Matrix4x4& mat );

	public:
		//! @brief SĂ̗vf 0.0f ̍s擾܂
		//! @return s\ Matrix4x4 NXԂ܂
		static const Matrix4x4& Zero( void )
		{
			static const Matrix4x4 mat(	0.0f, 0.0f, 0.0f, 0.0f,
										0.0f, 0.0f, 0.0f, 0.0f,
										0.0f, 0.0f, 0.0f, 0.0f,
										0.0f, 0.0f, 0.0f, 0.0f );

			return mat;
		}

		//! @brief Pʍs擾܂
		//! @return Pʍs\ Matrix4x4 NXԂ܂
		static const Matrix4x4& Identity( void )
		{
			static const Mix::Matrix4x4 mat(	1.0f, 0.0f, 0.0f, 0.0f,
												0.0f, 1.0f, 0.0f, 0.0f,
												0.0f, 0.0f, 1.0f, 0.0f,
												0.0f, 0.0f, 0.0f, 1.0f );

			return mat;
		}
	};

}
