#pragma once

//! @file Mix/Interpolation.h
//! @brief C^[|[[VCN[ht@C

namespace Mix{

	//! @class Interpolation
	//! @brief ԃev[gNX
	//! @tparam T Ԃľ^
	template<typename T>
	class Interpolation
	{
	public:
		//! @brief fXgN^
		virtual ~Interpolation( void ) {}

	public:
		//! @brief nꂽ̒lɕԂɕKvȃf[^\z܂
		//! @param[in] pPoints Ԃl̈ʒuz
		//! @param[in] pValues Ԃlz
		//! @param[in] count z̗vf̐
		//! @return ꍇ True Ԃ܂
		//! @note ʒuzƒlz̗vf͓̐ɂKv܂B
		virtual Boolean Build( const Float32* pPoints, const T* pValues, UInt32 count ) = 0;
		//! @brief w肵CfbNẌʒu擾܂
		//! @param[in] index CfbNX( 0`GetCount )
		//! @return ʒuԂ܂
		virtual Float32 GetPoint( UInt32 index ) const = 0;
		//! @brief w肵CfbNX̒l擾܂
		//! @param[in] index CfbNX( 0`GetCount )
		//! @return lԂ܂
		virtual T GetValue( UInt32 index ) const = 0;
		//! @brief Ԃvf̐Ԃ܂
		//! @return vf̐Ԃ܂
		virtual UInt32 GetCount( void ) const = 0;

		//! @brief w肵ʒu̕ԂꂽlZo܂
		//! @param[in] point ʒu
		//! @return ԂꂽlԂ܂
		virtual T Calculate( Float32 point ) const = 0;
	};

	//! @class LinearF
	//! @brief `ԃNX( Float32 )
	class _MIX_DLL_API LinearF : public Interpolation<Float32>
	{
	private:
		class Impl;
		Impl* pImpl;

	public:
		//! @brief RXgN^
		LinearF( void );
		//! @brief fXgN^
		virtual ~LinearF( void );

	public:
		//! @brief nꂽ̒lɕԂɕKvȃf[^\z܂
		//! @param[in] pPoints Ԃl̈ʒuz
		//! @param[in] pValues Ԃlz
		//! @param[in] count z̗vf̐
		//! @return ꍇ True Ԃ܂
		virtual Boolean Build( const Float32* pPoints, const Float32* pValues, UInt32 count );
		//! @brief w肵CfbNẌʒu擾܂
		//! @param[in] index CfbNX( 0`GetCount )
		//! @return ʒuԂ܂
		virtual Float32 GetPoint( UInt32 index ) const;
		//! @brief w肵CfbNX̒l擾܂
		//! @param[in] index CfbNX( 0`GetCount )
		//! @return lԂ܂
		virtual Float32 GetValue( UInt32 index ) const;
		//! @brief Ԃvf̐Ԃ܂
		//! @return vf̐Ԃ܂
		virtual UInt32 GetCount( void ) const;

		//! @brief w肵ʒu̕ԂꂽlZo܂
		//! @param[in] point ʒu
		//! @return ԂꂽlԂ܂
		virtual Float32 Calculate( Float32 point ) const;
	};

	//! @class LinearV2
	//! @brief `ԃNX( Mix::Vector2 )
	class _MIX_DLL_API LinearV2 : public Interpolation<Mix::Vector2>
	{
	private:
		class Impl;
		Impl* pImpl;

	public:
		//! @brief RXgN^
		LinearV2( void );
		//! @brief fXgN^
		virtual ~LinearV2( void );

	public:
		//! @brief nꂽ̒lɕԂɕKvȃf[^\z܂
		//! @param[in] pPoints Ԃl̈ʒuz
		//! @param[in] pValues Ԃl\ Mix::Vector2 NX̔z
		//! @param[in] count z̗vf̐
		//! @return ꍇ True Ԃ܂
		virtual Boolean Build( const Float32* pPoints, const Mix::Vector2* pValues, UInt32 count );
		//! @brief w肵CfbNẌʒu擾܂
		//! @param[in] index CfbNX( 0`GetCount )
		//! @return ʒuԂ܂
		virtual Float32 GetPoint( UInt32 index ) const;
		//! @brief w肵CfbNX̒l擾܂
		//! @param[in] index CfbNX( 0`GetCount )
		//! @return l\ Mix::Vector2 NXԂ܂
		virtual Mix::Vector2 GetValue( UInt32 index ) const;
		//! @brief Ԃvf̐Ԃ܂
		//! @return vf̐Ԃ܂
		virtual UInt32 GetCount( void ) const;

		//! @brief w肵ʒu̕ԂꂽlZo܂
		//! @param[in] point ʒu
		//! @return Ԃꂽl\ Mix::Vector2 NXԂ܂
		virtual Mix::Vector2 Calculate( Float32 point ) const;
	};

	//! @class LinearV3
	//! @brief `ԃNX( Mix::Vector3 )
	class _MIX_DLL_API LinearV3 : public Interpolation<Mix::Vector3>
	{
	private:
		class Impl;
		Impl* pImpl;

	public:
		//! @brief RXgN^
		LinearV3( void );
		//! @brief fXgN^
		virtual ~LinearV3( void );

	public:
		//! @brief nꂽ̒lɕԂɕKvȃf[^\z܂
		//! @param[in] pPoints Ԃl̈ʒuz
		//! @param[in] pValues Ԃl\ Mix::Vector3 NX̔z
		//! @param[in] count z̗vf̐
		//! @return ꍇ True Ԃ܂
		virtual Boolean Build( const Float32* pPoints, const Mix::Vector3* pValues, UInt32 count );
		//! @brief w肵CfbNẌʒu擾܂
		//! @param[in] index CfbNX( 0`GetCount )
		//! @return ʒuԂ܂
		virtual Float32 GetPoint( UInt32 index ) const;
		//! @brief w肵CfbNX̒l擾܂
		//! @param[in] index CfbNX( 0`GetCount )
		//! @return l\ Mix::Vector3 NXԂ܂
		virtual Mix::Vector3 GetValue( UInt32 index ) const;
		//! @brief Ԃvf̐Ԃ܂
		//! @return vf̐Ԃ܂
		virtual UInt32 GetCount( void ) const;

		//! @brief w肵ʒu̕ԂꂽlZo܂
		//! @param[in] point ʒu
		//! @return Ԃꂽl\ Mix::Vector3 NXԂ܂
		virtual Mix::Vector3 Calculate( Float32 point ) const;
	};

	//! @class LinearV4
	//! @brief `ԃNX( Mix::Vector4 )
	class _MIX_DLL_API LinearV4 : public Interpolation<Mix::Vector4>
	{
	private:
		class Impl;
		Impl* pImpl;

	public:
		//! @brief RXgN^
		LinearV4( void );
		//! @brief fXgN^
		virtual ~LinearV4( void );

	public:
		//! @brief nꂽ̒lɕԂɕKvȃf[^\z܂
		//! @param[in] pPoints Ԃl̈ʒuz
		//! @param[in] pValues Ԃl\ Mix::Vector4 NX̔z
		//! @param[in] count z̗vf̐
		//! @return ꍇ True Ԃ܂
		virtual Boolean Build( const Float32* pPoints, const Mix::Vector4* pValues, UInt32 count );
		//! @brief w肵CfbNẌʒu擾܂
		//! @param[in] index CfbNX( 0`GetCount )
		//! @return ʒuԂ܂
		virtual Float32 GetPoint( UInt32 index ) const;
		//! @brief w肵CfbNX̒l擾܂
		//! @param[in] index CfbNX( 0`GetCount )
		//! @return l\ Mix::Vector4 NXԂ܂
		virtual Mix::Vector4 GetValue( UInt32 index ) const;
		//! @brief Ԃvf̐Ԃ܂
		//! @return vf̐Ԃ܂
		virtual UInt32 GetCount( void ) const;

		//! @brief w肵ʒu̕ԂꂽlZo܂
		//! @param[in] point ʒu
		//! @return Ԃꂽl\ Mix::Vector4 NXԂ܂
		virtual Mix::Vector4 Calculate( Float32 point ) const;
	};

	//! @class SplineF
	//! @brief RXvCԃNX( Float32 )
	class _MIX_DLL_API SplineF : public Interpolation<Float32>
	{
	private:
		class Impl;
		Impl* pImpl;

	public:
		//! @brief RXgN^
		SplineF( void );
		//! @brief fXgN^
		virtual ~SplineF( void );

	public:
		//! @brief nꂽ̒lɕԂɕKvȃf[^\z܂
		//! @param[in] pPoints Ԃl̈ʒuz
		//! @param[in] pValues Ԃlz
		//! @param[in] count z̗vf̐
		//! @return ꍇ True Ԃ܂
		virtual Boolean Build( const Float32* pPoints, const Float32* pValues, UInt32 count );
		//! @brief w肵CfbNẌʒu擾܂
		//! @param[in] index CfbNX( 0`GetCount )
		//! @return ʒuԂ܂
		virtual Float32 GetPoint( UInt32 index ) const;
		//! @brief w肵CfbNX̒l擾܂
		//! @param[in] index CfbNX( 0`GetCount )
		//! @return lԂ܂
		virtual Float32 GetValue( UInt32 index ) const;
		//! @brief Ԃvf̐Ԃ܂
		//! @return vf̐Ԃ܂
		virtual UInt32 GetCount( void ) const;

		//! @brief w肵ʒu̕ԂꂽlZo܂
		//! @param[in] point ʒu
		//! @return ԂꂽlԂ܂
		virtual Float32 Calculate( Float32 point ) const;
	};

	//! @class SplineV2
	//! @brief RXvCԃNX( Mix::Vector2 )
	class _MIX_DLL_API SplineV2 : public Interpolation<Mix::Vector2>
	{
	private:
		class Impl;
		Impl* pImpl;

	public:
		//! @brief RXgN^
		SplineV2( void );
		//! @brief fXgN^
		virtual ~SplineV2( void );

	public:
		//! @brief nꂽ̒lɕԂɕKvȃf[^\z܂
		//! @param[in] pPoints Ԃl̈ʒuz
		//! @param[in] pValues Ԃl\ Mix::Vector2 ̔z
		//! @param[in] count z̗vf̐
		//! @return ꍇ True Ԃ܂
		virtual Boolean Build( const Float32* pPoints, const Mix::Vector2* pValues, UInt32 count );
		//! @brief w肵CfbNẌʒu擾܂
		//! @param[in] index CfbNX( 0`GetCount )
		//! @return ʒuԂ܂
		virtual Float32 GetPoint( UInt32 index ) const;
		//! @brief w肵CfbNX̒l擾܂
		//! @param[in] index CfbNX( 0`GetCount )
		//! @return l\ Mix::Vector2 NXԂ܂
		virtual Mix::Vector2 GetValue( UInt32 index ) const;
		//! @brief Ԃvf̐Ԃ܂
		//! @return vf̐Ԃ܂
		virtual UInt32 GetCount( void ) const;

		//! @brief w肵ʒu̕ԂꂽlZo܂
		//! @param[in] point ʒu
		//! @return Ԃꂽl\ Mix::Vector2 NXԂ܂
		virtual Mix::Vector2 Calculate( Float32 point ) const;
	};

	//! @class SplineV3
	//! @brief RXvCԃNX( Mix::Vector3 )
	class _MIX_DLL_API SplineV3 : public Interpolation<Mix::Vector3>
	{
	private:
		class Impl;
		Impl* pImpl;

	public:
		//! @brief RXgN^
		SplineV3( void );
		//! @brief fXgN^
		virtual ~SplineV3( void );

	public:
		//! @brief nꂽ̒lɕԂɕKvȃf[^\z܂
		//! @param[in] pPoints Ԃl̈ʒuz
		//! @param[in] pValues Ԃl\ Mix::Vector3 ̔z
		//! @param[in] count z̗vf̐
		//! @return ꍇ True Ԃ܂
		virtual Boolean Build( const Float32* pPoints, const Mix::Vector3* pValues, UInt32 count );
		//! @brief w肵CfbNẌʒu擾܂
		//! @param[in] index CfbNX( 0`GetCount )
		//! @return ʒuԂ܂
		virtual Float32 GetPoint( UInt32 index ) const;
		//! @brief w肵CfbNX̒l擾܂
		//! @param[in] index CfbNX( 0`GetCount )
		//! @return l\ Mix::Vector3 NXԂ܂
		virtual Mix::Vector3 GetValue( UInt32 index ) const;
		//! @brief Ԃvf̐Ԃ܂
		//! @return vf̐Ԃ܂
		virtual UInt32 GetCount( void ) const;

		//! @brief w肵ʒu̕ԂꂽlZo܂
		//! @param[in] point ʒu
		//! @return Ԃꂽl\ Mix::Vector3 NXԂ܂
		virtual Mix::Vector3 Calculate( Float32 point ) const;
	};

	//! @class SplineV4
	//! @brief RXvCԃNX( Mix::Vector4 )
	class _MIX_DLL_API SplineV4 : public Interpolation<Mix::Vector4>
	{
	private:
		class Impl;
		Impl* pImpl;

	public:
		//! @brief RXgN^
		SplineV4( void );
		//! @brief fXgN^
		virtual ~SplineV4( void );

	public:
		//! @brief nꂽ̒lɕԂɕKvȃf[^\z܂
		//! @param[in] pPoints Ԃl̈ʒuz
		//! @param[in] pValues Ԃl\ Mix::Vector4 ̔z
		//! @param[in] count z̗vf̐
		//! @return ꍇ True Ԃ܂
		virtual Boolean Build( const Float32* pPoints, const Mix::Vector4* pValues, UInt32 count );
		//! @brief w肵CfbNẌʒu擾܂
		//! @param[in] index CfbNX( 0`GetCount )
		//! @return ʒuԂ܂
		virtual Float32 GetPoint( UInt32 index ) const;
		//! @brief w肵CfbNX̒l擾܂
		//! @param[in] index CfbNX( 0`GetCount )
		//! @return l\ Mix::Vector4 NXԂ܂
		virtual Mix::Vector4 GetValue( UInt32 index ) const;
		//! @brief Ԃvf̐Ԃ܂
		//! @return vf̐Ԃ܂
		virtual UInt32 GetCount( void ) const;

		//! @brief w肵ʒu̕ԂꂽlZo܂
		//! @param[in] point ʒu
		//! @return Ԃꂽl\ Mix::Vector4 NXԂ܂
		virtual Mix::Vector4 Calculate( Float32 point ) const;
	};
}
