#pragma once

//! @file Mix/Input/IManager.h
//! @brief Cvbg}l[WC^[tF[XCN[ht@C

#include "Mix/Reference.h"

namespace Mix{ namespace Input{

	//! @class IManager
	//! @brief Cvbg}l[WC^[tF[X
	class IManager : public Mix::Reference
	{
	protected:
		//! @brief fXgN^
		virtual ~IManager( void ){}

	public:
		//! @brief L[{[h擾܂
		//! @param[out] ppKeyboard 擾L[{[hn Mix::Input::IKeyboard C^[tF[X̃|C^̃AhX
		//! @return ꍇ True Ԃ܂
		virtual Boolean GetKeyboard( Mix::Input::IKeyboard** ppKeyboard ) = 0;

		//! @brief }EX擾܂
		//! @param[out] ppMouse 擾}EXn Mix::Input::IMouse C^[tF[X̃|C^̃AhX
		//! @return ꍇ True Ԃ܂
		virtual Boolean GetMouse( Mix::Input::IMouse** ppMouse ) = 0;

		//! @brief Q[pbh擾܂
		//! @param[in] port Q[pbh̃|[g( Mix::Input::GAMEPAD_PORT )
		//! @param[out] ppGamepad 擾Q[pbh\ Mix::Input::IGamepad C^[tF[X̃|C^̃AhX
		//! @return ꍇ True Ԃ܂
		virtual Boolean GetGamepad( UInt32 port, Mix::Input::IGamepad** ppGamepad ) = 0;
		//! @brief p\ȃQ[pbh擾܂
		//! @param[in] api D悷Q[pbhAPI
		//! @param[out] ppGamepad 擾Q[pbh\ Mix::Input::IGamepad C^[tF[X̃|C^̃AhX
		//! @return ꍇ True Ԃ܂
		//! @note api  Mix::Input::GAMEPAD_UNKNOWN w肵ꍇ XInput D悵܂
		virtual Boolean FindGamepad( Mix::Input::GAMEPAD_API api, Mix::Input::IGamepad** ppGamepad ) = 0;
	};

}}
