#pragma once

//! @file Mix/Input/IGamepad.h
//! @brief Q[pbhC^[tF[XCN[ht@C

#include "Mix/Reference.h"

namespace Mix{ namespace Input{

	//! @class IGamepad
	//! @brief Q[pbhC^[tF[X
	class IGamepad : public Mix::Reference
	{
	protected:
		//! @brief fXgN^
		virtual ~IGamepad( void ){}

	public:
		//! @brief {^̏Ԃ擾܂
		//! @param[in] index {^\ Mix::Input::GAMEPAD_BUTTON 񋓒萔
		//! @return {^̏Ԃ\ Mix::Input::SWITCH_STATE 񋓒萔̑gݍ킹Ԃ܂
		virtual UInt32 GetButtonState( UInt32 index ) const = 0;
		//! @brief gK[̏Ԃ擾܂
		//! @param[in] index gK[̃CfbNX( Mix::Input::GAMEPAD_LEFT  Mix::Input::GAMEPAD_RIGHT )
		//! @return gK[̏Ԃ( 0.0f`1.0f )Ԃ܂
		virtual Float32 GetTriggerState( UInt32 index ) const = 0;
		//! @brief XeBbN̏Ԃ擾܂
		//! @param[in] index XeBbÑCfbNX( Mix::Input::GAMEPAD_LEFT  Mix::Input::GAMEPAD_RIGHT )
		//! @return XeBbN̏Ԃ\ Mix::Vector2 NXԂ܂
		virtual const Mix::Vector2& GetStickState( UInt32 index ) const = 0;

		//! @brief ̃C^[tF[Xp\ȂǂmF܂
		//! @return ̃C^[tF[Xp\ȏꍇ True Ԃ܂
		virtual Boolean IsAvailable( void ) const = 0;

		//! @brief ̃C^[tF[XŎgpĂAPI擾܂
		//! @return gpĂAPI\ Mix::Input::GAMEPAD_API 񋓒萔Ԃ܂
		virtual Mix::Input::GAMEPAD_API GetAPI( void ) const = 0;

		//! @brief {^̊蓖Ăݒ肵܂( DirectInput )
		//! @param[in] targetIndex {^̊蓖Đ{^\ Mix::Input::GAMEPAD_BUTTON 񋓒萔
		//! @param[in] sourceIndex {^̊蓖Č{^( 0`31 )A POV( 0`7 )
		virtual void SetButtonAssignment( UInt32 targetIndex, UInt32 sourceIndex ) = 0;
		//! @brief {^̊蓖Č擾܂( DirectInput )
		//! @param[in] targetIndex {^̊蓖Đ\ Mix::Input::GAMEPAD_BUTTON 񋓒萔
		//! @return {^̊蓖ČԂ܂
		//! @note {^̊蓖Ă( XInput )A targetIndex ͈͂𒴂Ăꍇ 0xFFFFFFFF Ԃ܂
		virtual UInt32 GetButtonAssignment( UInt32 targetIndex ) const = 0; 

		//! @brief gK[̊蓖Ăݒ肵܂( DirectInput )
		//! @param[in] targetIndex gK[̊蓖Đ( Mix::Input::GAMEPAD_LEFT  Mix::Input::GAMEPAD_RIGHT )
		//! @param[in] sourceIndex gK[̊蓖Č{^( 0`31 )
		virtual void SetTriggerAssignment( UInt32 targetIndex, UInt32 sourceIndex ) = 0; 
		//! @brief gK[̊蓖Č{^擾܂( DirectInput )
		//! @param[in] targetIndex gK[̊蓖Đ( Mix::Input::GAMEPAD_LEFT  Mix::Input::GAMEPAD_RIGHT )
		//! @return gK[̊蓖Č{^Ԃ܂
		//! @note gK[̊蓖Ă( XInput )A targetIndex ͈͂𒴂Ăꍇ 0xFFFFFFFF Ԃ܂
		virtual UInt32 GetTriggerAssignment( UInt32 targetIndex ) const = 0; 

		//! @brief gK[臒lݒ肵܂( XInput )
		//! @param[in] index gK[̃CfbNX( Mix::Input::GAMEPAD_LEFT  Mix::Input::GAMEPAD_RIGHT )
		//! @param[in] threshold gK[臒l( 0`255 )
		virtual void SetTriggerThreshold( UInt32 index, UInt8 threshold ) = 0;
		//! @brief gK[臒l擾܂( XInput )
		//! @param[in] index gK[̃CfbNX( Mix::Input::GAMEPAD_LEFT  Mix::Input::GAMEPAD_RIGHT )
		//! @return gK[臒lԂ܂
		//! @note gK[臒l( DirectInput )̏ꍇ Mix::Input::GAMEPAD_TRIGGER_RESOLUTION Ԃ܂
		virtual UInt8 GetTriggerThreshold( UInt32 index ) const = 0;

		//! @brief XeBbÑfbh][ݒ肵܂
		//! @param[in] index XeBbÑCfbNX( Mix::Input::GAMEPAD_LEFT  Mix::Input::GAMEPAD_RIGHT )
		//! @param[in] deadZone fbh][( 0`32767 )
		virtual void SetStickDeadZone( UInt32 index, Int16 deadZone ) = 0;
		//! @brief XeBbÑfbh][擾܂
		//! @param[in] index XeBbÑCfbNX( Mix::Input::GAMEPAD_LEFT  Mix::Input::GAMEPAD_RIGHT )
		//! @return XeBbÑfbh][Ԃ܂
		//! @note index ͈͂𒴂Ăꍇ Mix::Input::GAMEPAD_STICK_RESOLUTION Ԃ܂
		virtual Int16 SetStickDeadZone( UInt32 index ) const = 0;
	};

}}
