#pragma once

//! @file Mix/IWindow.h
//! @brief EBhEC^[tF[XCN[ht@C

#include "Mix/Reference.h"
#include "Mix/Delegate.h"

namespace Mix{

	class IWindow;

	//! @typedef MessageHandler
	//! @brief bZ[Wnh[
	typedef Mix::Delegate04<Boolean, IWindow*, UInt32, WPARAM, LPARAM> MessageHandler;

	//! @class IWindow
	//! @brief EBhEC^[tF[X
	class IWindow : public Mix::Reference
	{
	protected:
		//! @brief fXgN^
		virtual ~IWindow( void ){}

	public:
		//! @brief bZ[Wnho^܂
		//! @param messageHandler bZ[Wnh
		virtual void RegisterMessageHandler( const MessageHandler& messageHandler ) = 0;
		//! @brief bZ[Wnh̓o^܂
		//! @param messageHandler bZ[Wnh
		virtual void RemoveMessageHandler( const MessageHandler& messageHandler ) = 0;

		//! @brief bZ[W𑗐M܂
		//! @param[in] msg bZ[W
		//! @param[in] wParam ǉ1
		//! @param[in] lParam ǉ2
		//! @return bZ[W̌
		virtual LRESULT SendMessage( UInt32 msg, WPARAM wParam, LPARAM lParam ) = 0;
		//! @brief bZ[W𑗐M܂
		//! @param[in] msg bZ[W
		//! @param[in] wParam ǉ1
		//! @param[in] lParam ǉ2
		virtual void PostMessage( UInt32 msg, WPARAM wParam, LPARAM lParam ) = 0;

		//! @brief ^Cgݒ肵܂
		//! @param[in] pTitle ^Cg
		virtual void SetTitle( const wchar_t* pTitle ) = 0;
		//! @brief ^Cg擾܂
		//! @return ^CgԂ܂
		virtual const wchar_t* GetTitle( void ) const = 0;

		//! @brief j[ݒ肵܂
		//! @param[in] hMenu j[
		virtual void SetMenu( HMENU hMenu ) = 0;
		//! @brief j[擾܂
		//! @return j[Ԃ܂
		virtual HMENU GetMenu( void ) const = 0;

		//! @brief EBhE̕{^̏Ԃݒ肵܂
		//! @param[in] bEnable EBhE̕{^Lɂꍇ True<br>
		//! ɂꍇ False
		virtual void SetCloseEnabled( Boolean bEnable ) = 0;
		//! @brief EBhE̕{^̏Ԃ擾܂
		//! @return EBhE̕{^Lȏꍇ True Ԃ܂
		virtual Boolean GetCloseEnabled( void ) const = 0;

		//! @brief EBhE܂
		virtual void Close( void ) = 0;

		//! @brief x[XNCAgTCY擾܂
		//! @return x[XNCAgTCY\ Mix::Point NX
		virtual const Mix::Point& GetBaseSize( void ) const = 0;
		//! @brief NCAgTCY擾܂
		//! @return NCAgTCY\ Mix::Point NX
		virtual const Mix::Point& GetSize( void ) const = 0;

		//! @brief EBhEnh擾܂
		//! @return EBhEnh
		virtual HWND GetHandle( void ) const = 0;

		//! @brief EBhEANeBuANeBuǂmF܂
		//! @return ANeBuȏꍇ True Ԃ܂
		virtual Boolean GetActivated( void ) const = 0;
	};
}
