#pragma once

//! @file Mix/IEngine.h
//! @brief GWC^[tF[XCN[ht@C

#include "Mix/Reference.h"

namespace Mix{

	//! @class IEngine
	//! @brief GWC^[tF[X
	class IEngine : public Mix::Reference
	{
	protected:
		//! @brief fXgN^
		virtual ~IEngine( void ){}

	public:
		//! @brief XV܂
		//! @return XVpKvꍇ True Ԃ܂
		virtual Boolean Update( void ) = 0;

		//! @brief ŒFPS擾܂
		//! @return ŒFPSԂ܂
		virtual Int32 GetBaseFPS( void ) const = 0;
		//! @brief 1t[̌Œ̏v(bP)擾܂
		//! @return vԂԂ܂
		//! @note GetBaseDT() == 1.0f / GetBaseFPS()
		virtual Float32 GetBaseDT( void ) const = 0;

		//! @brief FPSZbg܂
		virtual void ResetFPS( void ) = 0;
		//! @brief FPS擾܂
		//! @return FPS
		virtual Float32 GetFPS( void ) const = 0;

		//! @brief 1t[̏v(bP)擾܂
		//! @return vԂԂ܂
		//! @note GetDT() == 1.0f / GetFPS()
		virtual Float32 GetDT( void ) const = 0;

		//! @brief b̃X[vԂ擾܂
		//! @return X[vԂԂ܂
		virtual Float32 GetSleepTimePerSec( void ) const = 0;

		//! @brief b̃X[vԂɓȂ񐔂擾܂
		//! @return X[vԂɓȂ񐔂Ԃ܂
		virtual Int32 GetInsomniaFrameCountPerSec( void ) const = 0;
		//! @brief X[vԂɓȂꍇɑ̃XbhɃ^CXCX( Sleep( 0 ) )t[
		//! @return t[Ԃ܂
		virtual Int32 GetInsomniaFrameMax( void ) const = 0;
	};

}
