#pragma once

//! @file Mix/Graphics/Utility/IText.h
//! @brief eLXgC^[tF[XCN[ht@C

#include "Mix/Reference.h"

namespace Mix{ namespace Graphics{ namespace Utility{

	//! @class IText
	//! @brief eLXgC^[tF[X
	class IText : public Mix::Reference
	{
	public:
		//! @enum FLAG
		//! @brief tO񋓒萔
		enum FLAG
		{
			HCENTER		= 0x01,	//!< ŃZ^O
			VCENTER		= 0x02,	//!< ŃZ^O
			WORDBREAK	= 0x04,	//!< `͂ݏoꍇ͉s
		};

		//! @struct CHARACTER_INFO
		//! @brief LN^[\
		struct CHARACTER_INFO
		{
			UInt32 line;				//!< s
			wchar_t code;				//!< R[h
			Mix::Rectangle bounds;		//!< ͂ދ`
			Mix::Rectangle cellBounds;	//!< Z͂ދ`
		};

		//! @struct LINE_INFO
		//! @brief C\
		struct LINE_INFO
		{
			Mix::Rectangle bounds;	//!< s͂ދ`
			UInt32 charStart;		//!< z̕Jnʒu
			UInt32 charCount;		//!< 
		};

	protected:
		//! @brief fXgN^
		virtual ~IText( void ){}

	public:
		//! @brief tHgݒ肵܂
		//! @param[in] pFont ݒ肷tHg\ Mix::Graphics::Utility::IFont C^[tF[X̃|C^
		virtual void SetFont( Mix::Graphics::Utility::IFont* pFont ) = 0;
		//! @brief ݐݒ肳ĂtHg̃|C^擾܂
		//! @return ݐݒ肳ĂtHg\ Mix::Graphics::Utility::IFont C^[tF[X̃|C^
		virtual Mix::Graphics::Utility::IFont* GetFontPtr( void ) const = 0;

		//! @brief ͈͂ݒ肵܂
		//! @param[in] range ͈͂\ Mix::Point NX
		virtual void SetRange( const Mix::Point& range ) = 0;
		//! @brief ݐݒ肳Ă͈͂擾܂
		//! @return ݐݒ肳Ă͈͂\ Mix::Point NX
		virtual const Mix::Point& GetRange( void ) const = 0;

		//! @brief tOݒ肵܂
		//! @param[in] flags tO\ IText::FLAG 񋓒萔
		virtual void SetFlags( UInt8 flags ) = 0;
		//! @brief ݐݒ肳ĂtO擾܂
		//! @return ݐݒ肳ĂtO\ IText::FLAG 񋓒萔
		virtual UInt8 GetFlags( void ) const = 0;

		//! @brief eLXgݒ肵܂
		//! @param[in] pText eLXg
		virtual void SetText( const wchar_t* pText ) = 0;
		//! @brief ݐݒ肳ĂeLXg擾܂
		//! @return ݐݒ肳ĂeLXg
		virtual const wchar_t* GetText( void ) const = 0;

		//! @brief ݐݒ肳Ăp[^̊ÂAeLXg̃CAEgXV܂
		virtual void Update( void ) = 0;

		//! @brief s擾܂
		//! @return sԂ܂
		virtual UInt32 GetLineCount( void ) const = 0;
		//! @brief s擾܂
		//! @return s\ IText::LINE_INFO \̂̔zԂ܂
		virtual const IText::LINE_INFO* GetLineInfoList( void ) const = 0;

		//! @brief 擾܂
		//! @return Ԃ܂
		virtual UInt32 GetCharacterCount( void ) const = 0;
		//! @brief 擾܂
		//! @return \ IText::CHARACTER_INFO \̂̔zԂ܂
		virtual const IText::CHARACTER_INFO* GetCharacterInfoList( void ) const = 0;
		//! @brief 擾܂
		//! @return \ wchar_t ^̔zԂ܂
		virtual const wchar_t* GetCharacterList( void ) const = 0;
	};

}}}
