#pragma once

//! @file Mix/Graphics/Utility/ILineArt.h
//! @brief CA[gC^[tF[XCN[ht@C

#include "Mix/Reference.h"
#include "Mix/Geometry/Sphere.h"
#include "Mix/Geometry/AABB.h"
#include "Mix/Geometry/OBB.h"
#include "Mix/Geometry/Frustum.h"

namespace Mix{ namespace Graphics{ namespace Utility{

	//! @class ILineArt
	//! @brief CA[gC^[tF[X
	class ILineArt : public Mix::Reference
	{
	protected:
		//! @brief fXgN^
		virtual ~ILineArt( void ){}

	public:
		//! @brief Fݒ肵܂
		//! @param[in] color F\ Mix::Vector4 NX
		virtual void SetColor( const Mix::Vector4& color ) = 0;
		//! @brief F擾܂
		//! return F\ Mix::Vector4 NXԂ܂
		virtual const Mix::Vector4& GetColor( void ) const = 0;

		//! @brief ϊsݒ肵܂
		//! @param[in] mat ϊs\ Mix::Matrix4x4 NX
		virtual void SetMatrix( const Mix::Matrix4x4& mat ) = 0;
		//! @brief ϊs擾܂
		//! @return ϊs\ Mix::Matrix4x4 NXԂ܂
		virtual const Mix::Matrix4x4& GetMatrix( void ) const = 0;

		//! @brief Cǉ܂
		//! @param[in] p0 ڂ̃|Cg\ Mix::Vector3 NX
		//! @param[in] p1 ڂ̃|Cg\ Mix::Vector3 NX
		virtual void AddLine( const Mix::Vector3& p0, const Mix::Vector3& p1 ) = 0;
		//! @brief Cǉ܂
		//! @param[in] points |Cge[u\ Mix::Vector3 NX̃|C^
		//! @param[in] pointNum |Cg̐( 2̔{łKv܂ )
		virtual void AddLines( const Mix::Vector3* points, UInt32 pointNum ) = 0;

		//! @brief ǉ܂
		//! @param[in] scale XP[
		virtual void AddAxis( Float32 scale = 1.0f ) = 0;

		//! @brief {bNXǉ܂
		//! @param[in] halfExtents {bNX̔̃TCY\ Mix::Vector3 NX
		virtual void AddBox( const Mix::Vector3& halfExtents ) = 0;
		//! @brief {bNXǉ܂
		//! @param[in] obb {bNX\ Mix::Geometry::OBB NX
		virtual void AddBox( const Mix::Geometry::OBB& obb ) = 0;
		//! @brief {bNXǉ܂
		//! @param[in] aabb {bNX\ Mix::Geometry::AABB NX
		virtual void AddBox( const Mix::Geometry::AABB& aabb ) = 0;

		//! @brief V_[ǉ܂
		//! @param[in] axis ( 0:X 1:Y 2:Z )
		//! @param[in] length ̕܂ގ̒
		//! @param[in] radius a
		virtual void AddCylinder( UInt32 axis, Float32 length, Float32 radius ) = 0;

		//! @brief JvZǉ܂
		//! @param[in] axis ( 0:X 1:Y 2:Z )
		//! @param[in] length ̕܂ގ̒
		//! @param[in] radius a
		virtual void AddCapsule( UInt32 axis, Float32 length, Float32 radius ) = 0;

		//! @brief tX^ǉ܂
		//! @param[in] frustum tX^\ Mix::Geometry::Frustum NX
		virtual void AddFrustum( const Mix::Geometry::Frustum& frustum ) = 0;

		//! @brief XtBAǉ܂
		//! @param[in] radius a
		virtual void AddSphere( Float32 radius ) = 0;
		//! @brief XtBAǉ܂
		//! @param[in] radius XYZ̔a\ Mix::Vector3 NX
		virtual void AddSphere( const Mix::Vector3& radius ) = 0;
		//! @brief XtBAǉ܂
		//! @param[in] center SW\ Mix::Vector3 NX
		//! @param[in] radius a
		virtual void AddSphere( const Mix::Vector3& center, Float32 radius ) = 0;
		//! @brief XtBAǉ܂
		//! @param[in] center SW\ Mix::Vector3 NX
		//! @param[in] radius XYZ̔a\ Mix::Vector3 NX
		virtual void AddSphere( const Mix::Vector3& center, const Mix::Vector3& radius ) = 0;
		//! @brief XtBAǉ܂
		//! @param[in] sphere XtBA\ Mix::Geometry::Sphere NX
		virtual void AddSphere( const Mix::Geometry::Sphere& sphere ) = 0;

		//! @brief R[( ~ )ǉ܂
		//! @param[in] pos R[̒_\ Mix::Vector3 NX
		//! @param[in] vec R[̒_ʂ̒Sւ̃xNg\ Mix::Vector3 NX
		//! @param[in] angle R[̊Op( WAP )
		//! @param[in] divCount ( 4`36 )
		virtual void AddCone( const Mix::Vector3& pos, const Mix::Vector3& vec, Float32 angle, UInt32 divCount ) = 0;

		//! @brief fBXN(~)ǉ܂
		//! @param[in] axis fBXN̎\ Mix::Vector3 NX
		//! @param[in] radius fBXN̔a
		virtual void AddDisc( const Mix::Vector3& axis, Float32 radius ) = 0;

		//! @brief p`ǉ܂
		//! @param[in] points p`̓_\ Mix::Vector3 NX̔z
		//! @param[in] pointNum _̐
		virtual void AddPolygon( const Mix::Vector3* points, UInt32 pointNum ) = 0;

		//! @brief XVs܂
		virtual void Update( void ) = 0;

		//! @brief `s܂
		//! @param[in] viewProjMat ϊs\ Mix::Matrix4x4 NX
		virtual void Draw( const Mix::Matrix4x4& viewProjMat ) = 0;
	};

}}}
