#pragma once

//! @file Mix/Graphics/IVertexBuffer.h
//! @brief o[ebNXobt@C^[tF[XCN[ht@C

#include "Mix/Reference.h"

namespace Mix{ namespace Graphics{

	//! @class IVertexBuffer
	//! @brief o[ebNXobt@C^[tF[X
	class IVertexBuffer : public Mix::Reference
	{
	protected:
		//! @brief fXgN^
		virtual ~IVertexBuffer( void ){}

	public:
		//! @brief bNA߂Ԃɂ܂
		//! @return ꍇ True Ԃ܂
		virtual Boolean Lock( void ) = 0;
		//! @brief AbNA`łԂɂ܂
		virtual void Unlock( void ) = 0;

		//! @brief _݂܂
		//! @param[in] pData ޒ_̃|C^
		//! @param[in] count ޒ_̐
		//! @return ꍇ True Ԃ܂
		//! @note ̃\bhgpꍇ́AOɃbNĂKv܂
		virtual Boolean Push( const void* pData, UInt32 count ) = 0;
		//! @brief _̏ݗ\܂
		//! @param[in] count ޒ_̐
		//! @return ꍇ́Aݐ̃|C^Ԃ܂<br>
		//! sꍇ NULL Ԃ܂
		//! @note ̃\bhgpꍇ́AOɃbNĂKv܂
		virtual void* Push( UInt32 count ) = 0;

		//! @brief ܂Ă钸_NA܂
		virtual void Clear( void ) = 0;

		//! @brief XgCh( oCgP )擾܂
		//! @return XgChԂ܂
		virtual UInt32 GetStride( void ) const = 0;

		//! @brief ܂Ă钸_擾܂
		//! @return ܂Ă钸_擾܂
		virtual UInt32 GetCount( void ) const = 0;
		//! @brief ߂ő咸_擾܂
		//! @return ߂ő咸_Ԃ܂
		virtual UInt32 GetCapacity( void ) const = 0;
	};

}}
