#pragma once

//! @file Mix/Graphics/ITexture.h
//! @brief eNX`C^[tF[XCN[ht@C

#include "Mix/Reference.h"

namespace Mix{ namespace Graphics{

	//! @class ITexture
	//! @brief eNX`C^[tF[X
	class ITexture : public Mix::Reference
	{
	protected:
		//! @brief fXgN^
		virtual ~ITexture( void ){}

	public:
		//! @brief bNA߂Ԃɂ܂
		//! @param[out] lockInfo eNX`̃bN\ Mix::Graphics::TEXTURE_LOCK_INFO \
		//! @return ꍇ True Ԃ܂
		virtual Boolean Lock( Mix::Graphics::TEXTURE_LOCK_INFO& lockInfo ) = 0;
		//! @brief AbNA`ɂłԂɂ܂
		virtual void Unlock( void ) = 0;

		//! @brief 擾܂
		//! @return Ԃ܂
		virtual UInt32 GetWidth( void ) const = 0;
		//! @brief 擾܂
		//! @return Ԃ܂
		virtual UInt32 GetHeight( void ) const = 0;

		//! @brief ^Cv擾܂
		//! @return ^Cv\ Mix::Graphics::TEXTURE_TYPE 񋓒萔Ԃ܂
		virtual Mix::Graphics::TEXTURE_TYPE GetType( void ) const = 0;
		//! @brief tH[}bg擾܂
		//! @return tH[}bg\ Mix::Graphics::FORMAT 񋓒萔Ԃ܂
		virtual Mix::Graphics::FORMAT GetFormat( void ) const = 0;

		//! @brief gpł邩ǂmF܂
		//! @return gpłꍇ True Ԃ܂
		virtual Boolean IsAvailable( void ) const = 0;
	};

}}
