#pragma once

//! @file Mix/Graphics/IShaderConstant.h
//! @brief VF[_[RX^gC^[tF[XCN[ht@C

#include "Mix/Reference.h"

namespace Mix{ namespace Graphics{

	//! @class IShaderConstant
	//! @brief VF[_[RX^gC^[tF[X
	class IShaderConstant : public Mix::Reference
	{
	protected:
		//! @brief fXgN^
		virtual ~IShaderConstant( void ){}

	public:
		//! @brief bNA߂Ԃɂ܂
		//! @return ꍇ True Ԃ܂
		virtual Boolean Lock( void ) = 0;
		//! @brief AbNAgpłԂɂ܂
		virtual void Unlock( void ) = 0;
		//! @brief f[^݂܂
		//! @param[in] pData ރf[^̃|C^
		//! @param[in] dataSize ރf[^̃TCY
		//! @return ꍇ True Ԃ܂
		//! @note ̃\bhgpɂ͎OɃbNĂKv܂
		virtual Boolean Write( const void* pData, UInt32 dataSize ) = 0;

		//! @brief TCY( oCgP )擾܂
		//! @return TCYԂ܂
		virtual UInt32 GetSize( void ) const = 0;
	};

}}
