#pragma once

//! @file Mix/Graphics/IManager.h
//! @brief OtBbNX}l[WC^[tF[XCN[ht@C

#include "Mix/Reference.h"

namespace Mix{ namespace Graphics{

	//! @class IManager
	//! @brief OtBbNX}l[WC^[tF[X
	class IManager : public Mix::Reference
	{
	protected:
		//! @brief fXgN^
		virtual ~IManager( void ){}

	public:
		//! @brief OtBbNXfoCX擾܂
		//! @param[out] ppDevice 擾OtBbNXfoCXn Mix::Graphics::IDevice C^[tF[X̃|C^̃AhX
		//! @return ꍇ True Ԃ܂
		virtual Boolean GetDevice( Mix::Graphics::IDevice** ppDevice ) = 0;

		//! @brief ^[QbgeNX``FC쐬܂
		//! @param[in] width ^[QbgeNX`̕
		//! @param[in] height ^[QbgeNX`̍
		//! @param[in] format ^[QbgeNX`̃tH[}bg
		//! @param[out] ppTargetTextureChain 쐬^[QbgeNX``FCn Mix::Graphics::Utility::ITargetTextureChain C^[tF[X̃|C^̃AhX
		//! @param[in] pName ^[QbgeNX``FC̖O
		//! @return ꍇ True Ԃ܂
		virtual Boolean CreateTargetTextureChain(	UInt32 width,
													UInt32 height,
													Mix::Graphics::FORMAT format,
													Mix::Graphics::Utility::ITargetTextureChain** ppTargetTextureChain,
													const wchar_t* pName = NULL ) = 0;

		//! @brief tHgt@C쐬܂
		//! @param[in] pFileName tHg̃t@C
		//! @param[out] ppFont 쐬tHgn Mix::Graphics::Utility::IFont C^[tF[X̃|C^̃AhX
		//! @return ꍇ True Ԃ܂
		virtual Boolean CreateFontFromFile( const wchar_t* pFileName, Mix::Graphics::Utility::IFont** ppFont ) = 0;
		//! @brief tHg̃t@C쐬܂
		//! @param[in] pBuffer ̃t@C\ Mix::Memory::IBuffer C^[tF[X̃|C^
		//! @param[out] ppFont 쐬tHgn Mix::Graphics::Utility::IFont C^[tF[X̃|C^̃AhX
		//! @param[in] pName tHg̖O
		//! @return ꍇ True Ԃ܂
		//! @note 쐬ɐꍇApBuffer ̎QƃJE^ +1 ܂
		virtual Boolean CreateFontFromMemory( Mix::Memory::IBuffer* pBuffer, Mix::Graphics::Utility::IFont** ppFont, const wchar_t* pName = NULL ) = 0;

		//! @brief eLXg쐬܂
		//! @param[out] ppText 쐬eLXgn Mix::Graphics::Utility::IText C^[tF[X̃|C^̃AhX
		//! @return ꍇ True Ԃ܂
		virtual Boolean CreateText( Mix::Graphics::Utility::IText** ppText ) = 0;

		//! @brief CA[g쐬܂
		//! @param[out] ppLineArt 쐬C_[n Mix::Graphics::Utility::ILineArt C^[tF[X̃|C^̃AhX
		//! @param[in] pName CA[g̖O
		//! @return ꍇ True Ԃ܂
		virtual Boolean CreateLineArt( Mix::Graphics::Utility::ILineArt** ppLineArt, const wchar_t* pName = NULL ) = 0;

		//! @brief LoX쐬܂
		//! @param[out] ppCanvas 쐬LoXn Mix::Graphics::Utility::ICanvas C^[tF[X̃|C^̃AhX
		//! @param[in] pName LoX̖O
		//! @return ꍇ True Ԃ܂
		virtual Boolean CreateCanvas( Mix::Graphics::Utility::ICanvas** ppCanvas, const wchar_t* pName = NULL ) = 0;
	};

}}
