#pragma once

//! @file Mix/Graphics/IIndexBuffer.h
//! @brief CfbNXobt@C^[tF[XCN[ht@C

#include "Mix/Reference.h"

namespace Mix{ namespace Graphics{

	//! @class IIndexBuffer
	//! @brief CfbNXobt@C^[tF[X
	class IIndexBuffer : public Mix::Reference
	{
	protected:
		//! @brief fXgN^
		virtual ~IIndexBuffer( void ){}

	public:
		//! @brief bNāA߂Ԃɂ܂
		//! @return ꍇ True Ԃ܂
		virtual Boolean Lock( void ) = 0;
		//! @brief AbNāA`łԂɂ܂
		virtual void Unlock( void ) = 0;

		//! @brief CfbNX݂܂
		//! @param[in] pData ރCfbNX
		//! @param[in] count ރCfbNX̐
		//! @return ꍇ True Ԃ܂
		virtual Boolean Push( const void* pData, UInt32 count ) = 0;
		//! @brief CfbNX̏ݗ\܂
		//! @param[in] count ރCfbNX̐
		//! @return ꍇ́Aݐ̃|C^擾܂<br>
		//! sꍇ NULL Ԃ܂
		virtual void* Push( UInt32 count ) = 0;

		//! @brief ܂ĂCfbNXNA܂
		virtual void Clear( void ) = 0;

		//! @brief ^Cv擾܂
		//! @return ^Cv\ Mix::Graphics::INDEX_TYPE 񋓒萔Ԃ܂
		virtual Mix::Graphics::INDEX_TYPE GetType( void ) const = 0;

		//! @brief ܂Ă钸_擾܂
		//! @return ܂Ă钸_擾܂
		virtual UInt32 GetCount( void ) const = 0;
		//! @brief ߂őCfbNX擾܂
		//! @return ߂őCfbNXԂ܂
		virtual UInt32 GetCapacity( void ) const = 0;
	};

}}
