#pragma once

//! @file Mix/Geometry.h
//! @brief WIICN[ht@C

#include "Mix/Geometry/Plane.h"
#include "Mix/Geometry/Sphere.h"
#include "Mix/Geometry/AABB.h"
#include "Mix/Geometry/OBB.h"

namespace Mix{ namespace Geometry{

	//! @brief ʂ_܂ł̋߂܂
	//! @param[in] p _\ Mix::Vector3 NX
	//! @param[in] plane Mix::Geometry::Plane NX
	//! @return ʂ_܂ł̋
	_MIX_DLL_API Float32 DistancePointPlane( const Mix::Vector3& p, const Mix::Geometry::Plane& plane );

	//! @brief _ւ̍Őڋߓ_߂܂
	//! @param[in] p 肷_\ Mix::Vector3 NX
	//! @param[in] sphere 肷鋅\ Mix::Geometry::Sphere NX
	//! @param[out] q Őڋߓ_\ Mix::Vector3 NX
	_MIX_DLL_API void ClosestPointSphere( const Mix::Vector3& p, const Mix::Geometry::Sphere& sphere, Mix::Vector3& q );
	//! @brief ʂ_ւ̍Őڋߓ_߂܂
	//! @param[in] p 肷_\ Mix::Vector3 NX
	//! @param[in] plane 肷镽ʂ\ Mix::Geometry::Plane NX
	//! @param[out] q Őڋߓ_\ Mix::Vector3 NX
	_MIX_DLL_API void ClosestPointPlane( const Mix::Vector3& p, const Mix::Geometry::Plane& plane, Mix::Vector3& q );
	//! @brief OBB_ւ̍Őڋߓ_߂܂
	//! @param[in] p 肷_\ Mix::Vector3 NX
	//! @param[in] obb 肷OBB\ Mix::Geometry::OBB NX
	//! @param[out] q Őڋߓ_\ Mix::Vector3 NX
	_MIX_DLL_API void ClosestPointOBB( const Mix::Vector3& p, const Mix::Geometry::OBB& obb, Mix::Vector3& q );
	//! @brief AABBƓ_̍Őڋߓ_߂܂
	//! @param[in] p 肷_\ Mix::Vector3 NX
	//! @param[in] aabb 肷AABB\ Mix::Geometry::AABB NX
	//! @param[out] q Őڋߓ_\ Mix::Vector3 NX
	_MIX_DLL_API void ClosestPointAABB( const Mix::Vector3& p, const Mix::Geometry::AABB& aabb, Mix::Vector3& q );

	//! @brief _v̎Op`abc̓ɂ邩ǂ𔻒肵܂
	//! @param[in] p 肷_\ Mix::Vector3 NX
	//! @param[in] a 肷Op`̓_1\ Mix::Vector3 NX
	//! @param[in] b 肷Op`̓_2\ Mix::Vector3 NX
	//! @param[in] c 肷Op`3_\ Mix::Vector3 NX
	//! @return _Op`̓ɂꍇ True Ԃ܂
	_MIX_DLL_API Boolean PointInTriangle( const Mix::Vector3& p, const Mix::Vector3& a, const Mix::Vector3& b, const Mix::Vector3& c );

	//! @brief AABBƓ_̌Ă邩ǂ𔻒肵܂
	//! @param[in] p 肷_\ Mix::Vector3 NX
	//! @param[in] aabb 肷AABB\ Mix::Geometry::AABB NX
	//! @return Ăꍇ True Ԃ܂
	_MIX_DLL_API Boolean IntersectPointAABB( const Mix::Vector3& p, const Mix::Geometry::AABB& aabb );
	//! @brief mĂ邩ǂ𔻒肵܂
	//! @param[in] sphere1 肷鋅\ Mix::Geometry::Sphere NX
	//! @param[in] sphere2 肷鋅\ Mix::Geometry::Sphere NX
	//! @param[out] pDist m̒S̋
	//! @return Ăꍇ True Ԃ܂
	_MIX_DLL_API Boolean IntersectSphereSphere( const Mix::Geometry::Sphere& sphere1, const Mix::Geometry::Sphere& sphere2, Float32* pDist = NULL );
	//! @brief ƕʂĂ邩ǂ𔻒肵܂
	//! @param[in] sphere 肷鋅\ Mix::Geometry::Sphere NX
	//! @param[in] plane 肷镽ʂ\ Mix::Geometry::Plane NX
	//! @param[out] pDist ʂ狅̒S܂ł̋
	//! @return Ăꍇ True Ԃ܂
	_MIX_DLL_API Boolean IntersectSpherePlane( const Mix::Geometry::Sphere& sphere, const Mix::Geometry::Plane& plane, Float32* pDist = NULL );
	//! @brief OBBĂ邩ǂ𔻒肵܂
	//! @param[in] sphere 肷鋅\ Mix::Geometry::Sphere NX
	//! @param[in] obb 肷OBB\ Mix::Geometry::OBB NX
	//! @param[out] pPos ̒Sɑ΂OBB̍Őڋߓ_\ Mix::Vector3 NX̃|C^
	//! @return Ăꍇ True Ԃ܂
	_MIX_DLL_API Boolean IntersectSphereOBB( const Mix::Geometry::Sphere& sphere, const Mix::Geometry::OBB& obb, Mix::Vector3* pPos = NULL );
	//! @brief AABBĂ邩ǂ𔻒肵܂
	//! @param[in] sphere 肷鋅\ Mix::Geometry::Sphere NX
	//! @param[in] aabb 肷AABB\ Mix::Geometry::AABB NX
	//! @param[out] pPos ̒Sɑ΂AABB̍Őڋߓ_\ Mix::Vector3 NX̃|C^
	//! @return Ăꍇ True Ԃ܂
	_MIX_DLL_API Boolean IntersectSphereAABB( const Mix::Geometry::Sphere& sphere, const Mix::Geometry::AABB& aabb, Mix::Vector3* pPos = NULL );

	//! @brief ʂƕʂĂ邩ǂ𔻒肵܂
	//! @param[in] plane1 肷镽ʂ\ Mix::Geometry::Plane NX
	//! @param[in] plane2 肷镽ʂ\ Mix::Geometry::Plane NX
	//! @param[out] pPos ̓_̈ʒu\ Mix::Vector3 NX̃|C^
	//! @param[out] pDir ̕\ Mix::Vector3 NX̃|C^
	//! @return Ăꍇ True Ԃ܂
	_MIX_DLL_API Boolean IntersectPlanePlane( const Mix::Geometry::Plane& plane1, const Mix::Geometry::Plane& plane2, Mix::Vector3* pPos = NULL, Mix::Vector3* pDir = NULL );
	//! @brief ʂOBBĂ邩ǂ𔻒肵܂
	//! @param[in] plane 肷镽ʂ\ Mix::Geometry::Plane NX
	//! @param[in] obb 肷OBB\ Mix::Geometry::OBB NX
	//! @return Ăꍇ True Ԃ܂
	_MIX_DLL_API Boolean IntersectPlaneOBB( const Mix::Geometry::Plane& plane, const Mix::Geometry::OBB& obb );
	//! @brief ʂAABBĂ邩ǂ𔻒肵܂
	//! @param[in] plane 肷镽ʂ\ Mix::Geometry::Plane NX
	//! @param[in] aabb 肷AABB\ Mix::Geometry::AABB NX
	//! @return Ăꍇ True Ԃ܂
	_MIX_DLL_API Boolean IntersectPlaneAABB( const Mix::Geometry::Plane& plane, const Mix::Geometry::AABB& aabb );

	//! @brief OBBmĂ邩ǂ𔻒肵܂
	//! @param[in] obb1 肷OBB\ Mix::Geometry::OBB NX
	//! @param[in] obb2 肷OBB\ Mix::Geometry::OBB NX
	//! @return Ăꍇ True Ԃ܂
	_MIX_DLL_API Boolean IntersectOBBOBB( const Mix::Geometry::OBB& obb1, const Mix::Geometry::OBB& obb2 );

	//! @brief AABBmĂ邩ǂ𔻒肵܂
	//! @param[in] aabb1 肷AABB\ Mix::Geometry::AABB NX
	//! @param[in] aabb2 肷AABB\ Mix::Geometry::AABB NX
	//! @return Ăꍇ True Ԃ܂
	_MIX_DLL_API Boolean IntersectAABBAABB( const Mix::Geometry::AABB& aabb1, const Mix::Geometry::AABB& aabb2 );

	//! @brief ƋĂ邩ǂ𔻒肵܂
	//! @param[in] rayPos 𔭂Ăʒu\ Mix::Vector3 NX
	//! @param[in] rayDir ̃xNg\ rayDir
	//! @param[in] sphere 肷鋅\ Mix::Geometry::Sphere NX
	//! @param[out] pDist 𔭂ĂʒuĂʒu܂ł̋
	//! @param[out] pPos Ăʒu\ Mix::Vector3 NX̃|C^
	//! @return Ăꍇ True Ԃ܂
	_MIX_DLL_API Boolean IntersectRaySphere( const Mix::Vector3& rayPos, const Mix::Vector3& rayDir, const Mix::Geometry::Sphere& sphere, Float32* pDist = NULL, Mix::Vector3* pPos = NULL );
	//! @brief ƕʂĂ邩ǂ𔻒肵܂
	//! @param[in] rayPos 𔭂Ăʒu\ Mix::Vector3 NX
	//! @param[in] rayDir ̃xNg\ rayDir
	//! @param[in] plane 肷镽ʂ\ Mix::Geometry::Plane NX
	//! @param[out] pDist 𔭂ĂʒuĂʒu܂ł̋
	//! @param[out] pPos Ăʒu\ Mix::Vector3 NX̃|C^
	//! @return Ăꍇ True Ԃ܂
	_MIX_DLL_API Boolean IntersectRayPlane( const Mix::Vector3& rayPos, const Mix::Vector3& rayDir, const Mix::Geometry::Plane& plane, Float32* pDist = NULL, Mix::Vector3* pPos = NULL );
	//! @brief OBBĂ邩ǂ𔻒肵܂
	//! @param[in] rayPos 𔭂Ăʒu\ Mix::Vector3 NX
	//! @param[in] rayDir ̃xNg\ rayDir
	//! @param[in] obb 肷OBB\ Mix::Geometry::OBB NX
	//! @return Ăꍇ True Ԃ܂
	_MIX_DLL_API Boolean IntersectRayOBB( const Mix::Vector3& rayPos, const Mix::Vector3& rayDir, const Mix::Geometry::OBB& obb );
	//! @brief AABBĂ邩ǂ𔻒肵܂
	//! @param[in] rayPos 𔭂Ăʒu\ Mix::Vector3 NX
	//! @param[in] rayDir ̃xNg\ rayDir
	//! @param[in] aabb 肷AABB\ Mix::Geometry::AABB NX
	//! @param[out] pDist 𔭂ĂʒuĂʒu܂ł̋
	//! @param[out] pPos Ăʒu\ Mix::Vector3 NX̃|C^
	//! @return Ăꍇ True Ԃ܂
	_MIX_DLL_API Boolean IntersectRayAABB( const Mix::Vector3& rayPos, const Mix::Vector3& rayDir, const Mix::Geometry::AABB& aabb, Float32* pDist = NULL, Mix::Vector3* pPos = NULL );

	//! @brief ƋĂ邩ǂ𔻒肵܂
	//! @param[in] p1 ̒[̓_\ Mix::Vector3 NX
	//! @param[in] p2 ̒[̓_\ Mix::Vector3 NX
	//! @param[in] sphere 肷鋅\ Mix::Geometry::Sphere NX
	//! @return Ăꍇ True Ԃ܂
	_MIX_DLL_API Boolean IntersectSegmentSphere( const Mix::Vector3& p1, const Mix::Vector3& p2, const Mix::Geometry::Sphere& sphere );
	//! @brief ƕʂĂ邩ǂ𔻒肵܂
	//! @param[in] p1 ̒[̓_1\ Mix::Vector3 NX
	//! @param[in] p2 ̒[̓_2\ Mix::Vector3 NX
	//! @param[in] plane 肷镽ʂ\ Mix::Geometry::Plane NX
	//! @param[out] pDist 𔭂ĂʒuĂʒu܂ł̋
	//! @param[out] pPos Ăʒu\ Mix::Vector3 NX̃|C^
	//! @return Ăꍇ True Ԃ܂
	_MIX_DLL_API Boolean IntersectSegmentPlane( const Mix::Vector3& p1, const Mix::Vector3& p2, const Mix::Geometry::Plane& plane, Float32* pDist = NULL, Mix::Vector3* pPos = NULL );
	//! @brief OBBĂ邩ǂ𔻒肵܂
	//! @param[in] p1 ̒[̓_1\ Mix::Vector3 NX
	//! @param[in] p2 ̒[̓_2\ Mix::Vector3 NX
	//! @param[in] obb 肷OBB\ Mix::Geometry::OBB NX
	//! @param[out] pDist 𔭂ĂʒuĂʒu܂ł̋
	//! @param[out] pPos Ăʒu\ Mix::Vector3 NX̃|C^
	//! @return Ăꍇ True Ԃ܂
	//! @note 
	_MIX_DLL_API Boolean IntersectSegmentOBB( const Mix::Vector3& p1, const Mix::Vector3& p2, const Mix::Geometry::OBB& obb, Float32* pDist = NULL, Mix::Vector3* pPos = NULL );
	//! @brief AABBĂ邩ǂ𔻒肵܂
	//! @param[in] p1 ̒[̓_1\ Mix::Vector3 NX
	//! @param[in] p2 ̒[̓_2\ Mix::Vector3 NX
	//! @param[in] aabb 肷OBB\ Mix::Geometry::AABB NX
	//! @return Ăꍇ True Ԃ܂
	_MIX_DLL_API Boolean IntersectSegmentAABB( const Mix::Vector3& p1, const Mix::Vector3& p2, const Mix::Geometry::AABB& aabb );
}}
