#pragma once

//! @file Mix/File/IManager.h
//! @brief t@C}l[WC^[tF[XCN[ht@C

#include "Mix/Reference.h"

namespace Mix{ namespace File{

	//! @class IManager
	//! @brief t@C}l[WC^[tF[X
	//! @note
	//! ut@CvufBNgvւ̃ANZX̓}Egʂčs܂B<br>
	//! }EgĂȂfBNgAt@Cւ̃ANZX͂łȂ悤ɂȂĂ܂B<br>
	class IManager : public Mix::Reference
	{
	protected:
		//! @brief fXgN^
		virtual ~IManager( void ){}

	public:
		//! @brief w肵A[JCũt@Cgpł悤ɂ܂
		//! @param[in] pFileName A[JCũt@C
		//! @return ꍇ True Ԃ܂
		virtual Boolean MountArchive( const wchar_t* pFileName ) = 0;
		//! @brief w肵fBNg̃t@Cgpł悤ɂ܂
		//! @param[in] pDirectoryName fBNg
		//! @return ꍇ True Ԃ܂
		virtual Boolean MountDirectory( const wchar_t* pDirectoryName ) = 0;
		//! @brief w肵t@Cgpł悤ɂ܂
		//! @param[in] pFileName t@C
		//! @return ꍇ True Ԃ܂
		virtual Boolean MountFile( const wchar_t* pFileName ) = 0;

		//! @brief ΃pX΃pXɕϊ܂
		//! @param[in] pSrc ɂȂ鑊΃pX
		//! @param[in] bDirectory fBNg̏ꍇ True
		//! @param[out] dst ϊ̐΃pX
		//! @return ꍇ True Ԃ܂
		virtual Boolean GetAbsolutePath( const wchar_t* pSrc, Boolean bDirectory, Mix::StringW& dst ) = 0;
		//! @brief fBNg̖O擾܂
		//! @param[in] ident fBNgʎq\ Mix::File::DIRECTORY_IDENT 񋓒萔
		//! @param[out] directoryName fBNgi[ Mix::String NX
		//! @return ꍇ True Ԃ܂
		virtual Boolean GetSpecialDirectoryName( Mix::File::DIRECTORY_IDENT ident, Mix::String& directoryName ) = 0;

		//! @brief w肵t@C̗LmF܂
		//! @param[in] pFileName t@C
		//! @return ݂Ăꍇ True Ԃ܂
		virtual Boolean ExistFile( const wchar_t* pFileName ) = 0;

		//! @brief t@C[_[쐬܂
		//! @param[in] pFileName t@C
		//! @param[out] ppReader 쐬t@C[_[n Mix::File::IReader C^[tF[X̃|C^̃AhX
		//! @return ꍇ True Ԃ܂
		virtual Boolean CreateFileReader( const wchar_t* pFileName, Mix::File::IReader** ppReader ) = 0;
		//! @brief t@CC^[쐬܂
		//! @param[in] pFileName t@C
		//! @param[out] ppWriter 쐬t@CC^[n Mix::File::IWriter C^[tF[X̃|C^̃AhX
		//! @return ꍇ True Ԃ܂
		virtual Boolean CreateFileWriter( const wchar_t* pFileName, Mix::File::IWriter** ppWriter ) = 0;

		//! @brief obt@h[_[쐬܂
		//! @param[in] pFileName t@C
		//! @param[out] ppReader 쐬obt@h[_[n Mix::File::IReader C^[tF[X̃|C^̃AhX
		//! @return ꍇ True Ԃ܂
		//! @note obt@h[_[̓̃t@C𑀍삵܂
		virtual Boolean CreateBufferedReader( const wchar_t* pFileName, Mix::File::IReader** ppReader ) = 0;
		//! @brief obt@h[_[쐬܂
		//! @param[in] pName O
		//! @param[in] pBuffer ǂݎ茳̃obt@\ Mix::Memory::IBuffer C^[tF[X̃|C^
		//! @param[out] ppReader 쐬obt@[_[n Mix::File::IReader C^[tF[X̃|C^̃AhX
		//! @return ꍇ True Ԃ܂
		//! @note obt@h[_[̓̃t@C𑀍삵܂
		virtual Boolean CreateBufferedReader( const wchar_t* pName, Mix::Memory::IBuffer* pBuffer, Mix::File::IReader** ppReader ) = 0;

		//! @brief t@C[_[쐬܂
		//! @param[in] pCallback t@C[_[̃R[obN\ Mix::File::ILoaderCallback C^[tF[X̃|C^
		//! @param[out] ppLoader 쐬t@C[_[n t@C[_[\ Mix::File::ILoader C^[tF[X̃|C^̃AhX
		//! @param[in] pName t@C[_[̖O
		//! @return ꍇ True Ԃ܂
		virtual Boolean CreateFileLoader( Mix::File::ILoaderCallback* pCallback, Mix::File::ILoader** ppLoader, const wchar_t* pName = NULL ) = 0;

		//! @brief t@Cobt@쐬܂
		//! @param[in] pFileName t@C
		//! @param[out] ppBuffer 쐬t@Cobt@n Mix::File::IBuffer C^[tF[X̃|C^̃AhX
		//! @return ꍇ True Ԃ܂
		virtual Boolean CreateBufferFromFile( const wchar_t* pFileName, Mix::Memory::IBuffer** ppBuffer ) = 0;
	};

}}
