#pragma once

//! @file Mix/File/ILoaderCallback.h
//! @brief [_[R[obNC^[tF[XCN[ht@C

#include "Mix/Reference.h"

namespace Mix{ namespace File{

	//! @class ILoaderCallback
	//! @brief [_[R[obNC^[tF[X
	class ILoaderCallback : public Mix::Reference
	{
	protected:
		//! @brief fXgN^
		virtual ~ILoaderCallback( void ){}

	public:
		//! @brief ǂݍ݂JnۂɌĂяo܂
		//! @param[in] fileName ǂݍ݂Jnt@C̖O
		//! @param[in] pObject IFileLoader::Load ֐̃p[^ pObject gēnꂽ Mix::Reference C^[tF[X̃|C^
		virtual void OnLoadStart( const wchar_t* fileName, Mix::Reference* pObject ) = 0;
		//! @brief ǂݍ݂ۂɌĂяo܂
		//! @param[in] fileName ǂݍ񂾃t@C̖O
		//! @param[in] pBuffer ǂݍ񂾃t@Ci[ Mix::Memory::IBuffer C^[tF[X̃|C^
		//! @param[in] pObject IFileLoader::Load ֐̃p[^ pObject gēnꂽ Mix::Reference C^[tF[X̃|C^
		virtual void OnLoadComplete( const wchar_t* fileName, Mix::Memory::IBuffer* pBuffer, Mix::Reference* pObject ) = 0;
		//! @brief ǂݍ݂ɎsۂɌĂяo܂
		//! @param[in] fileName ǂݍ݂Ɏst@C̖O
		//! @param[in] pObject IFileLoader::Load ֐̃p[^ pObject gēnꂽ Mix::Reference C^[tF[X̃|C^
		virtual void OnLoadFailed( const wchar_t* fileName, Mix::Reference* pObject ) = 0;
	};

}}
