#pragma once

//! @file Mix/EventDelegate.h
//! @brief CxgfQ[gNXCN[ht@C

namespace Mix{

	//! @class EventDelegate00
	//! @brief CxgfQ[gNX(  )
	class _MIX_DLL_API EventDelegate00
	{
	private:
		class Holder : public Mix::Reference
		{
		public:
			void* id0;
			void* id1;

		public:
			virtual void Call( void ) const = 0;
		};

		class HolderStatic : public Holder
		{
		private:
			typedef void ( __stdcall *Func )( void );

		private:
			Func m_Func;

		public:
			HolderStatic( Func func ) :
			m_Func( func )
			{
				id0 = m_Func;
				id1 = NULL;
			}

		public:
			virtual void Call( void ) const
			{
				m_Func();
			}
		};

		template<typename T>
		class HolderDynamic : public Holder
		{
		private:
			typedef void ( T::*Method )( void );

		private:
			T* m_pClass;
			Method m_Method;

		public:
			HolderDynamic( T* pClass, Method method ) :
			m_pClass( pClass ),
			m_Method( method )
			{
				id0 = pClass;
				id1 = &method;
			}

		public:
			virtual void Call( void ) const
			{
				( m_pClass->*m_Method )();
			}
		};

		struct NODE
		{
			Holder* holder;
			NODE* pre;
			NODE* next;
		};

	private:
		NODE* m_pTop;
		NODE* m_pBottom;

	private:
		Boolean AddNode( Holder* pHolder )
		{
			NODE* pNode;

			pNode = m_pTop;
			while( pNode != NULL )
			{
				if( ( pNode->holder->id0 == pHolder->id0 ) &&
					( pNode->holder->id1 == pHolder->id1 ) )
				{
					return False;
				}
				else
				{
					pNode = pNode->next;
				}
			}
			
			pNode = new NODE();
			pNode->holder = pHolder;

			if( m_pTop == NULL )
			{
				m_pTop = m_pBottom = pNode;
				m_pTop->pre = NULL;
				m_pTop->next = NULL;
			}
			else
			{
				pNode->pre = m_pBottom;
				pNode->next = NULL;
				m_pBottom->next = pNode;
				m_pBottom = pNode;
			}

			return True;
		}

		Holder* RemoveNode( Holder* pHolder )
		{
			Holder* pRetHolder = NULL;
			NODE* pNode = m_pTop;

			while( pNode != NULL )
			{
				if( ( pNode->holder->id0 == pHolder->id0 ) &&
					( pNode->holder->id1 == pHolder->id1 ) )
				{
					if( ( m_pTop == pNode ) &&
						( m_pBottom == pNode ) )
					{
						m_pTop = m_pBottom = NULL;
					}
					else if(	( m_pTop == pNode ) &&
								( m_pBottom != pNode ) )
					{
						m_pTop = m_pTop->next;
						m_pTop->pre = NULL;
					}
					else if(	( m_pTop != pNode ) &&
								( m_pBottom == pNode ) )
					{
						m_pBottom = m_pBottom->pre;
						m_pBottom->next = NULL;
					}
					else
					{
						pNode->pre->next = pNode->next;
						pNode->next->pre = pNode->pre;
					}

					pRetHolder = pNode->holder;
					MIX_DELETE( pNode );

					break;
				}
				else
				{
					pNode = pNode->next;
				}
			}

			return pRetHolder;
		}

		//Rs[֎~
		EventDelegate00& operator = ( const EventDelegate00& ed )
		{
			return *this;
		}

	public:
		//! @brief RXgN^
		EventDelegate00( void ) :
		m_pTop( NULL ),
		m_pBottom( NULL )
		{
		}

		//! @brief Rs[RXgN^
		//! @param[in] ed Rs[CxgfQ[g\ Mix::EventDelegate00 NX
		EventDelegate00( const EventDelegate00& ed ) :
		m_pTop( NULL ),
		m_pBottom( NULL )
		{
			*this += ed;
		}

		//! @brief RXgN^
		//! @param[in] ( __stdcall *func )( void ) ֐̃|C^
		EventDelegate00( void ( __stdcall *func )( void ) ) :
		m_pTop( NULL ),
		m_pBottom( NULL )
		{
			AddNode( new HolderStatic( func ) ); 
		}

		//! @brief RXgN^
		//! @tparam T NX̃^Cv
		//! @param[in] pClass NX̃|C^
		//! @param[in] method NX̃\bh
		template<typename T>
		EventDelegate00( T* pClass, void ( T::*method )( void ) ) :
		m_pTop( NULL ),
		m_pBottom( NULL )
		{
			AddNode( new HolderDynamic<T>( pClass, method ) );
		}

		//! @brief fXgN^
		~EventDelegate00( void )
		{
			NODE* pNode = m_pTop;
			NODE* pNextNode;
			while( pNode != NULL )
			{
				pNextNode = pNode->next;
				MIX_RELEASE( pNode->holder );
				MIX_DELETE( pNode );
				pNode = pNextNode;
			}
		}

	public:
		//! @brief o^\bhĂяo܂
		void operator ()() const
		{
			NODE* pNode = m_pTop;
			while( pNode != NULL )
			{
				pNode->holder->Call();
				pNode = pNode->next;
			}
		}

		//! @brief CxgfQ[gǉ܂
		//! @param[in] ed ǉCxgfQ[g\ Mix::EventDelegate00 NX
		void operator += ( const Mix::EventDelegate00& ed )
		{
			NODE* pNode = ed.m_pTop;
			while( pNode != NULL )
			{
				if( AddNode( pNode->holder ) == True )
				{
					pNode->holder->AddRef();
				}
				pNode = pNode->next;
			}
		}

		//! @brief CxgfQ[g폜܂
		//! @param[in] ed 폜CxgfQ[g\ Mix::EventDelegate00 NX
		void operator -= ( const Mix::EventDelegate00& ed )
		{
			Holder* pRemoveHolder;
			NODE* pNode = ed.m_pTop;

			while( pNode != NULL )
			{
				pRemoveHolder = RemoveNode( pNode->holder );
				if( pRemoveHolder != NULL )
				{
					MIX_RELEASE( pRemoveHolder );
				}
				pNode = pNode->next;
			}
		}
	};

	//! @class EventDelegate01
	//! @brief CxgfQ[gNX(  : 1 )
	//! @tparam Arg1Type Pڂ̈̌^
	template<typename Arg1Type>
	class _MIX_DLL_API EventDelegate01
	{
	private:
		class Holder : public Mix::Reference
		{
		public:
			void* id0;
			void* id1;

		public:
			virtual void Call( Arg1Type a1 ) const = 0;
		};

		class HolderStatic : public Holder
		{
		private:
			typedef void ( __stdcall *Func )( Arg1Type );

		private:
			Func m_Func;

		public:
			HolderStatic( Func func ) :
			m_Func( func )
			{
				id0 = m_Func;
				id1 = NULL;
			}

		public:
			virtual void Call( Arg1Type a1 ) const
			{
				m_Func( a1 );
			}
		};

		template<typename T>
		class HolderDynamic : public Holder
		{
		private:
			typedef void ( T::*Method )( Arg1Type );

		private:
			T* m_pClass;
			Method m_Method;

		public:
			HolderDynamic( T* pClass, Method method ) :
			m_pClass( pClass ),
			m_Method( method )
			{
				id0 = pClass;
				id1 = &method;
			}

		public:
			virtual void Call( Arg1Type a1 ) const
			{
				( m_pClass->*m_Method )( a1 );
			}
		};

		struct NODE
		{
			Holder* holder;
			NODE* pre;
			NODE* next;
		};

	private:
		NODE* m_pTop;
		NODE* m_pBottom;

	private:
		Boolean AddNode( Holder* pHolder )
		{
			NODE* pNode;

			pNode = m_pTop;
			while( pNode != NULL )
			{
				if( ( pNode->holder->id0 == pHolder->id0 ) &&
					( pNode->holder->id1 == pHolder->id1 ) )
				{
					return False;
				}
				else
				{
					pNode = pNode->next;
				}
			}
			
			pNode = new NODE();
			pNode->holder = pHolder;

			if( m_pTop == NULL )
			{
				m_pTop = m_pBottom = pNode;
				m_pTop->pre = NULL;
				m_pTop->next = NULL;
			}
			else
			{
				pNode->pre = m_pBottom;
				pNode->next = NULL;
				m_pBottom->next = pNode;
				m_pBottom = pNode;
			}

			return True;
		}

		Holder* RemoveNode( Holder* pHolder )
		{
			Holder* pRetHolder = NULL;
			NODE* pNode = m_pTop;

			while( pNode != NULL )
			{
				if( ( pNode->holder->id0 == pHolder->id0 ) &&
					( pNode->holder->id1 == pHolder->id1 ) )
				{
					if( ( m_pTop == pNode ) &&
						( m_pBottom == pNode ) )
					{
						m_pTop = m_pBottom = NULL;
					}
					else if(	( m_pTop == pNode ) &&
								( m_pBottom != pNode ) )
					{
						m_pTop = m_pTop->next;
						m_pTop->pre = NULL;
					}
					else if(	( m_pTop != pNode ) &&
								( m_pBottom == pNode ) )
					{
						m_pBottom = m_pBottom->pre;
						m_pBottom->next = NULL;
					}
					else
					{
						pNode->pre->next = pNode->next;
						pNode->next->pre = pNode->pre;
					}

					pRetHolder = pNode->holder;
					MIX_DELETE( pNode );

					break;
				}
				else
				{
					pNode = pNode->next;
				}
			}

			return pRetHolder;
		}

		//Rs[֎~
		EventDelegate01<Arg1Type>& operator = ( const EventDelegate01<Arg1Type>& ed )
		{
			return *this;
		}

	public:
		//! @brief RXgN^
		EventDelegate01( void ) :
		m_pTop( NULL ),
		m_pBottom( NULL )
		{
		}

		//! @brief Rs[RXgN^
		//! @param[in] ed Rs[CxgfQ[g\ Mix::EventDelegate01 NX
		EventDelegate01( const EventDelegate01& ed ) :
		m_pTop( NULL ),
		m_pBottom( NULL )
		{
			*this += ed;
		}

		//! @brief RXgN^
		//! @param[in] ( __stdcall *func )( Arg1Type ) ֐̃|C^
		EventDelegate01( void ( __stdcall *func )( Arg1Type ) ) :
		m_pTop( NULL ),
		m_pBottom( NULL )
		{
			AddNode( new HolderStatic( func ) ); 
		}

		//! @brief RXgN^
		//! @tparam T NX̃^Cv
		//! @param[in] pClass NX̃|C^
		//! @param[in] method NX̃\bh
		template<typename T>
		EventDelegate01( T* pClass, void ( T::*method )( Arg1Type ) ) :
		m_pTop( NULL ),
		m_pBottom( NULL )
		{
			AddNode( new HolderDynamic<T>( pClass, method ) );
		}

		//! @brief fXgN^
		~EventDelegate01( void )
		{
			NODE* pNode = m_pTop;
			NODE* pNextNode;
			while( pNode != NULL )
			{
				pNextNode = pNode->next;
				MIX_RELEASE( pNode->holder );
				MIX_DELETE( pNode );
				pNode = pNextNode;
			}
		}

	public:
		//! @brief o^\bhĂяo܂
		void operator ()( Arg1Type a1 ) const
		{
			NODE* pNode = m_pTop;
			while( pNode != NULL )
			{
				pNode->holder->Call( a1 );
				pNode = pNode->next;
			}
		}

		//! @brief CxgfQ[gǉ܂
		//! @param[in] ed ǉCxgfQ[g\ Mix::EventDelegate01 NX
		void operator += ( const Mix::EventDelegate01<Arg1Type>& ed )
		{
			NODE* pNode = ed.m_pTop;
			while( pNode != NULL )
			{
				if( AddNode( pNode->holder ) == True )
				{
					pNode->holder->AddRef();
				}
				pNode = pNode->next;
			}
		}

		//! @brief CxgfQ[g폜܂
		//! @param[in] ed 폜CxgfQ[g\ Mix::EventDelegate01 NX
		void operator -= ( const Mix::EventDelegate01<Arg1Type>& ed )
		{
			Holder* pRemoveHolder;
			NODE* pNode = ed.m_pTop;

			while( pNode != NULL )
			{
				pRemoveHolder = RemoveNode( pNode->holder );
				if( pRemoveHolder != NULL )
				{
					MIX_RELEASE( pRemoveHolder );
				}
				pNode = pNode->next;
			}
		}
	};

	//! @class EventDelegate02
	//! @brief CxgfQ[gNX(  : 2 )
	//! @tparam Arg1Type Pڂ̈̌^
	//! @tparam Arg2Type Qڂ̈̌^
	template<typename Arg1Type, typename Arg2Type>
	class _MIX_DLL_API EventDelegate02
	{
	private:
		class Holder : public Mix::Reference
		{
		public:
			void* id0;
			void* id1;

		public:
			virtual void Call( Arg1Type a1, Arg2Type a2 ) const = 0;
		};

		class HolderStatic : public Holder
		{
		private:
			typedef void ( __stdcall *Func )( Arg1Type, Arg2Type );

		private:
			Func m_Func;

		public:
			HolderStatic( Func func ) :
			m_Func( func )
			{
				id0 = m_Func;
				id1 = NULL;
			}

		public:
			virtual void Call( Arg1Type a1, Arg2Type a2 ) const
			{
				m_Func( a1, a2 );
			}
		};

		template<typename T>
		class HolderDynamic : public Holder
		{
		private:
			typedef void ( T::*Method )( Arg1Type, Arg2Type );

		private:
			T* m_pClass;
			Method m_Method;

		public:
			HolderDynamic( T* pClass, Method method ) :
			m_pClass( pClass ),
			m_Method( method )
			{
				id0 = pClass;
				id1 = &method;
			}

		public:
			virtual void Call( Arg1Type a1, Arg2Type a2 ) const
			{
				( m_pClass->*m_Method )( a1, a2 );
			}
		};

		struct NODE
		{
			Holder* holder;
			NODE* pre;
			NODE* next;
		};

	private:
		NODE* m_pTop;
		NODE* m_pBottom;

	private:
		Boolean AddNode( Holder* pHolder )
		{
			NODE* pNode;

			pNode = m_pTop;
			while( pNode != NULL )
			{
				if( ( pNode->holder->id0 == pHolder->id0 ) &&
					( pNode->holder->id1 == pHolder->id1 ) )
				{
					return False;
				}
				else
				{
					pNode = pNode->next;
				}
			}
			
			pNode = new NODE();
			pNode->holder = pHolder;

			if( m_pTop == NULL )
			{
				m_pTop = m_pBottom = pNode;
				m_pTop->pre = NULL;
				m_pTop->next = NULL;
			}
			else
			{
				pNode->pre = m_pBottom;
				pNode->next = NULL;
				m_pBottom->next = pNode;
				m_pBottom = pNode;
			}

			return True;
		}

		Holder* RemoveNode( Holder* pHolder )
		{
			Holder* pRetHolder = NULL;
			NODE* pNode = m_pTop;

			while( pNode != NULL )
			{
				if( ( pNode->holder->id0 == pHolder->id0 ) &&
					( pNode->holder->id1 == pHolder->id1 ) )
				{
					if( ( m_pTop == pNode ) &&
						( m_pBottom == pNode ) )
					{
						m_pTop = m_pBottom = NULL;
					}
					else if(	( m_pTop == pNode ) &&
								( m_pBottom != pNode ) )
					{
						m_pTop = m_pTop->next;
						m_pTop->pre = NULL;
					}
					else if(	( m_pTop != pNode ) &&
								( m_pBottom == pNode ) )
					{
						m_pBottom = m_pBottom->pre;
						m_pBottom->next = NULL;
					}
					else
					{
						pNode->pre->next = pNode->next;
						pNode->next->pre = pNode->pre;
					}

					pRetHolder = pNode->holder;
					MIX_DELETE( pNode );

					break;
				}
				else
				{
					pNode = pNode->next;
				}
			}

			return pRetHolder;
		}

		//Rs[֎~
		EventDelegate02<Arg1Type, Arg2Type>& operator = ( const EventDelegate02<Arg1Type, Arg2Type>& ed )
		{
			return *this;
		}

	public:
		//! @brief RXgN^
		EventDelegate02( void ) :
		m_pTop( NULL ),
		m_pBottom( NULL )
		{
		}

		//! @brief Rs[RXgN^
		//! @param[in] ed Rs[CxgfQ[g\ Mix::EventDelegate01 NX
		EventDelegate02( const EventDelegate02<Arg1Type, Arg2Type>& ed ) :
		m_pTop( NULL ),
		m_pBottom( NULL )
		{
			*this += ed;
		}

		//! @brief RXgN^
		//! @param[in] ( __stdcall *func )( Arg1Type, Arg2Type ) ֐̃|C^
		EventDelegate02( void ( __stdcall *func )( Arg1Type, Arg2Type ) ) :
		m_pTop( NULL ),
		m_pBottom( NULL )
		{
			AddNode( new HolderStatic( func ) ); 
		}

		//! @brief RXgN^
		//! @tparam T NX̃^Cv
		//! @param[in] pClass NX̃|C^
		//! @param[in] method NX̃\bh
		template<typename T>
		EventDelegate02( T* pClass, void ( T::*method )( Arg1Type, Arg2Type ) ) :
		m_pTop( NULL ),
		m_pBottom( NULL )
		{
			AddNode( new HolderDynamic<T>( pClass, method ) );
		}

		//! @brief fXgN^
		~EventDelegate02( void )
		{
			NODE* pNode = m_pTop;
			NODE* pNextNode;
			while( pNode != NULL )
			{
				pNextNode = pNode->next;
				MIX_RELEASE( pNode->holder );
				MIX_DELETE( pNode );
				pNode = pNextNode;
			}
		}

	public:
		//! @brief o^\bhĂяo܂
		void operator ()( Arg1Type a1, Arg2Type a2 ) const
		{
			NODE* pNode = m_pTop;
			while( pNode != NULL )
			{
				pNode->holder->Call( a1, a2 );
				pNode = pNode->next;
			}
		}

		//! @brief CxgfQ[gǉ܂
		//! @param[in] ed ǉCxgfQ[g\ Mix::EventDelegate02 NX
		void operator += ( const Mix::EventDelegate02<Arg1Type, Arg2Type>& ed )
		{
			NODE* pNode = ed.m_pTop;
			while( pNode != NULL )
			{
				if( AddNode( pNode->holder ) == True )
				{
					pNode->holder->AddRef();
				}
				pNode = pNode->next;
			}
		}

		//! @brief CxgfQ[g폜܂
		//! @param[in] ed 폜CxgfQ[g\ Mix::EventDelegate02 NX
		void operator -= ( const Mix::EventDelegate02<Arg1Type, Arg2Type>& ed )
		{
			Holder* pRemoveHolder;
			NODE* pNode = ed.m_pTop;

			while( pNode != NULL )
			{
				pRemoveHolder = RemoveNode( pNode->holder );
				if( pRemoveHolder != NULL )
				{
					MIX_RELEASE( pRemoveHolder );
				}
				pNode = pNode->next;
			}
		}
	};

	//! @class EventDelegate03
	//! @brief CxgfQ[gNX(  : 3 )
	//! @tparam Arg1Type Pڂ̈̌^
	//! @tparam Arg2Type Qڂ̈̌^
	//! @tparam Arg3Type Rڂ̈̌^
	template<typename Arg1Type, typename Arg2Type, typename Arg3Type>
	class _MIX_DLL_API EventDelegate03
	{
	private:
		class Holder : public Mix::Reference
		{
		public:
			void* id0;
			void* id1;

		public:
			virtual void Call( Arg1Type a1, Arg2Type a2, Arg3Type a3 ) const = 0;
		};

		class HolderStatic : public Holder
		{
		private:
			typedef void ( __stdcall *Func )( Arg1Type, Arg2Type, Arg3Type );

		private:
			Func m_Func;

		public:
			HolderStatic( Func func ) :
			m_Func( func )
			{
				id0 = m_Func;
				id1 = NULL;
			}

		public:
			virtual void Call( Arg1Type a1, Arg2Type a2, Arg3Type a3 ) const
			{
				m_Func( a1, a2, a3 );
			}
		};

		template<typename T>
		class HolderDynamic : public Holder
		{
		private:
			typedef void ( T::*Method )( Arg1Type, Arg2Type, Arg3Type );

		private:
			T* m_pClass;
			Method m_Method;

		public:
			HolderDynamic( T* pClass, Method method ) :
			m_pClass( pClass ),
			m_Method( method )
			{
				id0 = pClass;
				id1 = &method;
			}

		public:
			virtual void Call( Arg1Type a1, Arg2Type a2, Arg3Type a3 ) const
			{
				( m_pClass->*m_Method )( a1, a2, a3 );
			}
		};

		struct NODE
		{
			Holder* holder;
			NODE* pre;
			NODE* next;
		};

	private:
		NODE* m_pTop;
		NODE* m_pBottom;

	private:
		Boolean AddNode( Holder* pHolder )
		{
			NODE* pNode;

			pNode = m_pTop;
			while( pNode != NULL )
			{
				if( ( pNode->holder->id0 == pHolder->id0 ) &&
					( pNode->holder->id1 == pHolder->id1 ) )
				{
					return False;
				}
				else
				{
					pNode = pNode->next;
				}
			}
			
			pNode = new NODE();
			pNode->holder = pHolder;

			if( m_pTop == NULL )
			{
				m_pTop = m_pBottom = pNode;
				m_pTop->pre = NULL;
				m_pTop->next = NULL;
			}
			else
			{
				pNode->pre = m_pBottom;
				pNode->next = NULL;
				m_pBottom->next = pNode;
				m_pBottom = pNode;
			}

			return True;
		}

		Holder* RemoveNode( Holder* pHolder )
		{
			Holder* pRetHolder = NULL;
			NODE* pNode = m_pTop;

			while( pNode != NULL )
			{
				if( ( pNode->holder->id0 == pHolder->id0 ) &&
					( pNode->holder->id1 == pHolder->id1 ) )
				{
					if( ( m_pTop == pNode ) &&
						( m_pBottom == pNode ) )
					{
						m_pTop = m_pBottom = NULL;
					}
					else if(	( m_pTop == pNode ) &&
								( m_pBottom != pNode ) )
					{
						m_pTop = m_pTop->next;
						m_pTop->pre = NULL;
					}
					else if(	( m_pTop != pNode ) &&
								( m_pBottom == pNode ) )
					{
						m_pBottom = m_pBottom->pre;
						m_pBottom->next = NULL;
					}
					else
					{
						pNode->pre->next = pNode->next;
						pNode->next->pre = pNode->pre;
					}

					pRetHolder = pNode->holder;
					MIX_DELETE( pNode );

					break;
				}
				else
				{
					pNode = pNode->next;
				}
			}

			return pRetHolder;
		}

		//Rs[֎~
		EventDelegate03<Arg1Type, Arg2Type, Arg3Type>& operator = ( const EventDelegate03<Arg1Type, Arg2Type, Arg3Type>& ed )
		{
			return *this;
		}

	public:
		//! @brief RXgN^
		EventDelegate03( void ) :
		m_pTop( NULL ),
		m_pBottom( NULL )
		{
		}

		//! @brief Rs[RXgN^
		//! @param[in] ed Rs[CxgfQ[g\ Mix::EventDelegate03 NX
		EventDelegate03( const EventDelegate03<Arg1Type, Arg2Type, Arg3Type>& ed ) :
		m_pTop( NULL ),
		m_pBottom( NULL )
		{
			*this += ed;
		}

		//! @brief RXgN^
		//! @param[in] ( __stdcall *func )( Arg1Type, Arg2Type, Arg3Type ) ֐̃|C^
		EventDelegate03( void ( __stdcall *func )( Arg1Type, Arg2Type, Arg3Type ) ) :
		m_pTop( NULL ),
		m_pBottom( NULL )
		{
			AddNode( new HolderStatic( func ) ); 
		}

		//! @brief RXgN^
		//! @tparam T NX̃^Cv
		//! @param[in] pClass NX̃|C^
		//! @param[in] method NX̃\bh
		template<typename T>
		EventDelegate03( T* pClass, void ( T::*method )( Arg1Type, Arg2Type, Arg3Type ) ) :
		m_pTop( NULL ),
		m_pBottom( NULL )
		{
			AddNode( new HolderDynamic<T>( pClass, method ) );
		}

		//! @brief fXgN^
		~EventDelegate03( void )
		{
			NODE* pNode = m_pTop;
			NODE* pNextNode;
			while( pNode != NULL )
			{
				pNextNode = pNode->next;
				MIX_RELEASE( pNode->holder );
				MIX_DELETE( pNode );
				pNode = pNextNode;
			}
		}

	public:
		//! @brief o^\bhĂяo܂
		void operator ()( Arg1Type a1, Arg2Type a2, Arg3Type a3 ) const
		{
			NODE* pNode = m_pTop;
			while( pNode != NULL )
			{
				pNode->holder->Call( a1, a2, a3 );
				pNode = pNode->next;
			}
		}

		//! @brief CxgfQ[gǉ܂
		//! @param[in] ed ǉCxgfQ[g\ Mix::EventDelegate03 NX
		void operator += ( const Mix::EventDelegate03<Arg1Type, Arg2Type, Arg3Type>& ed )
		{
			NODE* pNode = ed.m_pTop;
			while( pNode != NULL )
			{
				if( AddNode( pNode->holder ) == True )
				{
					pNode->holder->AddRef();
				}
				pNode = pNode->next;
			}
		}

		//! @brief CxgfQ[g폜܂
		//! @param[in] ed 폜CxgfQ[g\ Mix::EventDelegate03 NX
		void operator -= ( const Mix::EventDelegate03<Arg1Type, Arg2Type, Arg3Type>& ed )
		{
			Holder* pRemoveHolder;
			NODE* pNode = ed.m_pTop;

			while( pNode != NULL )
			{
				pRemoveHolder = RemoveNode( pNode->holder );
				if( pRemoveHolder != NULL )
				{
					MIX_RELEASE( pRemoveHolder );
				}
				pNode = pNode->next;
			}
		}
	};

	//! @class EventDelegate04
	//! @brief CxgfQ[gNX(  : 4 )
	//! @tparam Arg1Type Pڂ̈̌^
	//! @tparam Arg2Type Qڂ̈̌^
	//! @tparam Arg3Type Rڂ̈̌^
	//! @tparam Arg4Type Sڂ̈̌^
	template<typename Arg1Type, typename Arg2Type, typename Arg3Type, typename Arg4Type>
	class _MIX_DLL_API EventDelegate04
	{
	private:
		class Holder : public Mix::Reference
		{
		public:
			void* id0;
			void* id1;

		public:
			virtual void Call( Arg1Type a1, Arg2Type a2, Arg3Type a3, Arg4Type a4 ) const = 0;
		};

		class HolderStatic : public Holder
		{
		private:
			typedef void ( __stdcall *Func )( Arg1Type, Arg2Type, Arg3Type, Arg4Type );

		private:
			Func m_Func;

		public:
			HolderStatic( Func func ) :
			m_Func( func )
			{
				id0 = m_Func;
				id1 = NULL;
			}

		public:
			virtual void Call( Arg1Type a1, Arg2Type a2, Arg3Type a3, Arg4Type a4 ) const
			{
				m_Func( a1, a2, a3, a4 );
			}
		};

		template<typename T>
		class HolderDynamic : public Holder
		{
		private:
			typedef void ( T::*Method )( Arg1Type, Arg2Type, Arg3Type, Arg4Type );

		private:
			T* m_pClass;
			Method m_Method;

		public:
			HolderDynamic( T* pClass, Method method ) :
			m_pClass( pClass ),
			m_Method( method )
			{
				id0 = pClass;
				id1 = &method;
			}

		public:
			virtual void Call( Arg1Type a1, Arg2Type a2, Arg3Type a3, Arg4Type a4 ) const
			{
				( m_pClass->*m_Method )( a1, a2, a3, a4 );
			}
		};

		struct NODE
		{
			Holder* holder;
			NODE* pre;
			NODE* next;
		};

	private:
		NODE* m_pTop;
		NODE* m_pBottom;

	private:
		Boolean AddNode( Holder* pHolder )
		{
			NODE* pNode;

			pNode = m_pTop;
			while( pNode != NULL )
			{
				if( ( pNode->holder->id0 == pHolder->id0 ) &&
					( pNode->holder->id1 == pHolder->id1 ) )
				{
					return False;
				}
				else
				{
					pNode = pNode->next;
				}
			}
			
			pNode = new NODE();
			pNode->holder = pHolder;

			if( m_pTop == NULL )
			{
				m_pTop = m_pBottom = pNode;
				m_pTop->pre = NULL;
				m_pTop->next = NULL;
			}
			else
			{
				pNode->pre = m_pBottom;
				pNode->next = NULL;
				m_pBottom->next = pNode;
				m_pBottom = pNode;
			}

			return True;
		}

		Holder* RemoveNode( Holder* pHolder )
		{
			Holder* pRetHolder = NULL;
			NODE* pNode = m_pTop;

			while( pNode != NULL )
			{
				if( ( pNode->holder->id0 == pHolder->id0 ) &&
					( pNode->holder->id1 == pHolder->id1 ) )
				{
					if( ( m_pTop == pNode ) &&
						( m_pBottom == pNode ) )
					{
						m_pTop = m_pBottom = NULL;
					}
					else if(	( m_pTop == pNode ) &&
								( m_pBottom != pNode ) )
					{
						m_pTop = m_pTop->next;
						m_pTop->pre = NULL;
					}
					else if(	( m_pTop != pNode ) &&
								( m_pBottom == pNode ) )
					{
						m_pBottom = m_pBottom->pre;
						m_pBottom->next = NULL;
					}
					else
					{
						pNode->pre->next = pNode->next;
						pNode->next->pre = pNode->pre;
					}

					pRetHolder = pNode->holder;
					MIX_DELETE( pNode );

					break;
				}
				else
				{
					pNode = pNode->next;
				}
			}

			return pRetHolder;
		}

		//Rs[֎~
		EventDelegate04<Arg1Type, Arg2Type, Arg3Type, Arg4Type>& operator = ( const EventDelegate04<Arg1Type, Arg2Type, Arg3Type, Arg4Type>& ed )
		{
			return *this;
		}

	public:
		//! @brief RXgN^
		EventDelegate04( void ) :
		m_pTop( NULL ),
		m_pBottom( NULL )
		{
		}

		//! @brief Rs[RXgN^
		//! @param[in] ed Rs[CxgfQ[g\ Mix::EventDelegate04 NX
		EventDelegate04( const EventDelegate04<Arg1Type, Arg2Type, Arg3Type, Arg4Type>& ed ) :
		m_pTop( NULL ),
		m_pBottom( NULL )
		{
			*this += ed;
		}

		//! @brief RXgN^
		//! @param[in] ( __stdcall *func )( Arg1Type, Arg2Type, Arg3Type, Arg4Type ) ֐̃|C^
		EventDelegate04( void ( __stdcall *func )( Arg1Type, Arg2Type, Arg3Type, Arg4Type ) ) :
		m_pTop( NULL ),
		m_pBottom( NULL )
		{
			AddNode( new HolderStatic( func ) ); 
		}

		//! @brief RXgN^
		//! @tparam T NX̃^Cv
		//! @param[in] pClass NX̃|C^
		//! @param[in] method NX̃\bh
		template<typename T>
		EventDelegate04( T* pClass, void ( T::*method )( Arg1Type, Arg2Type, Arg3Type, Arg4Type ) ) :
		m_pTop( NULL ),
		m_pBottom( NULL )
		{
			AddNode( new HolderDynamic<T>( pClass, method ) );
		}

		//! @brief fXgN^
		~EventDelegate04( void )
		{
			NODE* pNode = m_pTop;
			NODE* pNextNode;
			while( pNode != NULL )
			{
				pNextNode = pNode->next;
				MIX_RELEASE( pNode->holder );
				MIX_DELETE( pNode );
				pNode = pNextNode;
			}
		}

	public:
		//! @brief o^\bhĂяo܂
		void operator ()( Arg1Type a1, Arg2Type a2, Arg3Type a3, Arg4Type a4 ) const
		{
			NODE* pNode = m_pTop;
			while( pNode != NULL )
			{
				pNode->holder->Call( a1, a2, a3, a4 );
				pNode = pNode->next;
			}
		}

		//! @brief CxgfQ[gǉ܂
		//! @param[in] ed ǉCxgfQ[g\ Mix::EventDelegate04 NX
		void operator += ( const Mix::EventDelegate04<Arg1Type, Arg2Type, Arg3Type, Arg4Type>& ed )
		{
			NODE* pNode = ed.m_pTop;
			while( pNode != NULL )
			{
				if( AddNode( pNode->holder ) == True )
				{
					pNode->holder->AddRef();
				}
				pNode = pNode->next;
			}
		}

		//! @brief CxgfQ[g폜܂
		//! @param[in] ed 폜CxgfQ[g\ Mix::EventDelegate04 NX
		void operator -= ( const Mix::EventDelegate04<Arg1Type, Arg2Type, Arg3Type, Arg4Type>& ed )
		{
			Holder* pRemoveHolder;
			NODE* pNode = ed.m_pTop;

			while( pNode != NULL )
			{
				pRemoveHolder = RemoveNode( pNode->holder );
				if( pRemoveHolder != NULL )
				{
					MIX_RELEASE( pRemoveHolder );
				}
				pNode = pNode->next;
			}
		}
	};

}
