#pragma once

//! @file Mix/Dynamics/IVehicle.h
//! @brief rnCNC^[tF[XCN[ht@C

#include "Mix/Dynamics/IObject.h"

namespace Mix{ namespace Dynamics{

	//! @class IVehicleWheel
	//! @brief rnCNzC[C^[tF[X
	class IVehicleWheel : public Mix::Reference
	{
	public:
		//! @struct TIRE
		//! @brief ^C\
		struct TIRE
		{
			Float32 radius;			//!< a
			Float32 friction;		//!< CW
		};

		//! @struct SUSPENSION
		//! @brief TXyV\
		struct SUSPENSION
		{
			Float32 restLength;			//!< ([gP)
			Float32 maxTravelCm;		//!< ғ͈(Z`[gP)
			Float32 maxForce;			//!< őtH[X
			Float32 springStiffness;	//!< ol̍
			Float32 damperRelaxation;	//!< olLтۂɓKp_p[̌l
			Float32 damperCompression;	//!< olkލۂɓKp_p[̌l
		};

		//! @struct CONTACT
		//! @brief R^Ng\
		struct CONTACT
		{
			Mix::Vector3 worldPosition;	//!< ڐGʒũ[hW
			Mix::Vector3 worldNormal;	//!< ڐGʒũ[h@
		};

	protected:
		//! @brief fXgN^
		virtual ~IVehicleWheel( void ) {}

	public:
		//! @brief tgǂ擾܂
		//! @return tg̏ꍇ True Ԃ܂
		virtual Boolean IsFront( void ) const = 0;
		//! @brief 擾܂
		//! @return \ Mix::Vector3 NXԂ܂
		virtual const Mix::Vector3& GetDirection( void ) const = 0;
		//! @brief 擾܂
		//! @return \ Mix::Vector3 NXԂ܂
		virtual const Mix::Vector3& GetAxis( void ) const = 0;

		//! @brief ڑʒu擾܂
		//! @return ڑʒu\ Mix::Vector3 NXԂ܂
		virtual const Mix::Vector3& GetConnectionPoint( void ) const = 0;
		//! @brief ڑʒuݒ肵܂
		//! @param[in] cp ڑʒu\ Mix::Vector3 NX
		virtual void SetConnectionPoint( const Mix::Vector3& cp ) = 0;

		//! @brief ԑ̂]ex擾܂
		//! @return exԂ܂
		virtual Float32 GetRollInfluence( void ) const = 0;
		//! @brief ԑ̂]exݒ肵܂
		//! @param[in] rollInfluence ex
		//! @note lقǁAXeAOȂǂɎԑ̂]₷Ȃ܂
		virtual void SetRollInfluence( Float32 rollInfluence ) = 0;

		//! @brief ^C擾܂
		//! @return ^C\ Mix::Dynamics::IVehicleWheel::TIRE \̂Ԃ܂
		virtual const Mix::Dynamics::IVehicleWheel::TIRE& GetTire( void ) const = 0;
		//! @brief ^Cݒ肵܂
		//! @param[in] tire ^C\ Mix::Dynamics::IVehicleWheel::TIRE \
		virtual void SetTire( const Mix::Dynamics::IVehicleWheel::TIRE& tire ) = 0;

		//! @brief TXyV擾܂
		//! @return TXyV\ Mix::Dynamics::IVehicleWheel::SUSPENSION \̂Ԃ܂
		virtual const Mix::Dynamics::IVehicleWheel::SUSPENSION& GetSuspension( void ) const = 0;
		//! @brief TXyVݒ肵܂
		//! @param[in] suspension TXyV\ Mix::Dynamics::IVehicleWheel::SUSPENSION \
		virtual void SetSuspension( const Mix::Dynamics::IVehicleWheel::SUSPENSION& suspension ) = 0;

		//! @brief XeAO̒l擾܂
		//! @return XeAO̒lԂ܂
		virtual Float32 GetSteeringValue( void ) const = 0;
		//! @brief XeAO̒lݒ肵܂
		//! @param[in] value XeAO̒l( WAP )
		virtual void SetSteeringValue( Float32 value ) = 0;

		//! @brief GW͂擾܂
		//! @return GW̗͂Ԃ܂
		virtual Float32 GetEngineForce( void ) const = 0;
		//! @brief GW̗͂ݒ肵܂
		//! @param[in] force GW̗
		virtual void SetEngineForce( Float32 force ) = 0;

		//! @brief u[L̗͂擾܂
		//! @return u[L̗͂Ԃ܂
		virtual Float32 GetBreakingForce( void ) const = 0;
		//! @brief u[L̗͂ݒ肵܂
		//! @param[in] force u[L̗
		virtual void SetBreakingForce( Float32 force ) = 0;

		//! @brief ڒnĂ邩ǂmF܂
		//! @return ڒnĂꍇ True Ԃ܂
		virtual Boolean OnGround( void ) const = 0;

		//! @brief ڐG擾܂
		//! @return ڐG\ Mix::Dynamics::IVehicleWheel::CONTACT \̂Ԃ܂
		//! @note ڒnĂȂꍇ( OnGround() == False )AʒuA@ ( 0.0f, 0.0f, 0.0f ) ݒ肳܂B
		virtual Mix::Dynamics::IVehicleWheel::CONTACT GetContact( void ) const = 0;

		//! @brief [hs擾܂
		//! @return [hs\ Mix::Matrix4x4 NXԂ܂
		virtual const Mix::Matrix4x4& GetWorldMatrix( void ) = 0;
	};

	//! @class IVehicle
	//! @brief rnCNC^[tF[X
	class IVehicle : public Mix::Dynamics::IObject
	{
	protected:
		//! @brief fXgN^
		virtual ~IVehicle( void ) {}

	public:
		//! @brief Zbg܂
		//! @note xڐGTXyVNA܂
		virtual void Reset( void ) = 0;
		//! @brief Zbg܂
		//! @param[in] worldRot Zbg̉]\ Mix::Quaternion NX
		//! @param[in] worldPos Zbg̈ʒu\ Mix::Vector3 NX
		//! @note xڐGTXyVNA܂
		virtual void Reset( const Mix::Quaternion& worldRot, const Mix::Vector3& worldPos ) = 0;

		//! @brief zC[̐擾܂
		//! @return zC[̐Ԃ܂
		virtual UInt32 GetWheelNum( void ) const = 0;
		//! @brief zC[擾܂
		//! @param[in] wheelIndex zC[̃CfbNX
		//! @param[out] ppWheel zC[\ Mix::Dynamics::IVehicleWheel C^[tF[X̃|C^̃AhX
		//! @return ꍇ True Ԃ܂
		//! @note 擾zC[͎QƃJEg +1 ܂
		virtual Boolean GetWheel( UInt32 wheelIndex, Mix::Dynamics::IVehicleWheel** ppWheel ) = 0;
		//! @brief zC[̃|C^擾܂
		//! @param[in] wheelIndex zC[̃CfbNX
		//! @return zC[\ Mix::Dynamics::IVehicleWheel C^[tF[X̃|C^Ԃ܂
		virtual Mix::Dynamics::IVehicleWheel* GetWheelPtr( UInt32 wheelIndex ) const = 0;

		//! @brief ̑x(L[gP)擾܂
		//! @return ̑xԂ܂
		virtual Float32 GetCurrentSpeedKmHour( void ) const = 0;
	};

}}
