#pragma once

//! @file Mix/Dynamics/IStaticPlane.h
//! @brief X^eBbNv[C^[tF[XCN[ht@C

#include "Mix/Dynamics/IObject.h"

namespace Mix{ namespace Dynamics{

	//! @class IStaticPlane
	//! @brief X^eBbNv[C^[tF[X
	//! @note
	//! ȉ̃\bh͋@\܂B<br>
	//! <br>
	//! GetRotation<br>
	//! SetRotation<br>
	//! GetPosition<br>
	//! SetPosition<br>
	//! GetShape<br>
	class IStaticPlane : public Mix::Dynamics::IObject
	{
	protected:
		//! @brief fXgN^
		virtual ~IStaticPlane( void ) {}

	public:
		//! @brief @擾܂
		//! @return @\ Mix::Vector3 NXԂ܂
		virtual const Mix::Vector3& GetNormal( void ) const = 0;
		//! @brief 萔擾܂
		//! @return 萔Ԃ܂
		virtual float GetConstant( void ) const = 0;

		//! @brief C[t[̃C̊Ԋu擾܂
		//! @return C̊ԊuԂ܂
		virtual Float32 Debug_GetDrawInterval( void ) const = 0;
		//! @brief C[t[̃C̊Ԋuݒ肵܂
		//! @param[in] interval C̊Ԋu
		virtual void Debug_SetDrawInterval( Float32 interval ) = 0;

		//! @brief C[t[̍L擾܂
		//! @return LԂ܂
		virtual UInt32 Debug_GetDrawExtent( void ) const = 0;
		//! @brief C[t[̍Lݒ肵܂
		//! @param[in] extent L
		//! @note ۂ̍L( C̊Ԋu * ( L + 1 ) )ɂȂ܂
		virtual void Debug_SetDrawExtent( UInt32 extent ) = 0;
	};

}}
