#pragma once

//! @file Mix/Dynamics/IStaticMesh.h
//! @brief X^eBbNbVC^[tF[XCN[ht@C

#include "Mix/Dynamics/IObject.h"

namespace Mix{ namespace Dynamics{

	//! @class IStaticMesh
	//! @brief X^eBbNbVC^[tF[X
	class IStaticMesh : public Mix::Dynamics::IObject
	{
	protected:
		//! @brief fXgN^
		virtual ~IStaticMesh( void ) {}

	public:
		//! @brief p[g擾܂
		//! @return p[gԂ܂
		virtual UInt32 GetPartCount( void ) const = 0;
		//! @brief |S擾܂
		//! @return |SԂ܂
		virtual UInt32 GetPolygonCount( UInt32 partIndex ) const = 0;
		//! @brief |S擾܂
		//! @return |SԂ܂
		virtual UInt32 GetTotalPolygonCount( void ) const = 0;
		//! @brief }eA擾܂
		//! @return }eAԂ܂
		virtual UInt32 GetMaterialCount( void ) const = 0;

		//! @brief |S̃}eACfbNX擾܂
		//! @param[in] partIndex p[g̃CfbNX
		//! @param[in] polygonIndex |S̃CfbNX
		//! @return |S̃}eACfbNXԂ܂<br>
		//! w肵|S̃CfbNX͈͊Ȍꍇ́A 0xFFFFFFFF Ԃ܂
		virtual UInt32 GetMaterialIndex( UInt32 partIndex, UInt32 polygonIndex ) const = 0;
		//! @brief |S̃}eACfbNXݒ肵܂
		//! @param[in] partIndex p[g̃CfbNX
		//! @param[in] polygonIndex |S̃CfbNX
		//! @param[in] materialIndex }eÃCfbNX
		//! @return ꍇ True Ԃ܂
		virtual Boolean SetMaterialIndex( UInt32 partIndex, UInt32 polygonIndex, UInt32 materialIndex ) = 0;
		//! @brief |S̃}eACfbNXz擾܂
		//! @param[in] partIndex p[g̃CfbNX
		//! @param[in] polygonStartIndex 擾Jn|S̃CfbNX
		//! @param[in] polygonCount 擾|S̐
		//! @param[out] ppMaterialIndices p[g̃}eACfbNXz
		//! @return ۂɎ擾Ԃ܂
		virtual UInt32 LockMaterialIndices( UInt32 partIndex, UInt32 polygonStartIndex, UInt32 polygonCount, UInt32** ppMaterialIndices ) const = 0;

		//! @brief }eA擾܂
		//! @param[in] index }eÃCfbNX
		//! @return }eA\ Mix::Dynamics::MATERIAL Ԃ܂
		//! @note CfbNX͈͊Ȍꍇ͏lԂ܂B
		virtual const Mix::Dynamics::MATERIAL& GetMaterial( UInt32 index ) const = 0;
		//! @brief }eA擾܂
		//! @param[in] index }eÃCfbNX
		//! @param[out] material 擾}eAn 
		//! @return 擾ɐꍇ True Ԃ܂
		virtual Boolean GetMaterial( UInt32 index, Mix::Dynamics::MATERIAL& material ) const = 0;
		//! @brief }eA擾܂
		//! @param[in] partIndex p[g̃CfbNX
		//! @param[in] polygonIndex |S̃CfbNX
		//! @return }eA\ Mix::Dynamics::MATERIAL Ԃ܂
		//! @note p[gA|S̃CfbNX͈͊Ȍꍇ͏lԂ܂B
		virtual const Mix::Dynamics::MATERIAL& GetMaterial( UInt32 partIndex, UInt32 polygonIndex ) const = 0;
		//! @brief }eA擾܂
		//! @param[in] partIndex p[g̃CfbNX
		//! @param[in] polygonIndex |S̃CfbNX
		//! @param[out] material 擾}eAn 
		//! @return 擾ɐꍇ True Ԃ܂
		virtual Boolean GetMaterial( UInt32 partIndex, UInt32 polygonIndex, Mix::Dynamics::MATERIAL& material ) const = 0;
		//! @brief }eAݒ肵܂
		//! @param[in] index }eÃCfbNX
		//! @param[in] material ݒ肷}eA\ Mix::Dynamics::MATERIAL \
		//! @return ꍇ True Ԃ܂
		virtual Boolean SetMaterial( UInt32 index, const Mix::Dynamics::MATERIAL& material ) = 0;
		//! @brief }eAz擾܂
		//! @param[in] startIndex 擾JnCfbNX
		//! @param[in] count 擾
		//! @param[out] ppMaterials 擾}eAzn Mix::Dynamics::MATERIAL \̂̃|C^̃AhX
		//! @return ۂɎ擾Ԃ܂
		virtual UInt32 LockMaterials( UInt32 startIndex, UInt32 count, Mix::Dynamics::MATERIAL** ppMaterials ) const = 0;
	};

}}
