#pragma once

//! @file Mix/Dynamics/ISliderJoint.h
//! @brief XC_[WCgC^[tF[XCN[ht@C

#include "Mix/Dynamics/IJoint.h"

namespace Mix{ namespace Dynamics{

	//! @class ISliderJoint
	//! @brief XC_[WCgC^[tF[X
	//! @note Wbh{fB܂ȃ[ɍS܂B
	class ISliderJoint : public Mix::Dynamics::IJoint
	{
	public:
		//! @brief fXgN^
		virtual ~ISliderJoint( void ){}

	public:
		//! @brief Wbh{fB`̉]擾܂
		//! @return ]\ Mix::Quaternion NXԂ܂
		virtual const Mix::Quaternion& GetRotationA( void ) const = 0;
		//! @brief Wbh{fB`̉]ݒ肵܂
		//! @param[in] rot ]\ Mix::Quaternion NX
		virtual void SetRotationA( const Mix::Quaternion& rot ) = 0;

		//! @brief Wbh{fBả]擾܂
		//! @return ]\ Mix::Quaternion NXԂ܂
		virtual const Mix::Quaternion& GetRotationB( void ) const = 0;
		//! @brief Wbh{fBả]ݒ肵܂
		//! @param[in] rot ]\ Mix::Quaternion NX
		virtual void SetRotationB( const Mix::Quaternion& rot ) = 0;

		//! @brief `ړ͈̔͂ݒ肵܂
		//! @param[in] lower ŏl
		//! @param[in] upper ől
		virtual void SetLinearLimit( Float32 lower, Float32 upper ) = 0;
		//! @brief `ړ͈̔͂̍ŏl擾܂
		//! @return `ړ͈̔͂̍ŏlԂ܂
		virtual Float32 GetLinearLowerLimit( void ) const = 0;
		//! @brief `ړ͈̔͂̍ől擾܂
		//! @return `ړ͈̔͂̍őlԂ܂
		virtual Float32 GetLinearUpperLimit( void ) const = 0;

		//! @brief ]px͈̔͂ݒ肵܂
		//! @param[in] lower ŏl( WAP )
		//! @param[in] upper ől( WAP )
		virtual void SetAngularLimit( Float32 lower, Float32 upper ) = 0;
		//! @brief ]px͈̔͂̍ŏl擾܂
		//! @return ]px͈̔͂̍ŏlԂ܂
		virtual Float32 GetAngularLowerLimit( void ) const = 0;
		//! @brief ]px͈̔͂̍ől擾܂
		//! @return ]px͈̔͂̍őlԂ܂
		virtual Float32 GetAngularUpperLimit( void ) const = 0;

		//! @brief `^[^[Lǂ擾܂
		//! @return Lȏꍇ True Ԃ܂
		virtual Boolean GetLinearMotorEnabled( void ) const = 0;
		//! @brief `^[^[Lɂ邩ǂݒ肵܂
		//! @param[in] state Lɂꍇ True
		virtual void SetLinearMotorEnabled( Boolean state ) = 0;
		//! @brief `^[^[̖ڕWx擾܂
		//! @return `^[^[̖ڕWxԂ܂
		virtual Float32 GetLinearMotorTargetVelocity( void ) const = 0;
		//! @brief `^[^[̖ڕWxݒ肵܂
		//! @param[in] tv ڕWx
		virtual void SetLinearMotorTargetVelocity( Float32 tv ) = 0;
		//! @brief `^[^[̍őtH[X擾܂
		//! @return `^[^[̍őtH[XԂ܂
		virtual Float32 GetLinearMotorMaxForce( void ) const = 0;
		//! @brief `^[^[̍őtH[Xݒ肵܂
		//! @param[in] mf őtH[X
		virtual void SetLinearMotorMaxForce( Float32 mf ) = 0;

		//! @brief p^[^[Lǂ擾܂
		//! @return Lȏꍇ True Ԃ܂
		virtual Boolean GetAngularMotorEnabled( void ) const = 0;
		//! @brief p^[^[Lɂ邩ǂݒ肵܂
		//! @param[in] state Lɂꍇ True
		virtual void SetAngularMotorEnabled( Boolean state ) = 0;
		//! @brief p^[^[̑x擾܂
		//! @return p^[^[̑xԂ܂
		virtual Float32 GetAngularMotorTargetVelocity( void ) const = 0;
		//! @brief p^[^[̖ڕWxݒ肵܂
		//! @param[in] tv ڕWx
		virtual void SetAngularMotorTargetVelocity( Float32 tv ) = 0;
		//! @brief p^[^[̍őtH[X擾܂
		//! @return p^[^[̍őtH[XԂ܂
		virtual Float32 GetAngularMotorMaxForce( void ) const = 0;
		//! @brief p^[^[̍őtH[Xݒ肵܂
		//! @param[in] mf őtH[X
		virtual void SetAngularMotorMaxForce( Float32 mf ) = 0;

		//! @brief `ړ͈̔( SetLinearLimit )𒴂ۂ̃XvÔ炩擾܂
		//! @return XvÔ炩Ԃ܂
		virtual Float32 GetLinearLimit_LimSpring( void ) const = 0;
		//! @brief `ړ͈̔( SetLinearLimit )𒴂ۂ̃XvÔ炩ݒ肵܂
		//! @param[in] spring XvÔ炩( 0.0f`1.0f )
		virtual void SetLinearLimit_LimSpring( Float32 spring ) = 0;
		//! @brief `ړ͈̔( SetLinearLimit )𒴂ۂ̃_p[̌͂擾܂
		//! @return _p[̌͂Ԃ܂
		virtual Float32 GetLinearLimit_LimDamper( void ) const = 0;
		//! @brief `ړ͈̔( SetLinearLimit )𒴂ۂ̃_p[̌͂ݒ肵܂
		//! @param[in] damper _p[̌( 0.2f`0.8f )
		virtual void SetLinearLimit_LimDamper( Float32 damper ) = 0;
		//! @brief `ړ̎ɑ΂Đȕ̃XvÔ炩擾܂
		//! @return XvÔ炩Ԃ܂
		virtual Float32 GetLinearLimit_OrthoSpring( void ) const = 0;
		//! @brief `ړ̎ɑ΂Đȕ̃XvÔ炩ݒ肵܂
		//! @param[in] spring XvÔ炩( 0.0f`1.0f );
		virtual void SetLinearLimit_OrthoSpring( Float32 spring ) = 0;
		//! @brief `ړ̎ɑ΂Đȕ̃_p[̌͂擾܂
		//! @return _p[̌͂Ԃ܂
		virtual Float32 GetLinearLimit_OrthoDamper( void ) const = 0;
		//! @brief `ړ̎ɑ΂Đȕ̃_p[̌͂ݒ肵܂
		//! @param[in] damper _p[̌( 0.2f`0.8f )
		virtual void SetLinearLimit_OrthoDamper( Float32 damper ) = 0;

		//! @brief ]͈̔( SetAngularLimit )𒴂ۂ̃XvÔ炩擾܂
		//! @return 炩Ԃ܂
		virtual Float32 GetAngularLimit_LimSpring( void ) const = 0;
		//! @brief ]͈̔( SetAngularLimit )𒴂ۂ̃XvÔ炩ݒ肵܂
		//! @param[in] spring XvÔ炩( 0.0f`1.0f )
		virtual void SetAngularLimit_LimSpring( Float32 spring ) = 0;
		//! @brief ]͈̔( SetAngularLimit )𒴂ۂ̃_p[̌͂擾܂
		//! @return _p[̌͂Ԃ܂
		virtual Float32 GetAngularLimit_LimDamper( void ) const = 0;
		//! @brief ]͈̔( SetAngularLimit )𒴂ۂ̃_p[̌͂ݒ肵܂
		//! @param[in] damper _p[̌( 0.2f`0.8f )
		virtual void SetAngularLimit_LimDamper( Float32 damper ) = 0;
		//! @brief ]̎ɑ΂ĐȎ̃XvÔ炩擾܂
		//! @return XvÔ炩Ԃ܂
		virtual Float32 GetAngularLimit_OrthoSpring( void ) const = 0;
		//! @brief ]̎ɑ΂ĐȎ̃XvÔ炩ݒ肵܂
		//! @param[in] spring XvÔ炩( 0.0f`1.0f )
		virtual void SetAngularLimit_OrthoSpring( Float32 spring ) = 0;
		//! @brief ]̎ɑ΂ĐȎ̃_p[̌͂擾܂
		//! @return _p[̌͂Ԃ܂
		virtual Float32 GetAngularLimit_OrthoDamper( void ) const = 0;
		//! @brief ]̎ɑ΂ĐȎ̃_p[̌͂ݒ肵܂
		//! @param[in] damper _p[̌( 0.2f`0.8f )
		virtual void SetAngularLimit_OrthoDamper( Float32 damper ) = 0;
	};

}}
