#pragma once

//! @file Mix/Dynamics/IShape.h
//! @brief VFCvC^[tF[XCN[ht@C

#include "Mix/Reference.h"

namespace Mix{ namespace Dynamics{

	//! @class IShape
	//! @brief VFCvC^[tF[X
	class IShape : public Mix::Reference
	{
	public:
		//! @enum TYPE
		//! @brief ^Cv񋓒萔
		enum TYPE
		{
			BOX			= 0,	//!< {bNX
			CAPSULE		= 1,	//!< JvZ
			COMPOUND	= 2,	//!< RpEh()
			CONE		= 3,	//!< R[
			CONVEXHULL	= 4,	//!< RxbNXn(ʕ)
			CYLINDER	= 5,	//!< V_[
			SPHERE		= 6,	//!< XtBA
		};

	protected:
		//! @brief fXgN^
		virtual ~IShape( void ){}

	public:
		//! @brief VFCv̎ނ擾܂
		//! @return VFCv̎ނ\ Mix::Dynamics::IShape::TYPE 񋓒萔Ԃ܂
		virtual Mix::Dynamics::IShape::TYPE GetType( void ) const = 0;

		//! @brief Փ˃}[W擾܂
		//! @return Փ˃}[WԂ܂
		virtual Float32 GetMargin( void ) const = 0;
		//! @brief Փ˃}[Wݒ肵܂
		//! @param[in] margin Փ˃}[W
		//! @note
		//! ̒l邱ƂɂĂ߂荞݂ɂȂ܂B<br>
		//! Aݒ肵ƕ悤ȏԂɂȂ܂̂ŒӂĂB
		virtual void SetMargin( Float32 margin ) = 0;

		//! @brief fobO`܂
		//! @param[in] pLineArt fobO`p̃C^[tF[X\ Mix::Graphics::Utility::ILineArt C^[tF[X̃|C^
		virtual void DebugDraw( Mix::Graphics::Utility::ILineArt* pLineArt ) = 0;
	};

}}
