#pragma once

//! @file Mix/Dynamics/IJoint.h
//! @brief WCgC^[tF[XCN[ht@C

#include "Mix/Reference.h"

namespace Mix{ namespace Dynamics{

	//! @class IJoint
	//! @brief WCgC^[tF[X
	class IJoint : public Mix::Reference
	{
	public:
		//! @enum TYPE
		//! @brief ^Cv񋓒萔
		enum TYPE
		{
			POINT	= 0,	//!< |Cg
			HINGE	= 1,	//!< qW
			BALL	= 2,	//!< {[
			SLIDER	= 3,	//!< XC_[
			DOF		= 4,	//!< DOF
		};

	public:
		//! @brief fXgN^
		virtual ~IJoint( void ){}

	public:
		//! @brief ނ擾܂
		//! @return ނ\ Mix::Dynamics::IJoint::TYPE 񋓒萔
		virtual Mix::Dynamics::IJoint::TYPE GetType( void ) const = 0;

		//! @brief [hɔzuĂ邩ǂmF܂
		//! @return zuĂꍇ True Ԃ܂
		virtual Boolean IsInWorld( void ) const = 0;

		//! @brief ڑLǂmF܂
		//! @return Lȏꍇ True Ԃ܂
		virtual Boolean IsEnabled( void ) const = 0;
		//! @brief ڑLɂ邩ǂݒ肵܂
		//! @param[in] state Lɂꍇ True
		virtual void SetEnabled( Boolean state ) = 0;

		//! @brief ڑ͂擾܂
		//! @return ͂Ԃ܂
		virtual Float32 GetBreakingImpulseThreshold( void ) const = 0;
		//! @brief ڑ͂ݒ肵܂
		//! @param[in] threshold ( Pʂ̓j[g )
		//! @note d͂傫lݒ肷Kv܂
		virtual void SetBreakingImpulseThreshold( Float32 threshold ) = 0;

		//! @brief VOǂ擾܂
		//! @return VȌꍇ True Ԃ܂
		//! @note VOƂ́AWbh{fB`̂ݎw肳ĂĂŁAWbh{fBaw肳ĂȂꍇ̂Ƃ܂
		virtual Boolean IsSingle( void ) const = 0;

		//! @brief Wbh{fBA擾܂
		//! @param[out] ppRigidBody 擾Wbh{fBA\ Mix::Dynamics::IRigidBody C^[tF[X̃|C^̃AhX
		//! @note 擾Wbh{fB́AQƃJE^ +1 ܂
		virtual void GetRigidBodyA( Mix::Dynamics::IRigidBody** ppRigidBody ) = 0;
		//! @brief Wbh{fBB擾܂
		//! @param[out] ppRigidBody 擾Wbh{fBB\ Mix::Dynamics::IRigidBody C^[tF[X̃|C^̃AhX
		//! @note 擾Wbh{fB́AQƃJE^ +1 ܂
		virtual void GetRigidBodyB( Mix::Dynamics::IRigidBody** ppRigidBody ) = 0;

		//! @brief Wbh{fB`̃s{bg擾܂
		//! @return s{bg\ Mix::Vectro3 NXԂ܂
		virtual const Mix::Vector3& GetPivotA( void ) const = 0;
		//! @brief Wbh{fB`̃s{bgݒ肵܂
		//! @param[in] pivot s{bg\ Mix::Vectro3 NX
		virtual void SetPivotA( const Mix::Vector3& pivot ) = 0;

		//! @brief Wbh{fBãs{bg擾܂
		//! @return s{bg\ Mix::Vectro3 NXԂ܂
		virtual const Mix::Vector3& GetPivotB( void ) const = 0;
		//! @brief Wbh{fBãs{bgݒ肵܂
		//! @param[in] pivot s{bg\ Mix::Vectro3 NX
		virtual void SetPivotB( const Mix::Vector3& pivot ) = 0;

	public:
		//! @brief fobO : `tO擾܂
		//! @return `tO\ Mix::Dynamics::DEBUG_DRAW_FLAG 񋓒萔̑gݍ킹Ԃ܂
		virtual UInt32 Debug_GetDrawFlags( void ) const = 0;
		//! @brief fobO : `tOݒ肵܂
		//! @param[in] flags `tO\ Mix::Dynamics::DEBUG_DRAW_FLAG 񋓒萔̑gݍ킹
		virtual void Debug_SetDrawFlags( UInt32 flags ) = 0;

		//! @brief fobO : t[`悷ۂ̍ŏTCY擾܂
		//! @return t[`悷ۂ̍ŏTCYԂ܂
		virtual Float32 Debug_GetDrawFrameMinSize( void ) const = 0;
		//! @brief fobO : t[`悷ۂ̍ŏTCYݒ肵܂
		//! @param[in] minSize t[`悷ۂ̍ŏTCY( 0.0fȏ )
		virtual void Debug_SetDrawFrameMinSize( Float32 minSize ) = 0;

		//! @brief fobO : ~bg`悷ۂ̂擾܂
		//! @return ~bg`悷ۂ̃XP[Ԃ܂
		virtual Float32 Debug_GetDrawLimitScaling( void ) const = 0;
		//! @brief fobO : ~bg`悷ۂ̃XP[ݒ肵܂
		//! @param[in] scaling ~bg`悷ۂ̃XP[( 0.0fȏ )
		virtual void Debug_SetDrawLimitScaling( Float32 scaling ) = 0;

		//! @brief fobO`܂
		//! @param[in] pLineArt fobO`p̃C^[tF[X\ Mix::Graphics::Utility::ILineArt C^[tF[X̃|C^
		//! @param[in] opacity sx( 0.0f`1.0f )
		virtual void Debug_Draw( Mix::Graphics::Utility::ILineArt* pLineArt, Float32 opacity = 1.0f ) = 0;
	};

}}
