#pragma once

//! @file Mix/Dynamics/IDofJoint.h
//! @brief DOFWCgC^[tF[XCN[ht@C

#include "Mix/Dynamics/IJoint.h"

namespace Mix{ namespace Dynamics{

	//! @class IDofJoint
	//! @brief DOFWCgC^[tF[X
	//! @note
	//! 3ŃXC_[WCgłB<br>
	//! <br>
	//! ol̋⌸lύXꍇ́AuލʒuvXVKv܂B<br>
	//! ȉ̊֐gpꍇ́AK UpdateEquilibriumPoint ĂяoĂB<br>
	//! <br>
	//! SetLinearLimit<br>
	//! SetAngularLimit<br>
	//! SetLinearStiffness<br>
	//! SetLinearDamping<br>
	//! SetAngularStiffness<br>
	//! SetAngularDamping<br>
	class IDofJoint : public Mix::Dynamics::IJoint
	{
	protected:
		//! @brief fXgN^
		virtual ~IDofJoint( void ){}

	public:
		//! @brief Wbh{fB`̉]擾܂
		//! @return ]\ Mix::Quaternion NXԂ܂
		virtual const Mix::Quaternion& GetRotationA( void ) const = 0;
		//! @brief Wbh{fB`̉]ݒ肵܂
		//! @param[in] rot ]\ Mix::Quaternion NX
		virtual void SetRotationA( const Mix::Quaternion& rot ) = 0;

		//! @brief Wbh{fBả]擾܂
		//! @return ]\ Mix::Quaternion NXԂ܂
		virtual const Mix::Quaternion& GetRotationB( void ) const = 0;
		//! @brief Wbh{fBả]ݒ肵܂
		//! @param[in] rot ]\ Mix::Quaternion NX
		virtual void SetRotationB( const Mix::Quaternion& rot ) = 0;

		//! @brief `^̉ғ͈͂ݒ肵܂
		//! @param[in] lower `^̉ғ͈͂̍ŏl\ Mix::Vector3 NX
		//! @param[in] upper `^̉ғ͈͂̍ől\ Mix::Vector3 NX
		virtual void SetLinearLimit( const Mix::Vector3& lower, const Mix::Vector3& upper ) = 0;
		//! @brief `^̉ғ͈͂̍ŏl擾܂
		//! @return `^̉ғ͈͂̍ŏl\ Mix::Vector3 NXԂ܂
		virtual const Mix::Vector3& GetLinearLowerLimit( void ) const = 0;
		//! @brief `^̉ғ͈͂̍ől擾܂
		//! @return `^̉ғ͈͂̍ől\ Mix::Vector3 NXԂ܂
		virtual const Mix::Vector3& GetLinearUpperLimit( void ) const = 0;
		//! @brief `^̃ol̋ݒ肵܂
		//! @param[in] stiffness `^̃ol̋\ Mix::Vector3 NX
		//! @note ol̋ 0.0f ݒ肷ƃoľʂ𖳌ɂ邱Ƃł܂
		virtual void SetLinearStiffness( const Mix::Vector3& stiffness ) = 0;
		//! @brief `^̃ol̋擾܂
		//! @return `^̃ol̋\ Mix::Vector3 NX
		virtual const Mix::Vector3& GetLinearStiffness( void ) const = 0;
		//! @brief `^̌lݒ肵܂
		//! @param[in] damping `^̌l\ Mix::Vector3 NX
		virtual void SetLinearDamping( const Mix::Vector3& damping ) = 0;
		//! @brief `^̌l擾܂
		//! @return `^̌l\ Mix::Vector3 NX
		virtual const Mix::Vector3& GetLinearDamping( void ) const = 0;
		//! @brief `^͈̔͂𒴂ۂ̃XvÔ炩擾܂
		//! @return XvÔ炩Ԃ܂
		virtual const Mix::Vector3& GetLinearLimitSpring( void ) const = 0;
		//! @brief `^͈̔͂𒴂ۂ̃XvÔ炩ݒ肵܂
		//! @param[in] spring XvÔ炩( 0.0f`1.0f )
		virtual void SetLinearLimitSpring( const Mix::Vector3& spring ) = 0;
		//! @brief `^͈̔͂𒴂ۂ̃_p[͎̌擾܂
		//! @return _p[̌͂Ԃ܂
		virtual const Mix::Vector3& GetLinearLimitDamper( void ) const = 0;
		//! @brief `^͈̔͂𒴂ۂ̃_p[̌͐ݒ肵܂
		//! @param[in] damper _p[̌( 0.2f`0.8f )
		virtual void SetLinearLimitDamper( const Mix::Vector3& damper ) = 0;

		//! @brief ]͈̔͂ݒ肵܂
		//! @param[in] lower ]͈̔͂̍ŏl\ Mix::Vector3 NX
		//! @param[in] upper ]͈̔͂̍ől\ Mix::Vector3 NX
		virtual void SetAngularLimit( const Mix::Vector3& lower, const Mix::Vector3& upper ) = 0;
		//! @brief ]͈̔͂̍ŏl擾܂
		//! @return ]͈̔͂̍ŏl\ Mix::Vector3 NXԂ܂
		virtual const Mix::Vector3& GetAngularLowerLimit( void ) const = 0;
		//! @brief ]͈̔͂̍ől擾܂
		//! @return ]͈̔͂̍ől\ Mix::Vector3 NXԂ܂
		virtual const Mix::Vector3& GetAngularUpperLimit( void ) const = 0;
		//! @brief ]̃ol̋ݒ肵܂
		//! @param[in] stiffness p^̃ol̋\ Mix::Vector3 NX
		//! @note ol̋ 0.0f ݒ肷ƃoľʂ𖳌ɂ邱Ƃł܂
		virtual void SetAngularStiffness( const Mix::Vector3& stiffness ) = 0;
		//! @brief ]̃XvŐ擾܂
		//! @return ]̃XvŐ\ Mix::Vector3 NX
		virtual const Mix::Vector3& GetAngularStiffness( void ) const = 0;
		//! @brief ]̌lݒ肵܂
		//! @param[in] damping p^̌l\ Mix::Vector3 NX
		virtual void SetAngularDamping( const Mix::Vector3& damping ) = 0;
		//! @brief ]̌l擾܂
		//! @return ]̌l\ Mix::Vector3 NX
		virtual const Mix::Vector3& GetAngularDamping( void ) const = 0;
		//! @brief ]͈̔͂𒴂ۂ̃XvÔ炩擾܂
		//! @return XvÔ炩Ԃ܂
		virtual const Mix::Vector3& GetAngularLimitSpring( void ) const = 0;
		//! @brief ]͈̔͂𒴂ۂ̃XvÔ炩擾܂
		//! @param[in] spring XvÔ炩( 0.0f`1.0f )
		virtual void SetAngularLimitSpring( const Mix::Vector3& spring ) = 0;
		//! @brief ]͈̔͂𒴂ۂ̃_p[̌͂擾܂
		//! @return _p[̌͂Ԃ܂
		virtual const Mix::Vector3& GetAngularLimitDamper( void ) const = 0;
		//! @brief ]͈̔͂𒴂ۂ̃_p[̌͂ݒ肵܂
		//! @param[in] damper _p[̌( 0.2f`0.8f )
		virtual void SetAngularLimitDamper( const Mix::Vector3& damper ) = 0;

		//! @brief ލʒuXV܂
		virtual void UpdateEquilibriumPoint( void ) = 0;
	};

}}
