#pragma once

//! @file Mix/Dynamics.h
//! @brief _Ci~NXCN[ht@C

#include "Mix/Dynamics/IManager.h"
#include "Mix/Dynamics/IShape.h"
#include "Mix/Dynamics/ISphereShape.h"
#include "Mix/Dynamics/IBoxShape.h"
#include "Mix/Dynamics/IConeShape.h"
#include "Mix/Dynamics/ICapsuleShape.h"
#include "Mix/Dynamics/ICylinderShape.h"
#include "Mix/Dynamics/IConvexHullShape.h"
#include "Mix/Dynamics/ICompoundShape.h"
#include "Mix/Dynamics/IJoint.h"
#include "Mix/Dynamics/IPointJoint.h"
#include "Mix/Dynamics/IHingeJoint.h"
#include "Mix/Dynamics/ISliderJoint.h"
#include "Mix/Dynamics/IDofJoint.h"
#include "Mix/Dynamics/IBallJoint.h"
#include "Mix/Dynamics/IWorld.h"
#include "Mix/Dynamics/IObject.h"
#include "Mix/Dynamics/IObjectListener.h"
#include "Mix/Dynamics/IObjectDragger.h"
#include "Mix/Dynamics/IStaticPlane.h"
#include "Mix/Dynamics/IStaticMesh.h"
#include "Mix/Dynamics/IRigidBody.h"
#include "Mix/Dynamics/ISensor.h"
#include "Mix/Dynamics/IKinematicCharacter.h"
#include "Mix/Dynamics/IVehicle.h"

namespace Mix{ namespace Dynamics{

	//! @brief CƃIuWFNǧs܂
	//! @param[in] rayFrom C̎n_\ Mix::Vector3 NX
	//! @param[in] rayTo C̏I_\ Mix::Vector3 NX
	//! @param[in] pReceiveObject sIuWFNg\ Mix::Dynamics::IObject C^[tF[X̃|C^
	//! @param[out] result 茋ʂ\ Mix::Dynamics::TEST_LOCAL_RESULT \
	//! @return Ăꍇ True Ԃ܂
	_MIX_DLL_API Boolean TestRay(	const Mix::Vector3& rayFrom,
									const Mix::Vector3& rayTo,
									const Mix::Dynamics::IObject* pReceiveObject,
									Mix::Dynamics::TEST_LOCAL_RESULT& result );

	//! @brief XB[vƃIuWFNǧs܂
	//! @param[in] pCastShape XB[v쐬VFCv\ Mix::Dynamics::IShape C^[tF[X̃|C^
	//! @param[in] castShapeFromPos XB[v̎n_̈ʒu\ Mix::Vector3 NX
	//! @param[in] castShapeToPos XB[v̏I_̈ʒu\ Mix::Vector3 NX
	//! @param[in] pReceiveObject sIuWFNg\ Mix::Dynamics::IObject C^[tF[X̃|C^
	//! @param[out] result 茋ʂ\ Mix::Dynamics::TEST_LOCAL_RESULT \
	//! @return Ăꍇ True Ԃ܂
	_MIX_DLL_API Boolean TestSweep(	const Mix::Dynamics::IShape* pCastShape,
									const Mix::Vector3& castShapeFromPos,
									const Mix::Vector3& castShapeToPos,
									const Mix::Dynamics::IObject* pReceiveObject,
									Mix::Dynamics::TEST_LOCAL_RESULT& result );

	//! @brief XB[vƃIuWFNǧs܂
	//! @param[in] pCastShape XB[v쐬VFCv\ Mix::Dynamics::IShape C^[tF[X̃|C^
	//! @param[in] castShapeFromRot XB[v̎n_̉]\ Mix::Vector3 NX
	//! @param[in] castShapeFromPos XB[v̎n_̈ʒu\ Mix::Vector3 NX
	//! @param[in] castShapeToRot XB[v̏I_̉]\ Mix::Vector3 NX
	//! @param[in] castShapeToPos XB[v̏I_̈ʒu\ Mix::Vector3 NX
	//! @param[in] pReceiveObject sIuWFNg\ Mix::Dynamics::IObject C^[tF[X̃|C^
	//! @param[out] result 茋ʂ\ Mix::Dynamics::TEST_LOCAL_RESULT \
	//! @return Ăꍇ True Ԃ܂
	_MIX_DLL_API Boolean TestSweep(	const Mix::Dynamics::IShape* pCastShape,
									const Mix::Quaternion& castShapeFromRot, const Mix::Vector3& castShapeFromPos,
									const Mix::Quaternion& castShapeToRot, const Mix::Vector3& castShapeToPos,
									const Mix::Dynamics::IObject* pReceiveObject,
									Mix::Dynamics::TEST_LOCAL_RESULT& result );

}}
