#pragma once

//! @file Mix/Delegate.h
//! @brief fQ[gev[gCN[ht@C

#include "Mix/Reference.h"

namespace Mix{

	//! @class Delegate00
	//! @brief fQ[gev[g(  )
	//! @tparam RetType Ԃľ^
	template< typename RetType >
	class _MIX_DLL_API Delegate00
	{
	private:
		class Holder : public Mix::Reference
		{
		public:
			void* id0;
			void* id1;

		public:
			virtual RetType Call( void ) const = 0;
		};

		class HolderStatic : public Holder
		{
		private:
			typedef RetType ( __stdcall *Func )( void );

		private:
			Func m_Func;

		public:
			HolderStatic( Func func ) :
			m_Func( func )
			{
				id0 = func;
				id1 = NULL;
			}

		public:
			virtual RetType Call( void ) const
			{
				return m_Func();
			}
		};

		template<typename T>
		class HolderDynamic : public Holder
		{
		private:
			typedef RetType ( T::*Method )( void );

		private:
			T* m_pClass;
			Method m_Method;

		public:
			HolderDynamic( T* pClass, Method method ) :
			m_pClass( pClass ),
			m_Method( method )
			{
				id0 = pClass;
				id1 = &method;
			}

		public:
			virtual RetType Call( void ) const
			{
				return ( m_pClass->*m_Method )();
			}
		};

	private:
		Holder* m_pHolder;

	public:
		//! @brief RXgN^
		Delegate00( void ) :
		m_pHolder( NULL )
		{
		}

		//! @brief Rs[RXgN^
		Delegate00( const Delegate00& deleg ) :
		m_pHolder( NULL )
		{
			*this = deleg;
		}

		//! @brief RXgN^
		//! @param[in] ( __stdcall *func )( void ) ֐̃|C^
		Delegate00( RetType ( __stdcall *func )( void ) )
		{
			m_pHolder = new HolderStatic( func );
		}

		//! @brief RXgN^
		//! @tparam T NX̃^Cv
		//! @param[in] pClass NX̃|C^
		//! @param[in] method NX̃\bh
		template<typename T>
		Delegate00( T* pClass, RetType ( T::*method )( void ) )
		{
			m_pHolder = new HolderDynamic<T>( pClass, method );
		}

		//! @brief fXgN^
		~Delegate00( void )
		{
			MIX_RELEASE( m_pHolder );
		}

	public:
		//! @brief o^\bhĂяo܂
		//! @return \bh̕Ԃl
		RetType operator ()() const
		{
			return m_pHolder->Call();
		}

		//! @brief fQ[gRs[܂
		//! @param[in] deleg Rs[̃fQ[g
		//! @return Rs[̃fQ[g
		Delegate00& operator = ( const Delegate00& deleg )
		{
			MIX_RELEASE( m_pHolder );

			MIX_ADD_REF( deleg.m_pHolder );
			m_pHolder = deleg.m_pHolder;

			return *this;
		}

		//! @brief fQ[gmr( == )܂
		//! @param[in] deleg rfQ[g
		//! @return ꂾꍇ True Ԃ܂
		Boolean operator == ( const Delegate00& deleg )
		{
			if( ( m_pHolder->id0 != deleg.m_pHolder->id0 ) ||
				( m_pHolder->id1 != deleg.m_pHolder->id1 ) )
			{
				return False;
			}

			return True;
		}
	};

	//! @class Delegate01
	//! @brief fQ[gev[g( [1] )
	//! @tparam RetType Ԃľ^
	//! @tparam Arg1Type Pڂ̈̌^
	template< typename RetType, typename Arg1Type >
	class _MIX_DLL_API Delegate01
	{
	private:
		class Holder : public Mix::Reference
		{
		public:
			void* id0;
			void* id1;

		public:
			virtual RetType Call( Arg1Type a1 ) const = 0;
		};

		class HolderStatic : public Holder
		{
		private:
			typedef RetType ( __stdcall *Func )( Arg1Type a1 );

		private:
			Func m_Func;

		public:
			HolderStatic( Func func ) :
			m_Func( func )
			{
				id0 = func;
				id1 = NULL;
			}

		public:
			virtual RetType Call( Arg1Type a1 ) const
			{
				return m_Func( a1 );
			}
		};

		template<typename T>
		class HolderDynamic : public Holder
		{
		private:
			typedef RetType ( T::*Method )( Arg1Type a1 );

		private:
			T* m_pClass;
			Method m_Method;

		public:
			HolderDynamic( T* pClass, Method method ) :
			m_pClass( pClass ),
			m_Method( method )
			{
				id0 = pClass;
				id1 = &method;
			}

		public:
			virtual RetType Call( Arg1Type a1 ) const
			{
				return ( m_pClass->*m_Method )( a1 );
			}
		};

	private:
		Holder* m_pHolder;

	public:
		//! @brief RXgN^
		Delegate01( void ) :
		m_pHolder( NULL )
		{
		}

		//! @brief Rs[RXgN^
		Delegate01( const Delegate01& deleg ) :
		m_pHolder( NULL )
		{
			*this = deleg;
		}

		//! @brief RXgN^
		//! @param[in] ( __stdcall *func )( Arg1Type ) ֐̃|C^
		Delegate01( RetType ( __stdcall *func )( Arg1Type ) )
		{
			m_pHolder = new HolderStatic( func );
		}

		//! @brief RXgN^
		//! @tparam T NX̃^Cv
		//! @param[in] pClass NX̃|C^
		//! @param[in] method NX̃\bh
		template<typename T>
		Delegate01( T* pClass, RetType ( T::*method )( Arg1Type ) )
		{
			m_pHolder = new HolderDynamic<T>( pClass, method );
		}

		//! @brief fXgN^
		~Delegate01( void )
		{
			MIX_RELEASE( m_pHolder );
		}

	public:
		//! @brief o^\bhĂяo܂
		//! @param a1 Pڂ̈
		//! @return \bh̕Ԃl
		RetType operator ()( Arg1Type a1 ) const
		{
			return m_pHolder->Call( a1 );
		}

		//! @brief fQ[gRs[܂
		//! @param[in] deleg Rs[̃fQ[g
		//! @return Rs[̃fQ[g
		Delegate01& operator = ( const Delegate01& deleg )
		{
			MIX_RELEASE( m_pHolder );

			MIX_ADD_REF( deleg.m_pHolder );
			m_pHolder = deleg.m_pHolder;

			return *this;
		}

		//! @brief fQ[gmr( == )܂
		//! @param[in] deleg rfQ[g
		//! @return ꂾꍇ True Ԃ܂
		Boolean operator == ( const Delegate01& deleg )
		{
			if( ( m_pHolder->id0 != deleg.m_pHolder->id0 ) ||
				( m_pHolder->id1 != deleg.m_pHolder->id1 ) )
			{
				return False;
			}

			return True;
		}
	};

	//! @class Delegate02
	//! @brief fQ[gev[g( [2] )
	//! @tparam RetType Ԃľ^
	//! @tparam Arg1Type Pڂ̈̌^
	//! @tparam Arg2Type Qڂ̈̌^
	template< typename RetType, typename Arg1Type, typename Arg2Type >
	class _MIX_DLL_API Delegate02
	{
	private:
		class Holder : public Mix::Reference
		{
		public:
			void* id0;
			void* id1;

		public:
			virtual RetType Call( Arg1Type a1, Arg2Type a2 ) const = 0;
		};

		class HolderStatic : public Holder
		{
		private:
			typedef RetType ( __stdcall *Func )( Arg1Type a1, Arg2Type a2 );

		private:
			Func m_Func;

		public:
			HolderStatic( Func func ) :
			m_Func( func )
			{
				id0 = func;
				id1 = NULL;
			}

		public:
			virtual RetType Call( Arg1Type a1, Arg2Type a2 ) const
			{
				return m_Func( a1, a2 );
			}
		};

		template<typename T>
		class HolderDynamic : public Holder
		{
		private:
			typedef RetType ( T::*Method )( Arg1Type a1, Arg2Type a2 );

		private:
			T* m_pClass;
			Method m_Method;

		public:
			HolderDynamic( T* pClass, Method method ) :
			m_pClass( pClass ),
			m_Method( method )
			{
				id0 = pClass;
				id1 = &method;
			}

		public:
			virtual RetType Call( Arg1Type a1, Arg2Type a2 ) const
			{
				return ( m_pClass->*m_Method )( a1, a2 );
			}
		};

	private:
		Holder* m_pHolder;

	public:
		//! @brief RXgN^
		Delegate02( void ) :
		m_pHolder( NULL )
		{
		}

		//! @brief Rs[RXgN^
		//! @param[in] deleg Rs[fQ[g
		Delegate02( const Delegate02& deleg ) :
		m_pHolder( NULL )
		{
			*this = deleg;
		}

		//! @brief RXgN^
		//! @param[in] ( __stdcall *func )( Arg1Type, Arg2Type ) ֐̃|C^
		Delegate02( RetType ( __stdcall *func )( Arg1Type, Arg2Type ) )
		{
			m_pHolder = new HolderStatic( func );
		}

		//! @brief RXgN^
		//! @tparam T NX̃^Cv
		//! @param[in] pClass NX̃|C^
		//! @param[in] method NX̃\bh
		template<typename T>
		Delegate02( T* pClass, RetType ( T::*method )( Arg1Type, Arg2Type ) )
		{
			m_pHolder = new HolderDynamic<T>( pClass, method );
		}

		//! @brief fXgN^
		~Delegate02( void )
		{
			MIX_RELEASE( m_pHolder );
		}

	public:
		//! @brief o^\bhĂяo܂
		//! @param a1 Pڂ̈
		//! @param a2 Qڂ̈
		//! @return \bh̕Ԃl
		RetType operator ()( Arg1Type a1, Arg2Type a2 ) const
		{
			return m_pHolder->Call( a1, a2 );
		}

		//! @brief fQ[gRs[܂
		//! @param[in] deleg Rs[̃fQ[g
		//! @return Rs[̃fQ[g
		Delegate02& operator = ( const Delegate02& deleg )
		{
			MIX_RELEASE( m_pHolder );

			MIX_ADD_REF( deleg.m_pHolder );
			m_pHolder = deleg.m_pHolder;

			return *this;
		}

		//! @brief fQ[gmr( == )܂
		//! @param[in] deleg rfQ[g
		//! @return ꂾꍇ True Ԃ܂
		Boolean operator == ( const Delegate02& deleg )
		{
			if( ( m_pHolder->id0 != deleg.m_pHolder->id0 ) ||
				( m_pHolder->id1 != deleg.m_pHolder->id1 ) )
			{
				return False;
			}

			return True;
		}
	};

	//! @class Delegate03
	//! @brief fQ[gev[g( [3] )
	//! @tparam RetType Ԃľ^
	//! @tparam Arg1Type Pڂ̈̌^
	//! @tparam Arg2Type Qڂ̈̌^
	//! @tparam Arg3Type Rڂ̈̌^
	template< typename RetType, typename Arg1Type, typename Arg2Type, typename Arg3Type >
	class _MIX_DLL_API Delegate03
	{
	private:
		class Holder : public Mix::Reference
		{
		public:
			void* id0;
			void* id1;

		public:
			virtual RetType Call( Arg1Type a1, Arg2Type a2, Arg3Type a3 ) const = 0;
		};

		class HolderStatic : public Holder
		{
		private:
			typedef RetType ( __stdcall *Func )( Arg1Type a1, Arg2Type a2, Arg3Type a3 );

		private:
			Func m_Func;

		public:
			HolderStatic( Func func ) :
			m_Func( func )
			{
				id0 = func;
				id1 = NULL;
			}

		public:
			virtual RetType Call( Arg1Type a1, Arg2Type a2, Arg3Type a3 ) const
			{
				return m_Func( a1, a2, a3 );
			}
		};

		template<typename T>
		class HolderDynamic : public Holder
		{
		private:
			typedef RetType ( T::*Method )( Arg1Type a1, Arg2Type a2, Arg3Type a3 );

		private:
			T* m_pClass;
			Method m_Method;

		public:
			HolderDynamic( T* pClass, Method method ) :
			m_pClass( pClass ),
			m_Method( method )
			{
				id0 = pClass;
				id1 = &method;
			}

		public:
			virtual RetType Call( Arg1Type a1, Arg2Type a2, Arg3Type a3 ) const
			{
				return ( m_pClass->*m_Method )( a1, a2, a3 );
			}
		};

	private:
		Holder* m_pHolder;

	public:
		//! @brief RXgN^
		Delegate03( void ) :
		m_pHolder( NULL )
		{
		}

		//! @brief Rs[RXgN^
		//! @param[in] deleg Rs[fQ[g
		Delegate03( const Delegate03& deleg ) :
		m_pHolder( NULL )
		{
			*this = deleg;
		}

		//! @brief RXgN^
		//! @param[in] ( __stdcall *func )( Arg1Type, Arg2Type, Arg3Type ) ֐̃|C^
		Delegate03( RetType ( __stdcall *func )( Arg1Type, Arg2Type, Arg3Type ) )
		{
			m_pHolder = new HolderStatic( func );
		}

		//! @brief RXgN^
		//! @tparam T NX̃^Cv
		//! @param[in] pClass NX̃|C^
		//! @param[in] method NX̃\bh
		template<typename T>
		Delegate03( T* pClass, RetType ( T::*method )( Arg1Type, Arg2Type, Arg3Type ) )
		{
			m_pHolder = new HolderDynamic<T>( pClass, method );
		}

		//! @brief fXgN^
		~Delegate03( void )
		{
			MIX_RELEASE( m_pHolder );
		}

	public:
		//! @brief o^\bhĂяo܂
		//! @param a1 Pڂ̈
		//! @param a2 Qڂ̈
		//! @param a3 Rڂ̈
		//! @return \bh̕Ԃl
		RetType operator ()( Arg1Type a1, Arg2Type a2, Arg3Type a3 ) const
		{
			return m_pHolder->Call( a1, a2, a3 );
		}

		//! @brief fQ[gRs[܂
		//! @param[in] deleg Rs[̃fQ[g
		//! @return Rs[̃fQ[g
		Delegate03& operator = ( const Delegate03& deleg )
		{
			MIX_RELEASE( m_pHolder );

			MIX_ADD_REF( deleg.m_pHolder );
			m_pHolder = deleg.m_pHolder;

			return *this;
		}

		//! @brief fQ[gmr( == )܂
		//! @param[in] deleg rfQ[g
		//! @return ꂾꍇ True Ԃ܂
		Boolean operator == ( const Delegate03& deleg )
		{
			if( ( m_pHolder->id0 != deleg.m_pHolder->id0 ) ||
				( m_pHolder->id1 != deleg.m_pHolder->id1 ) )
			{
				return False;
			}

			return True;
		}
	};

	//! @class Delegate04
	//! @brief fQ[gev[g( [4] )
	//! @tparam RetType Ԃľ^
	//! @tparam Arg1Type Pڂ̈̌^
	//! @tparam Arg2Type Qڂ̈̌^
	//! @tparam Arg3Type Rڂ̈̌^
	//! @tparam Arg4Type Sڂ̈̌^
	template< typename RetType, typename Arg1Type, typename Arg2Type, typename Arg3Type, typename Arg4Type >
	class _MIX_DLL_API Delegate04
	{
	private:
		class Holder : public Mix::Reference
		{
		public:
			void* id0;
			void* id1;

		public:
			virtual RetType Call( Arg1Type a1, Arg2Type a2, Arg3Type a3, Arg4Type a4 ) const = 0;
		};

		class HolderStatic : public Holder
		{
		private:
			typedef RetType ( __stdcall *Func )( Arg1Type a1, Arg2Type a2, Arg3Type a3, Arg4Type a4 );

		private:
			Func m_Func;

		public:
			HolderStatic( Func func ) :
			m_Func( func )
			{
				id0 = func;
				id1 = NULL;
			}

		public:
			virtual RetType Call( Arg1Type a1, Arg2Type a2, Arg3Type a3, Arg4Type a4 ) const
			{
				return m_Func( a1, a2, a3, a4 );
			}
		};

		template<typename T>
		class HolderDynamic : public Holder
		{
		private:
			typedef RetType ( T::*Method )( Arg1Type a1, Arg2Type a2, Arg3Type a3, Arg4Type a4 );

		private:
			T* m_pClass;
			Method m_Method;

		public:
			HolderDynamic( T* pClass, Method method ) :
			m_pClass( pClass ),
			m_Method( method )
			{
				id0 = pClass;
				id1 = &method;
			}

		public:
			virtual RetType Call( Arg1Type a1, Arg2Type a2, Arg3Type a3, Arg4Type a4 ) const
			{
				return ( m_pClass->*m_Method )( a1, a2, a3, a4 );
			}
		};

	private:
		Holder* m_pHolder;

	public:
		//! @brief RXgN^
		Delegate04( void ) :
		m_pHolder( NULL )
		{
		}

		//! @brief Rs[RXgN^
		//! @param[in] deleg Rs[̃fQ[g
		Delegate04( const Delegate04& deleg ) :
		m_pHolder( NULL )
		{
			*this = deleg;
		}

		//! @brief RXgN^
		//! @param[in] ( __stdcall *func )( Arg1Type, Arg2Type, Arg3Type, Arg4Type ) ֐̃|C^
		Delegate04( RetType ( __stdcall *func )( Arg1Type, Arg2Type, Arg3Type, Arg4Type ) )
		{
			m_pHolder = new HolderStatic( func );
		}

		//! @brief RXgN^
		//! @tparam T NX̃^Cv
		//! @param[in] pClass NX̃|C^
		//! @param[in] method NX̃\bh
		template<typename T>
		Delegate04( T* pClass, RetType ( T::*method )( Arg1Type, Arg2Type, Arg3Type, Arg4Type ) )
		{
			m_pHolder = new HolderDynamic<T>( pClass, method );
		}

		//! @brief fXgN^
		~Delegate04( void )
		{
			MIX_RELEASE( m_pHolder );
		}

	public:
		//! @brief o^\bhĂяo܂
		//! @param a1 Pڂ̈
		//! @param a2 Qڂ̈
		//! @param a3 Rڂ̈
		//! @param a4 Sڂ̈
		//! @return \bh̕Ԃl
		RetType operator ()( Arg1Type a1, Arg2Type a2, Arg3Type a3, Arg4Type a4 ) const
		{
			return m_pHolder->Call( a1, a2, a3, a4 );
		}

		//! @brief fQ[gRs[܂
		//! @param[in] deleg Rs[̃fQ[g
		//! @return Rs[̃fQ[g
		Delegate04& operator = ( const Delegate04& deleg )
		{
			MIX_RELEASE( m_pHolder );

			MIX_ADD_REF( deleg.m_pHolder );
			m_pHolder = deleg.m_pHolder;

			return *this;
		}

		//! @brief fQ[gmr( == )܂
		//! @param[in] deleg rfQ[g
		//! @return ꂾꍇ True Ԃ܂
		Boolean operator == ( const Delegate04& deleg )
		{
			if( ( m_pHolder->id0 != deleg.m_pHolder->id0 ) ||
				( m_pHolder->id1 != deleg.m_pHolder->id1 ) )
			{
				return False;
			}

			return True;
		}
	};
}
