#pragma once

#include "Mix/IWindow.h"
#include <list>

namespace Mix{

	class Window : public Mix::IWindow
	{
	private:
		enum VALUE
		{
			WINDOW_STYLE = ( WS_OVERLAPPED | WS_CAPTION | WS_SYSMENU | WS_MINIMIZEBOX | WS_VISIBLE ),	//EBhEX^C
			FULLSCREEN_STYLE = ( WS_POPUP | WS_VISIBLE ), //tXN[X^C
		};

		typedef std::list<MessageHandler> MessageHandlerList;

	public:
		static Window* CreateInstance( void );

	private:
		static Window* g_pWindow;
		HWND m_hWnd;
		HMENU m_hMenu;
		Boolean m_bExternalWnd;
		WNDPROC m_ExternalWndProc;
		MessageHandlerList m_MessageHandlerList;
		Mix::String m_Title;
		Mix::Point m_BaseSize;
		Mix::Point m_Size;
		Boolean m_bCloseEnabled;
		Boolean m_bWindowed;
		Boolean m_bActive;

	private:
		Window( void );
		virtual ~Window( void );

		LRESULT MessageProc( HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam );
		static LRESULT CALLBACK MessageProcEntry( HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam );

	public:
		Boolean Initialize( const Mix::WINDOW_CONFIG& config );
		Boolean Update( void );
		void Dispose( void );
		void SetStyle( Boolean bWindowed );

	public:
		virtual void RegisterMessageHandler( const MessageHandler& messageHandler );
		virtual void RemoveMessageHandler( const MessageHandler& messageHandler );
		virtual LRESULT SendMessage( UInt32 msg, WPARAM wParam, LPARAM lParam );
		virtual void PostMessage( UInt32 msg, WPARAM wParam, LPARAM lParam );
		virtual void SetTitle( const wchar_t* pTitle );
		virtual const wchar_t* GetTitle( void ) const;
		virtual void SetMenu( HMENU hMenu );
		virtual HMENU GetMenu( void ) const;
		virtual void SetCloseEnabled( Boolean bEnable );
		virtual Boolean GetCloseEnabled( void ) const;
		virtual void Close( void );
		virtual const Mix::Point& GetBaseSize( void ) const;
		virtual const Mix::Point& GetSize( void ) const;
		virtual HWND GetHandle( void ) const;
		virtual Boolean GetActivated( void ) const;
	};
}
