#include "Mix/Class/Window.h"
#include "Mix/Class/Resource.h"

using namespace Mix;

Window* Window::g_pWindow = NULL;

Window* Window::CreateInstance( void )
{
	return new Window();
}

Window::Window( void ) :
m_hWnd( NULL ),
m_bExternalWnd( False ),
m_ExternalWndProc( 0 ),
m_bCloseEnabled( True ),
m_bWindowed( False ),
m_bActive( True )
{
	Window::g_pWindow = this;
}

Window::~Window( void )
{
}

Boolean Window::Initialize( const Mix::WINDOW_CONFIG& config )
{
	HINSTANCE hInstance = Mix::GetInternalInstanceHandle();
	WNDCLASSEX wcex = { 0 };

	////////////////////////////////////////////////////////////////////////////////////////////////////
	// l̐ݒ
	////////////////////////////////////////////////////////////////////////////////////////////////////

	m_Title = ( config.pTitle != NULL )? config.pTitle : L"MixAvP[V";
	m_BaseSize = m_Size = Mix::Point( config.width, config.height );

	////////////////////////////////////////////////////////////////////////////////////////////////////
	// NXo^
	////////////////////////////////////////////////////////////////////////////////////////////////////

	wcex.cbSize			= sizeof( WNDCLASSEX );
	wcex.style			= ( CS_HREDRAW | CS_VREDRAW );
	wcex.lpfnWndProc	= Window::MessageProcEntry;
	wcex.cbClsExtra		= 0;
	wcex.cbWndExtra		= 0;
	wcex.hInstance		= hInstance;
	wcex.hCursor		= ::LoadCursor( NULL, IDC_ARROW );
	wcex.hbrBackground	= static_cast<HBRUSH>( ::GetStockObject( BLACK_BRUSH ) );
	wcex.lpszMenuName	= NULL;
	wcex.lpszClassName	= m_Title.GetConstPtr();

	if( ( config.hIcon != NULL ) &&
		( config.hIconSm != NULL ) )
	{
		wcex.hIcon = config.hIcon;
		wcex.hIconSm = config.hIconSm;
	}
	else if(	( config.hIcon != NULL ) &&
				( config.hIconSm == NULL ) )
	{
		wcex.hIcon = config.hIcon;
		wcex.hIconSm = config.hIcon;
	}
	else if(	( config.hIcon == NULL ) &&
				( config.hIconSm != NULL ) )
	{
		wcex.hIcon = config.hIconSm;
		wcex.hIconSm = config.hIconSm;
	}
	else
	{
		wcex.hIcon		= (HICON)LoadImage( hInstance, MAKEINTRESOURCE( IDI_MIX ), IMAGE_ICON, 0, 0, 0 );
		wcex.hIconSm	= (HICON)LoadImage( hInstance, MAKEINTRESOURCE( IDI_MIX_SMALL ), IMAGE_ICON, 0, 0, 0 );
	}

	if( ::RegisterClassEx( &wcex ) == 0 )
	{
		return False;
	}

	////////////////////////////////////////////////////////////////////////////////////////////////////
	// 쐬
	////////////////////////////////////////////////////////////////////////////////////////////////////

	m_hWnd = ::CreateWindowEx(	( config.bAcceptDrop == True )? WS_EX_ACCEPTFILES : 0,
								m_Title.GetConstPtr(),
								m_Title.GetConstPtr(),
								WS_POPUP,
								CW_USEDEFAULT,
								CW_USEDEFAULT,
								CW_USEDEFAULT,
								CW_USEDEFAULT,
								HWND_DESKTOP,
								NULL,
								hInstance,
								NULL );
	if( m_hWnd == NULL )
	{
		return False;
	}

	SetStyle( True );

	::ShowWindow( m_hWnd, SW_SHOW );

	return True;
}

Boolean Window::Update( void )
{
	MSG msg;

	while( ::PeekMessage( &msg, NULL, 0, 0, PM_NOREMOVE ) == TRUE )
	{
		if( ::GetMessage( &msg, NULL, 0, 0 ) == TRUE )
		{
			::TranslateMessage( &msg );
			::DispatchMessage( &msg );
		}
		else
		{
			return False;
		}
	}

	return True;
}

void Window::Dispose( void )
{
	if( m_hWnd != NULL )
	{
		::DestroyWindow( m_hWnd );
		m_hWnd = NULL;
	}
}

void Window::SetStyle( Boolean bWindowed )
{
	if( m_bWindowed == bWindowed )
	{
		return;
	}

	if( bWindowed == True )
	{
		RECT workRect;
		RECT rect;

		rect.left = 0;
		rect.top = 0;
		rect.right = m_BaseSize.x;
		rect.bottom = m_BaseSize.y;

		::AdjustWindowRect( &rect, Window::WINDOW_STYLE, FALSE ); 

		if( ::SystemParametersInfo( SPI_GETWORKAREA, 0, &workRect, 0 ) )
		{
			Int32 workWidth = workRect.right - workRect.left;
			Int32 workHeight = workRect.bottom - workRect.top;
			Int32 ox = ( workWidth > m_BaseSize.x )? ( workRect.left + ( ( workWidth - m_BaseSize.x ) / 2 ) ) : 0;
			Int32 oy = ( workHeight > m_BaseSize.y )? ( workRect.top + ( ( workHeight - m_BaseSize.y ) / 2 ) ) : 0;

			rect.left += ox;
			rect.top += oy;
			rect.right += ox;
			rect.bottom += oy;
		}

		::SetWindowLongPtr( m_hWnd, GWL_STYLE, Window::WINDOW_STYLE );
		::SetMenu( m_hWnd, m_hMenu );
		::SetWindowPos(	m_hWnd, HWND_NOTOPMOST, rect.left, rect.top, rect.right - rect.left, rect.bottom - rect.top, SWP_SHOWWINDOW );
	}
	else
	{
		::SetWindowLongPtr( m_hWnd, GWL_STYLE, Window::FULLSCREEN_STYLE );
		::SetMenu( m_hWnd, NULL );
	}

	//EBhEǂ
	m_bWindowed = bWindowed;
}

void Window::RegisterMessageHandler( const MessageHandler& messageHandler )
{
	m_MessageHandlerList.push_back( messageHandler );
}

void Window::RemoveMessageHandler( const MessageHandler& messageHandler )
{
	m_MessageHandlerList.remove( messageHandler );
}

LRESULT Window::SendMessage( UInt32 msg, WPARAM wParam, LPARAM lParam )
{
	return ::SendMessageW( m_hWnd, msg, wParam, lParam );
}

void Window::PostMessage( UInt32 msg, WPARAM wParam, LPARAM lParam )
{
	::PostMessageW( m_hWnd, msg, wParam, lParam );
}

void Window::SetTitle( const wchar_t* pTitle )
{
	m_Title = pTitle;
	::SetWindowTextW( m_hWnd, pTitle );
}

const wchar_t* Window::GetTitle( void ) const
{
	return m_Title.GetConstPtr();
}

void Window::SetMenu( HMENU hMenu )
{
	if( m_bWindowed == True )
	{
		RECT rect;

		if( ::GetWindowRect( m_hWnd, &rect ) == TRUE )
		{
			UInt32 style = ::GetWindowLongPtr( m_hWnd, GWL_STYLE );
			Int32 x = rect.left;
			Int32 y = rect.top;

			rect.left = 0;
			rect.top = 0;
			rect.right = m_BaseSize.x;
			rect.bottom = m_BaseSize.y;

			if( ::AdjustWindowRect( &rect, style, ( hMenu != NULL ) ) == TRUE )
			{
				if( ::MoveWindow( m_hWnd, x, y, rect.right - rect.left, rect.bottom - rect.top, TRUE ) == TRUE )
				{
					if( ::SetMenu( m_hWnd, hMenu ) == TRUE )
					{
						m_hMenu = hMenu;
					}
				}
			}
		}
	}
	else
	{
		m_hMenu = hMenu;
	}
}

HMENU Window::GetMenu( void ) const
{
	return ::GetMenu( m_hWnd );
}

void Window::SetCloseEnabled( Boolean bEnable )
{
	HMENU hMenu = ::GetSystemMenu( m_hWnd, FALSE );
	if( hMenu != NULL )
	{
		::EnableMenuItem( hMenu, SC_CLOSE, ( bEnable == True )? MF_ENABLED : MF_GRAYED );
		m_bCloseEnabled = bEnable;
	}
}

Boolean Window::GetCloseEnabled( void ) const
{
	return m_bCloseEnabled;
}

void Window::Close( void )
{
	::PostMessageW( m_hWnd, WM_CLOSE, 0, 0 );
}

const Mix::Point& Window::GetBaseSize( void ) const
{
	return m_BaseSize;
}

const Mix::Point& Window::GetSize( void ) const
{
	return m_Size;
}

HWND Window::GetHandle( void ) const
{
	return m_hWnd;
}

Boolean Window::GetActivated( void ) const
{
	return m_bActive;
}

LRESULT Window::MessageProc( HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam )
{
	Boolean bDefaultProc = True;
	LRESULT ret = 0;

	//o^Ă郁bZ[WnhĂяo
	for( MessageHandlerList::iterator it = m_MessageHandlerList.begin(); it != m_MessageHandlerList.end(); ++it )
	{
		if( ( *it )( this, msg, wParam, lParam ) == False )
		{
			bDefaultProc = False;
		}
	}

	//bZ[W
	switch( msg )
	{
	case WM_PAINT:
		::ValidateRect( hWnd, NULL );
		break;

	case WM_SIZE:
		m_Size.x = LOWORD( lParam );
		m_Size.y = HIWORD( lParam );
		break;

	case WM_STYLECHANGED:
		SetCloseEnabled( m_bCloseEnabled );
		break;

	case WM_IME_SETCONTEXT:
		//ϊ̃XgoȂ悤ɂ
		lParam = 0;
		break;
	
	case WM_SYSCOMMAND:
		switch ( wParam & 0xFFF0 )
		{
		//XN[Z[o[쓮Ȃ
		//j^[p[𗎂ƂȂ
		case SC_SCREENSAVE:
		case SC_MONITORPOWER:
			bDefaultProc = False;
			break;

		case SC_MOVE:
		case SC_SIZE:
		case SC_MAXIMIZE:
		case SC_KEYMENU:
			if( m_bWindowed == False )
			{
				bDefaultProc = False;
			}
			break;
		}
		break;

	case WM_ACTIVATEAPP:
		m_bActive = wParam;
		break;

	case WM_CLOSE:
		if( m_bCloseEnabled == False )
		{
			bDefaultProc = False;
		}
		break;

	case WM_DESTROY:
		::PostQuitMessage( 0 );
		break;
	}

	if( bDefaultProc == True )
	{
		if( m_ExternalWndProc == False )
		{
			ret = ::DefWindowProc( hWnd, msg, wParam, lParam );
		}
		else
		{
			ret = ::CallWindowProcW( m_ExternalWndProc, hWnd, msg, wParam, lParam );
		}
	}

	return ret;
}

LRESULT CALLBACK Window::MessageProcEntry( HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam )
{
	return Window::g_pWindow->MessageProc( hWnd, msg, wParam, lParam );
}
