#pragma once

namespace Mix{

	class UserFile
	{
	private:
		enum VALUE
		{
			MAX_CHAR = 1024,
		};

	private:
		Boolean m_bInit;
		Mix::String m_MyDocPath;
		Mix::String m_Path;
		Mix::String m_SearchPath;
		Mix::String m_FullFileName;
		UInt32 m_OpenCount;
		HANDLE m_hFile;

	public:
		UserFile( void );
		~UserFile( void );

	public:
		Boolean Initialize( const wchar_t* path, const wchar_t* fileName );

	private:
		Boolean CreateFolder( void );

	public:
		Boolean Open( void );
		void Close( void );
		Boolean Write( const wchar_t* format, ... );
		Boolean WriteLine( const wchar_t* format, ... );
	};

}
