#include "Mix/String.h"

namespace Mix{

/////////////////////////////////////////////////////////////////////////////////////////////////////////
// StringW NX( jR[h )
/////////////////////////////////////////////////////////////////////////////////////////////////////////

wchar_t StringW::empty = 0;

StringW::StringW( void ) :
m_pStr( NULL ),
m_Num( 0 ),
m_Size( 0 ),
m_AllocateSize( 0 ),
m_Capacity( 0 )
{
}

StringW::StringW( const char* pStr ) :
m_pStr( NULL ),
m_Num( 0 ),
m_Size( 0 ),
m_AllocateSize( 0 ),
m_Capacity( 0 )
{
	Convert( pStr );
}

StringW::StringW( const wchar_t* pStr ) :
m_pStr( NULL ),
m_Num( 0 ),
m_Size( 0 ),
m_AllocateSize( 0 ),
m_Capacity( 0 )
{
	Copy( pStr );
}

StringW::StringW( const wchar_t* pStr, size_t SizeInWords ) :
m_pStr( NULL ),
m_Num( 0 ),
m_Size( 0 ),
m_AllocateSize( 0 ),
m_Capacity( 0 )
{
	Copy( pStr, SizeInWords );
}

StringW::StringW( const StringW& Str ) :
m_pStr( NULL ),
m_Num( 0 ),
m_Size( 0 ),
m_AllocateSize( 0 ),
m_Capacity( 0 )
{
	Copy( Str.m_pStr );
}

StringW::~StringW( void )
{
	if( m_pStr != NULL )
	{
		free( m_pStr );
		m_pStr = NULL;
	}
}

void StringW::Allocate( size_t num )
{
	size_t size = num * 2;
	size_t allocSize = size + 2;

	if( m_pStr == NULL )
	{
		m_pStr = static_cast<wchar_t*>( malloc( allocSize ) );
		MIX_ASSERT( m_pStr != NULL );

		m_Capacity = allocSize;
	}
	else
	{
		if( m_Capacity < allocSize )
		{
			void* pTemp = realloc( m_pStr, allocSize );
			MIX_ASSERT( pTemp != NULL );

			m_pStr = static_cast<wchar_t*>( pTemp );
			m_Capacity = allocSize;
		}
	}

	m_Num = num;
	m_Size = size;
	m_AllocateSize = allocSize;
}

void StringW::Copy( const wchar_t* pStr )
{
	Copy( pStr, ( pStr == NULL )? ( 0 ) : ( wcslen( pStr ) ) );
}

void StringW::Copy( const wchar_t* pStr, size_t num )
{
#if 1

	Allocate( num );

	if( m_Size > 0 )
	{
		Mix::Memory::Copy( m_pStr, pStr, m_Size );
	}

	m_pStr[m_Num] = L'\0';

#else

	//
	Release();

	if( pStr == NULL )
	{
		return;
	}

	m_Num = SizeInWords;
	m_Size = m_Num * 2;
	m_AllocateSize = m_Size + sizeof( wchar_t );

	m_pStr = ( wchar_t* )malloc( m_AllocateSize );
	if( m_pStr == NULL )
	{
		MIX_ASSERT( m_pStr != NULL );
		Release();
	}
	else
	{
		ZeroMemory( m_pStr, m_AllocateSize );
		CopyMemory( m_pStr, pStr, m_Size );
	}

#endif
}

void StringW::Convert( const char* pStr )
{
#if 1

	//ϊ̒擾
	Int32 length = MultiByteToWideChar( CP_ACP, 0, pStr, -1, NULL, 0 );

	if( length > 0 )
	{
		//TCY
		Allocate( length - 1 );

		//ϊ
		if( MultiByteToWideChar( CP_ACP, 0, pStr, static_cast<Int32>( strlen( pStr ) ), m_pStr, static_cast<Int32>( m_Num ) ) > 0 )
		{
			m_pStr[m_Num] = L'\0';
		}
	}

#else

	//
	Release();

	//ϊ̒擾
	Int32 length = MultiByteToWideChar( CP_ACP, 0, pStr, -1, NULL, 0 );
	MIX_ASSERT( length!= 0 );
	if( length == 0 )
	{
		return;
	}

	m_Num = static_cast<size_t>( length - 1 );
	m_Size = m_Num * 2;
	m_AllocateSize = m_Size + sizeof( wchar_t );

	m_pStr = ( wchar_t* )malloc( m_AllocateSize );
	MIX_ASSERT( m_pStr != NULL );
	if( m_pStr == NULL )
	{
		Release();
	}
	else
	{
		ZeroMemory( m_pStr, m_AllocateSize );
		if( MultiByteToWideChar( CP_ACP, 0, pStr, static_cast<Int32>( strlen( pStr ) ), m_pStr, static_cast<Int32>( m_Num ) ) == 0 )
		{
			Release();
		}
	}

#endif
}

void StringW::Add( const wchar_t* pStr )
{
#if 1

	if( pStr == NULL )
	{
		return;
	}

	size_t oldNum = m_Num;
	size_t addNum = wcslen( pStr );
	size_t addSize = addNum * 2;

	Allocate( oldNum + addNum );

	Mix::Memory::Copy( m_pStr + oldNum, pStr, addSize );
	m_pStr[m_Num] = L'\0';

#else

	if( pStr == NULL )
	{
		return;
	}

	if( m_pStr == NULL )
	{
		Copy( pStr );
		return;
	}

	size_t AddNum = wcslen( pStr );
	size_t AddSize = AddNum * 2;
	size_t OldNum = m_Num;

	m_Num += AddNum;
	m_Size += AddSize;
	m_AllocateSize = m_Size + sizeof( wchar_t );

	m_pStr = ( wchar_t* )realloc( m_pStr, m_AllocateSize );
	if( m_pStr == NULL )
	{
		MIX_ASSERT( m_pStr != NULL );
		Release();
	}
	else
	{
		ZeroMemory( m_pStr + OldNum + 1, AddSize );
		wcscat_s( m_pStr, m_Num + 1, pStr );
	}
#endif
}

wchar_t& StringW::operator [] ( UInt32 index )
{
	MIX_ASSERT( m_pStr != NULL );
	MIX_ASSERT( m_Num > index );

	return m_pStr[index];
}

Boolean StringW::operator == ( const StringW& Str ) const
{
	if( ( m_pStr == NULL ) && ( Str.m_pStr == NULL ) )
	{
		return False;
	}
	else if( ( m_pStr == NULL ) || ( Str.m_pStr == NULL ) )
	{
		return True;
	}

	return ( wcscmp( m_pStr, Str.m_pStr ) == 0 );
}

Boolean StringW::operator == ( const wchar_t* pStr ) const
{
	if( ( m_pStr == NULL ) && ( pStr == NULL ) )
	{
		return True;
	}
	else if( ( m_pStr == NULL ) || ( pStr == NULL ) )
	{
		return False;
	}

	return ( wcscmp( m_pStr, pStr ) == 0 );
}

Boolean StringW::operator == ( wchar_t code ) const
{
	if( m_pStr == NULL )
	{
		return False;
	}

	if( m_pStr[0] == code )
	{
		return True;
	}

	return False;
}

Boolean StringW::operator == ( Int32 NullValue ) const
{
	return ( m_pStr == NULL );
}

Boolean StringW::operator != ( const StringW& str ) const
{
	if( ( m_pStr == NULL ) && ( str.m_pStr == NULL ) )
	{
		return False;
	}
	else if( ( m_pStr == NULL ) || ( str.m_pStr == NULL ) )
	{
		return True;
	}

	return ( wcscmp( m_pStr, str.m_pStr ) != 0 );
}

Boolean StringW::operator != ( const wchar_t* pStr ) const
{
	if( ( m_pStr == NULL ) && ( pStr == NULL ) )
	{
		return False;
	}
	else if( ( m_pStr == NULL ) || ( pStr == NULL ) )
	{
		return True;
	}

	return ( wcscmp( m_pStr, pStr ) != 0 );
}

Boolean StringW::operator != ( Int32 NullValue ) const
{
	return ( m_pStr != NULL );
}

StringW& StringW::operator = ( const StringW& str )
{
	Copy( str.m_pStr );

	return *this;
}

StringW& StringW::operator = ( const wchar_t* pStr )
{
	Copy( pStr );

	return *this;
}

StringW& StringW::operator = ( const char* pStr )
{
	Convert( pStr );

	return *this;
}

StringW& StringW::operator = ( const wchar_t code )
{
	wchar_t tmp[2] = { code, L'\0' };

	Copy( tmp );

	return *this;
}

StringW& StringW::operator = ( Int32 nullValue )
{
#if 1
	Allocate( 0 );
#else
	Release();
#endif

	return *this;
}

StringW& StringW::operator += ( const wchar_t* pStr )
{
	Add( pStr );

	return *this;
}

StringW& StringW::operator += ( const StringW& Str )
{
	Add( Str.m_pStr );

	return *this;
}

StringW& StringW::operator += ( const wchar_t code )
{
	wchar_t tmp[2] = { code, L'\0' };

	Add( tmp );

	return *this;
}

StringW StringW::operator + ( const StringW& Str )
{
	StringW tempStr( m_pStr );

	tempStr.Add( Str.m_pStr );

	return tempStr;
}
/*
void StringW::Resize( size_t num )
{
	size_t size = num * 2;
	size_t allocSize = size + 2;

	if( m_pStr == NULL )
	{
		m_pStr = static_cast<wchar_t*>( malloc( allocSize ) );
		MIX_ASSERT( m_pStr != NULL );

		m_Capacity = allocSize;

		Mix::Memory::Zero( m_pStr, allocSize );

		m_Num = 0;
		m_Size = 0;
		m_AllocateSize = allocSize;
	}
	else
	{
		if( m_Capacity < allocSize )
		{
			m_pStr = static_cast<wchar_t*>( realloc( m_pStr, allocSize ) );
			MIX_ASSERT( m_pStr != NULL );

			m_Capacity = allocSize;
		}

		if( m_Num > num )
		{
			m_pStr[num] = L'\0';

			m_Num = num;
			m_Size = size;
			m_AllocateSize = allocSize;
		}
		else if( m_Num < num )
		{
			Mix::Memory::Zero( m_pStr + m_Num, ( allocSize - m_AllocateSize ) + 2 );

			m_AllocateSize = allocSize;
		}
	}
}
*/
Float64 StringW::ToDouble( Boolean* pbRet ) const
{
	if( m_pStr == NULL )
	{
		if( pbRet != NULL )
		{
			*pbRet = False;
		}

		return 0.0;
	}

	wchar_t* pStopString = NULL;
	Float64 retValue = wcstod( m_pStr, &pStopString );

	if( *pStopString != 0 )
	{
		if( pbRet != NULL )
		{
			*pbRet = False;
		}
		return 0.0;
	}

	if( pbRet != NULL )
	{
		*pbRet = True;
	}

	return retValue;
}

Float32 StringW::ToFloat( Boolean* pbRet ) const
{
	if( m_pStr == NULL )
	{
		if( pbRet != NULL )
		{
			*pbRet = False;
		}
		return 0.0f;
	}

	wchar_t* pStopString = NULL;
	Float32 retValue = static_cast<Float32>( wcstod( m_pStr, &pStopString ) );

	if( *pStopString != 0 )
	{
		if( pbRet != NULL )
		{
			*pbRet = False;
		}

		return 0.0f;
	}

	if( pbRet != NULL )
	{
		*pbRet = True;
	}

	return retValue;
}

Int32 StringW::ToInt( Boolean* pbRet ) const
{
	if( m_pStr == NULL )
	{
		if( pbRet != NULL )
		{
			*pbRet = False;
		}
		return 0;
	}

	wchar_t* pStopString = NULL;
	Int32 retValue = static_cast<Int32>( wcstol( m_pStr, &pStopString, 0 ) );

	if( *pStopString != 0 )
	{
		if( pbRet != NULL )
		{
			*pbRet = False;
		}

		return 0;
	}

	if( pbRet != NULL )
	{
		*pbRet = True;
	}

	return retValue;
}

UInt32 StringW::ToUInt( Boolean* pbRet ) const
{
	if( m_pStr == NULL )
	{
		if( pbRet != NULL )
		{
			*pbRet = False;
		}
		return 0;
	}

	wchar_t* pStopString = NULL;
	UInt32 retValue = static_cast<UInt32>( wcstoul( m_pStr, &pStopString, 0 ) );

	if( *pStopString != 0 )
	{
		if( pbRet != NULL )
		{
			*pbRet = False;
		}

		return 0;
	}

	if( pbRet != NULL )
	{
		*pbRet = True;
	}

	return retValue;
}

StringW StringW::ToUpper( void )
{
	Mix::StringW temp = *this;

	temp.Upper();

	return temp;
}

StringW StringW::ToLower( void )
{
	Mix::StringW temp = *this;

	temp.Lower();

	return temp;
}

void StringW::Upper( void )
{
	if( m_pStr != NULL )
	{
		wchar_t* pc = &( m_pStr[0] );

		while( *pc != L'\0' )
		{
			// A`Z( 0x0041`0x005A )
			// a`z( 0x0061`0x007A )
			if( ( *pc >= 0x0061 ) &&
				( *pc <= 0x007A ) )
			{
				*pc = *pc - 0x0061 + 0x0041;
			}

			pc++;
		}
	}
}

void StringW::Lower( void )
{
	if( m_pStr != NULL )
	{
		wchar_t* pc = &( m_pStr[0] );

		while( *pc != L'\0' )
		{
			// A`Z( 0x0041`0x005A )
			// a`z( 0x0061`0x007A )
			if( ( *pc >= 0x0041 ) &&
				( *pc <= 0x005A ) )
			{
				*pc = *pc - 0x0041 + 0x0061;
			}

			pc++;
		}
	}
}

wchar_t* StringW::Sprintf( const wchar_t* format, ... )
{
	MIX_ASSERT( format != NULL );

#if 1

	wchar_t tmp[Mix::StringW::VA_TEMP_NUM] = { L'\0' };
	va_list args;

	va_start( args, format );
	_vsnwprintf_s( tmp, Mix::StringW::VA_TEMP_NUM, _TRUNCATE, format, args );
	va_end( args );

	Copy( tmp, wcslen( tmp ) );

#else

	Release();

	size_t Num = ( wcslen( Format ) + Mix::StringW::SPF_PLUS_SIZE );
	size_t AllocateSize = Num * 2;

	m_pStr = ( wchar_t* )malloc( AllocateSize );
	MIX_ASSERT( m_pStr != NULL );
	if( m_pStr == NULL )
	{
		Release();
		return NULL;
	}
	ZeroMemory( m_pStr, AllocateSize );

	va_list Args;
	va_start( Args, Format );
	_vsnwprintf_s( m_pStr, Num, _TRUNCATE, Format, Args );
	va_end( Args );

	m_Num = wcslen( m_pStr );
	m_Size = m_Num * 2;
	m_AllocateSize = AllocateSize;

#endif

	return m_pStr;
} 

StringW StringW::Left( size_t num )
{
	return StringW( m_pStr, ( m_Num < num )? ( m_Num ) : ( num ) );
}

StringW StringW::Right( size_t num )
{
	size_t offset = 0;
	size_t size = 0;

	if( m_Num < num )
	{
		offset = 0;
		size = m_Num;
	}
	else
	{
		offset = ( m_Num - num );
		size = num;
	}

	return StringW( m_pStr + offset, size );
}

StringW StringW::Mid( size_t startPos, size_t num )
{
	StringW ret;
	size_t offset = 0;
	size_t size = 0;

	if( m_Num <= startPos )
	{
		return ret;
	}

	offset = startPos;

	if( m_Num < ( offset + num ) )
	{
		size = m_Num - offset;
	}
	else
	{
		size = num;
	}

	ret.Copy( m_pStr + offset, size );

	return ret;
}

Int32 StringW::IndexOf( wchar_t value )
{
	if( m_pStr == NULL )
	{
		return -1;
	}

	for( size_t i = 0; m_pStr[i] != L'\0'; i++ )
	{
		if( m_pStr[i] == value )
		{
			return i;
		}
	}

	return -1;
}

Int32 StringW::LastIndexOf( wchar_t value )
{
	if( m_pStr == NULL )
	{
		return -1;
	}

	for( size_t i = ( m_Num - 1 ); i >= 0; i-- )
	{
		if( m_pStr[i] == value )
		{
			return i;
		}
	}

	return -1;
}

void StringW::Tok( Mix::StringW::StringList& list, const wchar_t* pDelimit )
{
	MIX_ASSERT( pDelimit != NULL );

	StringW tmpStr( m_pStr );
	wchar_t* pctx = NULL;
	wchar_t* pt = wcstok_s( tmpStr.m_pStr, pDelimit, &pctx );

	while( pt != NULL )
	{
		list.push_back( StringW( pt ) );
		pt = wcstok_s( NULL, pDelimit, &pctx );
	}
}

wchar_t* StringW::GetPtr( void ) const
{
	return m_pStr;
}

const wchar_t* StringW::GetConstPtr( void ) const
{
	return m_pStr;
}

UInt32 StringW::GetNum( void ) const
{
	return static_cast<UInt32>( m_Num );
}

size_t StringW::GetSize( void ) const
{
	return m_Size;
}

size_t StringW::GetAllocateSize( void ) const
{
	return m_AllocateSize;
}

size_t StringW::GetCapacity( void ) const
{
	return m_Capacity;
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////
// StringA NX( }`oCg )
/////////////////////////////////////////////////////////////////////////////////////////////////////////

char StringA::empty = 0;

StringA::StringA( void ) :
m_pStr( NULL ),
m_Num( 0 ),
m_Size( 0 ),
m_AllocateSize( 0 ),
m_Capacity( 0 )
{
}

StringA::StringA( const wchar_t* pStr ) :
m_pStr( NULL ),
m_Num( 0 ),
m_Size( 0 ),
m_AllocateSize( 0 ),
m_Capacity( 0 )
{
	Convert( pStr );
}

StringA::StringA( const char* pStr ) :
m_pStr( NULL ),
m_Num( 0 ),
m_Size( 0 ),
m_AllocateSize( 0 ),
m_Capacity( 0 )
{
	Copy( pStr );
}

StringA::StringA( const char* pStr, size_t Size ) :
m_pStr( NULL ),
m_Num( 0 ),
m_Size( 0 ),
m_AllocateSize( 0 ),
m_Capacity( 0 )
{
	Copy( pStr, Size );
}

StringA::StringA( const StringA& Str ) :
m_pStr( NULL ),
m_Num( 0 ),
m_Size( 0 ),
m_AllocateSize( 0 ),
m_Capacity( 0 )
{
	Copy( Str.m_pStr );
}

StringA::~StringA( void )
{
	if( m_pStr != NULL )
	{
		free( m_pStr );
		m_pStr = NULL;
	}
}

void StringA::Allocate( size_t size )
{
	size_t allocSize = size + 1;

	if( m_pStr == NULL )
	{
		m_pStr = static_cast<char*>( malloc( allocSize ) );
		MIX_ASSERT( m_pStr != NULL );

		m_Capacity = allocSize;
	}
	else
	{
		if( m_Capacity < allocSize )
		{
			void* pTemp = realloc( m_pStr, allocSize );
			MIX_ASSERT( pTemp != NULL );

			m_pStr = static_cast<char*>( pTemp );
			m_Capacity = allocSize;
		}
	}

	m_AllocateSize = allocSize;
}

void StringA::Copy( const char* pStr )
{
	Copy( pStr, ( pStr == NULL )? ( 0 ) : ( strlen( pStr ) ) );
}

void StringA::Copy( const char* pStr, size_t size )
{
#if 1

	if( pStr != NULL )
	{
		Allocate( size );

		m_Num = CalcStrNum( pStr );
		m_Size = size;

		Mix::Memory::Copy( m_pStr, pStr, m_Size );
		m_pStr[m_Size] = '\0';
	}

#else
	//
	Release();

	if( pStr == NULL )
	{
		return;
	}

	m_Num = CalcStrNum( pStr );
	m_Size = Size;
	m_AllocateSize = m_Size + sizeof( char );

	m_pStr = ( char* )malloc( m_AllocateSize );
	if( m_pStr == NULL )
	{
		MIX_ASSERT( m_pStr != NULL );
		Release();
	}
	else
	{
		ZeroMemory( m_pStr, m_AllocateSize );
		CopyMemory( m_pStr, pStr, m_Size );
	}
#endif
}

void StringA::Convert( const wchar_t* pStr )
{
#if 1

	//ϊ̒擾
	Int32 length = WideCharToMultiByte( CP_ACP, 0, pStr, -1, NULL, 0, NULL, NULL );

	if( length > 0 )
	{
		size_t size = length - 1;

		Allocate( size );

		if( WideCharToMultiByte( CP_ACP, 0, pStr, static_cast<Int32>( wcslen( pStr ) ), m_pStr, static_cast<Int32>( size ), NULL, NULL ) > 0 )
		{
			m_pStr[size] = L'\0';

			m_Num = CalcStrNum( m_pStr );
			m_Size = size;
		}
	}

#else

	//
	Release();

	//ϊ̒擾
	Int32 Length = WideCharToMultiByte( CP_ACP, 0, pStr, -1, NULL, 0, NULL, NULL );
	MIX_ASSERT( Length!= 0 );
	if( Length == 0 )
	{
		return;
	}

	m_Size = static_cast<size_t>( Length - 1 );
	m_AllocateSize = m_Size + sizeof( char );

	m_pStr = ( char* )malloc( m_AllocateSize );
	MIX_ASSERT( m_pStr != NULL );
	if( m_pStr == NULL )
	{
		Release();
	}
	else
	{
		ZeroMemory( m_pStr, m_AllocateSize );
		if( WideCharToMultiByte( CP_ACP, 0, pStr, static_cast<Int32>( wcslen( pStr ) ), m_pStr, static_cast<Int32>( m_Size ), NULL, NULL ) == 0 )
		{
			Release();
		}
	}

	m_Num = CalcStrNum( m_pStr );

#endif
}

void StringA::Add( const char* pStr )
{
#if 1
	
	if( pStr != NULL )
	{
		size_t oldSize = m_Size;
		size_t addNum = CalcStrNum( pStr );
		size_t addSize = strlen( pStr );

		Allocate( oldSize + addSize );

		m_Num += addNum;
		m_Size += addSize;

		Mix::Memory::Copy( m_pStr + oldSize, pStr, addSize );
		m_pStr[m_Size] = '\0';
	}

#else

	if( pStr == NULL )
	{
		return;
	}

	size_t AddNum = CalcStrNum( pStr );
	size_t AddSize = strlen( pStr );
	size_t OldSize = m_Size;

	m_Num += AddNum;
	m_Size += AddSize;
	m_AllocateSize = OldSize + AddSize + sizeof( char );

	m_pStr = ( char* )realloc( m_pStr, m_AllocateSize );
	if( m_pStr == NULL )
	{
		MIX_ASSERT( m_pStr != NULL );
		Release();
	}
	else
	{
		ZeroMemory( m_pStr + OldSize, AddSize + 1 );
		strcat_s( m_pStr, m_AllocateSize, pStr );
	}

#endif
}

size_t StringA::CalcStrNum( const char* pStr )
{
	size_t count = 0;
	const char* pc = &( pStr[0] );

	for( ;; )
	{
		BYTE c = ( BYTE )( *pc );
		if( c == 0x00 )
		{
			break;
		}

		if( c >= 0x80 )
		{
			pc++;
		}
		pc++;

		count++;
	}

	return count;
}

char& StringA::operator [] ( UInt32 index )
{
	MIX_ASSERT( m_pStr != NULL );
	MIX_ASSERT( m_Size > index );

	return m_pStr[index];
}

Boolean StringA::operator == ( const StringA& Str ) const
{
	if( ( m_pStr == NULL ) && ( Str.m_pStr == NULL ) )
	{
		return True;
	}
	else if( ( m_pStr == NULL ) || ( Str.m_pStr == NULL ) )
	{
		return False;
	}

	return ( strcmp( m_pStr, Str.m_pStr ) == 0 );
}

Boolean StringA::operator == ( const char* pStr ) const
{
	if( ( m_pStr == NULL ) && ( pStr == NULL ) )
	{
		return True;
	}
	else if( ( m_pStr == NULL ) || ( pStr == NULL ) )
	{
		return False;
	}

	return ( strcmp( m_pStr, pStr ) == 0 );
}

Boolean StringA::operator == ( char code ) const
{
	if( m_pStr == NULL )
	{
		return False;
	}

	if( m_pStr[0] == code )
	{
		return True;
	}

	return False;
}

Boolean StringA::operator == ( Int32 NullValue ) const
{
	return ( m_pStr == NULL );
}

Boolean StringA::operator != ( const StringA& str ) const
{
	if( ( m_pStr == NULL ) && ( str.m_pStr == NULL ) )
	{
		return False;
	}
	else if( ( m_pStr == NULL ) || ( str.m_pStr == NULL ) )
	{
		return True;
	}

	return ( strcmp( m_pStr, str.m_pStr ) != 0 );
}

Boolean StringA::operator != ( const char* pStr ) const
{
	if( ( m_pStr == NULL ) && ( pStr == NULL ) )
	{
		return False;
	}
	else if( ( m_pStr == NULL ) || ( pStr == NULL ) )
	{
		return True;
	}

	return ( strcmp( m_pStr, pStr ) != 0 );
}

Boolean StringA::operator != ( Int32 nullValue ) const
{
	return ( m_pStr != NULL );
}

StringA& StringA::operator = ( const StringA& Str )
{
	Copy( Str.m_pStr );

	return *this;
}

StringA& StringA::operator = ( const char* pStr )
{
	Copy( pStr );

	return *this;
}

StringA& StringA::operator = ( const wchar_t* pStr )
{
	Convert( pStr );

	return *this;
}

StringA& StringA::operator = ( char Code )
{
	char Tmp[2];

	Tmp[0] = Code;
	Tmp[1] = 0;

	Copy( Tmp );

	return *this;
}

StringA& StringA::operator += ( const char* pStr )
{
	Add( pStr );

	return *this;
}

StringA& StringA::operator += ( const StringA& str )
{
	Add( str.m_pStr );

	return *this;
}

StringA StringA::operator + ( const StringA& str )
{
	StringA tmpStr( m_pStr );

	tmpStr.Add( str.m_pStr );

	return tmpStr;
}

StringA& StringA::operator += ( char code )
{
	char tmp[2] = { code, '\0' };

	Add( tmp );

	return *this;
}

Float64 StringA::ToDouble( Boolean* pbRet ) const
{
	if( m_pStr == NULL )
	{
		if( pbRet != NULL )
		{
			*pbRet = False;
		}
		return 0.0;
	}

	char* pStopString = NULL;
	Float64 retValue = strtod( m_pStr, &pStopString );

	if( *pStopString != 0 )
	{
		if( pbRet != NULL )
		{
			*pbRet = False;
		}

		return 0.0;
	}

	if( pbRet != NULL )
	{
		*pbRet = True;
	}

	return retValue;
}

Float32 StringA::ToFloat( Boolean* pbRet ) const
{
	if( m_pStr == NULL )
	{
		if( pbRet != NULL )
		{
			*pbRet = False;
		}
		return 0.0f;
	}

	char* pStopString = NULL;
	Float32 retValue = static_cast<Float32>( strtod( m_pStr, &pStopString ) );

	if( *pStopString != 0 )
	{
		if( pbRet != NULL )
		{
			*pbRet = False;
		}

		return 0.0f;
	}

	if( pbRet != NULL )
	{
		*pbRet = True;
	}

	return retValue;
}

Int32 StringA::ToInt( Boolean* pbRet ) const
{
	if( m_pStr == NULL )
	{
		if( pbRet != NULL )
		{
			*pbRet = False;
		}
		return 0;
	}

	char* pStopString = NULL;
	Int32 retValue = static_cast<Int32>( strtol( m_pStr, &pStopString, 0 ) );

	if( *pStopString != 0 )
	{
		if( pbRet != NULL )
		{
			*pbRet = False;
		}
		return 0;
	}

	if( pbRet != NULL )
	{
		*pbRet = True;
	}

	return retValue;
}

UInt32 StringA::ToUInt( Boolean* pbRet ) const
{
	if( m_pStr == NULL )
	{
		if( pbRet != NULL )
		{
			*pbRet = False;
		}
		return 0;
	}

	char* pStopString = NULL;
	UInt32 retValue = static_cast<UInt32>( strtoul( m_pStr, &pStopString, 0 ) );

	if( *pStopString != 0 )
	{
		if( pbRet != NULL )
		{
			*pbRet = False;
		}

		return 0;
	}

	if( pbRet != NULL )
	{
		*pbRet = True;
	}

	return retValue;
}

StringA StringA::ToUpper( void )
{
	Mix::StringA temp = *this;

	temp.Upper();

	return temp;
}

StringA StringA::ToLower( void )
{
	Mix::StringA temp = *this;

	temp.Lower();

	return temp;
}

void StringA::Upper( void )
{
	if( m_pStr == NULL )
	{
		return;
	}

	char* pc = &( m_pStr[0] );

	while( *pc != L'\0' )
	{
		// A`Z( 0x41`0x5A )
		// a`z( 0x61`0x7A )
		if( ( *pc >= 0x61 ) &&
			( *pc <= 0x7A ) )
		{
			*pc = *pc - 0x61 + 0x41;
		}

		pc++;
	}
}

void StringA::Lower( void )
{
	if( m_pStr == NULL )
	{
		return;
	}

	char* pc = &( m_pStr[0] );

	while( *pc != L'\0' )
	{
		// A`Z( 0x41`0x5A )
		// a`z( 0x61`0x7A )
		if( ( *pc >= 0x41 ) &&
			( *pc <= 0x5A ) )
		{
			*pc = *pc - 0x41 + 0x61;
		}

		pc++;
	}
}

char* StringA::Sprintf( const char* format, ... )
{
	MIX_ASSERT( format != NULL );

#if 1

	char temp[Mix::StringA::VA_TEMP_NUM] = { '\0' };
	va_list args;

	va_start( args, format );
	vsnprintf_s( m_pStr, Mix::StringA::VA_TEMP_NUM, _TRUNCATE, format, args );
	va_end( args );

	Copy( temp, strlen( temp ) );

#else

	Release();

	size_t AllocateSize = strlen( format ) + Mix::StringA::SPF_PLUS_SIZE;

	m_pStr = ( char* )malloc( AllocateSize );
	MIX_ASSERT( m_pStr != NULL );
	if( m_pStr == NULL )
	{
		Release();
		return NULL;
	}
	ZeroMemory( m_pStr, AllocateSize );

	va_list Args;
	va_start( Args, format );
	vsnprintf_s( m_pStr, AllocateSize, _TRUNCATE, format, Args );
	va_end( Args );

	m_Num = CalcStrNum( m_pStr );
	m_Size = strlen( m_pStr );
	m_AllocateSize = AllocateSize;

#endif

	return m_pStr;
}

StringA StringA::Left( size_t Size )
{
	return StringA( m_pStr, ( m_Size < Size )? ( m_Size ) : ( Size ) );
}

StringA StringA::Right( size_t Size )
{
	size_t offset = 0;
	size_t size = 0;

	if( m_Size < Size )
	{
		offset = 0;
		size = m_Size;
	}
	else
	{
		offset = ( m_Size - Size );
		size = Size;
	}

	return StringA( m_pStr + offset, size );
}

StringA StringA::Mid( size_t startPos, size_t size )
{
	StringA tmpStr;
	size_t offset = 0;
	size_t copySize = 0;

	if( m_Size <= startPos )
	{
		return tmpStr;
	}

	offset = startPos;

	if( m_Size < ( offset + size ) )
	{
		copySize = m_Size - offset;
	}
	else
	{
		copySize = size;
	}

	tmpStr.Copy( m_pStr + offset, copySize );

	return tmpStr;
}

Int32 StringA::IndexOf( char value )
{
	if( m_pStr == NULL )
	{
		return -1;
	}

	for( Int32 i = 0; m_pStr[i] != '\0'; i++ )
	{
		if( m_pStr[i] == value )
		{
			return i;
		}
	}

	return -1;
}

Int32 StringA::LastIndexOf( char value )
{
	if( m_pStr == NULL )
	{
		return -1;
	}

	for( Int32 i = ( m_Num - 1 ); i >= 0; i-- )
	{
		if( m_pStr[i] == value )
		{
			return i;
		}
	}

	return -1;
}

void StringA::Tok( Mix::StringA::StringList& list, const char* pDelimit )
{
	MIX_ASSERT( pDelimit != NULL );

	StringA tmpStr( m_pStr );
	char* pctx = NULL;
	char* pt = strtok_s( tmpStr.m_pStr, pDelimit, &pctx );

	while( pt != NULL )
	{
		list.push_back( StringA( pt ) );
		pt = strtok_s( NULL, pDelimit, &pctx );
	}
}

char* StringA::GetPtr( void ) const
{
	return m_pStr;
}

const char* StringA::GetConstPtr( void ) const
{
	return m_pStr;
}

UInt32 StringA::GetNum( void ) const
{
	return static_cast<UInt32>( m_Num );
}

size_t StringA::GetSize( void ) const
{
	return m_Size;
}

size_t StringA::GetAllocateSize( void ) const
{
	return m_AllocateSize;
}

size_t StringA::GetCapacity( void ) const
{
	return m_Capacity;
}

}
