#include "Mix/Class/Engine.h"

#include "Mix/Class/CpuID.h"

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// ϐ
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

//Mix
namespace Mix{

	static Boolean		g_bInitialize		= False;	//Ăꍇ True
	static Boolean		g_bComInitialize	= False;	//COMĂꍇ True
	static Boolean		g_bTimeBeginPeriod	= False;	//Sleep̐xグ( timeBeginPeriod )ꍇ True

}


/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// Mix ֐
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

Boolean Mix::Initialize( const Mix::ENGINE_CONFIG& config )
{
	if( g_bInitialize == True )
	{
		::MessageBox( ::GetDesktopWindow(), L"Mix::Initialize : łɏĂ܂", L"G[", MB_OK | MB_ICONSTOP );
		Mix::Finalize();
		return False;
	}

	Mix::UserFile sysReport;

	////////////////////////////////////////////////////////////////////////////////////////////////////
	// [Ňo
	////////////////////////////////////////////////////////////////////////////////////////////////////

#ifdef _DEBUG
	::_CrtSetDbgFlag( _CrtSetDbgFlag( _CRTDBG_REPORT_FLAG ) | _CRTDBG_LEAK_CHECK_DF );
#endif //_DEBUG

	////////////////////////////////////////////////////////////////////////////////////////////////////
	// ݒ̊mF
	////////////////////////////////////////////////////////////////////////////////////////////////////

	if( config.bUseGraphics == True )
	{
		if( config.bUseFile == False )
		{
			::MessageBox( ::GetDesktopWindow(), L"Mix::CreateEngine : uOtBbNXvgpꍇ́Aut@CvLɂĂ", L"G[", MB_OK | MB_ICONSTOP );
			Mix::Finalize();
			return False;
		}
	}

	if( config.bUseSound == True )
	{
		if( config.bUseFile == False )
		{
			::MessageBox( ::GetDesktopWindow(), L"Mix::CreateEngine : uTEhvgpꍇ́Aut@CvLɂĂ", L"G[", MB_OK | MB_ICONSTOP );
			Mix::Finalize();
			return False;
		}
	}

	if( config.bUseScene == True )
	{
		if( ( config.bUseFile == False ) ||
			( config.bUseGraphics == False ) )
		{
			::MessageBox( ::GetDesktopWindow(), L"Mix::CreateEngine : uV[vgpꍇ́Aut@CvuOtBbNXvLɂĂ", L"G[", MB_OK | MB_ICONSTOP );
			Mix::Finalize();
			return False;
		}
	}

	////////////////////////////////////////////////////////////////////////////////////////////////////
	// VXe|[g
	////////////////////////////////////////////////////////////////////////////////////////////////////

	if( sysReport.Initialize( ( config.file.pUserDirectoryName != NULL )? config.file.pUserDirectoryName : Mix::DEF_USERDIRECTORYNAME, Mix::SYSTEM_FILENAME ) == False )
	{
		::MessageBox( ::GetDesktopWindow(), L"VXe|[g̏Ɏs܂", L"G[", MB_OK | MB_ICONSTOP );
		Mix::Finalize();
		return False;
	}

	////////////////////////////////////////////////////////////////////////////////////////////////////
	// Iy[eBOVXe̊mF
	////////////////////////////////////////////////////////////////////////////////////////////////////

	OSVERSIONINFOEX os;

	Mix::Memory::Zero( &os, sizeof( os ) );
	os.dwOSVersionInfoSize = sizeof( OSVERSIONINFOEX );

	if( ::GetVersionEx( reinterpret_cast<LPOSVERSIONINFO>( &os ) ) == FALSE )
	{
		::MessageBox( ::GetDesktopWindow(), L"OS̎擾Ɏs܂", L"G[", MB_OK | MB_ICONSTOP );
		Mix::Finalize();
		return False;
	}

	if( sysReport.Open() == True )
	{
		sysReport.WriteLine( L"////////////////////////////////////////////////////////////////////////////////////////////////////" );
		sysReport.WriteLine( L"// Iy[eBOVXe                                                                       //" );
		sysReport.WriteLine( L"////////////////////////////////////////////////////////////////////////////////////////////////////" );
		sysReport.WriteLine( L"" );

		if( ( os.dwMajorVersion == 5 ) && ( os.dwMinorVersion == 1 ) )
		{
			sysReport.WriteLine( L"^Cv : WindowsXP" );
		}
		else if( ( os.dwMajorVersion == 6 ) && ( os.dwMinorVersion == 0 ) && ( os.wProductType == VER_NT_WORKSTATION ) )
		{
			sysReport.WriteLine( L"^Cv : WindowsVista" );
		}
		else if( ( os.dwMajorVersion == 6 ) && ( os.dwMinorVersion == 1 ) && ( os.wProductType == VER_NT_WORKSTATION ) )
		{
			sysReport.WriteLine( L"^Cv : Windows7" );
		}

		if( os.wServicePackMajor != 0 )
		{
			sysReport.WriteLine( L"T[rXpbN : %d.%d", os.wServicePackMajor, os.wServicePackMinor );
		}
		else
		{
			sysReport.WriteLine( L"T[rXpbN : CXg[Ă܂" );
		}

		sysReport.WriteLine( L"o[W : %d.%d.%d", os.dwMajorVersion, os.dwMinorVersion, os.dwBuildNumber );
		sysReport.WriteLine( L"" );

		sysReport.Close();
	}
/*
	if(	( os.dwMajorVersion == 5 && os.dwMinorVersion == 1 ) ||	//WindowsXP
		( os.dwMajorVersion == 6 && os.dwMinorVersion == 0 && os.wProductType == VER_NT_WORKSTATION ) ||	//WindowsVista
		( os.dwMajorVersion == 6 && os.dwMinorVersion == 1 && os.wProductType == VER_NT_WORKSTATION ) )	//Windows7
	{
		;
	}
	else
	{
		::MessageBox( ::GetDesktopWindow(), L"T|[gΏۊÕIy[eBOVXegpĂ܂", L"G[", MB_OK | MB_ICONSTOP );
		Mix::Finalize();
		return False;
	}
*/
	if(	( os.dwMajorVersion == 5 && os.dwMinorVersion == 1 ) ||	//WindowsXP
		( os.dwMajorVersion == 6 && os.dwMinorVersion == 0 && os.wProductType == VER_NT_WORKSTATION ) ||	//WindowsVista
		( os.dwMajorVersion == 6 && os.dwMinorVersion == 1 && os.wProductType == VER_NT_WORKSTATION ) ||	//Windows7
		( os.dwMajorVersion == 6 && os.dwMinorVersion == 2 && os.wProductType == VER_NT_WORKSTATION ) ||	//Windows8
		( os.dwMajorVersion == 6 && os.dwMinorVersion == 3 && os.wProductType == VER_NT_WORKSTATION ) )		//Windows8.1
	{
		;
	}
	else
	{
		::MessageBox( ::GetDesktopWindow(), L"T|[gΏۊÕIy[eBOVXegpĂ܂", L"G[", MB_OK | MB_ICONSTOP );
		Mix::Finalize();
		return False;
	}

	////////////////////////////////////////////////////////////////////////////////////////////////////
	// CPU擾
	////////////////////////////////////////////////////////////////////////////////////////////////////

	if( Mix::CpuID::Initialize() == False )
	{
		::MessageBox( ::GetDesktopWindow(), L"CPU̎擾Ɏs܂", L"G[", MB_OK | MB_ICONSTOP );
		Mix::Finalize();
		return False;
	}

	////////////////////////////////////////////////////////////////////////////////////////////////////
	// SSE2gpł邩ǂmF
	////////////////////////////////////////////////////////////////////////////////////////////////////

#ifdef _MIX_USE_SSE2

	if( MIX_TESTBIT( Mix::CpuID::GetInfo().osFeature, Mix::CPU_FEATURE_SSE2 ) != Mix::CPU_FEATURE_SSE2 )
	{
		::MessageBox( ::GetDesktopWindow(), L"CPUSSE2߂T|[gĂ܂", L"G[", MB_OK | MB_ICONSTOP );
		Mix::Finalize();
		return False;
	}

#endif //_MIX_USE_SSE2

	////////////////////////////////////////////////////////////////////////////////////////////////////
	// \ptH[}XJE^gpł邩`FbN
	////////////////////////////////////////////////////////////////////////////////////////////////////

	LARGE_INTEGER liDammy;

	if( ::QueryPerformanceCounter( &liDammy ) == FALSE )
	{
		::MessageBox( ::GetDesktopWindow(), L"\ptH[}XJE^gpł܂", L"G[", MB_OK | MB_ICONSTOP );
		Mix::Finalize();
		return False;
	}

	////////////////////////////////////////////////////////////////////////////////////////////////////
	// COM
	////////////////////////////////////////////////////////////////////////////////////////////////////

	if( SUCCEEDED( ::CoInitializeEx( NULL, COINIT_APARTMENTTHREADED | COINIT_DISABLE_OLE1DDE ) ) )
	{
		g_bComInitialize = True;
	}
	else
	{
		::MessageBox( ::GetDesktopWindow(), L"COM̏Ɏs܂", L"G[", MB_OK | MB_ICONSTOP );
		Mix::Finalize();
		return False;
	}

	////////////////////////////////////////////////////////////////////////////////////////////////////
	// ^C}[x
	////////////////////////////////////////////////////////////////////////////////////////////////////

	if( ::timeBeginPeriod( 1 ) == TIMERR_NOERROR )
	{
		g_bTimeBeginPeriod = True;
	}
	else
	{
		::MessageBox( ::GetDesktopWindow(), L"ŏ^C}\̐ݒɎs܂", L"G[", MB_OK | MB_ICONSTOP );
		Mix::Finalize();
		return False;
	}

	////////////////////////////////////////////////////////////////////////////////////////////////////
	// ̏
	////////////////////////////////////////////////////////////////////////////////////////////////////

	Mix::InitRand();

	////////////////////////////////////////////////////////////////////////////////////////////////////
	// XbhŒ( WindowsXP  QueryPerformanceCounter ΍ )
	////////////////////////////////////////////////////////////////////////////////////////////////////

	if( ( os.dwMajorVersion == 5 ) && ( os.dwMinorVersion == 1 ) )
	{
		if( ::SetThreadAffinityMask( ::GetCurrentThread(), 0x00000001 ) == 0 )
		{
			::MessageBox( ::GetDesktopWindow(), L"JgXbȟŒɎs܂", L"G[", MB_OK | MB_ICONSTOP );
			Mix::Finalize();
			return False;
		}
	}

	////////////////////////////////////////////////////////////////////////////////////////////////////
	// K[쐬
	////////////////////////////////////////////////////////////////////////////////////////////////////

	if( Mix::Logger::CreateInstance( ( config.file.pUserDirectoryName != NULL )? config.file.pUserDirectoryName : Mix::DEF_USERDIRECTORYNAME, Mix::LOG_FILENAME ) == False )
	{
		::MessageBox( ::GetDesktopWindow(), L"K[̍쐬Ɏs܂", L"G[", MB_OK | MB_ICONSTOP );
		Mix::Finalize();
		return False;
	}

	////////////////////////////////////////////////////////////////////////////////////////////////////
	// GW쐬
	////////////////////////////////////////////////////////////////////////////////////////////////////

	if( Mix::Engine::CreateInstance( config, &sysReport ) == False )
	{
		::MessageBox( ::GetDesktopWindow(), L"GW̍쐬Ɏs܂", L"G[", MB_OK | MB_ICONSTOP );
		Mix::Finalize();
		return False;
	}

	////////////////////////////////////////////////////////////////////////////////////////////////////
	// 
	////////////////////////////////////////////////////////////////////////////////////////////////////

	g_bInitialize = True;

	////////////////////////////////////////////////////////////////////////////////////////////////////

	return True;
}

void Mix::Finalize( void )
{
	//GW
	Mix::Engine::ReleaseInstance();

	//K[
	Mix::Logger::ReleaseInstance();

	//^C}[x߂
	if( g_bTimeBeginPeriod == True )
	{
		::timeEndPeriod( 1 );
		g_bTimeBeginPeriod = False;
	}

	//COMI
	if( g_bComInitialize == True )
	{
		::CoUninitialize();
		g_bComInitialize = False;
	}

	//
	g_bInitialize = False;
}
