#pragma once

#include "Mix/Reference.h"
#include "Mix/Semaphore.h"
#include "Mix/CriticalSection.h"
#include "Mix/AtomicValue.h"

namespace Mix{ namespace Sound{

	class TaskMediator : public Mix::Reference
	{
	public:
		enum EVENT_TYPE
		{
			EVENT_TYPE_PLAY = 1,
			EVENT_TYPE_STOP = 2,
			EVENT_TYPE_SUSPEND = 3,
			EVENT_TYPE_RESUME = 4,
			EVENT_TYPE_TERMINATE = 5,
		};

		enum STATE
		{
			STATE_STOP = 0,
			STATE_PLAY = 1,
		};

	private:
		enum VALUE
		{
			MAX_EVENT_QUEUE = 4,
		};

		struct EVENT_QUEUE
		{
			Mix::Semaphore emptySema;
			Mix::Semaphore countSema;
			Mix::CriticalSection sync;
			Int32 data[TaskMediator::MAX_EVENT_QUEUE];
			UInt32 read;
			UInt32 write;

			EVENT_QUEUE( void );
		};

	private:
		EVENT_QUEUE m_EventQueue;
		Mix::AtomicValue m_State;

	protected:
		virtual ~TaskMediator( void ){}

	public:
		void PushEvent( Int16 type, Int16 opt );
		Long32 GetState( void );

	public:
		Boolean PopEvent( Int16& type, Int16& opt );
		void SetState( Long32 value ); 
	};

}}
