#include "Mix/Class/Sound/TaskMediator.h"

namespace Mix{ namespace Sound{

////////////////////////////////////////////////////////////////////////////////////////////////////
// TaskMediator::EVENT_QUEUE
////////////////////////////////////////////////////////////////////////////////////////////////////

TaskMediator::EVENT_QUEUE::EVENT_QUEUE( void ) :
emptySema( TaskMediator::MAX_EVENT_QUEUE, TaskMediator::MAX_EVENT_QUEUE ),
countSema( 0, TaskMediator::MAX_EVENT_QUEUE ),
read( 0 ),
write( 0 )
{
}

////////////////////////////////////////////////////////////////////////////////////////////////////
// TaskMediator
// JgXbhĂяo郁\bh
////////////////////////////////////////////////////////////////////////////////////////////////////

void TaskMediator::PushEvent( Int16 type, Int16 opt )
{
	m_EventQueue.emptySema.Reduce();
	m_EventQueue.sync.Enter();

	m_EventQueue.data[m_EventQueue.write] = ( ( type << 16 ) | opt );

	m_EventQueue.write++;
	if( m_EventQueue.write == TaskMediator::MAX_EVENT_QUEUE )
	{
		m_EventQueue.write = 0;
	}

	m_EventQueue.sync.Leave();
	m_EventQueue.countSema.Increase();
}

Long32 TaskMediator::GetState( void )
{
	return m_State.Get();
}

////////////////////////////////////////////////////////////////////////////////////////////////////
// TaskMediator
// TEhXbhĂяo郁\bh
////////////////////////////////////////////////////////////////////////////////////////////////////

Boolean TaskMediator::PopEvent( Int16& type, Int16& opt )
{
	if( m_EventQueue.countSema.Reduce( 0 ) == False )
	{
		return False;
	}

	m_EventQueue.sync.Enter();

	Int32 temp = m_EventQueue.data[m_EventQueue.read];

	type = static_cast<Int16>( ( temp >> 16 ) & 0x0000FFFF );
	opt = static_cast<Int16>( temp & 0x0000FFFF );

	m_EventQueue.read++;
	if( m_EventQueue.read == TaskMediator::MAX_EVENT_QUEUE )
	{
		m_EventQueue.read = 0;
	}

	m_EventQueue.sync.Leave();
	m_EventQueue.emptySema.Increase();

	return True;
}

void TaskMediator::SetState( Long32 value )
{
	m_State.Set( value );
}

}}
