#include "Mix/Class/Sound/StreamEmitterTask.h"
#include "Mix/Class/Sound/EmitterTaskMediator.h"

namespace Mix{ namespace Sound{

StreamEmitterTask::StreamEmitterTask( Mix::Sound::EmitterTaskMediator* pTaskMediator ) : StreamTask( pTaskMediator ),
m_pTaskMediator( pTaskMediator )
{
	MIX_ADD_REF( m_pTaskMediator );
}

StreamEmitterTask::~StreamEmitterTask( void )
{
	MIX_RELEASE( m_pTaskMediator );
}

Boolean StreamEmitterTask::Process( void )
{
	XAUDIO2_VOICE_STATE state;

	m_pVoice->GetState( &state );

	if( state.BuffersQueued > 0 )
	{
		m_pTaskMediator->ApplyDSPSettings( m_pVoice );
	}

	return StreamTask::Process();
}

}}
