#pragma once

#include "Mix/Class/Sound/TaskMediator.h"

namespace Mix{ namespace Sound{

	class StreamControllerTaskMediator : public Mix::Sound::TaskMediator
	{
	private:
		class SyncFloat
		{
		private:
			Mix::CriticalSection m_Sync;
			Float32 m_Current;
			Float32 m_Next;

		public:
			SyncFloat( Float32 defValue );

		public:
			void SetNext( Float32 value );
			Float32 GetNext( void );

		public:
			Boolean GetCurrent( Float32& value );
		};

	public:
		static StreamControllerTaskMediator* CreateInstance( void );

	private:
		StreamControllerTaskMediator::SyncFloat m_Volume;
		StreamControllerTaskMediator::SyncFloat m_Panpot;

	private:
		StreamControllerTaskMediator( void );
		virtual ~StreamControllerTaskMediator( void );

	public:
		void SetVolume( Float32 value );
		void SetPanpot( Float32 value );
		Float32 GetVolume( void );
		Float32 GetPanpot( void );

	public:
		Boolean GetVolume( Float32& value );
		Boolean GetPanpot( Float32& value );
	};
}}
