#include "Mix/Class/Sound/StreamControllerTaskMediator.h"
#include "Mix/ScopedLock.h"

namespace Mix{ namespace Sound{

////////////////////////////////////////////////////////////////////////////////////////////////////
// StreamControllerTaskMediator::SyncFloat
////////////////////////////////////////////////////////////////////////////////////////////////////

StreamControllerTaskMediator::SyncFloat::SyncFloat( Float32 defValue ) :
m_Current( defValue ),
m_Next( defValue )
{
}

void StreamControllerTaskMediator::SyncFloat::SetNext( Float32 value )
{
	m_Sync.Enter();
	m_Next = value;
	m_Sync.Leave();
}

Float32 StreamControllerTaskMediator::SyncFloat::GetNext( void )
{
	Mix::ScopedLock lock( m_Sync );

	return m_Next;
}

Boolean StreamControllerTaskMediator::SyncFloat::GetCurrent( Float32& value )
{
	Mix::ScopedLock lock( m_Sync );

	Boolean bUpdate = False;

	if( m_Current != m_Next )
	{
		m_Current = m_Next;
		value = m_Current;
	}

	return bUpdate;
}


////////////////////////////////////////////////////////////////////////////////////////////////////
// StreamControllerTaskMediator
////////////////////////////////////////////////////////////////////////////////////////////////////

StreamControllerTaskMediator* StreamControllerTaskMediator::CreateInstance( void )
{
	return new StreamControllerTaskMediator();
}

StreamControllerTaskMediator::StreamControllerTaskMediator( void ) :
m_Volume( 1.0f ),
m_Panpot( 0.0f )
{
}

StreamControllerTaskMediator::~StreamControllerTaskMediator( void )
{
}

void StreamControllerTaskMediator::SetVolume( Float32 value )
{
	m_Volume.SetNext( value );
}

void StreamControllerTaskMediator::SetPanpot( Float32 value )
{
	m_Panpot.SetNext( value );
}

Float32 StreamControllerTaskMediator::GetVolume( void )
{
	return m_Volume.GetNext();
}

Float32 StreamControllerTaskMediator::GetPanpot( void )
{
	return m_Panpot.GetNext();
}

Boolean StreamControllerTaskMediator::GetVolume( Float32& value )
{
	return m_Volume.GetCurrent( value );
}

Boolean StreamControllerTaskMediator::GetPanpot( Float32& value )
{
	return m_Panpot.GetCurrent( value );
}

}}
