#include "Mix/Class/Sound/StreamControllerTask.h"
#include "Mix/Class/Sound/StreamControllerTaskMediator.h"

namespace Mix{ namespace Sound{

StreamControllerTask::StreamControllerTask( Mix::Sound::StreamControllerTaskMediator* pTaskMediator ) : StreamTask( pTaskMediator ),
m_pTaskMediator( pTaskMediator )
{
	MIX_ADD_REF( m_pTaskMediator );
}

StreamControllerTask::~StreamControllerTask( void )
{
	MIX_RELEASE( m_pTaskMediator );
}

Boolean StreamControllerTask::Process( void )
{
	Float32 volume;
	Float32 panpot;

	if( m_pTaskMediator->GetVolume( volume ) == True )
	{
		m_pVoice->SetVolume( volume );
	}

	if( m_pTaskMediator->GetPanpot( panpot ) == True )
	{
		Float32 cv[2];

		if( panpot >= 0.0f )
		{
			cv[0] = ( 1.0f - panpot );
			cv[1] = 1.0;
		}
		else
		{
			cv[0] = 1.0;
			cv[1] = ( 1.0f + panpot );
		}

		m_pVoice->SetChannelVolumes( 2, cv );
	}

	return StreamTask::Process();
}

}}
