#pragma once

#include "Mix/Sound/IController.h"

namespace Mix{ namespace Sound{

	class Manager;
	class StreamControllerTaskMediator;

	class StreamController : public Mix::Sound::IController
	{
	public:
		static StreamController* CreateInstance(	Mix::Sound::Manager* pMgr,
													Mix::File::IReader* pReader,
													Mix::Sound::StreamControllerTaskMediator* pTaskMediator );

	private:
		Mix::Sound::Manager* m_pMgr;
		Mix::File::IReader* m_pReader;
		Mix::Sound::StreamControllerTaskMediator* m_pTaskMediator;

	private:
		StreamController( Mix::Sound::Manager* pMgr, Mix::File::IReader* pReader, Mix::Sound::StreamControllerTaskMediator* pTaskMediator );
		virtual ~StreamController( void );

	public:
		////////////////////////////////////////////////////////////////////////////////////////////////////
		// Mix::Sound::IController
		////////////////////////////////////////////////////////////////////////////////////////////////////

		virtual Float32 GetVolume( void ) const;
		virtual void SetVolume( Float32 volume );

		virtual Float32 GetPanpot( void ) const;
		virtual void SetPanpot( Float32 panpot );

		virtual Boolean IsCloneable( void ) const;
		virtual Boolean Clone( Mix::Sound::IController** ppController );

		////////////////////////////////////////////////////////////////////////////////////////////////////
		// Mix::Sound::IDevice
		////////////////////////////////////////////////////////////////////////////////////////////////////

		virtual Boolean IsPlaying( void );
		virtual void Play( Boolean bLoop );
		virtual void Stop( void );

		virtual void Suspend( void );
		virtual void Resume( void );

		virtual const wchar_t* GetFilePath( void ) const;
	};

}}
