#include "Mix/Class/Sound/StreamController.h"
#include "Mix/Class/Sound/StreamControllerTaskMediator.h"
#include "Mix/Class/Sound/Manager.h"
#include "Mix/File/IReader.h"

namespace Mix{ namespace Sound{

StreamController* StreamController::CreateInstance( Mix::Sound::Manager* pMgr,
													Mix::File::IReader* pReader,
													Mix::Sound::StreamControllerTaskMediator* pTaskMediator )
{
	return new StreamController( pMgr, pReader, pTaskMediator );
}

StreamController::StreamController( Mix::Sound::Manager* pMgr,
									Mix::File::IReader* pReader,
									Mix::Sound::StreamControllerTaskMediator* pTaskMediator ) :
m_pMgr( pMgr ),
m_pReader( pReader ),
m_pTaskMediator( pTaskMediator )
{
	MIX_ADD_REF( m_pMgr );
	MIX_ADD_REF( m_pReader );
	MIX_ADD_REF( m_pTaskMediator );
}

StreamController::~StreamController( void )
{
	m_pTaskMediator->PushEvent( Mix::Sound::TaskMediator::EVENT_TYPE_TERMINATE, 0 );

	MIX_RELEASE( m_pTaskMediator );
	MIX_RELEASE( m_pReader );
	MIX_RELEASE( m_pMgr );
}

////////////////////////////////////////////////////////////////////////////////////////////////////
// Mix::Sound::IController
////////////////////////////////////////////////////////////////////////////////////////////////////

Float32 StreamController::GetVolume( void ) const
{
	return m_pTaskMediator->GetVolume();
}

void StreamController::SetVolume( Float32 volume )
{
	m_pTaskMediator->SetVolume( volume );
}

Float32 StreamController::GetPanpot( void ) const
{
	return m_pTaskMediator->GetPanpot();
}

void StreamController::SetPanpot( Float32 panpot )
{
	m_pTaskMediator->SetPanpot( panpot );
}

Boolean StreamController::IsCloneable( void ) const
{
	return m_pReader->IsBuffered();
}

Boolean StreamController::Clone( Mix::Sound::IController** ppController )
{
	return m_pMgr->CloneStreamController( m_pReader, ppController );
}

////////////////////////////////////////////////////////////////////////////////////////////////////
// Mix::Sound::IDevice
////////////////////////////////////////////////////////////////////////////////////////////////////

Boolean StreamController::IsPlaying( void )
{
	return ( m_pTaskMediator->GetState() == Mix::Sound::TaskMediator::STATE_PLAY );
}

void StreamController::Play( Boolean bLoop )
{
	m_pTaskMediator->PushEvent( Mix::Sound::TaskMediator::EVENT_TYPE_STOP, 0 );
	m_pTaskMediator->PushEvent( Mix::Sound::TaskMediator::EVENT_TYPE_PLAY, ( bLoop == True )? 1 : 0 );
}

void StreamController::Stop( void )
{
	m_pTaskMediator->PushEvent( Mix::Sound::TaskMediator::EVENT_TYPE_STOP, 0 );
}

void StreamController::Suspend( void )
{
	m_pTaskMediator->PushEvent( Mix::Sound::TaskMediator::EVENT_TYPE_SUSPEND, 0 );
}

void StreamController::Resume( void )
{
	m_pTaskMediator->PushEvent( Mix::Sound::TaskMediator::EVENT_TYPE_RESUME, 0 );
}

const wchar_t* StreamController::GetFilePath( void ) const
{
	return m_pReader->GetFilePath();
}

}}
