#pragma once

#include "Mix/Class/Sound/Task.h"

namespace Mix{ namespace Sound{

	class EmitterTaskMediator;

	class StaticEmitterTask : public Mix::Sound::Task
	{
	private:
		Mix::Sound::EmitterTaskMediator* m_pMediator;
		IXAudio2SourceVoice* m_pVoice;
		Mix::Memory::IBuffer* m_pBuffer;
		XAUDIO2_BUFFER m_Data;
		Int32 m_SuspendCount;

	private:
		void ProcPlay( Boolean bLoop );
		void ProcStop( void );
		void ProcSuspend( void );
		void ProcResume( void );
		void ProcState( void );

	public:
		StaticEmitterTask( Mix::Sound::EmitterTaskMediator* pMediator, Mix::Memory::IBuffer* pBuffer, IXAudio2SourceVoice* pVoice );
		virtual ~StaticEmitterTask( void );

	public:
		virtual Boolean Process( void );
	};

}}
