#pragma once

#include "Mix/Plugin/Sound/IDecoder.h"

namespace Mix{ namespace Sound{

	class Plugin
	{
	private:
		typedef Boolean ( __stdcall* CheckSoundFormatFunc )( const void* pData, UInt32& size );
		typedef const wchar_t* ( __stdcall* GetSoundDecoderNameFunc )( void );
		typedef const wchar_t* ( __stdcall* GetSoundDecoderVersionFunc )( void );
		typedef Boolean ( __stdcall* CreateSoundDecoderFunc )( Mix::File::IReader* pReader, Mix::Plugin::Sound::IDecoder** ppDecoder );

	private:
		HMODULE m_hModule;
		UInt32 m_KeySize;

	public:
		Plugin( void );
		~Plugin( void );

	private:
		void Unload( void );

	public:
		Boolean Load( const wchar_t* pFileName );

		UInt32 GetKeySize( void ) const;

		Boolean CheckFormat( const void* pData, UInt32& size );
		const wchar_t* GetDecoderName( void );
		const wchar_t* GetDecoderVersion( void );
		Boolean CreateDecoder( Mix::File::IReader* pReader, Mix::Plugin::Sound::IDecoder** ppDecoder );
	};

}}
