#include "Mix/Class/Sound/Plugin.h"

namespace Mix{ namespace Sound{

Plugin::Plugin( void ) :
m_hModule( NULL ),
m_KeySize( 0 )
{
}

Plugin::~Plugin( void )
{
	Unload();
}

Boolean Plugin::Load( const wchar_t* pFileName )
{
	if( m_hModule != NULL )
	{
		return False;
	}

	m_hModule = ::LoadLibraryW( pFileName );
	if( m_hModule == NULL )
	{
		return False;
	}

	if( ( ::GetProcAddress( m_hModule, "CheckSoundFormat" ) == NULL ) ||
		( ::GetProcAddress( m_hModule, "GetSoundDecoderName" ) == NULL ) ||
		( ::GetProcAddress( m_hModule, "GetSoundDecoderVersion" ) == NULL ) ||
		( ::GetProcAddress( m_hModule, "CreateSoundDecoder" ) == NULL ) )
	{
		Unload();
		return False;
	}

	if( CheckFormat( NULL, m_KeySize ) == False )
	{
		return False;
	}

	if( m_KeySize == 0 )
	{
		return False;
	}

	return True;
}

UInt32 Plugin::GetKeySize( void ) const
{
	return m_KeySize;
}

Boolean Plugin::CheckFormat( const void* pData, UInt32& size )
{
	void* pFunc = ::GetProcAddress( m_hModule, "CheckSoundFormat" );
	if( pFunc == NULL )
	{
		return False;
	}

	return static_cast<Plugin::CheckSoundFormatFunc>( pFunc )( pData, size );
}

const wchar_t* Plugin::GetDecoderName( void )
{
	void* pFunc = ::GetProcAddress( m_hModule, "GetSoundDecoderName" );
	if( pFunc == NULL )
	{
		return False;
	}

	return static_cast<Plugin::GetSoundDecoderNameFunc>( pFunc )();
}

const wchar_t* Plugin::GetDecoderVersion( void )
{
	void* pFunc = ::GetProcAddress( m_hModule, "GetSoundDecoderVersion" );
	if( pFunc == NULL )
	{
		return False;
	}

	return static_cast<Plugin::GetSoundDecoderVersionFunc>( pFunc )();
}

Boolean Plugin::CreateDecoder( Mix::File::IReader* pReader, Mix::Plugin::Sound::IDecoder** ppDecoder )
{
	void* pFunc = ::GetProcAddress( m_hModule, "CreateSoundDecoder" );
	if( pFunc == NULL )
	{
		return False;
	}

	return static_cast<Plugin::CreateSoundDecoderFunc>( pFunc )( pReader, ppDecoder );
}

void Plugin::Unload( void )
{
	if ( m_hModule != NULL )
	{
		::FreeLibrary( m_hModule );
		m_hModule = NULL;
	}
}

}}
