#pragma once

#include <map>
#include <list>
#include <vector>

#include "Mix/Sound/IManager.h"
#include "Mix/Thread.h"
#include "Mix/Event.h"
#include "Mix/CriticalSection.h"

namespace Mix{
	class UserFile;
	namespace Plugin{
		namespace Sound{
			class IDecoder;
		}
	}
}

namespace Mix{ namespace Sound{

	class Plugin;
	class Listener;
	class StaticEmitter;
	class StreamEmitter;
	class Task;

	class Manager : public Mix::Sound::IManager
	{
	private:
		static const wchar_t* FAILED_INITIALIZE;
		static const wchar_t* FAILED_LOADPLUGIN;
		static const wchar_t* FAILED_CREATESTATIC;
		static const wchar_t* FAILED_CREATESTREAM;
		static const wchar_t* FAILED_CREATEEMITTER_STATIC;
		static const wchar_t* FAILED_CREATEEMITTER_STREAM;
		static const wchar_t* FAILED_CREATELISTENER;
		static const wchar_t* FAILED_CREATEDISTANCECURVE;
		static const wchar_t* SUCCESS_CREATEDISTANCECURVE;
		static const wchar_t* FAILED_CLONESTATIC;
		static const wchar_t* FAILED_CLONESTREAM;
		static const wchar_t* STR_STREAM;
		static const wchar_t* STR_STATIC_EMITTER;
		static const wchar_t* STR_STREAM_EMITTER;

		enum VALUE
		{
			MIN_CHANNELS = 2, //ŏ`l
			MIN_BITSPERSAMPLE = 16,	//ŏrbg
			MIN_SAMPLEPERSEC = 44100,	//ŏTv

			SLEEP_TIME = 1,	//Xg[~OXbh̃X[v
		};

		static const wchar_t* g_XAudio2ResultTextTable[5];

		typedef std::map<Mix::StringW, Mix::Sound::Plugin*> PluginMap;
		typedef std::list<Mix::Sound::Task*> TaskList;

	public:
		static Manager* CreateInstance( void );

	private:
		IXAudio2* m_pXAudio;
		IXAudio2MasteringVoice* m_pMasterVoice;
		XAUDIO2_DEVICE_DETAILS m_Details;

		X3DAUDIO_HANDLE m_hX3DAudio;

		Mix::File::IManager* m_pFileMgr;

		Mix::Thread m_Thread;
		Mix::Event m_EndEvent;

		std::vector<UInt8> m_KeyTemp;
		PluginMap m_PluginMap;
		TaskList m_TaskList;
		Mix::CriticalSection m_TaskListSync;

	private:
		Manager( void );
		virtual ~Manager( void );

		Mix::File::IReader* CreateReader( const wchar_t* pFileName, Boolean bBuffered );
		Mix::Plugin::Sound::IDecoder* CreateDecoder( const wchar_t* failedMsg, Mix::File::IReader* pReader );

		void AddTask( Mix::Sound::Task* pTask );

		const wchar_t* GetXA2ResultText( HRESULT ret );

		static void __cdecl ThreadEntry_Main( void* pArg );
		void ThreadMain( void );

	public:
		Boolean Start( Mix::UserFile* pSysReport );

		Boolean CreateStreamController( const wchar_t* actionMsg,
										Mix::File::IReader* pReader,
										Mix::Sound::IController** ppController );

		Boolean CreateStaticEmitter(	const wchar_t* actionMsg,
										const wchar_t* pFilePath,
										Mix::Sound::IListener* pListener,
										const WAVEFORMATEX* pFormat,
										Mix::Memory::IBuffer* pBuffer,
										const Mix::Vector3& localFront,
										const Mix::Vector3& localUp,
										Mix::Sound::IEmitter** ppEmitter );

		Boolean CreateStreamEmitter(	const wchar_t* actionMsg,
										Mix::Sound::IListener* pListener,
										Mix::File::IReader* pReader,
										const Mix::Vector3& localFront,
										const Mix::Vector3& localUp,
										Mix::Sound::IEmitter** ppEmitter );

		Boolean CreateDecoderAndVoice( Mix::File::IReader* pReader, IXAudio2VoiceCallback* pCallback, Mix::Plugin::Sound::IDecoder** ppDecoder, IXAudio2SourceVoice** ppVoice );

		Boolean CloneStaticController( const Mix::Sound::IController* pSrc, Mix::Sound::IController** ppDst );
		Boolean CloneStreamController( Mix::File::IReader* pSrcReader, Mix::Sound::IController** ppDst );
		Boolean CloneStaticEmitter( Mix::Sound::Listener* pListener, const wchar_t* pFileName, const WAVEFORMATEX* pFormat, Mix::Memory::IBuffer* pBuffer, const Mix::Vector3& forward, const Mix::Vector3& up, Mix::Sound::IEmitter** ppDst );
		Boolean CloneStreamEmitter( Mix::Sound::Listener* pListener, Mix::File::IReader* pSrcReader, const Mix::Vector3& forward, const Mix::Vector3& up, Mix::Sound::IEmitter** ppDst );

	public:
		virtual Boolean LoadPlugin( const wchar_t* pFilePath );

		virtual Boolean CreateStaticController( const wchar_t* pFilePath, Mix::Sound::IController** ppController );
		virtual Boolean CreateStaticController( Mix::File::IReader* pReader, Mix::Sound::IController** ppController );
		virtual Boolean CreateStreamController( const wchar_t* pFilePath, Boolean bBuffered, Mix::Sound::IController** ppController );
		virtual Boolean CreateStreamController( Mix::File::IReader* pReader, Mix::Sound::IController** ppController );

		virtual Boolean CreateListener( const Mix::Vector3& localFront, const Mix::Vector3& localUp, Mix::Sound::IListener** ppListener, const wchar_t* pDebugName = NULL );
		virtual Boolean CreateStaticEmitter( Mix::Sound::IListener* pListener, const wchar_t* pFilePath, const Mix::Vector3& forward, const Mix::Vector3& up, Mix::Sound::IEmitter** ppEmitter );
		virtual Boolean CreateStaticEmitter( Mix::Sound::IListener* pListener, Mix::File::IReader* pReader, const Mix::Vector3& forward, const Mix::Vector3& up, Mix::Sound::IEmitter** ppEmitter );
		virtual Boolean CreateStreamEmitter( Mix::Sound::IListener* pListener, const wchar_t* pFilePath, Boolean bBuffered, const Mix::Vector3& forward, const Mix::Vector3& up, Mix::Sound::IEmitter** ppEmitter );
		virtual Boolean CreateStreamEmitter( Mix::Sound::IListener* pListener, Mix::File::IReader* pReader, const Mix::Vector3& forward, const Mix::Vector3& up, Mix::Sound::IEmitter** ppEmitter );
	};

}}
