#include "Mix/Class/Sound/Manager.h"
#include "Mix/Class/Sound/Plugin.h"
#include "Mix/Class/Sound/StaticController.h"
#include "Mix/Class/Sound/StreamController.h"
#include "Mix/Class/Sound/StaticEmitter.h"
#include "Mix/Class/Sound/StreamEmitter.h"
#include "Mix/Class/Sound/Listener.h"
#include "Mix/Class/Sound/StreamControllerTaskMediator.h"
#include "Mix/Class/Sound/EmitterTaskMediator.h"
#include "Mix/Class/Sound/StreamControllerTask.h"
#include "Mix/Class/Sound/StaticEmitterTask.h"
#include "Mix/Class/Sound/StreamEmitterTask.h"
#include "Mix/File/IManager.h"
#include "Mix/File/IReader.h"
#include "Mix/Class/Memory/Buffer.h"
#include "Mix/Class/UserFile.h"

namespace Mix{ namespace Sound{

const wchar_t* Manager::FAILED_INITIALIZE           = L"TEh}l[W̏Ɏs";
const wchar_t* Manager::FAILED_LOADPLUGIN           = L"TEhvOC̃[hɎs";
const wchar_t* Manager::FAILED_CREATESTATIC         = L"X^eBbNTEhRg[[̍쐬Ɏs";
const wchar_t* Manager::FAILED_CREATESTREAM         = L"Xg[TEhRg[[̍쐬Ɏs";
const wchar_t* Manager::FAILED_CREATEEMITTER_STATIC = L"X^eBbTEhNG~b^[̍쐬Ɏs";
const wchar_t* Manager::FAILED_CREATEEMITTER_STREAM = L"Xg[TEhG~b^[̍쐬Ɏs";
const wchar_t* Manager::FAILED_CREATELISTENER       = L"TEhXi[̍쐬Ɏs";
const wchar_t* Manager::FAILED_CREATEDISTANCECURVE  = L"fBX^XJ[u̍쐬Ɏs";
const wchar_t* Manager::SUCCESS_CREATEDISTANCECURVE = L"fBX^XJ[u쐬";
const wchar_t* Manager::FAILED_CLONESTATIC          = L"X^eBbNTEhRg[[̕Ɏs";
const wchar_t* Manager::FAILED_CLONESTREAM          = L"Xg[TEhRg[[̕Ɏs";
const wchar_t* Manager::STR_STREAM                  = L"Xg[TEhRg[[";
const wchar_t* Manager::STR_STATIC_EMITTER          = L"X^eBbNTEhG~b^[";
const wchar_t* Manager::STR_STREAM_EMITTER          = L"Xg[TEhG~b^[";

const wchar_t* Manager::g_XAudio2ResultTextTable[5] =
{
	L"ȃp[^p[^n܂",
	L"XMA n[hEFAɉ񕜕s\ȃG[܂",
	L"GtFNgCX^Xł܂ł",
	L"TEhfoCXAؒfꂽ̉炩̃CxgɂAgpłȂԂɂȂ܂",
	L"sȃG[",
};

Manager* Manager::CreateInstance( void )
{
	return new Manager();
}

Manager::Manager( void ) :
m_pFileMgr( NULL ),
m_EndEvent( True, False )
{
	Mix::File::IManager* pFileMgr = Mix::File::GetManagerPtr();

	MIX_ASSERT( pFileMgr != NULL );

	MIX_ADD_REF( pFileMgr );
	m_pFileMgr = pFileMgr;
}

Manager::~Manager( void )
{
	//XbhI
	m_EndEvent.Set();
	m_Thread.Join();

	//}X^[{CX̉
	if( m_pMasterVoice != NULL )
	{
		m_pMasterVoice->DestroyVoice();
	}

	//XAudio
	MIX_RELEASE( m_pXAudio );

	//vOC
	for( Manager::PluginMap::iterator it = m_PluginMap.begin(); it != m_PluginMap.end(); ++it )
	{
		MIX_DELETE( it->second );
	}

	//t@C}l[W
	MIX_RELEASE( m_pFileMgr );
}

Boolean Manager::Start( Mix::UserFile* pSysReport )
{
	HRESULT ret;
	UInt32 flags;
	UINT32 deviceCount;

	////////////////////////////////////////////////////////////////////////////////////////////////////
	// XAudio2 ̏
	////////////////////////////////////////////////////////////////////////////////////////////////////

#ifdef _DEBUG
	flags = XAUDIO2_DEBUG_ENGINE;
#else //_DEBUG
	flags = 0;
#endif //_DEBUG

	ret = ::XAudio2Create( &m_pXAudio, flags, XAUDIO2_DEFAULT_PROCESSOR );
	if( ret != S_OK )
	{
		MIX_LOG_ERROR( L"%s : XAudio2Create %s : Result[%s]", FAILED_INITIALIZE, Mix::STR_RETERROR, GetXA2ResultText( ret ) );
		return False;
	}

	ret = m_pXAudio->GetDeviceCount( &deviceCount );
	if( ret != S_OK )
	{
		MIX_LOG_ERROR( L"%s : IXAudio2::GetDeviceCount %s : Result[%s]", FAILED_INITIALIZE, Mix::STR_RETERROR, GetXA2ResultText( ret ) );
		MIX_RELEASE( m_pXAudio );
		return False;
	}

	ret = m_pXAudio->GetDeviceDetails( 0, &m_Details );
	if( ret != S_OK )
	{
		MIX_LOG_ERROR( L"%s : IXAudio2::GetDeviceDetails %s : Result[%s]", FAILED_INITIALIZE, Mix::STR_RETERROR, GetXA2ResultText( ret ) );
		MIX_RELEASE( m_pXAudio );
		return False;
	}

	//foCX|[g
	if( pSysReport->Open() == True )
	{
		//^Cg
		pSysReport->WriteLine( L"////////////////////////////////////////////////////////////////////////////////////////////////////" );
		pSysReport->WriteLine( L"// TEh                                                                                       //" );
		pSysReport->WriteLine( L"////////////////////////////////////////////////////////////////////////////////////////////////////" );
		pSysReport->WriteLine( L"" );

		//foCX
		pSysReport->WriteLine( L"[foCX]" );
		pSysReport->WriteLine( L"ʎq : \"%s\"", m_Details.DeviceID );
		pSysReport->WriteLine( L"\ : \"%s\"", m_Details.DisplayName );
		pSysReport->WriteLine( L"" );

		pSysReport->WriteLine( L"[tH[}bg]" );
		pSysReport->WriteLine( L"`l : %d", m_Details.OutputFormat.Format.nChannels );
		pSysReport->WriteLine( L"TvO[g : %fkHz", static_cast<Float32>( m_Details.OutputFormat.Format.nSamplesPerSec ) / 1000.0f );
		pSysReport->WriteLine( L"σf[^]x : %fKB", static_cast<Float32>( m_Details.OutputFormat.Format.nAvgBytesPerSec ) / 1000.0f );
		pSysReport->WriteLine( L"ubÑACg : %dByte", m_Details.OutputFormat.Format.nBlockAlign );
		pSysReport->WriteLine( L"1TvÕrbg : %dBit", m_Details.OutputFormat.Format.wBitsPerSample );
		pSysReport->WriteLine( L"" );

		pSysReport->Close();
	}

	ret = m_pXAudio->CreateMasteringVoice( &m_pMasterVoice, XAUDIO2_DEFAULT_CHANNELS, XAUDIO2_DEFAULT_SAMPLERATE, 0, 0, NULL );
	if( ret != S_OK )
	{
		MIX_LOG_ERROR( L"%s : IXAudio2::CreateMasteringVoice %s : Result[%s]", FAILED_INITIALIZE, Mix::STR_RETERROR, GetXA2ResultText( ret ) );
		MIX_RELEASE( m_pXAudio );
		return False;
	}

	////////////////////////////////////////////////////////////////////////////////////////////////////
	// X3DAudio ̏
	////////////////////////////////////////////////////////////////////////////////////////////////////

	::X3DAudioInitialize( m_Details.OutputFormat.dwChannelMask, X3DAUDIO_SPEED_OF_SOUND, m_hX3DAudio );

	////////////////////////////////////////////////////////////////////////////////////////////////////
	// Xg[Xbh̊Jn
	////////////////////////////////////////////////////////////////////////////////////////////////////

	if( m_Thread.Start( Manager::ThreadEntry_Main, this ) == False )
	{
		MIX_LOG_ERROR( L"%s : XbhJnł܂ł", FAILED_INITIALIZE );
		MIX_RELEASE( m_pXAudio );
		return False;
	}

	return True;
}

Boolean Manager::LoadPlugin( const wchar_t* pFilePath )
{
	if( ( pFilePath == NULL ) ||
		( ::wcslen( pFilePath ) == 0 ) )
	{
		MIX_LOG_ERROR( L"%s : %s : pFilePath[%s]", FAILED_LOADPLUGIN, Mix::STR_ILLEGALARG, MIX_LOG_STR( pFilePath ) );
		return False;
	}

	Mix::StringW filePath;

	if( m_pFileMgr->GetAbsolutePath( pFilePath, False, filePath ) == False )
	{
		MIX_LOG_ERROR( L"%s : t@Cł܂ : File[%s]", FAILED_LOADPLUGIN, pFilePath );
		return False;
	}

	if( m_PluginMap.find( filePath.GetConstPtr() ) != m_PluginMap.end() )
	{
		MIX_LOG_ERROR( L"%s : łɃ[hĂ܂ : File[%s]", FAILED_LOADPLUGIN, pFilePath );
		return False;
	}

	Mix::Sound::Plugin* pPlugin = new Mix::Sound::Plugin();
	if( pPlugin == NULL )
	{
		MIX_LOG_ERROR( L"%s : %s : File[%s]", FAILED_LOADPLUGIN, Mix::STR_OUTOFMEMORY, pFilePath );
		return False;
	}

	if( pPlugin->Load( filePath.GetConstPtr() ) == True )
	{
		m_PluginMap[filePath] = pPlugin;
	}
	else
	{
		MIX_LOG_ERROR( L"%s : sȃvOC : File[%s]", FAILED_LOADPLUGIN, pFilePath );
		MIX_DELETE( pPlugin );
		return False;
	}

	MIX_LOG_INFO( L"TEhvOC[h : File[%s] Name[%s] Version[%s]", pFilePath, pPlugin->GetDecoderName(), pPlugin->GetDecoderVersion() );

	return True;
}

Boolean Manager::CreateStaticController( const wchar_t* pFilePath, Mix::Sound::IController** ppController )
{
	if( ( pFilePath == NULL ) ||
		( ::wcslen( pFilePath ) == 0 ) ||
		( ppController == NULL ) )
	{
		MIX_LOG_ERROR( L"%s : %s : pFilePath[%s] ppController[%s]",
			FAILED_CREATESTATIC,
			Mix::STR_ILLEGALARG,
			MIX_LOG_STR( pFilePath ),
			MIX_LOG_PTR( ppController ) );

		return False;
	}

	Mix::File::IReader* pReader = NULL;

	if( m_pFileMgr->CreateFileReader( pFilePath, &pReader ) == False )
	{
		return False;
	}

	if( CreateStaticController( pReader, ppController ) == False )
	{
		MIX_RELEASE( pReader );
		return False;
	}

	MIX_RELEASE( pReader );

	return True;
}

Boolean Manager::CreateStaticController( Mix::File::IReader* pReader, Mix::Sound::IController** ppController )
{
	if( ( pReader == NULL ) ||
		( ppController == NULL ) )
	{
		MIX_LOG_ERROR( L"%s : %s : pReader[%s] ppController[%s]",
			FAILED_CREATESTATIC,
			Mix::STR_ILLEGALARG,
			MIX_LOG_PTR( pReader ),
			MIX_LOG_PTR( ppController ) );

		return False;
	}

	HRESULT ret;
	Mix::Sound::StaticController* pController;
	Mix::Plugin::Sound::IDecoder* pDecoder;
	Mix::Memory::Buffer* pBuffer;
	IXAudio2SourceVoice* pVoice;
	UInt32 waveSize;

	pDecoder = CreateDecoder( FAILED_CREATESTATIC, pReader );
	if( pDecoder == NULL )
	{
		return False;
	}

	waveSize = static_cast<UInt32>( pDecoder->GetSize() );

	pBuffer = Mix::Memory::Buffer::CreateInstance();
	if( pBuffer == NULL )
	{
		MIX_RELEASE( pDecoder );
		MIX_LOG_ERROR( L"%s : %s : File[%s]", FAILED_CREATESTATIC, Mix::STR_OUTOFMEMORY, pReader->GetFilePath() );
		return False;
	}

	if( pBuffer->Create( waveSize ) == False )
	{
		MIX_RELEASE( pBuffer );
		MIX_RELEASE( pDecoder );
		MIX_LOG_ERROR( L"%s : %s : File[%s]", FAILED_CREATESTATIC, Mix::STR_OUTOFMEMORY, pReader->GetFilePath() );
		return False;
	}

	if( pDecoder->Read( pBuffer->GetPointer(), waveSize ) != waveSize )
	{
		MIX_RELEASE( pBuffer );
		MIX_RELEASE( pDecoder );
		MIX_LOG_ERROR( L"%s : fR[hɃG[ : File[%s]", FAILED_CREATESTATIC, pReader->GetFilePath() );
		return False;
	}

	ret = m_pXAudio->CreateSourceVoice( &pVoice, pDecoder->GetFormat(), 0, XAUDIO2_DEFAULT_FREQ_RATIO, NULL, NULL, NULL );
	if( ret != S_OK )
	{
		MIX_RELEASE( pBuffer );
		MIX_RELEASE( pDecoder );
		MIX_LOG_ERROR( L"%s : CreateSourceVoice %s : File[%s] Result[%s]", FAILED_CREATESTATIC, Mix::STR_RETERROR, pReader->GetFilePath(), GetXA2ResultText( ret ) );
		return False;
	}

	pController = Mix::Sound::StaticController::CreateInstance( this, pReader->GetFilePath(), pDecoder->GetFormat(), pVoice, pBuffer );
	if( pController == NULL )
	{
		MIX_LOG_ERROR( L"%s : %s", FAILED_CREATESTATIC, Mix::STR_OUTOFMEMORY );
		return False;
	}

	MIX_RELEASE( pDecoder );

	( *ppController ) = pController;

	MIX_LOG_INFO( L"X^eBbNRg[[쐬 : File[%s]", pReader->GetFilePath() );

	return True;
}

Boolean Manager::CreateStreamController( const wchar_t* pFilePath, Boolean bBuffered, Mix::Sound::IController** ppController )
{
	if( ( pFilePath == NULL ) ||
		( ppController == NULL ) )
	{
		MIX_LOG_ERROR( L"%s : %s : pFilePath[%s] ppController[%s]",
			FAILED_CREATESTREAM,
			Mix::STR_ILLEGALARG,
			MIX_LOG_STR( pFilePath ),
			MIX_LOG_PTR( ppController ) );

		return False;
	}

	Mix::File::IReader* pReader = NULL;

	pReader = CreateReader( pFilePath, bBuffered );
	if( pReader == NULL )
	{
		return False;
	}

	if( CreateStreamController( L"쐬", pReader, ppController ) == False )
	{
		MIX_RELEASE( pReader );
		return False;
	}

	MIX_RELEASE( pReader );

	return True;
}

Boolean Manager::CreateStreamController( Mix::File::IReader* pReader, Mix::Sound::IController** ppController )
{
	if( ( pReader == NULL ) ||
		( ppController == NULL ) )
	{
		MIX_LOG_ERROR( L"%s : %s : pReader[%s] ppController[%s]",
			FAILED_CREATESTREAM,
			Mix::STR_ILLEGALARG,
			MIX_LOG_PTR( pReader ),
			MIX_LOG_PTR( ppController ) );

		return False;
	}

	return CreateStreamController( L"쐬", pReader, ppController );
}

Boolean Manager::CreateListener( const Mix::Vector3& localFront, const Mix::Vector3& localUp, Mix::Sound::IListener** ppListener, const wchar_t* pDebugName )
{
	Mix::String safeDebugName = MIX_SAFE_NAME( pDebugName );

	if( ppListener == NULL )
	{
		MIX_LOG_ERROR( L"%s : %s : DebugName[%s] : pListener[%s]",
			FAILED_CREATELISTENER,
			Mix::STR_ILLEGALARG,
			safeDebugName.GetConstPtr(),
			MIX_LOG_PTR( ppListener ) );

		return False;
	}

	Mix::Sound::Listener* pListener = Mix::Sound::Listener::CreateInstance( localFront, localUp );
	if( pListener == NULL )
	{
		MIX_LOG_ERROR( L"%s : %s : DebugName[%s]",
			FAILED_CREATELISTENER,
			Mix::STR_OUTOFMEMORY,
			safeDebugName.GetConstPtr() );

		return False;
	}

	( *ppListener ) = pListener;

	MIX_LOG_INFO( L"TEhXi[쐬 : LocalFront( %f, %f, %f ) LocalUp( %f, %f, %f )",
		localFront.x, localFront.y, localFront.z,
		localUp.x, localUp.y, localUp.z );

	return True;
}

Boolean Manager::CreateStaticEmitter( Mix::Sound::IListener* pListener, const wchar_t* pFilePath, const Mix::Vector3& localFront, const Mix::Vector3& localUp, Mix::Sound::IEmitter** ppEmitter )
{
	if( ( pListener == NULL ) ||
		( pFilePath == NULL ) ||
		( ::wcslen( pFilePath ) == 0 ) ||
		( ppEmitter == NULL ) )
	{
		MIX_LOG_ERROR( L"%s : %s : pFileName[%s] ppEmitter[%s]",
			FAILED_CREATEEMITTER_STATIC,
			Mix::STR_ILLEGALARG,
			MIX_LOG_PTR( pListener ),
			MIX_LOG_STR( pFilePath ),
			MIX_LOG_PTR( ppEmitter ) );

		return False;
	}

	Mix::File::IReader* pReader;

	if( m_pFileMgr->CreateFileReader( pFilePath, &pReader ) == False )
	{
		return False;
	}

	if( CreateStaticEmitter( pListener, pReader, localFront, localUp, ppEmitter ) == False )
	{
		MIX_RELEASE( pReader );
		return False;
	}

	MIX_RELEASE( pReader );

	return True;
}

Boolean Manager::CreateStaticEmitter( Mix::Sound::IListener* pListener, Mix::File::IReader* pReader, const Mix::Vector3& localFront, const Mix::Vector3& localUp, Mix::Sound::IEmitter** ppEmitter )
{
	if( ( pListener == NULL ) ||
		( pReader == NULL ) ||
		( ppEmitter == NULL ) )
	{
		MIX_LOG_ERROR( L"%s : %s : pListener[%s] pReader[%s] ppEmitter[%s]",
			FAILED_CREATEEMITTER_STATIC,
			Mix::STR_ILLEGALARG,
			MIX_LOG_PTR( pListener ),
			MIX_LOG_PTR( pReader ),
			MIX_LOG_PTR( ppEmitter ) );

		return False;
	}

	UInt32 waveSize;
	Mix::Plugin::Sound::IDecoder* pDecoder;
	Mix::Memory::Buffer* pBuffer;

	pDecoder = CreateDecoder( FAILED_CREATEEMITTER_STATIC, pReader );
	if( pDecoder == NULL )
	{
		return False;
	}

	waveSize = static_cast<UInt32>( pDecoder->GetSize() );

	pBuffer = Mix::Memory::Buffer::CreateInstance();
	if( pBuffer == NULL )
	{
		MIX_LOG_ERROR( L"%s : %s : File[%s]", FAILED_CREATEEMITTER_STATIC, Mix::STR_OUTOFMEMORY, pReader->GetFilePath() );
		MIX_RELEASE( pDecoder );
		return False;
	}

	if( pBuffer->Create( waveSize ) == False )
	{
		MIX_LOG_ERROR( L"%s : %s : File[%s]", FAILED_CREATEEMITTER_STATIC, Mix::STR_OUTOFMEMORY, pReader->GetFilePath() );
		MIX_RELEASE( pBuffer );
		MIX_RELEASE( pDecoder );
		return False;
	}

	if( pDecoder->Read( pBuffer->GetPointer(), waveSize ) != waveSize )
	{
		MIX_LOG_ERROR( L"%s : fR[hɃG[ : File[%s]", FAILED_CREATEEMITTER_STATIC, pReader->GetFilePath() );
		MIX_RELEASE( pBuffer );
		MIX_RELEASE( pDecoder );
		return False;
	}

	if( CreateStaticEmitter( L"쐬", pReader->GetFilePath(), pListener, pDecoder->GetFormat(), pBuffer, localFront, localUp, ppEmitter ) == False )
	{
		MIX_RELEASE( pBuffer );
		MIX_RELEASE( pDecoder );
		return False;
	}

	MIX_RELEASE( pBuffer );
	MIX_RELEASE( pDecoder );

	MIX_LOG_INFO( L"X^eBbNTEhG~b^[쐬 : File[%s]", pReader->GetFilePath() );

	return True;
}

Boolean Manager::CreateStreamEmitter( Mix::Sound::IListener* pListener, const wchar_t* pFilePath, Boolean bBuffered, const Mix::Vector3& localFront, const Mix::Vector3& localUp, Mix::Sound::IEmitter** ppEmitter )
{
	if( ( pListener == NULL ) ||
		( pFilePath == NULL ) ||
		( ppEmitter == NULL ) )
	{
		MIX_LOG_ERROR( L"%s : %s : pFilePath[%s] ppEmitter[%s]",
			FAILED_CREATEEMITTER_STREAM,
			Mix::STR_ILLEGALARG,
			MIX_LOG_PTR( pListener ),
			MIX_LOG_STR( pFilePath ),
			MIX_LOG_PTR( ppEmitter ) );

		return False;
	}

	Mix::File::IReader* pReader;

	pReader = CreateReader( pFilePath, bBuffered );
	if( pReader == NULL )
	{
		return False;
	}

	if( CreateStreamEmitter( L"쐬", pListener, pReader, localFront, localUp, ppEmitter ) == False )
	{
		MIX_RELEASE( pReader );
		return False;
	}

	MIX_RELEASE( pReader );

	return True;
}

Boolean Manager::CreateStreamEmitter( Mix::Sound::IListener* pListener, Mix::File::IReader* pReader, const Mix::Vector3& localFront, const Mix::Vector3& localUp, Mix::Sound::IEmitter** ppEmitter )
{
	if( ( pListener == NULL ) ||
		( pReader == NULL ) ||
		( ppEmitter == NULL ) )
	{
		MIX_LOG_ERROR( L"%s : %s : pReader[%s] ppEmitter[%s]",
			FAILED_CREATEEMITTER_STREAM,
			Mix::STR_ILLEGALARG,
			MIX_LOG_PTR( pListener ),
			MIX_LOG_PTR( pReader ),
			MIX_LOG_PTR( ppEmitter ) );

		return False;
	}

	return CreateStreamEmitter( L"쐬", pListener, pReader, localFront, localUp, ppEmitter );
}

Mix::File::IReader* Manager::CreateReader( const wchar_t* pFilePath, Boolean bBuffered )
{
	Mix::File::IReader* pReader;

	if( bBuffered == False )
	{
		if( m_pFileMgr->CreateFileReader( pFilePath, &pReader ) == False )
		{
			return NULL;
		}
	}
	else
	{
		if( m_pFileMgr->CreateBufferedReader( pFilePath, &pReader ) == False )
		{
			return NULL;
		}
	}

	return pReader;
}

Mix::Plugin::Sound::IDecoder* Manager::CreateDecoder( const wchar_t* failedMsg, Mix::File::IReader* pReader )
{
	PluginMap::iterator it_plugin_begin = m_PluginMap.begin();
	PluginMap::iterator it_plugin_end = m_PluginMap.end();
	PluginMap::iterator it_plugin;

	Mix::Plugin::Sound::IDecoder* pDecoder = NULL;
	UInt32 preKeySize = 0;

	//fR[_쐬
	for( it_plugin = it_plugin_begin; ( ( it_plugin != it_plugin_end ) && ( pDecoder == NULL ) ); ++it_plugin )
	{
		Mix::Sound::Plugin* pPlugin = it_plugin->second;
		UInt32 keySize = pPlugin->GetKeySize();

		MIX_ASSERT( keySize > 0 );

		if( preKeySize < keySize )
		{
			m_KeyTemp.resize( keySize );

			pReader->Read( &( m_KeyTemp[0] ), keySize );
			pReader->Seek( Mix::File::SEEK_METHOD_BEGIN, 0 );

			preKeySize = keySize;
		}

		if( pPlugin->CheckFormat( &( m_KeyTemp[0] ), keySize ) == True )
		{
			if( pPlugin->CreateDecoder( pReader, &pDecoder ) == False )
			{
				pDecoder = NULL;
			}
		}
	}

	if( pDecoder == NULL )
	{
		MIX_LOG_ERROR( L"%s : w肳ꂽt@CT|[gfR[_܂ : File[%s]", failedMsg, pReader->GetFilePath() );
	}

	return pDecoder;
}

void Manager::AddTask( Mix::Sound::Task* pTask )
{
	m_TaskListSync.Enter();
	m_TaskList.push_back( pTask );
	m_TaskListSync.Leave();
}

const wchar_t* Manager::GetXA2ResultText( HRESULT ret )
{
	switch( ret )
	{
	case XAUDIO2_E_INVALID_CALL:
		return g_XAudio2ResultTextTable[0];
	case XAUDIO2_E_XMA_DECODER_ERROR:
		return g_XAudio2ResultTextTable[1];
	case XAUDIO2_E_XAPO_CREATION_FAILED:
		return g_XAudio2ResultTextTable[2];
	case XAUDIO2_E_DEVICE_INVALIDATED:
		return g_XAudio2ResultTextTable[3];
	}

	return g_XAudio2ResultTextTable[4];
}

Boolean Manager::CreateStreamController( const wchar_t* actionMsg, Mix::File::IReader* pReader, Mix::Sound::IController** ppController )
{
	if( ( pReader == NULL ) ||
		( ppController == NULL ) )
	{
		MIX_LOG_ERROR( L"%s%sɎs : %s : pReader[%s] ppController[%s]",
			STR_STREAM,
			Mix::STR_ILLEGALARG,
			actionMsg,
			( pReader != NULL )? L"" : L"NULL",
			( ppController != NULL )? L"" : L"~"
			);

		return False;
	}

	HRESULT ret;
	Mix::Sound::StreamControllerTask* pTask;
	Mix::Sound::StreamControllerTaskMediator* pTaskMediator;
	Mix::Sound::StreamController* pController;
	Mix::Plugin::Sound::IDecoder* pDecoder;
	IXAudio2SourceVoice* pVoice;

	//^XNfBG[^[쐬
	pTaskMediator = Mix::Sound::StreamControllerTaskMediator::CreateInstance();
	if( pTaskMediator == NULL )
	{
		MIX_LOG_ERROR( L"%s%sɎs : %s : File[%s]", STR_STREAM, actionMsg, Mix::STR_OUTOFMEMORY, pReader->GetFilePath() );
		return False;
	}

	//^XN쐬
	pTask = new Mix::Sound::StreamControllerTask( pTaskMediator );
	if( pTask == NULL )
	{
		MIX_LOG_ERROR( L"%s%sɎs : %s : File[%s]", STR_STREAM, actionMsg, Mix::STR_OUTOFMEMORY, pReader->GetFilePath() );
		MIX_RELEASE( pTaskMediator );
		return False;
	}

	//fR[_[쐬
	pDecoder = CreateDecoder( FAILED_CREATESTREAM, pReader );
	if( pDecoder != NULL )
	{
		pTask->SetDecoder( pDecoder );
	}
	else
	{
		MIX_RELEASE( pTaskMediator );
		MIX_DELETE( pTask );
		return False;
	}

	//{CX쐬
	ret = m_pXAudio->CreateSourceVoice( &pVoice, pDecoder->GetFormat(), 0, XAUDIO2_DEFAULT_FREQ_RATIO, pTask->GetVoiceCallbackPtr(), NULL, NULL );
	if( ret == S_OK )
	{
		pTask->SetVoice( pVoice );
	}
	else
	{
		MIX_LOG_ERROR( L"%s : IXAudio2::CreateSourceVoice %s : Result[%s]", FAILED_CREATESTREAM, Mix::STR_RETERROR, GetXA2ResultText( ret ) );
		MIX_RELEASE( pTaskMediator );
		MIX_DELETE( pTask );
		return False;
	}

	//^XN
	if( pTask->Initialize() == False )
	{
		MIX_LOG_ERROR( L"%s%sɎs : %s : File[%s]", STR_STREAM, actionMsg, Mix::STR_OUTOFMEMORY, pReader->GetFilePath() );
		MIX_RELEASE( pTaskMediator );
		MIX_DELETE( pTask );
		return False;
	}

	//C^[tF[X쐬
	pController = Mix::Sound::StreamController::CreateInstance( this, pReader, pTaskMediator );
	if( pController == NULL )
	{
		MIX_LOG_ERROR( L"%s%sɎs : %s : File[%s]", STR_STREAM, actionMsg, Mix::STR_OUTOFMEMORY, pReader->GetFilePath() );
		MIX_RELEASE( pTaskMediator );
		MIX_DELETE( pTask );
		return False;
	}

	MIX_RELEASE( pTaskMediator );

	AddTask( pTask );

	( *ppController ) = pController;

	MIX_LOG_INFO( L"Xg[TEhRg[[%s : File[%s] Buffered[%s]", actionMsg, pReader->GetFilePath(), ( pReader->IsBuffered() == True )? L"" : L"~" );

	return True;
}

Boolean Manager::CreateStaticEmitter(	const wchar_t* pActionMsg,
										const wchar_t* pFilePath,
										Mix::Sound::IListener* pListener,
										const WAVEFORMATEX* pFormat,
										Mix::Memory::IBuffer* pBuffer,
										const Mix::Vector3& localFront,
										const Mix::Vector3& localUp,
										Mix::Sound::IEmitter** ppEmitter )
{
	HRESULT ret;
	Mix::Sound::EmitterTaskMediator* pTaskMediator;
	Mix::Sound::StaticEmitterTask* pTask;
	Mix::Sound::StaticEmitter* pEmitter;
	IXAudio2SourceVoice* pVoice;

	ret = m_pXAudio->CreateSourceVoice( &pVoice, pFormat, 0, XAUDIO2_DEFAULT_FREQ_RATIO, NULL, NULL, NULL );
	if( ret != S_OK )
	{
		MIX_LOG_ERROR( L"%s%s : CreateSourceVoice %s : File[%s] Result[%s]", STR_STATIC_EMITTER, pActionMsg, Mix::STR_RETERROR, pFilePath, GetXA2ResultText( ret ) );
		return False;
	}

	pTaskMediator = Mix::Sound::EmitterTaskMediator::CreateInstance( m_hX3DAudio, m_Details.OutputFormat.Format.nChannels, pFormat->nChannels );
	if( pTaskMediator == NULL )
	{
		MIX_LOG_ERROR( L"%s%s : %s : File[%s]", STR_STATIC_EMITTER, pActionMsg, Mix::STR_OUTOFMEMORY, pFilePath );
		pVoice->DestroyVoice();
		return False;
	}

	pTask = new Mix::Sound::StaticEmitterTask( pTaskMediator, pBuffer, pVoice );
	if( pTask == NULL )
	{
		MIX_LOG_ERROR( L"%s%s : %s : File[%s]", STR_STATIC_EMITTER, pActionMsg, Mix::STR_OUTOFMEMORY, pFilePath );
		MIX_RELEASE( pTaskMediator );
		pVoice->DestroyVoice();
		return False;
	}

	pEmitter = Mix::Sound::StaticEmitter::CreateInstance(	static_cast<Mix::Sound::Listener*>( pListener ),
															pTaskMediator,
															pFormat,
															pBuffer,
															localFront,
															localUp,
															m_Details.OutputFormat.Format.nChannels,
															pFilePath );
	if( pEmitter == NULL )
	{
		MIX_LOG_ERROR( L"%s%s : %s : File[%s]", STR_STATIC_EMITTER, pActionMsg, Mix::STR_OUTOFMEMORY, pFilePath );
		MIX_DELETE( pTask );
		MIX_RELEASE( pTaskMediator );
		pVoice->DestroyVoice();
		return False;
	}

	MIX_RELEASE( pTaskMediator );

	AddTask( pTask );

	( *ppEmitter ) = pEmitter;

	return True;
}

Boolean Manager::CreateStreamEmitter(	const wchar_t* actionMsg,
										Mix::Sound::IListener* pListener,
										Mix::File::IReader* pReader,
										const Mix::Vector3& localFront,
										const Mix::Vector3& localUp,
										Mix::Sound::IEmitter** ppEmitter )
{
	if( ( pReader == NULL ) ||
		( ppEmitter == NULL ) )
	{
		MIX_LOG_ERROR( L"%s%sɎs : %s : pReader[%s] ppEmitter[%s]",
			STR_STREAM_EMITTER,
			Mix::STR_ILLEGALARG,
			actionMsg,
			( pReader != NULL )? L"" : L"NULL",
			( ppEmitter != NULL )? L"" : L"~"
			);

		return False;
	}

	HRESULT ret;
	Mix::Sound::StreamEmitterTask* pTask;
	Mix::Sound::EmitterTaskMediator* pTaskMediator;
	Mix::Sound::StreamEmitter* pEmitter;
	Mix::Plugin::Sound::IDecoder* pDecoder;
	IXAudio2SourceVoice* pVoice;

	//fR[_[쐬
	pDecoder = CreateDecoder( FAILED_CREATEEMITTER_STREAM, pReader );
	if( pDecoder == NULL )
	{
		return False;
	}

	//^XNfBG[^[쐬
	pTaskMediator = Mix::Sound::EmitterTaskMediator::CreateInstance( m_hX3DAudio, m_Details.OutputFormat.Format.nChannels, pDecoder->GetFormat()->nChannels );
	if( pTaskMediator == NULL )
	{
		MIX_LOG_ERROR( L"%s%sɎs : %s : File[%s]", STR_STREAM_EMITTER, actionMsg, Mix::STR_OUTOFMEMORY, pReader->GetFilePath() );
		MIX_RELEASE( pDecoder );
		return False;
	}

	//^XN쐬
	pTask = new Mix::Sound::StreamEmitterTask( pTaskMediator );
	if( pTask == NULL )
	{
		MIX_LOG_ERROR( L"%s%sɎs : %s : File[%s]", STR_STREAM_EMITTER, actionMsg, Mix::STR_OUTOFMEMORY, pReader->GetFilePath() );
		MIX_RELEASE( pTaskMediator );
		MIX_RELEASE( pDecoder );
		return False;
	}

	//fR[_ݒ
	pTask->SetDecoder( pDecoder );

	//{CX쐬
	ret = m_pXAudio->CreateSourceVoice(	&pVoice,
										pDecoder->GetFormat(),
										0,
										XAUDIO2_DEFAULT_FREQ_RATIO,
										pTask->GetVoiceCallbackPtr(),
										NULL,
										NULL );
	if( ret == S_OK )
	{
		pTask->SetVoice( pVoice );
	}
	else
	{
		MIX_LOG_ERROR( L"%s : IXAudio2::CreateSourceVoice %s : Result[%s]", FAILED_CREATEEMITTER_STREAM, Mix::STR_RETERROR, GetXA2ResultText( ret ) );
		MIX_RELEASE( pTaskMediator );
		MIX_DELETE( pTask );
		return False;
	}

	//^XN
	if( pTask->Initialize() == False )
	{
		MIX_LOG_ERROR( L"%s%sɎs : %s : File[%s]", STR_STREAM_EMITTER, actionMsg, Mix::STR_OUTOFMEMORY, pReader->GetFilePath() );
		MIX_RELEASE( pTaskMediator );
		MIX_DELETE( pTask );
		return False;
	}

	//C^[tF[X쐬
	pEmitter = Mix::Sound::StreamEmitter::CreateInstance(	static_cast<Mix::Sound::Listener*>( pListener ),
															pReader,
															pTaskMediator,
															localFront,
															localUp,
															pDecoder->GetFormat()->nChannels,
															m_Details.OutputFormat.Format.nChannels );
	if( pEmitter == NULL )
	{
		MIX_LOG_ERROR( L"%s%sɎs : %s : File[%s]", STR_STREAM_EMITTER, actionMsg, Mix::STR_OUTOFMEMORY, pReader->GetFilePath() );
		MIX_RELEASE( pTaskMediator );
		MIX_DELETE( pTask );
		return False;
	}

	MIX_RELEASE( pTaskMediator );

	AddTask( pTask );

	( *ppEmitter ) = pEmitter;

	MIX_LOG_INFO( L"Xg[TEhG~b^[%s : File[%s] Buffered[%s]", actionMsg, pReader->GetFilePath(), ( pReader->IsBuffered() == True )? L"" : L"~" );

	return True;
}

Boolean Manager::CreateDecoderAndVoice( Mix::File::IReader* pReader, IXAudio2VoiceCallback* pCallback, Mix::Plugin::Sound::IDecoder** ppDecoder, IXAudio2SourceVoice** ppVoice )
{
	HRESULT ret;
	Mix::Plugin::Sound::IDecoder* pDecoder;
	IXAudio2SourceVoice* pVoice;

	pDecoder = CreateDecoder( FAILED_CREATESTREAM, pReader );
	if( pDecoder == NULL )
	{
		return False;
	}

	ret = m_pXAudio->CreateSourceVoice( &pVoice, pDecoder->GetFormat(), 0, XAUDIO2_DEFAULT_FREQ_RATIO, pCallback, NULL, NULL );
	if( ret != S_OK )
	{
		MIX_RELEASE( pDecoder );
		MIX_LOG_ERROR( L"%s : IXAudio2::CreateSourceVoice %s : Result[%s]", FAILED_CREATESTREAM, Mix::STR_RETERROR, GetXA2ResultText( ret ) );
		return False;
	}

	( *ppDecoder ) = pDecoder;
	( *ppVoice ) = pVoice;

	return True;
}

Boolean Manager::CloneStaticController( const Mix::Sound::IController* pSrc, Mix::Sound::IController** ppDst )
{
	HRESULT ret;
	const Mix::Sound::StaticController* pSrcCtrl;
	Mix::Sound::StaticController* pDstCtrl;
	IXAudio2SourceVoice* pVoice;

	pSrcCtrl = dynamic_cast<const Mix::Sound::StaticController*>( pSrc );

	ret = m_pXAudio->CreateSourceVoice( &pVoice, pSrcCtrl->GetFormat(), 0, XAUDIO2_DEFAULT_FREQ_RATIO, NULL, NULL, NULL );
	if( ret != S_OK )
	{
		MIX_LOG_ERROR( L"%s : CreateSourceVoice %s : File[%s] Result[%s]", FAILED_CLONESTATIC, Mix::STR_RETERROR, pSrcCtrl->GetFilePath(), GetXA2ResultText( ret ) );
		return False;
	}

	pDstCtrl = Mix::Sound::StaticController::CreateInstance( pSrcCtrl, pVoice );
	if( pDstCtrl == NULL )
	{
		pVoice->DestroyVoice();
		MIX_LOG_ERROR( L"%s : %s : File[%s]", FAILED_CLONESTATIC, Mix::STR_OUTOFMEMORY, pSrcCtrl->GetFilePath() );
		return False;
	}

	( *ppDst ) = pDstCtrl;

	MIX_LOG_INFO( L"X^eBbNTEhRg[[𕡐 : File[%s]", pDstCtrl->GetFilePath() );

	return True;
}

Boolean Manager::CloneStreamController( Mix::File::IReader* pSrcReader, Mix::Sound::IController** ppDst )
{
	if( pSrcReader->IsBuffered() == False )
	{
		return False;
	}

	Mix::File::IReader* pReader;

	if( pSrcReader->Clone( &pReader ) == False )
	{
		return False;
	}

	if( CreateStreamController( L"", pReader, ppDst ) == False )
	{
		MIX_RELEASE( pReader );
		return False;
	}

	MIX_RELEASE( pReader );

	return True;
}

Boolean Manager::CloneStaticEmitter( Mix::Sound::Listener* pListener, const wchar_t* pFilePath, const WAVEFORMATEX* pFormat, Mix::Memory::IBuffer* pBuffer, const Mix::Vector3& forward, const Mix::Vector3& up, Mix::Sound::IEmitter** ppDst )
{
	if( CreateStaticEmitter( L"", pFilePath, pListener, pFormat, pBuffer, forward, up, ppDst ) == False )
	{
		return False;
	}

	MIX_LOG_INFO( L"X^eBbNTEhG~b^[𕡐 : File[%s]", pFilePath );

	return True;
}

Boolean Manager::CloneStreamEmitter( Mix::Sound::Listener* pListener, Mix::File::IReader* pSrcReader, const Mix::Vector3& localFront, const Mix::Vector3& localUp, Mix::Sound::IEmitter** ppDst )
{
	if( pSrcReader->IsBuffered() == False )
	{
		return False;
	}

	Mix::File::IReader* pReader;

	if( pSrcReader->Clone( &pReader ) == False )
	{
		return False;
	}

	if( CreateStreamEmitter( L"", pListener, pReader, localFront, localUp, ppDst ) == False )
	{
		MIX_RELEASE( pReader );
		return False;
	}

	MIX_RELEASE( pReader );

	return True;
}

void Manager::ThreadMain( void )
{
	TaskList::iterator sst;
	TaskList::iterator sst_end;

	::CoInitialize( NULL );

	while( m_EndEvent.Wait( Manager::SLEEP_TIME ) == False )
	{
		m_TaskListSync.Enter();

		sst = m_TaskList.begin();
		sst_end = m_TaskList.end();

		while( sst != sst_end )
		{
			if( ( *sst )->Process() == True )
			{
				sst++;
			}
			else
			{
				MIX_DELETE( ( *sst ) );
				sst = m_TaskList.erase( sst );
			}
		}

		m_TaskListSync.Leave();
	}

	m_TaskListSync.Enter();
	for( sst = m_TaskList.begin(); sst != m_TaskList.end(); ++sst )
	{
		MIX_DELETE( ( *sst ) );
	}
	m_TaskList.clear();
	m_TaskListSync.Leave();

	::CoUninitialize();
}

void Manager::ThreadEntry_Main( void* pArg )
{
	Manager* pMgr = reinterpret_cast<Manager*>( pArg );
	pMgr->ThreadMain();
}

}}
