#pragma once

#include "Mix/Sound/IListener.h"
#include <vector>

namespace Mix{ namespace Sound{

	class Listener : public Mix::Sound::IListener
	{
	public:
		static Listener* CreateInstance( const Mix::Vector3& localFront, const Mix::Vector3& localUp );

	private:
		X3DAUDIO_LISTENER m_Param;

		Mix::Vector3 m_LocalFront;
		Mix::Vector3 m_LocalUp;

		Mix::Matrix4x4 m_WorldMatrix;

		Mix::Vector3 m_WorldFront;
		Mix::Vector3 m_WorldUp;

		Mix::Vector3 m_Velocity;

	private:
		Listener( const Mix::Vector3& localFront, const Mix::Vector3& localUp );
		virtual ~Listener( void );

	public:
		const X3DAUDIO_LISTENER& GetParam( void ) const;

	public:
		virtual void SetWorldMatrix( const Mix::Matrix4x4& mat );
		virtual const Mix::Matrix4x4& GetWorldMatrix( void ) const;

		virtual const Mix::Vector3& GetLocalFront( void ) const;
		virtual const Mix::Vector3& GetLocalUp( void ) const;

		virtual const Mix::Vector3& GetWorldFront( void ) const;
		virtual const Mix::Vector3& GetWorldUp( void ) const;

		virtual void SetVelocity( const Mix::Vector3& velocity );
		virtual const Mix::Vector3& GetVelocity( void ) const;
	};

}}
