#pragma once

#include "Mix/Class/Sound/TaskMediator.h"

namespace Mix{ namespace Sound{

	class Manager;

	class EmitterTaskMediator : public Mix::Sound::TaskMediator
	{
	public:
		static EmitterTaskMediator* CreateInstance( const X3DAUDIO_HANDLE& handle, UInt32 masterChannels, UInt32 channels );

	private:
		X3DAUDIO_HANDLE m_Handle;

		Mix::CriticalSection m_Sync;
		X3DAUDIO_DSP_SETTINGS m_DSPSettings;
		std::vector<Float32> m_Matrix;

	private:
		EmitterTaskMediator( const X3DAUDIO_HANDLE& handle, UInt32 masterChannels, UInt32 channels );
		virtual ~EmitterTaskMediator( void );

	public:
		void UpdateDSPSettings( const X3DAUDIO_LISTENER& lp, const X3DAUDIO_EMITTER& ep );

	public:
		void ApplyDSPSettings( IXAudio2SourceVoice* pVoice );
	};

}}
