#include "Mix/Class/Sound/EmitterTaskMediator.h"
#include "Mix/Class/Sound/Manager.h"

namespace Mix{ namespace Sound{

////////////////////////////////////////////////////////////////////////////////////////////////////
// EmitterTaskMediator
// JgXbhяo郁\bh
////////////////////////////////////////////////////////////////////////////////////////////////////

EmitterTaskMediator* EmitterTaskMediator::CreateInstance( const X3DAUDIO_HANDLE& handle, UInt32 masterChannels, UInt32 channels )
{
	return new EmitterTaskMediator( handle, masterChannels, channels );
}

EmitterTaskMediator::EmitterTaskMediator( const X3DAUDIO_HANDLE& handle, UInt32 masterChannels, UInt32 channels )
{
	Mix::Memory::Copy( &m_Handle, &handle, sizeof( X3DAUDIO_HANDLE ) );

	m_Matrix.resize( ( masterChannels * channels ), 0.0f );

	m_DSPSettings.pMatrixCoefficients = &( m_Matrix[0] );
	m_DSPSettings.SrcChannelCount = channels;
	m_DSPSettings.DstChannelCount = masterChannels;
	m_DSPSettings.pDelayTimes = NULL;
	m_DSPSettings.LPFDirectCoefficient = 0.0f;
	m_DSPSettings.LPFReverbCoefficient = 0.0f;
	m_DSPSettings.ReverbLevel = 0.0f;
	m_DSPSettings.DopplerFactor = 1.0f;
	m_DSPSettings.EmitterToListenerAngle = 0.0f;
	m_DSPSettings.EmitterToListenerDistance = 0.0f;
	m_DSPSettings.EmitterVelocityComponent = 1.0f;
	m_DSPSettings.ListenerVelocityComponent = 1.0f;
}

EmitterTaskMediator::~EmitterTaskMediator( void )
{
}

void EmitterTaskMediator::UpdateDSPSettings( const X3DAUDIO_LISTENER& lp, const X3DAUDIO_EMITTER& ep )
{
	m_Sync.Enter();

	::X3DAudioCalculate( m_Handle, &lp, &ep, X3DAUDIO_CALCULATE_MATRIX | X3DAUDIO_CALCULATE_DOPPLER, &m_DSPSettings );

	m_Sync.Leave();
}

////////////////////////////////////////////////////////////////////////////////////////////////////
// EmitterTaskMediator
// TEhXbhĂяo郁\bh
////////////////////////////////////////////////////////////////////////////////////////////////////

void EmitterTaskMediator::ApplyDSPSettings( IXAudio2SourceVoice* pVoice )
{
	m_Sync.Enter();

	pVoice->SetOutputMatrix(	NULL,
								m_DSPSettings.SrcChannelCount,
								m_DSPSettings.DstChannelCount,
								m_DSPSettings.pMatrixCoefficients );

	pVoice->SetFrequencyRatio( m_DSPSettings.DopplerFactor );

	m_Sync.Leave();
}

}}
