#include "Mix/Class/Scene/Standard/DX9/Factory.h"

#include "Mix/Class/Scene/Standard/DX9/Renderer.h"
#include "Mix/Class/Scene/Standard/DX9/DefaultMaterial.h"

namespace Mix{ namespace Scene{ namespace Standard{ namespace DX9{

////////////////////////////////////////////////////////////////////////////////////////////////////
// Factory : VF[_[ : Misc
////////////////////////////////////////////////////////////////////////////////////////////////////

//TvO(VS)
static const UInt8 VS_SAMPLING_3[] =
{
	#include "Mix/Class/Scene/Standard/DX9/Shader/3/Misc/sampling.vs.inc"
};

//TvO - Rs[(PS)
static const UInt8 PS_SAMPLING_COPY_3[] =
{
	#include "Mix/Class/Scene/Standard/DX9/Shader/3/Misc/samplingCopy.ps.inc"
};

//TvO - _E1/2(PS)
static const UInt8 PS_SAMPLING_DOWN2X_3[] =
{
	#include "Mix/Class/Scene/Standard/DX9/Shader/3/Misc/samplingDown2x.ps.inc"
};

//TvO - _E1/4(PS)
static const UInt8 PS_SAMPLING_DOWN4X_3[] =
{
	#include "Mix/Class/Scene/Standard/DX9/Shader/3/Misc/samplingDown4x.ps.inc"
};

//u[ - 3TvX(PS)
static const UInt8 PS_BLUR3X_X_3[] =
{
	#include "Mix/Class/Scene/Standard/DX9/Shader/3/Misc/blur3x_X.ps.inc"
};

//u[ - 3TvY(PS)
static const UInt8 PS_BLUR3X_Y_3[] =
{
	#include "Mix/Class/Scene/Standard/DX9/Shader/3/Misc/blur3x_Y.ps.inc"
};

//u[ - 5TvX(PS)
static const UInt8 PS_BLUR5X_X_3[] =
{
	#include "Mix/Class/Scene/Standard/DX9/Shader/3/Misc/blur5x_X.ps.inc"
};

//u[ - 5TvY(PS)
static const UInt8 PS_BLUR5X_Y_3[] =
{
	#include "Mix/Class/Scene/Standard/DX9/Shader/3/Misc/blur5x_Y.ps.inc"
};

//KEVAu[ - X(VS)
static const UInt8 VS_GAUSSIAN_BLUR_X_3[] =
{
	#include "Mix/Class/Scene/Standard/DX9/Shader/3/Misc/gaussianBlur_X.vs.inc"
};

//KEVAu[ - X(PS)
static const UInt8 PS_GAUSSIAN_BLUR_X_3[] =
{
	#include "Mix/Class/Scene/Standard/DX9/Shader/3/Misc/gaussianBlur_X.ps.inc"
};

//KEVAu[ - Y(VS)
static const UInt8 VS_GAUSSIAN_BLUR_Y_3[] =
{
	#include "Mix/Class/Scene/Standard/DX9/Shader/3/Misc/gaussianBlur_Y.vs.inc"
};

//KEVAu[ - Y(PS)
static const UInt8 PS_GAUSSIAN_BLUR_Y_3[] =
{
	#include "Mix/Class/Scene/Standard/DX9/Shader/3/Misc/gaussianBlur_Y.ps.inc"
};

//KEVAu[EX(PS)
static const UInt8 PS_GAUSSIAN_BLUR_EX_3[] =
{
	#include "Mix/Class/Scene/Standard/DX9/Shader/3/Misc/gaussianBlurEx.ps.inc"
};

//uCgpX - __(PS)
static const UInt8 PS_BRIGHTPASS____3[] =
{
	#include "Mix/Class/Scene/Standard/DX9/Shader/3/Misc/brightPass__.ps.inc"
};


//uCgpX - L_(PS)
static const UInt8 PS_BRIGHTPASS_L__3[] =
{
	#include "Mix/Class/Scene/Standard/DX9/Shader/3/Misc/brightPassL_.ps.inc"
};

//uCgpX - LA(PS)
static const UInt8 PS_BRIGHTPASS_LA_3[] =
{
	#include "Mix/Class/Scene/Standard/DX9/Shader/3/Misc/brightPassLA.ps.inc"
};

////////////////////////////////////////////////////////////////////////////////////////////////////
// Factory : VF[_[ : SkyDome
////////////////////////////////////////////////////////////////////////////////////////////////////

//ftHg(VS)
static const UInt8 VS_SKYDOME_DEFAULT_3[] =
{
	#include "Mix/Class/Scene/Standard/DX9/Shader/3/SkyDome/default.vs.inc"
};

//ftHg - BaseTex[~] CloudTex[~] CloudLayer[~] CloudLighting[~](PS)
static const UInt8 PS_SKYDOME_DEFAULT______3[] =
{
	#include "Mix/Class/Scene/Standard/DX9/Shader/3/SkyDome/default_____.ps.inc"
};

//ftHg - BaseTex[~] CloudTex[] CloudLayer[~] CloudLighting[~](PS)
static const UInt8 PS_SKYDOME_DEFAULT__C___3[] =
{
	#include "Mix/Class/Scene/Standard/DX9/Shader/3/SkyDome/default__c__.ps.inc"
};

//ftHg - BaseTex[~] CloudTex[] CloudLayer[] CloudLighting[~](PS)
static const UInt8 PS_SKYDOME_DEFAULT__C2__3[] =
{
	#include "Mix/Class/Scene/Standard/DX9/Shader/3/SkyDome/default__c2_.ps.inc"
};

//ftHg - BaseTex[] CloudTex[~] CloudLayer[~] CloudLighting[~](PS)
static const UInt8 PS_SKYDOME_DEFAULT_B____3[] =
{
	#include "Mix/Class/Scene/Standard/DX9/Shader/3/SkyDome/default_b___.ps.inc"
};

//ftHg - BaseTex[] CloudTex[] CloudLayer[~] CloudLighting[~](PS)
static const UInt8 PS_SKYDOME_DEFAULT_BC___3[] =
{
	#include "Mix/Class/Scene/Standard/DX9/Shader/3/SkyDome/default_bc__.ps.inc"
};

//ftHg - BaseTex[] CloudTex[] CloudLayer[] CloudLighting[~](PS)
static const UInt8 PS_SKYDOME_DEFAULT_BC2__3[] =
{
	#include "Mix/Class/Scene/Standard/DX9/Shader/3/SkyDome/default_bc2_.ps.inc"
};

//CUV~[V(VS)
static const UInt8 VS_SKYDOME_ATMOSPHERE_3[] =
{
	#include "Mix/Class/Scene/Standard/DX9/Shader/3/SkyDome/atmosphere.vs.inc"
};

//CUV~[V - BaseTex[~] CloudTex[~] CloudLayer[~] CloudLighting[~](PS)
static const UInt8 PS_SKYDOME_ATMOSPHERE______3[] =
{
	#include "Mix/Class/Scene/Standard/DX9/Shader/3/SkyDome/atmosphere_____.ps.inc"
};

//CUV~[V - BaseTex[~] CloudTex[] CloudLayer[~] CloudLighting[~](PS)
static const UInt8 PS_SKYDOME_ATMOSPHERE__C___3[] =
{
	#include "Mix/Class/Scene/Standard/DX9/Shader/3/SkyDome/atmosphere__c__.ps.inc"
};

//CUV~[V - BaseTex[~] CloudTex[] CloudLayer[~] CloudLighting[](PS)
static const UInt8 PS_SKYDOME_ATMOSPHERE__C_L_3[] =
{
	#include "Mix/Class/Scene/Standard/DX9/Shader/3/SkyDome/atmosphere__c_l.ps.inc"
};

//CUV~[V - BaseTex[~] CloudTex[] CloudLayer[] CloudLighting[~](PS)
static const UInt8 PS_SKYDOME_ATMOSPHERE__C2__3[] =
{
	#include "Mix/Class/Scene/Standard/DX9/Shader/3/SkyDome/atmosphere__c2_.ps.inc"
};

//CUV~[V - BaseTex[~] CloudTex[] CloudLayer[] CloudLighting[](PS)
static const UInt8 PS_SKYDOME_ATMOSPHERE__C2L_3[] =
{
	#include "Mix/Class/Scene/Standard/DX9/Shader/3/SkyDome/atmosphere__c2l.ps.inc"
};

//CUV~[V - BaseTex[] CloudTex[~] CloudLayer[~] CloudLighting[~](PS)
static const UInt8 PS_SKYDOME_ATMOSPHERE_B____3[] =
{
	#include "Mix/Class/Scene/Standard/DX9/Shader/3/SkyDome/atmosphere_b___.ps.inc"
};

//CUV~[V - BaseTex[] CloudTex[] CloudLayer[~] CloudLighting[~](PS)
static const UInt8 PS_SKYDOME_ATMOSPHERE_BC___3[] =
{
	#include "Mix/Class/Scene/Standard/DX9/Shader/3/SkyDome/atmosphere_bc__.ps.inc"
};

//CUV~[V - BaseTex[] CloudTex[] CloudLayer[~] CloudLighting[](PS)
static const UInt8 PS_SKYDOME_ATMOSPHERE_BC_L_3[] =
{
	#include "Mix/Class/Scene/Standard/DX9/Shader/3/SkyDome/atmosphere_bc_l.ps.inc"
};

//CUV~[V - BaseTex[] CloudTex[] CloudLayer[] CloudLighting[~](PS)
static const UInt8 PS_SKYDOME_ATMOSPHERE_BC2__3[] =
{
	#include "Mix/Class/Scene/Standard/DX9/Shader/3/SkyDome/atmosphere_bc2_.ps.inc"
};

//CUV~[V - BaseTex[] CloudTex[] CloudLayer[] CloudLighting[](PS)
static const UInt8 PS_SKYDOME_ATMOSPHERE_BC2L_3[] =
{
	#include "Mix/Class/Scene/Standard/DX9/Shader/3/SkyDome/atmosphere_bc2l.ps.inc"
};

//pm} (VS)
static const UInt8 VS_SKYDOME_PANORAMA_3[] =
{
	#include "Mix/Class/Scene/Standard/DX9/Shader/3/SkyDome/panorama.vs.inc"
};

//pm} - tHO[CUV~[V] (VS)
static const UInt8 VS_SKYDOME_PANORAMA_FA_3[] =
{
	#include "Mix/Class/Scene/Standard/DX9/Shader/3/SkyDome/panorama_fa.vs.inc"
};

//pm} (PS)
static const UInt8 PS_SKYDOME_PANORAMA_3[] =
{
	#include "Mix/Class/Scene/Standard/DX9/Shader/3/SkyDome/panorama.ps.inc"
};

//pm} - tHO[ftHg] (PS)
static const UInt8 PS_SKYDOME_PANORAMA_FD_3[] =
{
	#include "Mix/Class/Scene/Standard/DX9/Shader/3/SkyDome/panorama_fd.ps.inc"
};

//pm} - tHO[CUV~[V] (PS)
static const UInt8 PS_SKYDOME_PANORAMA_FA_3[] =
{
	#include "Mix/Class/Scene/Standard/DX9/Shader/3/SkyDome/panorama_fa.ps.inc"
};

////////////////////////////////////////////////////////////////////////////////////////////////////
// Factory : VF[_[ : PostEffect
////////////////////////////////////////////////////////////////////////////////////////////////////

//SSAO(PS)
static const UInt8 PS_SSAO_3[] =
{
	#include "Mix/Class/Scene/Standard/DX9/Shader/3/PostEffect/ssao.ps.inc"
};

//SSAO - eNX`L(PS)
static const UInt8 PS_SSAO_TEX_3[] =
{
	#include "Mix/Class/Scene/Standard/DX9/Shader/3/PostEffect/ssao_tex.ps.inc"
};

//VhE}bsO - _E2X(PS)
static const UInt8 PS_SM_DOWN2X_3[] =
{
	#include "Mix/Class/Scene/Standard/DX9/Shader/3/PostEffect/smDown2x.ps.inc"
};

//VhE}bsO - _E4X(PS)
static const UInt8 PS_SM_DOWN4X_3[] =
{
	#include "Mix/Class/Scene/Standard/DX9/Shader/3/PostEffect/smDown4x.ps.inc"
};

//VhE}bsO - fBt@C(PS)
static const UInt8 PS_SM_FINISH_3[] =
{
	#include "Mix/Class/Scene/Standard/DX9/Shader/3/PostEffect/smFinish.ps.inc"
};

//ʉ (PS)
static const UInt8 PS_UNDER_WATER_3[] =
{
	#include "Mix/Class/Scene/Standard/DX9/Shader/3/PostEffect/underWater.ps.inc"
};

//~iX - gXtH[ - INITAL (PS)
static const UInt8 PS_LUM_TRANSFORM_INITAL_3[] =
{
	#include "Mix/Class/Scene/Standard/DX9/Shader/3/PostEffect/lumTransform_Inital.ps.inc"
};

//~iX - gXtH[ - ITERATE (PS)
static const UInt8 PS_LUM_TRANSFORM_ITERATE_3[] =
{
	#include "Mix/Class/Scene/Standard/DX9/Shader/3/PostEffect/lumTransform_Iterate.ps.inc"
};

//~iX - gXtH[ - FINAL (PS)
static const UInt8 PS_LUM_TRANSFORM_FINAL_3[] =
{
	#include "Mix/Class/Scene/Standard/DX9/Shader/3/PostEffect/lumTransform_Final.ps.inc"
};

//~iX - A_vebh (PS)
static const UInt8 PS_LUM_ADAPTED_3[] =
{
	#include "Mix/Class/Scene/Standard/DX9/Shader/3/PostEffect/lumAdapted.ps.inc"
};

//~iX - Iy[^ - __B (PS)
static const UInt8 PS_LUM_OPERATOR___B_3[] =
{
	#include "Mix/Class/Scene/Standard/DX9/Shader/3/PostEffect/lumOperator__B.ps.inc"
};

//~iX - Iy[^ - T__ (PS)
static const UInt8 PS_LUM_OPERATOR_T___3[] =
{
	#include "Mix/Class/Scene/Standard/DX9/Shader/3/PostEffect/lumOperatorT__.ps.inc"
};

//~iX - Iy[^ - T_B (PS)
static const UInt8 PS_LUM_OPERATOR_T_B_3[] =
{
	#include "Mix/Class/Scene/Standard/DX9/Shader/3/PostEffect/lumOperatorT_B.ps.inc"
};

//~iX - Iy[^ - TA_ (PS)
static const UInt8 PS_LUM_OPERATOR_TA__3[] =
{
	#include "Mix/Class/Scene/Standard/DX9/Shader/3/PostEffect/lumOperatorTA_.ps.inc"
};

//~iX - Iy[^ - TAB (PS)
static const UInt8 PS_LUM_OPERATOR_TAB_3[] =
{
	#include "Mix/Class/Scene/Standard/DX9/Shader/3/PostEffect/lumOperatorTAB.ps.inc"
};

//CgVtg -  _(PS)
static const UInt8 PS_LS_INIT___3[] =
{
	#include "Mix/Class/Scene/Standard/DX9/Shader/3/PostEffect/lightShaftsInit_.ps.inc"
};

//CgVtg -  A(PS)
static const UInt8 PS_LS_INIT_A_3[] =
{
	#include "Mix/Class/Scene/Standard/DX9/Shader/3/PostEffect/lightShaftsInitA.ps.inc"
};

//CgVtg - u[ LOW(PS)
static const UInt8 PS_LS_BLUR_L_3[] =
{
	#include "Mix/Class/Scene/Standard/DX9/Shader/3/PostEffect/lightShaftsBlurM.ps.inc"
};

//CgVtg - u[ MIDDLE(PS)
static const UInt8 PS_LS_BLUR_M_3[] =
{
	#include "Mix/Class/Scene/Standard/DX9/Shader/3/PostEffect/lightShaftsBlurH.ps.inc"
};

//CgVtg - u[ HIGH(PS)
static const UInt8 PS_LS_BLUR_H_3[] =
{
	#include "Mix/Class/Scene/Standard/DX9/Shader/3/PostEffect/lightShaftsBlurL.ps.inc"
};

//YtA - C[W - __(PS)
static const UInt8 PS_LF_IMAGE____3[] =
{
	#include "Mix/Class/Scene/Standard/DX9/Shader/3/PostEffect/lensFlareImage__.ps.inc"
};

//YtA - C[W - _H(PS)
static const UInt8 PS_LF_IMAGE__H_3[] =
{
	#include "Mix/Class/Scene/Standard/DX9/Shader/3/PostEffect/lensFlareImage_H.ps.inc"
};

//YtA - C[W - G_(PS)
static const UInt8 PS_LF_IMAGE_G__3[] =
{
	#include "Mix/Class/Scene/Standard/DX9/Shader/3/PostEffect/lensFlareImageG_.ps.inc"
};

//YtA - C[W - GH(PS)
static const UInt8 PS_LF_IMAGE_GH_3[] =
{
	#include "Mix/Class/Scene/Standard/DX9/Shader/3/PostEffect/lensFlareImageGH.ps.inc"
};

//YtA - fBt@C - __(PS)
static const UInt8 PS_LF_MODIFY____3[] =
{
	#include "Mix/Class/Scene/Standard/DX9/Shader/3/PostEffect/lensFlareModify__.ps.inc"
};

//YtA - fBt@C - D_(PS)
static const UInt8 PS_LF_MODIFY_D__3[] =
{
	#include "Mix/Class/Scene/Standard/DX9/Shader/3/PostEffect/lensFlareModifyD_.ps.inc"
};

//YtA - fBt@C - _B(PS)
static const UInt8 PS_LF_MODIFY__B_3[] =
{
	#include "Mix/Class/Scene/Standard/DX9/Shader/3/PostEffect/lensFlareModify_B.ps.inc"
};

//YtA - fBt@C - DB(PS)
static const UInt8 PS_LF_MODIFY_DB_3[] =
{
	#include "Mix/Class/Scene/Standard/DX9/Shader/3/PostEffect/lensFlareModifyDB.ps.inc"
};

//tB~bN - Jim Hejl( PS )
static const UInt8 PS_FILMIC_HEJL_3[] =
{
	#include "Mix/Class/Scene/Standard/DX9/Shader/3/PostEffect/filmicHejl.ps.inc"
};

//tB~bN - John Hable( PS )
static const UInt8 PS_FILMIC_HABLE_3[] =
{
	#include "Mix/Class/Scene/Standard/DX9/Shader/3/PostEffect/filmicHable.ps.inc"
};

//K}␳(PS)
static const UInt8 PS_GAMMA_3[] =
{
	#include "Mix/Class/Scene/Standard/DX9/Shader/3/PostEffect/gamma.ps.inc"
};

//F - C[W _ (PS)
static const UInt8 PS_CA_IMAGE___3[] =
{
	#include "Mix/Class/Scene/Standard/DX9/Shader/3/PostEffect/caImage_.ps.inc"
};

//F - C[W K (PS)
static const UInt8 PS_CA_IMAGE_K_3[] =
{
	#include "Mix/Class/Scene/Standard/DX9/Shader/3/PostEffect/caImageK.ps.inc"
};

//F - tBjbV _ (PS)
static const UInt8 PS_CA_FINISH___3[] =
{
	#include "Mix/Class/Scene/Standard/DX9/Shader/3/PostEffect/caFinish_.ps.inc"
};

//F - tBjbV D (PS)
static const UInt8 PS_CA_FINISH_D_3[] =
{
	#include "Mix/Class/Scene/Standard/DX9/Shader/3/PostEffect/caFinishD.ps.inc"
};

//ʊE[x (PS)
static const UInt8 PS_DOF_3[] =
{
	#include "Mix/Class/Scene/Standard/DX9/Shader/3/PostEffect/depthOfField.ps.inc"
};

//YfBXg[V - _(PS)
static const UInt8 PS_LENS_DIST___3[] =
{
	#include "Mix/Class/Scene/Standard/DX9/Shader/3/PostEffect/lensDistortion_.ps.inc"
};

//YfBXg[V - K(PS)
static const UInt8 PS_LENS_DIST_K_3[] =
{
	#include "Mix/Class/Scene/Standard/DX9/Shader/3/PostEffect/lensDistortionK.ps.inc"
};

//rlbg
static const UInt8 PS_VIGNETTE_PS[] =
{
	#include "Mix/Class/Scene/Standard/DX9/Shader/3/PostEffect/vignette.ps.inc"
};

//A`GCAX - FXAA (PS)
static const UInt8 PS_FXAA_3[] =
{
	#include "Mix/Class/Scene/Standard/DX9/Shader/3/PostEffect/fxaa.ps.inc"
};

////////////////////////////////////////////////////////////////////////////////////////////////////
// Factory
////////////////////////////////////////////////////////////////////////////////////////////////////

Factory* Factory::CreateInstance( void )
{
	return new Factory();
}

Factory::Factory( void )
{
}

Factory::~Factory( void )
{
}

void Factory::GetShaderBinary( Factory::SHADER_TYPES type, Factory::SHADER_BINARY& out )
{
	switch( type )
	{
	// Misc //

	case Factory::SHADER_SAMPLING_VS:
		::wcscpy_s( out.name, Factory::SHADER_BINARY::NAME_SIZE, L"Sampling(DX9_3)" );
		out.pData = &( VS_SAMPLING_3[0] );
		out.dataSize = sizeof( VS_SAMPLING_3 );
		break;
	case Factory::SHADER_SAMPLING_COPY_PS:
		::wcscpy_s( out.name, Factory::SHADER_BINARY::NAME_SIZE, L"SamplingCopy(DX9_3)" );
		out.pData = &( PS_SAMPLING_COPY_3[0] );
		out.dataSize = sizeof( PS_SAMPLING_COPY_3 );
		break;
	case Factory::SHADER_SAMPLING_DOWN2X_PS:
		::wcscpy_s( out.name, Factory::SHADER_BINARY::NAME_SIZE, L"SamplingDown2x(DX9_3)" );
		out.pData = &( PS_SAMPLING_DOWN2X_3[0] );
		out.dataSize = sizeof( PS_SAMPLING_DOWN2X_3 );
		break;
	case Factory::SHADER_SAMPLING_DOWN4X_PS:
		::wcscpy_s( out.name, Factory::SHADER_BINARY::NAME_SIZE, L"SamplingDown4x(DX9_3)" );
		out.pData = &( PS_SAMPLING_DOWN4X_3[0] );
		out.dataSize = sizeof( PS_SAMPLING_DOWN4X_3 );
		break;

	case Factory::SHADER_BLUR3X_X_PS:
		::wcscpy_s( out.name, Factory::SHADER_BINARY::NAME_SIZE, L"Blur3x_X(DX9_3)" );
		out.pData = &( PS_BLUR3X_X_3[0] );
		out.dataSize = sizeof( PS_BLUR3X_X_3 );
		break;
	case Factory::SHADER_BLUR3X_Y_PS:
		::wcscpy_s( out.name, Factory::SHADER_BINARY::NAME_SIZE, L"Blur3x_Y(DX9_3)" );
		out.pData = &( PS_BLUR3X_Y_3[0] );
		out.dataSize = sizeof( PS_BLUR3X_Y_3 );
		break;

	case Factory::SHADER_BLUR5X_X_PS:
		::wcscpy_s( out.name, Factory::SHADER_BINARY::NAME_SIZE, L"Blur5x_X(DX9_3)" );
		out.pData = &( PS_BLUR5X_X_3[0] );
		out.dataSize = sizeof( PS_BLUR5X_X_3 );
		break;
	case Factory::SHADER_BLUR5X_Y_PS:
		::wcscpy_s( out.name, Factory::SHADER_BINARY::NAME_SIZE, L"Blur5x_Y(DX9_3)" );
		out.pData = &( PS_BLUR5X_Y_3[0] );
		out.dataSize = sizeof( PS_BLUR5X_Y_3 );
		break;

	case Factory::SHADER_GAUSSIAN_BLUR_X_VS:
		::wcscpy_s( out.name, Factory::SHADER_BINARY::NAME_SIZE, L"GaussianBlur_X(DX9_3)" );
		out.pData = &( VS_GAUSSIAN_BLUR_X_3[0] );
		out.dataSize = sizeof( VS_GAUSSIAN_BLUR_X_3 );
		break;
	case Factory::SHADER_GAUSSIAN_BLUR_X_PS:
		::wcscpy_s( out.name, Factory::SHADER_BINARY::NAME_SIZE, L"GaussianBlur_X(DX9_3)" );
		out.pData = &( PS_GAUSSIAN_BLUR_X_3[0] );
		out.dataSize = sizeof( PS_GAUSSIAN_BLUR_X_3 );
		break;
	case Factory::SHADER_GAUSSIAN_BLUR_Y_VS:
		::wcscpy_s( out.name, Factory::SHADER_BINARY::NAME_SIZE, L"GaussianBlur_Y(DX9_3)" );
		out.pData = &( VS_GAUSSIAN_BLUR_Y_3[0] );
		out.dataSize = sizeof( VS_GAUSSIAN_BLUR_Y_3 );
		break;
	case Factory::SHADER_GAUSSIAN_BLUR_Y_PS:
		::wcscpy_s( out.name, Factory::SHADER_BINARY::NAME_SIZE, L"GaussianBlur_Y(DX9_3)" );
		out.pData = &( PS_GAUSSIAN_BLUR_Y_3[0] );
		out.dataSize = sizeof( PS_GAUSSIAN_BLUR_Y_3 );
		break;

	case Factory::SHADER_GAUSSIAN_BLUR_EX_PS:
		::wcscpy_s( out.name, Factory::SHADER_BINARY::NAME_SIZE, L"GaussianBlurEx(DX9_3)" );
		out.pData = &( PS_GAUSSIAN_BLUR_EX_3[0] );
		out.dataSize = sizeof( PS_GAUSSIAN_BLUR_EX_3 );
		break;

	case Factory::SHADER_BP____PS:
		::wcscpy_s( out.name, Factory::SHADER_BINARY::NAME_SIZE, L"BrightPass__(DX9_3)" );
		out.pData = &( PS_BRIGHTPASS____3[0] );
		out.dataSize = sizeof( PS_BRIGHTPASS____3 );
		break;
	case Factory::SHADER_BP_L__PS:
		::wcscpy_s( out.name, Factory::SHADER_BINARY::NAME_SIZE, L"BrightPassL_(DX9_3)" );
		out.pData = &( PS_BRIGHTPASS_L__3[0] );
		out.dataSize = sizeof( PS_BRIGHTPASS_L__3 );
		break;
	case Factory::SHADER_BP_LA_PS:
		::wcscpy_s( out.name, Factory::SHADER_BINARY::NAME_SIZE, L"BrightPassLA(DX9_3)" );
		out.pData = &( PS_BRIGHTPASS_LA_3[0] );
		out.dataSize = sizeof( PS_BRIGHTPASS_LA_3 );
		break;

	// SkyDome //

	case Factory::SHADER_SKYDOME_DEFAULT_VS:
		::wcscpy_s( out.name, Factory::SHADER_BINARY::NAME_SIZE, L"SkyDome - Default ---- (DX9_3)" );
		out.pData = &( VS_SKYDOME_DEFAULT_3[0] );
		out.dataSize = sizeof( VS_SKYDOME_DEFAULT_3 );
		break;
	case Factory::SHADER_SKYDOME_DEFAULT______PS:
		::wcscpy_s( out.name, Factory::SHADER_BINARY::NAME_SIZE, L"SkyDome - Default ---- (DX9_3)" );
		out.pData = &( PS_SKYDOME_DEFAULT______3[0] );
		out.dataSize = sizeof( PS_SKYDOME_DEFAULT______3 );
		break;
	case Factory::SHADER_SKYDOME_DEFAULT__C___PS:
		::wcscpy_s( out.name, Factory::SHADER_BINARY::NAME_SIZE, L"SkyDome - Default -C--- (DX9_3)" );
		out.pData = &( PS_SKYDOME_DEFAULT__C___3[0] );
		out.dataSize = sizeof( PS_SKYDOME_DEFAULT__C___3 );
		break;
	case Factory::SHADER_SKYDOME_DEFAULT__C2__PS:
		::wcscpy_s( out.name, Factory::SHADER_BINARY::NAME_SIZE, L"SkyDome - Default -C2- (DX9_3)" );
		out.pData = &( PS_SKYDOME_DEFAULT__C2__3[0] );
		out.dataSize = sizeof( PS_SKYDOME_DEFAULT__C2__3 );
		break;
	case Factory::SHADER_SKYDOME_DEFAULT_B____PS:
		::wcscpy_s( out.name, Factory::SHADER_BINARY::NAME_SIZE, L"SkyDome - Default B--- (DX9_3)" );
		out.pData = &( PS_SKYDOME_DEFAULT_B____3[0] );
		out.dataSize = sizeof( PS_SKYDOME_DEFAULT_B____3 );
		break;
	case Factory::SHADER_SKYDOME_DEFAULT_BC___PS:
		::wcscpy_s( out.name, Factory::SHADER_BINARY::NAME_SIZE, L"SkyDome - Default BC-- (DX9_3)" );
		out.pData = &( PS_SKYDOME_DEFAULT_BC___3[0] );
		out.dataSize = sizeof( PS_SKYDOME_DEFAULT_BC___3 );
		break;
	case Factory::SHADER_SKYDOME_DEFAULT_BC2__PS:
		::wcscpy_s( out.name, Factory::SHADER_BINARY::NAME_SIZE, L"SkyDome - Default BC2- (DX9_3)" );
		out.pData = &( PS_SKYDOME_DEFAULT_BC2__3[0] );
		out.dataSize = sizeof( PS_SKYDOME_DEFAULT_BC2__3 );
		break;

	case Factory::SHADER_SKYDOME_ATMOSPHERE_VS:
		::wcscpy_s( out.name, Factory::SHADER_BINARY::NAME_SIZE, L"SkyDome - Atmosphere ---- (DX9_3)" );
		out.pData = &( VS_SKYDOME_ATMOSPHERE_3[0] );
		out.dataSize = sizeof( VS_SKYDOME_ATMOSPHERE_3 );
		break;
	case Factory::SHADER_SKYDOME_ATMOSPHERE______PS:
		::wcscpy_s( out.name, Factory::SHADER_BINARY::NAME_SIZE, L"SkyDome - Atmosphere ---- (DX9_3)" );
		out.pData = &( PS_SKYDOME_ATMOSPHERE______3[0] );
		out.dataSize = sizeof( PS_SKYDOME_ATMOSPHERE______3 );
		break;
	case Factory::SHADER_SKYDOME_ATMOSPHERE__C___PS:
		::wcscpy_s( out.name, Factory::SHADER_BINARY::NAME_SIZE, L"SkyDome - Atmosphere -C--- (DX9_3)" );
		out.pData = &( PS_SKYDOME_ATMOSPHERE__C___3[0] );
		out.dataSize = sizeof( PS_SKYDOME_ATMOSPHERE__C___3 );
		break;
	case Factory::SHADER_SKYDOME_ATMOSPHERE__C_L_PS:
		::wcscpy_s( out.name, Factory::SHADER_BINARY::NAME_SIZE, L"SkyDome - Atmosphere -C--L (DX9_3)" );
		out.pData = &( PS_SKYDOME_ATMOSPHERE__C_L_3[0] );
		out.dataSize = sizeof( PS_SKYDOME_ATMOSPHERE__C_L_3 );
		break;
	case Factory::SHADER_SKYDOME_ATMOSPHERE__C2__PS:
		::wcscpy_s( out.name, Factory::SHADER_BINARY::NAME_SIZE, L"SkyDome - Atmosphere -C2- (DX9_3)" );
		out.pData = &( PS_SKYDOME_ATMOSPHERE__C2__3[0] );
		out.dataSize = sizeof( PS_SKYDOME_ATMOSPHERE__C2__3 );
		break;
	case Factory::SHADER_SKYDOME_ATMOSPHERE__C2L_PS:
		::wcscpy_s( out.name, Factory::SHADER_BINARY::NAME_SIZE, L"SkyDome - Atmosphere -C2L (DX9_3)" );
		out.pData = &( PS_SKYDOME_ATMOSPHERE__C2L_3[0] );
		out.dataSize = sizeof( PS_SKYDOME_ATMOSPHERE__C2L_3 );
		break;
	case Factory::SHADER_SKYDOME_ATMOSPHERE_B____PS:
		::wcscpy_s( out.name, Factory::SHADER_BINARY::NAME_SIZE, L"SkyDome - Atmosphere B--- (DX9_3)" );
		out.pData = &( PS_SKYDOME_ATMOSPHERE_B____3[0] );
		out.dataSize = sizeof( PS_SKYDOME_ATMOSPHERE_B____3 );
		break;
	case Factory::SHADER_SKYDOME_ATMOSPHERE_BC___PS:
		::wcscpy_s( out.name, Factory::SHADER_BINARY::NAME_SIZE, L"SkyDome - Atmosphere BC-- (DX9_3)" );
		out.pData = &( PS_SKYDOME_ATMOSPHERE_BC___3[0] );
		out.dataSize = sizeof( PS_SKYDOME_ATMOSPHERE_BC___3 );
		break;
	case Factory::SHADER_SKYDOME_ATMOSPHERE_BC_L_PS:
		::wcscpy_s( out.name, Factory::SHADER_BINARY::NAME_SIZE, L"SkyDome - Atmosphere BC-L (DX9_3)" );
		out.pData = &( PS_SKYDOME_ATMOSPHERE_BC_L_3[0] );
		out.dataSize = sizeof( PS_SKYDOME_ATMOSPHERE_BC_L_3 );
		break;
	case Factory::SHADER_SKYDOME_ATMOSPHERE_BC2__PS:
		::wcscpy_s( out.name, Factory::SHADER_BINARY::NAME_SIZE, L"SkyDome - Atmosphere BC2- (DX9_3)" );
		out.pData = &( PS_SKYDOME_ATMOSPHERE_BC2__3[0] );
		out.dataSize = sizeof( PS_SKYDOME_ATMOSPHERE_BC2__3 );
		break;
	case Factory::SHADER_SKYDOME_ATMOSPHERE_BC2L_PS:
		::wcscpy_s( out.name, Factory::SHADER_BINARY::NAME_SIZE, L"SkyDome - Atmosphere BC2L (DX9_3)" );
		out.pData = &( PS_SKYDOME_ATMOSPHERE_BC2L_3[0] );
		out.dataSize = sizeof( PS_SKYDOME_ATMOSPHERE_BC2L_3 );
		break;

	case Factory::SHADER_SKYDOME_PANORAMA_VS:
		::wcscpy_s( out.name, Factory::SHADER_BINARY::NAME_SIZE, L"SkyDome - Panorama -- (DX9_3)" );
		out.pData = &( VS_SKYDOME_PANORAMA_3[0] );
		out.dataSize = sizeof( VS_SKYDOME_PANORAMA_3 );
		break;
	case Factory::SHADER_SKYDOME_PANORAMA_FA_VS:
		::wcscpy_s( out.name, Factory::SHADER_BINARY::NAME_SIZE, L"SkyDome - Panorama FA (DX9_3)" );
		out.pData = &( VS_SKYDOME_PANORAMA_FA_3[0] );
		out.dataSize = sizeof( VS_SKYDOME_PANORAMA_FA_3 );
		break;
	case Factory::SHADER_SKYDOME_PANORAMA_PS:
		::wcscpy_s( out.name, Factory::SHADER_BINARY::NAME_SIZE, L"SkyDome - Panorama -- (DX9_3)" );
		out.pData = &( PS_SKYDOME_PANORAMA_3[0] );
		out.dataSize = sizeof( PS_SKYDOME_PANORAMA_3 );
		break;
	case Factory::SHADER_SKYDOME_PANORAMA_FD_PS:
		::wcscpy_s( out.name, Factory::SHADER_BINARY::NAME_SIZE, L"SkyDome - Panorama FD (DX9_3)" );
		out.pData = &( PS_SKYDOME_PANORAMA_FD_3[0] );
		out.dataSize = sizeof( PS_SKYDOME_PANORAMA_FD_3 );
		break;
	case Factory::SHADER_SKYDOME_PANORAMA_FA_PS:
		::wcscpy_s( out.name, Factory::SHADER_BINARY::NAME_SIZE, L"SkyDome - Panorama FA (DX9_3)" );
		out.pData = &( PS_SKYDOME_PANORAMA_FA_3[0] );
		out.dataSize = sizeof( PS_SKYDOME_PANORAMA_FA_3 );
		break;

	// PostEffect //

	case Factory::SHADER_SSAO_PS:
		::wcscpy_s( out.name, Factory::SHADER_BINARY::NAME_SIZE, L"SSAO(DX9_3)" );
		out.pData = &( PS_SSAO_3[0] );
		out.dataSize = sizeof( PS_SSAO_3 );
		break;
	case Factory::SHADER_SSAO_TEX_PS:
		::wcscpy_s( out.name, Factory::SHADER_BINARY::NAME_SIZE, L"SSAO_Tex(DX9_3)" );
		out.pData = &( PS_SSAO_TEX_3[0] );
		out.dataSize = sizeof( PS_SSAO_TEX_3 );
		break;

	case Factory::SHADER_SM_DOWN2X_PS:
		::wcscpy_s( out.name, Factory::SHADER_BINARY::NAME_SIZE, L"SM_Down2X(DX9_3)" );
		out.pData = &( PS_SM_DOWN2X_3[0] );
		out.dataSize = sizeof( PS_SM_DOWN2X_3 );
		break;
	case Factory::SHADER_SM_DOWN4X_PS:
		::wcscpy_s( out.name, Factory::SHADER_BINARY::NAME_SIZE, L"SM_Down4X(DX9_3)" );
		out.pData = &( PS_SM_DOWN4X_3[0] );
		out.dataSize = sizeof( PS_SM_DOWN4X_3 );
		break;
	case Factory::SHADER_SM_FINISH_PS:
		::wcscpy_s( out.name, Factory::SHADER_BINARY::NAME_SIZE, L"SM_Finish(DX9_3)" );
		out.pData = &( PS_SM_FINISH_3[0] );
		out.dataSize = sizeof( PS_SM_FINISH_3 );
		break;

	case Factory::SHADER_UNDER_WATER_PS:
		::wcscpy_s( out.name, Factory::SHADER_BINARY::NAME_SIZE, L"UnderWater(DX9_3)" );
		out.pData = &( PS_UNDER_WATER_3[0] );
		out.dataSize = sizeof( PS_UNDER_WATER_3 );
		break;

	case Factory::SHADER_LUM_TRANSFORM_INITAL_PS:
		::wcscpy_s( out.name, Factory::SHADER_BINARY::NAME_SIZE, L"LumTransform_Inital(DX9_3)" );
		out.pData = &( PS_LUM_TRANSFORM_INITAL_3[0] );
		out.dataSize = sizeof( PS_LUM_TRANSFORM_INITAL_3 );
		break;
	case Factory::SHADER_LUM_TRANSFORM_ITERATE_PS:
		::wcscpy_s( out.name, Factory::SHADER_BINARY::NAME_SIZE, L"LumTransform_Iterate(DX9_3)" );
		out.pData = &( PS_LUM_TRANSFORM_ITERATE_3[0] );
		out.dataSize = sizeof( PS_LUM_TRANSFORM_ITERATE_3 );
		break;
	case Factory::SHADER_LUM_TRANSFORM_FINAL_PS:
		::wcscpy_s( out.name, Factory::SHADER_BINARY::NAME_SIZE, L"LumTransform_Final(DX9_3)" );
		out.pData = &( PS_LUM_TRANSFORM_FINAL_3[0] );
		out.dataSize = sizeof( PS_LUM_TRANSFORM_FINAL_3 );
		break;
	case Factory::SHADER_LUM_ADAPTED_PS:
		::wcscpy_s( out.name, Factory::SHADER_BINARY::NAME_SIZE, L"LumAdapted(DX9_3)" );
		out.pData = &( PS_LUM_ADAPTED_3[0] );
		out.dataSize = sizeof( PS_LUM_ADAPTED_3 );
		break;
	case Factory::SHADER_LUM_OPERATOR___B_PS:
		::wcscpy_s( out.name, Factory::SHADER_BINARY::NAME_SIZE, L"LumOperator__B(DX9_3)" );
		out.pData = &( PS_LUM_OPERATOR___B_3[0] );
		out.dataSize = sizeof( PS_LUM_OPERATOR___B_3 );
		break;
	case Factory::SHADER_LUM_OPERATOR_T___PS:
		::wcscpy_s( out.name, Factory::SHADER_BINARY::NAME_SIZE, L"LumOperatorT__(DX9_3)" );
		out.pData = &( PS_LUM_OPERATOR_T___3[0] );
		out.dataSize = sizeof( PS_LUM_OPERATOR_T___3 );
		break;
	case Factory::SHADER_LUM_OPERATOR_T_B_PS:
		::wcscpy_s( out.name, Factory::SHADER_BINARY::NAME_SIZE, L"LumOperatorT_B(DX9_3)" );
		out.pData = &( PS_LUM_OPERATOR_T_B_3[0] );
		out.dataSize = sizeof( PS_LUM_OPERATOR_T_B_3 );
		break;
	case Factory::SHADER_LUM_OPERATOR_TA__PS:
		::wcscpy_s( out.name, Factory::SHADER_BINARY::NAME_SIZE, L"LumOperatorTA_(DX9_3)" );
		out.pData = &( PS_LUM_OPERATOR_TA__3[0] );
		out.dataSize = sizeof( PS_LUM_OPERATOR_TA__3 );
		break;
	case Factory::SHADER_LUM_OPERATOR_TAB_PS:
		::wcscpy_s( out.name, Factory::SHADER_BINARY::NAME_SIZE, L"LumOperatorTAB(DX9_3)" );
		out.pData = &( PS_LUM_OPERATOR_TAB_3[0] );
		out.dataSize = sizeof( PS_LUM_OPERATOR_TAB_3 );
		break;

	case Factory::SHADER_LS_INIT___PS:
		::wcscpy_s( out.name, Factory::SHADER_BINARY::NAME_SIZE, L"LightShaftsInit_(DX9_3)" );
		out.pData = &( PS_LS_INIT___3[0] );
		out.dataSize = sizeof( PS_LS_INIT___3 );
		break;
	case Factory::SHADER_LS_INIT_A_PS:
		::wcscpy_s( out.name, Factory::SHADER_BINARY::NAME_SIZE, L"LightShaftsInitA(DX9_3)" );
		out.pData = &( PS_LS_INIT_A_3[0] );
		out.dataSize = sizeof( PS_LS_INIT_A_3 );
		break;
	case Factory::SHADER_LS_BLUR_L_PS:
		::wcscpy_s( out.name, Factory::SHADER_BINARY::NAME_SIZE, L"LightShaftsBlur_Low(DX9_3)" );
		out.pData = &( PS_LS_BLUR_L_3[0] );
		out.dataSize = sizeof( PS_LS_BLUR_L_3 );
		break;
	case Factory::SHADER_LS_BLUR_M_PS:
		::wcscpy_s( out.name, Factory::SHADER_BINARY::NAME_SIZE, L"LightShaftsBlur_Middle(DX9_3)" );
		out.pData = &( PS_LS_BLUR_M_3[0] );
		out.dataSize = sizeof( PS_LS_BLUR_M_3 );
		break;
	case Factory::SHADER_LS_BLUR_H_PS:
		::wcscpy_s( out.name, Factory::SHADER_BINARY::NAME_SIZE, L"LightShaftsBlur_High(DX9_3)" );
		out.pData = &( PS_LS_BLUR_H_3[0] );
		out.dataSize = sizeof( PS_LS_BLUR_H_3 );
		break;

	case Factory::SHADER_LF_IMAGE____PS:
		::wcscpy_s( out.name, Factory::SHADER_BINARY::NAME_SIZE, L"LensFlare_Image___(DX9_3)" );
		out.pData = &( PS_LF_IMAGE____3[0] );
		out.dataSize = sizeof( PS_LF_IMAGE____3 );
		break;
	case Factory::SHADER_LF_IMAGE__H_PS:
		::wcscpy_s( out.name, Factory::SHADER_BINARY::NAME_SIZE, L"LensFlare_Image_H(DX9_3)" );
		out.pData = &( PS_LF_IMAGE__H_3[0] );
		out.dataSize = sizeof( PS_LF_IMAGE__H_3 );
		break;
	case Factory::SHADER_LF_IMAGE_G__PS:
		::wcscpy_s( out.name, Factory::SHADER_BINARY::NAME_SIZE, L"LensFlare_Image_G_(DX9_3)" );
		out.pData = &( PS_LF_IMAGE_G__3[0] );
		out.dataSize = sizeof( PS_LF_IMAGE_G__3 );
		break;
	case Factory::SHADER_LF_IMAGE_GH_PS:
		::wcscpy_s( out.name, Factory::SHADER_BINARY::NAME_SIZE, L"LensFlare_ImageGH(DX9_3)" );
		out.pData = &( PS_LF_IMAGE_GH_3[0] );
		out.dataSize = sizeof( PS_LF_IMAGE_GH_3 );
		break;
	case Factory::SHADER_LF_MODIFY____PS:
		::wcscpy_s( out.name, Factory::SHADER_BINARY::NAME_SIZE, L"LensFlare_Modify__(DX9_3)" );
		out.pData = &( PS_LF_MODIFY____3[0] );
		out.dataSize = sizeof( PS_LF_MODIFY____3 );
		break;
	case Factory::SHADER_LF_MODIFY_D__PS:
		::wcscpy_s( out.name, Factory::SHADER_BINARY::NAME_SIZE, L"LensFlare_ModifyD_(DX9_3)" );
		out.pData = &( PS_LF_MODIFY_D__3[0] );
		out.dataSize = sizeof( PS_LF_MODIFY_D__3 );
		break;
	case Factory::SHADER_LF_MODIFY__B_PS:
		::wcscpy_s( out.name, Factory::SHADER_BINARY::NAME_SIZE, L"LensFlare_Modify_B(DX9_3)" );
		out.pData = &( PS_LF_MODIFY__B_3[0] );
		out.dataSize = sizeof( PS_LF_MODIFY__B_3 );
		break;
	case Factory::SHADER_LF_MODIFY_DB_PS:
		::wcscpy_s( out.name, Factory::SHADER_BINARY::NAME_SIZE, L"LensFlare_ModifyDB(DX9_3)" );
		out.pData = &( PS_LF_MODIFY_DB_3[0] );
		out.dataSize = sizeof( PS_LF_MODIFY_DB_3 );
		break;

	case Factory::SHADER_FI_HEJL_PS:
		::wcscpy_s( out.name, Factory::SHADER_BINARY::NAME_SIZE, L"FilmicHejl(DX9_3)" );
		out.pData = &( PS_FILMIC_HEJL_3[0] );
		out.dataSize = sizeof( PS_FILMIC_HEJL_3 );
		break;
	case Factory::SHADER_FI_HABLE_PS:
		::wcscpy_s( out.name, Factory::SHADER_BINARY::NAME_SIZE, L"FilmicHable(DX9_3)" );
		out.pData = &( PS_FILMIC_HABLE_3[0] );
		out.dataSize = sizeof( PS_FILMIC_HABLE_3 );
		break;

	case Factory::SHADER_GAMMA_PS:
		::wcscpy_s( out.name, Factory::SHADER_BINARY::NAME_SIZE, L"Gamma(DX9_3)" );
		out.pData = &( PS_GAMMA_3[0] );
		out.dataSize = sizeof( PS_GAMMA_3 );
		break;

	case Factory::SHADER_CA_IMAGE___PS:
		::wcscpy_s( out.name, Factory::SHADER_BINARY::NAME_SIZE, L"Chromatism_Image_(DX9_3)" );
		out.pData = &( PS_CA_IMAGE___3[0] );
		out.dataSize = sizeof( PS_CA_IMAGE___3 );
		break;
	case Factory::SHADER_CA_IMAGE_K_PS:
		::wcscpy_s( out.name, Factory::SHADER_BINARY::NAME_SIZE, L"Chromatism_ImageK(DX9_3)" );
		out.pData = &( PS_CA_IMAGE_K_3[0] );
		out.dataSize = sizeof( PS_CA_IMAGE_K_3 );
		break;
	case Factory::SHADER_CA_FINISH___PS:
		::wcscpy_s( out.name, Factory::SHADER_BINARY::NAME_SIZE, L"Chromatism_Finish_(DX9_3)" );
		out.pData = &( PS_CA_FINISH___3[0] );
		out.dataSize = sizeof( PS_CA_FINISH___3 );
		break;
	case Factory::SHADER_CA_FINISH_D_PS:
		::wcscpy_s( out.name, Factory::SHADER_BINARY::NAME_SIZE, L"Chromatism_FinishD(DX9_3)" );
		out.pData = &( PS_CA_FINISH_D_3[0] );
		out.dataSize = sizeof( PS_CA_FINISH_D_3 );
		break;

	case Factory::SHADER_DOF_PS:
		::wcscpy_s( out.name, Factory::SHADER_BINARY::NAME_SIZE, L"DepthOfField(DX9_3)" );
		out.pData = &( PS_DOF_3[0] );
		out.dataSize = sizeof( PS_DOF_3 );
		break;

	case Factory::SHADER_LENS_DIST___PS:
		::wcscpy_s( out.name, Factory::SHADER_BINARY::NAME_SIZE, L"LensDistortion_(DX9_3)" );
		out.pData = &( PS_LENS_DIST___3[0] );
		out.dataSize = sizeof( PS_LENS_DIST___3 );
		break;
	case Factory::SHADER_LENS_DIST_K_PS:
		::wcscpy_s( out.name, Factory::SHADER_BINARY::NAME_SIZE, L"LensDistortionK(DX9_3)" );
		out.pData = &( PS_LENS_DIST_K_3[0] );
		out.dataSize = sizeof( PS_LENS_DIST_K_3 );
		break;

	case Factory::SHADER_VIGNETTE_PS:
		::wcscpy_s( out.name, Factory::SHADER_BINARY::NAME_SIZE, L"Vignette(DX9_3)" );
		out.pData = &( PS_VIGNETTE_PS[0] );
		out.dataSize = sizeof( PS_VIGNETTE_PS );
		break;

	case Factory::SHADER_AA_FXAA_PS:
		::wcscpy_s( out.name, Factory::SHADER_BINARY::NAME_SIZE, L"FXAA(DX9_3)" );
		out.pData = &( PS_FXAA_3[0] );
		out.dataSize = sizeof( PS_FXAA_3 );
		break;

	default:
		MIX_ERROR_W( L"w肳ꂽ풓VF[_[݂͑܂(DX9_3)" );
	};
}

Mix::Scene::IRenderer* Factory::CreateRenderer( const Mix::Scene::RENDERER_CONFIG& config, const wchar_t* pName )
{
	Mix::Scene::Standard::DX9::Renderer* pRenderer = NULL;

	pRenderer = Mix::Scene::Standard::DX9::Renderer::CreateInstance( this, MIX_SAFE_NAME( pName ) );
	if( pRenderer != NULL )
	{
		if( pRenderer->Initialize( config, NULL ) == False )
		{
			MIX_RELEASE( pRenderer );
		}
	}
	else
	{
		MIX_LOG_ERROR( L"%s : Name[%s]", Mix::STR_OUTOFMEMORY, MIX_SAFE_NAME( pName ) );
	}

	return pRenderer;
}

Mix::Scene::IMaterial* Factory::CreateDefaultMaterial(	const wchar_t* pNameLabel,
														const wchar_t* pName,
														Boolean bWithMagicNumber,
														Mix::File::IReader* pReader,
														Mix::Scene::Common::Factory* pFactory,
														Mix::Graphics::IDevice* pDevice )
{
	return Mix::Scene::Standard::DX9::DefaultMaterial::CreateInstance( pNameLabel, pName, bWithMagicNumber, pReader, pFactory, pDevice );
}

}}}}
