#pragma once

#include <vector>
#include "Mix/Class/Scene/Standard/Common/Renderer.h"

namespace Mix{ namespace Scene{ namespace Standard{ namespace DX11{

	class Renderer : public Mix::Scene::Standard::Common::Renderer
	{
	public:
		static Renderer* CreateInstance( Mix::Scene::Common::Factory* pFactory, const wchar_t* pName );

	private:
		//o[ebNXVF[_[RX^gWX^񋓒萔
		enum VSCR
		{
			VSCR_GENERAL		= 1,	//S
			VSCR_TRANSFORM		= 2,	//gXtH[

			VSCR_SKYDOME		= 0,	//XJCh[
			VSCR_PANORAMA		= 0,	//XJCh[ : pm}

			VSCR_GAUSSIAN_BLUR	= 0,	//KEVAu[
		};

		//sNZVF[_[RX^gWX^񋓒萔
		enum PSCR
		{
			PSCR_GENERAL			= 1,	//S
			PSCR_LOCALLIGHT			= 2,	//[JCg
			PSCR_MATERIAL			= 3,	//}eA( VhEƕٗp )

			PSCR_SKYDOME			= 0,	//XJCh[
			PSCR_PANORAMA			= 0,	//XJCh[ : pm}

			PSCR_SAMPLING			= 0,	//TvO
			PSCR_BLUR				= 0,	//u[
			PSCR_GAUSSIAN_BLUR		= 0,	//KEVAu[
			PSCR_GAUSSIAN_BLUR_EX	= 0,	//KEVAu[EX

			PSCR_SM					= 0,	//VhE}bsO
			PSCR_SSAO				= 0,	//SSAO
			PSCR_LUM_TRANSFORM		= 0,	//Px : gXtH[
			PSCR_LUM_ADAPTED		= 0,	//Px : A_vebh
			PSCR_LUM_OPERATOR		= 0,	//Px : Iy[^[
			PSCR_BRIGHT_PASS		= 0,	//uCgpX
			PSCR_UNDERWATER			= 0,	//ʉ|XgGtFNg
			PSCR_LS_INIT			= 0,	//CgVtg : 
			PSCR_LS_BLUR			= 0,	//CgVtg : u[
			PSCR_LF_IMAGE			= 0,	//YtA : C[W
			PSCR_LF_MODIFY			= 0,	//YtA : fBt@C
			PSCR_FILMIC				= 0,	//tB~bN
			PSCR_CA_IMAGE			= 0,	//F : C[W
			PSCR_CA_FINISH			= 0,	//F : tBjbV
			PSCR_GAMMA_CORRECT		= 0,	//K}␳
			PSCR_DOF				= 0,	//ʊE[x
			PSCR_LENS_DIST			= 0,	//cȎ
			PSCR_VIGNETTE			= 0,	//Blbg
			PSCR_FXAA				= 0,	//FXAA
		};

		////////////////////////////////////////////////////////////////////////////////////////////////////
		// _O萔
		////////////////////////////////////////////////////////////////////////////////////////////////////

		//VS
		struct VSC_RENDERRING
		{
			Mix::Matrix4x4 viewMat;			//J( View )
			Mix::Matrix4x4 viewProjMat;		//J( ViewProj )
			Mix::Matrix4x4 lightMat;		//VhE( Light )
			Mix::Matrix4x4 lightBiasMat;	//VhE( LightBias )
		};

		//PS
		struct PSC_RENDERRING
		{
			Mix::Vector4 camParam;									//J( XYZ=eyePos W=invFarZ )
			Mix::Vector4 ambientColor;								//ArGgJ[( XYZ=RGB )
			Mix::Vector4 hsParam;									//Cg( XYZ=Axis W=Enabled )
			Mix::Vector4 hsGroundColor;								//Cg( XYZ=GroundColor W=Intensity )
			Mix::Vector4 hsSkyColor;								//Cg( XYZ=SkyColor W=Intensity )
			Mix::Vector4 sunParam;									//sCg( XYZ=Dir W=Enabled )
			Mix::Vector4 sunColor;									//sCg( XYZ=Color W=Intensity )
			Mix::Vector4 fogParam;									//tHO( X=p0 Y=p1 Z=Enabled )
			Mix::Vector4 fogColor;									//tHO( XYZ=F )
			Mix::Vector4 shadowParam0;								//VhE( X=ZBias Y=Density W=Enabled )
			Mix::Vector4 reserve;
			Mix::Vector4 shadowSmpTable[Renderer::SM_SAMPLING_NUM];	//VhE( TvOe[u )
			Mix::Vector4 asColor;								    //CUV~[V( XYZ=Color )
			Mix::Vector4 asSunDir;								    //CUV~[V( XYZ=SunDirection )
			Mix::Vector4 asMultipliers;								//CUV~[V( X=Lin YZW=Fex )
			Mix::Vector4 asHG;										//CUV~[V( XYZ=HG )
			Mix::Vector4 asBetaDashR;								//CUV~[V( XYZ=BetaDashR )
			Mix::Vector4 asBetaDashM;								//CUV~[V( XYZ=BetaDashM )
			Mix::Vector4 asBetaRM;									//CUV~[V( XYZ=BetaRM )
			Mix::Vector4 asOneOverBetaRM;							//CUV~[V( XYZ=OneOverBetaRM )
		};

		////////////////////////////////////////////////////////////////////////////////////////////////////
		// gXtH[萔
		////////////////////////////////////////////////////////////////////////////////////////////////////

		//VS
		//Mix::Matrix4x4[20] : [hs

		//PS
		//

		////////////////////////////////////////////////////////////////////////////////////////////////////
		// }eA萔
		////////////////////////////////////////////////////////////////////////////////////////////////////

		//VS
		//

		//PS
		struct PSC_MATERIAL
		{
			Mix::Vector4 ambientColor;		//ArGg( XYZ=RGB )
			Mix::Vector4 diffuseColor;		//fBt[Y( XYZW=RGBA )
			Mix::Vector4 diffuseParam;		//fBt[Y( X=FresnelRatio Y=RLHardness Z=RLScale )
			Mix::Vector4 specularColor;		//XyL[( XYZ=RGB W=Intensity )
			Mix::Vector4 specularParam;		//XyL[( X=Hardness Y=Scale Z=CTFresnel W=CTRoughness2 )
			Mix::Vector4 reflectParam0;		//tNg( X=Scale )
			Mix::Vector4 reflectParam1;		//tNg( X=Tint Y=Intensity Z=Bias W=Exprosure )
			Mix::Vector4 emissiveColor;		//G~bVu( XYZ=RGB W=Scale )
			Mix::Vector4 bumpParam0;		//ov( X=HeightScale Y=HeightSample Z=ReflectRatio W=WaveOffset )
			Mix::Vector4 bumpParam1;		//ov( XY=WavwUV Z=RefractRatio )
			Mix::Vector4 particleParam;		//p[eBN( X=SodtCoiffe )
		};

		////////////////////////////////////////////////////////////////////////////////////////////////////
		// [JCg萔
		////////////////////////////////////////////////////////////////////////////////////////////////////

		//VS
		//

		//PS
		struct PSC_LOCAL_LIGHT
		{
			Mix::Vector4 pos[Renderer::LOCAL_LIGHT_MAX];	//ʒu( XYZ=Pos W=Enabled )
			Mix::Vector4 dir[Renderer::LOCAL_LIGHT_MAX];	//( XYZ=Dir W=SpotLightEnabled )
			Mix::Vector4 atten[Renderer::LOCAL_LIGHT_MAX];	//( X=Linear Y=Quadratic Z=Exponent )
			Mix::Vector4 color[Renderer::LOCAL_LIGHT_MAX];	//F( XYZ=RGB W=Intensity )
			Mix::Vector4 misc[Renderer::LOCAL_LIGHT_MAX];	//̑ 
		};

		////////////////////////////////////////////////////////////////////////////////////////////////////
		// XJCh[
		////////////////////////////////////////////////////////////////////////////////////////////////////

		/*
			ftHg
		*/

		//VS
		struct VSC_SKYDOME_DEFAULT
		{
			Mix::Matrix4x4 wvpMat;
		};

		//PS
		struct PSC_SKYDOME_DEFAULT
		{
			Mix::Vector4 baseColor;		//x[XJ[
			Mix::Vector4 baseParam;		//x[X( X=Scale Y=Alpha )
			Mix::Vector4 cloudColor;	//NEh : F( XYZ=RGB W=x )
			Mix::Vector4 cloudLayer[2];	//NEh : C[( XY=UVItZbg Z=UVXP[ W=sx )
		};

		/*
			CUV~[V
		*/

		//VS
		struct VSC_SKYDOME_ATMOSPHERE
		{
			Mix::Matrix4x4 wMat;
			Mix::Matrix4x4 wvpMat;
		};

		//PS
		struct PSC_SKYDOME_ATMOSPHERE
		{
			Mix::Vector4 sunColor;		//z( XYZ=RGB )
			Mix::Vector4 nightColor;	//̐F( XYZ=RGB W=ڍs )
			Mix::Vector4 baseParam;		//x[X( X=Scale Y=Alpha )
			Mix::Vector4 cloudColor;	//NEh : F( XYZ=RGB W=x )
			Mix::Vector4 cloudLayer[2];	//NEh : C[( XY=UVItZbg Z=UVXP[ W=sx )
			Mix::Vector4 cloudParams;	//NEh : p[^( X=n臒l Y=n̔{ Z=ëÂ )
		};

		////////////////////////////////////////////////////////////////////////////////////////////////////
		// XJCh[ : pm}
		////////////////////////////////////////////////////////////////////////////////////////////////////

		//VS
		struct VSC_SKYDOME_PANORAMA
		{
			Mix::Matrix4x4 wvpMat;
			Mix::Matrix4x4 wMat;
		};

		//PS
		struct PSC_SKYDOME_PANORAMA
		{
			Mix::Vector4 baseColor;		//x[XJ[( XYZW=RGBA )
			Mix::Vector4 param;			//p[^( X=eNX`̃s[g Y= Z=tHO )
		};

		////////////////////////////////////////////////////////////////////////////////////////////////////
		// TvO萔
		////////////////////////////////////////////////////////////////////////////////////////////////////

		//VS
		//

		//PS
		//Mix::Vector4( XY=TexelSize Z=Scale )

		////////////////////////////////////////////////////////////////////////////////////////////////////
		// u[萔
		////////////////////////////////////////////////////////////////////////////////////////////////////

		//VS
		//

		//PS
		//Mix::Vector4[3] XY=Offset W=Weight

		////////////////////////////////////////////////////////////////////////////////////////////////////
		// KEVAu[萔
		////////////////////////////////////////////////////////////////////////////////////////////////////

		//VS
		//Mix::Vector4[8] ItZbg

		//PS
		struct PSC_GAUSSIAN_BLUR
		{
			Mix::Vector4 offset;	//ItZbg( XY=Offset )
			Float32 weights[8];
		};

		////////////////////////////////////////////////////////////////////////////////////////////////////
		// KEVAu[EX萔
		////////////////////////////////////////////////////////////////////////////////////////////////////

		//VS
		//

		//PS
		struct PSC_GAUSSIAN_BLUR_EX
		{
			Float32 halfRadius;
			Float32 reserve0[3];

			Mix::Vector3 inc;
			Float32 reserve1[1];

			Mix::Vector2 step;
			Float32 reserve2[2];
		};

		////////////////////////////////////////////////////////////////////////////////////////////////////
		// VhE}bsO萔
		////////////////////////////////////////////////////////////////////////////////////////////////////

		//VS
		//

		//PS
		struct PSC_SM
		{
			//params
			Float32 falloutStart;
			Float32 invFalloutDist;
			Float32 reserve1;
			Float32 reserve2;

			Mix::Vector4 sunDir;

			Mix::Vector4 color;
		};

		////////////////////////////////////////////////////////////////////////////////////////////////////
		// SOAA萔
		////////////////////////////////////////////////////////////////////////////////////////////////////

		//VS
		//

		//PS
		struct PSC_SSAO
		{
			Float32 radius;
			Float32 threshold;
			Float32 depth;
			Float32 intensity;

			Mix::Vector2 ntexAspect;
			Float32 reserve[2];

			Mix::Vector4 color;
		};

		////////////////////////////////////////////////////////////////////////////////////////////////////
		// Px : gXtH[萔
		////////////////////////////////////////////////////////////////////////////////////////////////////

		//VS
		//

		//PS
		struct PSC_LUM_TRANSFORM
		{
			Mix::Vector2 texelSize;
			Mix::Vector2 lumRange;
		};

		////////////////////////////////////////////////////////////////////////////////////////////////////
		// Px : A_vebh萔
		////////////////////////////////////////////////////////////////////////////////////////////////////

		//VS
		//

		//PS
		struct PSC_LUM_ADAPTED
		{
			Float32 rods;
			Float32 cones;
			Float32 deltaTime;
			Float32 reserve0;
		};

		////////////////////////////////////////////////////////////////////////////////////////////////////
		// Px : Iy[^[萔
		////////////////////////////////////////////////////////////////////////////////////////////////////

		//VS
		//

		//PS
		struct PSC_LUM_OPERATOR
		{
			Float32 middleGray;
			Float32 white2Inv;
			Float32 reserve[2];
		};

		////////////////////////////////////////////////////////////////////////////////////////////////////
		// uCgpX萔
		////////////////////////////////////////////////////////////////////////////////////////////////////

		//VS
		//

		//PS
		struct PSC_BRIGHT_PASS
		{
			Float32 middleGray;
			Float32 white2Inv;
			Float32 threshold;
			Float32 offset;
		};

		////////////////////////////////////////////////////////////////////////////////////////////////////
		// A_[EH[^[萔
		////////////////////////////////////////////////////////////////////////////////////////////////////

		//VS
		//

		//PS
		struct PSC_UNDER_WATER
		{
			Mix::Vector4 color;	//J[( XYZ=RGB W=Intensity )
			Float32 density;
			Float32 intensity;
			Float32 threshold;
			Float32 offset;
		};

		////////////////////////////////////////////////////////////////////////////////////////////////////
		// CgVtg : 萔
		////////////////////////////////////////////////////////////////////////////////////////////////////

		//VS
		//

		//PS
		struct PSC_LIGHT_SHAFTS_INIT
		{
			Float32 whiteness;
			Mix::Vector2 ntexAspect;
			Float32 reserve;
		};

		////////////////////////////////////////////////////////////////////////////////////////////////////
		// CgVtg : u[萔
		////////////////////////////////////////////////////////////////////////////////////////////////////

		//VS
		//

		//PS
		struct PSC_LIGHT_SHAFTS_BLUR
		{
			Mix::Vector2 lightPos;
			Float32 EdotL;
			Float32 reserve0;

			Float32 density;
			Float32 decay;
			Float32 exposure;
			Float32 reserve1;

			Float32 fiStart;
			Float32 fiEnd;
			Float32 fiInvDist;
			Float32 reserve2;
		};

		////////////////////////////////////////////////////////////////////////////////////////////////////
		// YtA : C[W萔
		////////////////////////////////////////////////////////////////////////////////////////////////////

		//VS
		//

		//PS
		struct PSC_LF_IMAGE
		{
			Mix::Vector3 distoVec;
			Float32 numGhost;
			Float32 ghostWeight;
			Float32 ghostDisp;
			Float32 haloWeight;
			Float32 haloWidth;
		};

		////////////////////////////////////////////////////////////////////////////////////////////////////
		// YtA : fBt@C萔
		////////////////////////////////////////////////////////////////////////////////////////////////////

		//VS
		//

		//PS
		struct PSC_LF_MODIFY
		{
			Float32 dirtInt;
			Float32 dirtExp;
			Float32 brustInt;
			Float32 brustExp;

			Mix::Matrix4x4 camMat;
		};

		////////////////////////////////////////////////////////////////////////////////////////////////////
		// tB~bN : HABLE
		////////////////////////////////////////////////////////////////////////////////////////////////////

		//VS
		//

		//PS
		struct PSC_FILMIC_HABLE
		{
			Float32 exposureBias;
			Float32 shoulderStrength;
			Float32 linearStrength;
			Float32 linearAngle;
			Float32 toeStrength;
			Float32 toeNumerator;
			Float32 toeDenominator;
			Float32 linearWhitePointValue;
		};

		////////////////////////////////////////////////////////////////////////////////////////////////////
		// F : C[W萔
		////////////////////////////////////////////////////////////////////////////////////////////////////

		//VS
		//

		//PS
		struct PSC_CA_IMAGE
		{
			Float32 k;
			Float32 kCube;
			Float32 scale;
			Float32 reserve;

			Mix::Vector4 colorFactor;
		};

		////////////////////////////////////////////////////////////////////////////////////////////////////
		// F : tBjbV萔
		////////////////////////////////////////////////////////////////////////////////////////////////////

		//VS
		//

		//PS
		struct PSC_CA_FINISH
		{
			Float32 weight;
			Float32 fiStartZ;
			Float32 fiInvDist;
			Float32 reserve;
		};

		////////////////////////////////////////////////////////////////////////////////////////////////////
		// K}␳萔
		////////////////////////////////////////////////////////////////////////////////////////////////////

		//VS
		//

		//PS
		//Mix::Vector4( XYZ=K}l̋t )

		////////////////////////////////////////////////////////////////////////////////////////////////////
		// ʊE[x萔
		////////////////////////////////////////////////////////////////////////////////////////////////////

		//VS
		//

		//PS
		struct PSC_DOF
		{
			Float32 nearZ;
			Float32 farZ;
			Float32 invNearDist;
			Float32 invFarDist;

			Float32 blurThreshold;
			Float32 invBlurThreaholdN;
			Float32 invBlurThreaholdF;
			Float32 reserve;

			Mix::Vector4 samplingTable[Renderer::DOF_SAMPLING_NUM];
		};

		////////////////////////////////////////////////////////////////////////////////////////////////////
		// cȎ萔
		////////////////////////////////////////////////////////////////////////////////////////////////////

		//VS
		//

		//PS
		struct PSC_LENS_DIST
		{
			Float32 k;
			Float32 kCube;
			Float32 scale;
			Float32 reserve;

			Mix::Vector4 colorFactor;
		};

		////////////////////////////////////////////////////////////////////////////////////////////////////
		// Blbg萔
		////////////////////////////////////////////////////////////////////////////////////////////////////

		//VS
		//

		//PS
		struct PSC_VIGNETTE
		{
			Float32 start;
			Float32 invDist;
			Float32 reserve[2];

			Mix::Vector4 color;
		};

		////////////////////////////////////////////////////////////////////////////////////////////////////
		// FXAA萔
		////////////////////////////////////////////////////////////////////////////////////////////////////

		//VS
		//

		//PS
		struct PSC_FXAA
		{
			Mix::Vector4 texCoords[2];
			Mix::Vector4 invScreenSize;
		};

	private:
		Mix::Graphics::IShaderConstant* m_pGeneralVSC;
		Mix::Graphics::IShaderConstant* m_pGeneralPSC;

		Mix::Graphics::IShaderConstant* m_pSkyDomeVSC;
		Mix::Graphics::IShaderConstant* m_pSkyDomePSC;
		Mix::Graphics::IShaderConstant* m_pPanoramaVSC;
		Mix::Graphics::IShaderConstant* m_pPanoramaPSC;

		Mix::Graphics::IShaderConstant* m_pTransformVSC;
		Mix::Graphics::IShaderConstant* m_pLocalLightPSC;

		Mix::Graphics::IShaderConstant* m_pSamplingPSC;
		Mix::Graphics::IShaderConstant* m_pBlurPSC;
		Mix::Graphics::IShaderConstant* m_pGaussianBlurVSC;
		Mix::Graphics::IShaderConstant* m_pGaussianBlurPSC;
		Mix::Graphics::IShaderConstant* m_pGaussianBlurExPSC;
		Mix::Graphics::IShaderConstant* m_pShadowMappingPSC;
		Mix::Graphics::IShaderConstant* m_pSsaoPSC;
		Mix::Graphics::IShaderConstant* m_pLumTransformPSC;
		Mix::Graphics::IShaderConstant* m_pLumAdaptedPSC;
		Mix::Graphics::IShaderConstant* m_pLumOperatorPSC;
		Mix::Graphics::IShaderConstant* m_pBrightPassPSC;
		Mix::Graphics::IShaderConstant* m_pUnderWaterPSC;
		Mix::Graphics::IShaderConstant* m_pLSInitPSC;
		Mix::Graphics::IShaderConstant* m_pLSBlurPSC;
		Mix::Graphics::IShaderConstant* m_pLFImagePSC;
		Mix::Graphics::IShaderConstant* m_pLFModifyPSC;
		Mix::Graphics::IShaderConstant* m_pFIHablePSC;
		Mix::Graphics::IShaderConstant* m_pCAImagePSC;
		Mix::Graphics::IShaderConstant* m_pCAFinishPSC;
		Mix::Graphics::IShaderConstant* m_pGammaCorrectPSC;
		Mix::Graphics::IShaderConstant* m_pDofPSC;
		Mix::Graphics::IShaderConstant* m_pLensDistPSC;
		Mix::Graphics::IShaderConstant* m_pVignettePSC;
		Mix::Graphics::IShaderConstant* m_pFxaaPSC;

	private:
		Renderer( Mix::Scene::Common::Factory* pFactory, const wchar_t* pName );
		virtual ~Renderer( void );

	protected:
		////////////////////////////////////////////////////////////////////////////////////////////////////
		// Mix::Scene::Common::Renderer
		////////////////////////////////////////////////////////////////////////////////////////////////////

		virtual Boolean OnInitialize( const Mix::Scene::RENDERER_CONFIG& config );
		virtual Boolean OnUpdateConfig( const Mix::Scene::RENDERER_CONFIG& config );

		////////////////////////////////////////////////////////////////////////////////////////////////////
		// Mix::Scene::Standard::Common::Renderer
		////////////////////////////////////////////////////////////////////////////////////////////////////

		virtual void OnPrepareRendering( const Renderer::PREPARE_REDNERING_EVENT_ARGS& e );
		virtual void OnTransform( const Renderer::TRANSFORM_EVENT_ARGS& e );
		virtual void OnPlacementLocalLight( const Renderer::LOCALLIGHT_EVENT_ARGS& e );
		virtual void OnRenderSkyDome( const Renderer::SKYDOME_DEFAULT_EVENT_ARGS& e );
		virtual void OnRenderSkyDome( const Renderer::SKYDOME_ATMOSPHERE_EVENT_ARGS& e );
		virtual void OnRenderPanorama( const Renderer::SKYDOME_PANORAMA_EVENT_ARGS& e );

		virtual void OnRenderSampling( const Renderer::RENDER_SAMPLING_ARGS& e );
		virtual void OnRenderBlur( const Renderer::RENDER_BLUR_ARGS& e );
		virtual void OnRenderGaussianBlur( const Renderer::RENDER_GAUSSIAN_BLUR_ARGS& e );
		virtual void OnRenderGaussianBlurEx( const Renderer::RENDER_GAUSSIAN_BLUR_EX_ARGS& e );
		virtual void OnRenderAmbientOcclusion( const Renderer::RENDER_AMBIENT_OCCLUSION_ARGS& e );
		virtual void OnRenderShadowMapping( const Renderer::RENDER_SHADOW_MAPPING_ARGS& e );
		virtual void OnRenderLumTransform( const Renderer::RENDER_LUM_TRANSFORM_ARGS& e );
		virtual void OnRenderLumAdapted( const Renderer::RENDER_LUM_ADAPTED_ARGS& e );
		virtual void OnRenderLumOperator( const Renderer::RENDER_LUM_OPERATOR_ARGS& e );
		virtual void OnRenderBrightPass( const Renderer::RENDER_BRIGHTPASS_ARGS& e );
		virtual void OnRenderUnderWater( const Renderer::UNDERWATER_EVENT_ARGS& e );
		virtual void OnRenderLightShaftsInit( const Renderer::RENDER_LIGHT_SHAFTS_INIT_ARGS& e );
		virtual void OnRenderLightShaftsBlur( const Renderer::RENDER_LIGHT_SHAFTS_BLUR_ARGS& e );
		virtual void OnRenderLensFlareImage( const Renderer::RENDER_LENSFLARE_IMAGE_ARGS& e );
		virtual void OnRenderLensFlareModify( const Renderer::RENDER_LENSFLARE_MODIFY_ARGS& e );
		virtual void OnRenderFilmicHable( const Renderer::RENDER_FILMIC_HABLE_ARGS& e );
		virtual void OnRenderChromatismImage( const Renderer::RENDER_CHROMATISM_IMAGE_ARGS& e );
		virtual void OnRenderChromatismFinish( const Renderer::RENDER_CHROMATISM_FINISH_ARGS& e );
		virtual void OnRenderGammaCorrect( const Renderer::RENDER_GAMMA_ARGS& e );
		virtual void OnRenderDof( const Renderer::RENDER_DOF_ARGS& e );
		virtual void OnRenderLensDistortion( const Renderer::RENDER_LENS_DISTORTION_ARGS& e );
		virtual void OnRenderVignette( const Renderer::RENDER_VIGNETTE_ARGS& e );
		virtual void OnRenderFXAA( const Renderer::RENDER_FXAA_ARGS& e );
	};

}}}}
