#include "Mix/Class/Scene/Standard/DX11/Factory.h"

#include "Mix/Class/Scene/Standard/DX11/Renderer.h"
#include "Mix/Class/Scene/Standard/DX11/DefaultMaterial.h"

namespace Mix{ namespace Scene{ namespace Standard{ namespace DX11{

////////////////////////////////////////////////////////////////////////////////////////////////////
// Factory : VF[_[ : Misc
////////////////////////////////////////////////////////////////////////////////////////////////////

//TvO(VS)
static const UInt8 VS_SAMPLING_5[] =
{
	#include "Mix/Class/Scene/Standard/DX11/Shader/5/Misc/sampling.vs.inc"
};

//TvO - Rs[(PS)
static const UInt8 PS_SAMPLING_COPY_5[] =
{
	#include "Mix/Class/Scene/Standard/DX11/Shader/5/Misc/samplingCopy.ps.inc"
};

//TvO - _E1/2(PS)
static const UInt8 PS_SAMPLING_DOWN2X_5[] =
{
	#include "Mix/Class/Scene/Standard/DX11/Shader/5/Misc/samplingDown2x.ps.inc"
};

//TvO - _E1/4(PS)
static const UInt8 PS_SAMPLING_DOWN4X_5[] =
{
	#include "Mix/Class/Scene/Standard/DX11/Shader/5/Misc/samplingDown4x.ps.inc"
};

//u[ - 3TvX(PS)
static const UInt8 PS_BLUR3X_X_5[] =
{
	#include "Mix/Class/Scene/Standard/DX11/Shader/5/Misc/blur3x_X.ps.inc"
};

//u[ - 3TvY(PS)
static const UInt8 PS_BLUR3X_Y_5[] =
{
	#include "Mix/Class/Scene/Standard/DX11/Shader/5/Misc/blur3x_Y.ps.inc"
};

//u[ - 5TvX(PS)
static const UInt8 PS_BLUR5X_X_5[] =
{
	#include "Mix/Class/Scene/Standard/DX11/Shader/5/Misc/blur5x_X.ps.inc"
};

//u[ - 5TvY(PS)
static const UInt8 PS_BLUR5X_Y_5[] =
{
	#include "Mix/Class/Scene/Standard/DX11/Shader/5/Misc/blur5x_Y.ps.inc"
};

//KEVAu[ - X(VS)
static const UInt8 VS_GAUSSIAN_BLUR_X_5[] =
{
	#include "Mix/Class/Scene/Standard/DX11/Shader/5/Misc/gaussianBlur_X.vs.inc"
};

//KEVAu[ - X(PS)
static const UInt8 PS_GAUSSIAN_BLUR_X_5[] =
{
	#include "Mix/Class/Scene/Standard/DX11/Shader/5/Misc/gaussianBlur_X.ps.inc"
};

//KEVAu[ - Y(VS)
static const UInt8 VS_GAUSSIAN_BLUR_Y_5[] =
{
	#include "Mix/Class/Scene/Standard/DX11/Shader/5/Misc/gaussianBlur_Y.vs.inc"
};

//KEVAu[ - Y(PS)
static const UInt8 PS_GAUSSIAN_BLUR_Y_5[] =
{
	#include "Mix/Class/Scene/Standard/DX11/Shader/5/Misc/gaussianBlur_Y.ps.inc"
};

//KEVAu[EX(PS)
static const UInt8 PS_GAUSSIAN_BLUR_EX_5[] =
{
	#include "Mix/Class/Scene/Standard/DX11/Shader/5/Misc/gaussianBlurEx.ps.inc"
};

//uCgpX - __(PS)
static const UInt8 PS_BRIGHTPASS____5[] =
{
	#include "Mix/Class/Scene/Standard/DX11/Shader/5/Misc/brightPass__.ps.inc"
};

//uCgpX - L__(PS)
static const UInt8 PS_BRIGHTPASS_L__5[] =
{
	#include "Mix/Class/Scene/Standard/DX11/Shader/5/Misc/brightPassL_.ps.inc"
};

//uCgpX - LA(PS)
static const UInt8 PS_BRIGHTPASS_LA_5[] =
{
	#include "Mix/Class/Scene/Standard/DX11/Shader/5/Misc/brightPassLA.ps.inc"
};

////////////////////////////////////////////////////////////////////////////////////////////////////
// Factory : VF[_[ : SkyDome
////////////////////////////////////////////////////////////////////////////////////////////////////

//ftHg(VS)
static const UInt8 VS_SKYDOME_DEFAULT_5[] =
{
	#include "Mix/Class/Scene/Standard/DX11/Shader/5/SkyDome/default.vs.inc"
};

//ftHg - BaseTex[~] CloudTex[~] CloudLayer[~] CloudLighting[~](PS)
static const UInt8 PS_SKYDOME_DEFAULT______5[] =
{
	#include "Mix/Class/Scene/Standard/DX11/Shader/5/SkyDome/default_____.ps.inc"
};

//ftHg - BaseTex[~] CloudTex[] CloudLayer[~] CloudLighting[~](PS)
static const UInt8 PS_SKYDOME_DEFAULT__C___5[] =
{
	#include "Mix/Class/Scene/Standard/DX11/Shader/5/SkyDome/default__c__.ps.inc"
};

//ftHg - BaseTex[~] CloudTex[] CloudLayer[] CloudLighting[~](PS)
static const UInt8 PS_SKYDOME_DEFAULT__C2__5[] =
{
	#include "Mix/Class/Scene/Standard/DX11/Shader/5/SkyDome/default__c2_.ps.inc"
};

//ftHg - BaseTex[] CloudTex[~] CloudLayer[~] CloudLighting[~](PS)
static const UInt8 PS_SKYDOME_DEFAULT_B____5[] =
{
	#include "Mix/Class/Scene/Standard/DX11/Shader/5/SkyDome/default_b___.ps.inc"
};

//ftHg - BaseTex[] CloudTex[] CloudLayer[~] CloudLighting[~](PS)
static const UInt8 PS_SKYDOME_DEFAULT_BC___5[] =
{
	#include "Mix/Class/Scene/Standard/DX11/Shader/5/SkyDome/default_bc__.ps.inc"
};

//ftHg - BaseTex[] CloudTex[] CloudLayer[] CloudLighting[~](PS)
static const UInt8 PS_SKYDOME_DEFAULT_BC2__5[] =
{
	#include "Mix/Class/Scene/Standard/DX11/Shader/5/SkyDome/default_bc2_.ps.inc"
};

//CUV~[V(VS)
static const UInt8 VS_SKYDOME_ATMOSPHERE_5[] =
{
	#include "Mix/Class/Scene/Standard/DX11/Shader/5/SkyDome/atmosphere.vs.inc"
};

//CUV~[V - BaseTex[~] CloudTex[~] CloudLayer[~] CloudLighting[~](PS)
static const UInt8 PS_SKYDOME_ATMOSPHERE______5[] =
{
	#include "Mix/Class/Scene/Standard/DX11/Shader/5/SkyDome/atmosphere_____.ps.inc"
};

//CUV~[V - BaseTex[~] CloudTex[] CloudLayer[~] CloudLighting[~](PS)
static const UInt8 PS_SKYDOME_ATMOSPHERE__C___5[] =
{
	#include "Mix/Class/Scene/Standard/DX11/Shader/5/SkyDome/atmosphere__c__.ps.inc"
};

//CUV~[V - BaseTex[~] CloudTex[] CloudLayer[~] CloudLighting[](PS)
static const UInt8 PS_SKYDOME_ATMOSPHERE__C_L_5[] =
{
	#include "Mix/Class/Scene/Standard/DX11/Shader/5/SkyDome/atmosphere__c_l.ps.inc"
};

//CUV~[V - BaseTex[~] CloudTex[] CloudLayer[] CloudLighting[~](PS)
static const UInt8 PS_SKYDOME_ATMOSPHERE__C2__5[] =
{
	#include "Mix/Class/Scene/Standard/DX11/Shader/5/SkyDome/atmosphere__c2_.ps.inc"
};

//CUV~[V - BaseTex[~] CloudTex[] CloudLayer[] CloudLighting[](PS)
static const UInt8 PS_SKYDOME_ATMOSPHERE__C2L_5[] =
{
	#include "Mix/Class/Scene/Standard/DX11/Shader/5/SkyDome/atmosphere__c2l.ps.inc"
};

//CUV~[V - BaseTex[] CloudTex[~] CloudLayer[~] CloudLighting[~](PS)
static const UInt8 PS_SKYDOME_ATMOSPHERE_B____5[] =
{
	#include "Mix/Class/Scene/Standard/DX11/Shader/5/SkyDome/atmosphere_b___.ps.inc"
};

//CUV~[V - BaseTex[] CloudTex[] CloudLayer[~] CloudLighting[~](PS)
static const UInt8 PS_SKYDOME_ATMOSPHERE_BC___5[] =
{
	#include "Mix/Class/Scene/Standard/DX11/Shader/5/SkyDome/atmosphere_bc__.ps.inc"
};

//CUV~[V - BaseTex[] CloudTex[] CloudLayer[~] CloudLighting[](PS)
static const UInt8 PS_SKYDOME_ATMOSPHERE_BC_L_5[] =
{
	#include "Mix/Class/Scene/Standard/DX11/Shader/5/SkyDome/atmosphere_bc_l.ps.inc"
};

//CUV~[V - BaseTex[] CloudTex[] CloudLayer[] CloudLighting[~](PS)
static const UInt8 PS_SKYDOME_ATMOSPHERE_BC2__5[] =
{
	#include "Mix/Class/Scene/Standard/DX11/Shader/5/SkyDome/atmosphere_bc2_.ps.inc"
};

//CUV~[V - BaseTex[] CloudTex[] CloudLayer[] CloudLighting[](PS)
static const UInt8 PS_SKYDOME_ATMOSPHERE_BC2L_5[] =
{
	#include "Mix/Class/Scene/Standard/DX11/Shader/5/SkyDome/atmosphere_bc2l.ps.inc"
};

//pm} (VS)
static const UInt8 VS_SKYDOME_PANORAMA_5[] =
{
	#include "Mix/Class/Scene/Standard/DX11/Shader/5/SkyDome/panorama.vs.inc"
};

//pm} - tHO[CUV~[V] (VS)
static const UInt8 VS_SKYDOME_PANORAMA_FA_5[] =
{
	#include "Mix/Class/Scene/Standard/DX11/Shader/5/SkyDome/panorama_fa.vs.inc"
};

//pm} (PS)
static const UInt8 PS_SKYDOME_PANORAMA_5[] =
{
	#include "Mix/Class/Scene/Standard/DX11/Shader/5/SkyDome/panorama.ps.inc"
};

//pm} - tHO[ftHg] (PS)
static const UInt8 PS_SKYDOME_PANORAMA_FD_5[] =
{
	#include "Mix/Class/Scene/Standard/DX11/Shader/5/SkyDome/panorama_fd.ps.inc"
};

//pm} - tHO[CUV~[V] (PS)
static const UInt8 PS_SKYDOME_PANORAMA_FA_5[] =
{
	#include "Mix/Class/Scene/Standard/DX11/Shader/5/SkyDome/panorama_fa.ps.inc"
};

////////////////////////////////////////////////////////////////////////////////////////////////////
// Factory : VF[_[ : PostEffect
////////////////////////////////////////////////////////////////////////////////////////////////////

//VhE}bsO - _E2X(PS)
static const UInt8 PS_SM_DOWN2X_5[] =
{
	#include "Mix/Class/Scene/Standard/DX11/Shader/5/PostEffect/smDown2x.ps.inc"
};

//VhE}bsO - _E4X(PS)
static const UInt8 PS_SM_DOWN4X_5[] =
{
	#include "Mix/Class/Scene/Standard/DX11/Shader/5/PostEffect/smDown4x.ps.inc"
};

//VhE}bsO - tBjbV(PS)
static const UInt8 PS_SM_FINISH_5[] =
{
	#include "Mix/Class/Scene/Standard/DX11/Shader/5/PostEffect/smFinish.ps.inc"
};

//SSAO(PS)
static const UInt8 PS_SSAO_5[] =
{
	#include "Mix/Class/Scene/Standard/DX11/Shader/5/PostEffect/ssao.ps.inc"
};

//SSAO - eNX`L(PS)
static const UInt8 PS_SSAO_TEX_5[] =
{
	#include "Mix/Class/Scene/Standard/DX11/Shader/5/PostEffect/ssao_tex.ps.inc"
};

//ʉ (PS)
static const UInt8 PS_UNDER_WATER_5[] =
{
	#include "Mix/Class/Scene/Standard/DX11/Shader/5/PostEffect/underWater.ps.inc"
};

//~iX - gXtH[ - INITAL (PS)
static const UInt8 PS_LUM_TRANSFORM_INITAL_5[] =
{
	#include "Mix/Class/Scene/Standard/DX11/Shader/5/PostEffect/lumTransform_Inital.ps.inc"
};

//~iX - gXtH[ - ITERATE (PS)
static const UInt8 PS_LUM_TRANSFORM_ITERATE_5[] =
{
	#include "Mix/Class/Scene/Standard/DX11/Shader/5/PostEffect/lumTransform_Iterate.ps.inc"
};

//~iX - gXtH[ - FINAL (PS)
static const UInt8 PS_LUM_TRANSFORM_FINAL_5[] =
{
	#include "Mix/Class/Scene/Standard/DX11/Shader/5/PostEffect/lumTransform_Final.ps.inc"
};

//~iX - A_vebh (PS)
static const UInt8 PS_LUM_ADAPTED_5[] =
{
	#include "Mix/Class/Scene/Standard/DX11/Shader/5/PostEffect/lumAdapted.ps.inc"
};

//~iX - Iy[^ - __B (PS)
static const UInt8 PS_LUM_OPERATOR___B_5[] =
{
	#include "Mix/Class/Scene/Standard/DX11/Shader/5/PostEffect/lumOperator__B.ps.inc"
};

//~iX - Iy[^ - T__ (PS)
static const UInt8 PS_LUM_OPERATOR_T___5[] =
{
	#include "Mix/Class/Scene/Standard/DX11/Shader/5/PostEffect/lumOperatorT__.ps.inc"
};

//~iX - Iy[^ - T_B (PS)
static const UInt8 PS_LUM_OPERATOR_T_B_5[] =
{
	#include "Mix/Class/Scene/Standard/DX11/Shader/5/PostEffect/lumOperatorT_B.ps.inc"
};

//~iX - Iy[^ - TA_ (PS)
static const UInt8 PS_LUM_OPERATOR_TA__5[] =
{
	#include "Mix/Class/Scene/Standard/DX11/Shader/5/PostEffect/lumOperatorTA_.ps.inc"
};

//~iX - Iy[^ - TAB (PS)
static const UInt8 PS_LUM_OPERATOR_TAB_5[] =
{
	#include "Mix/Class/Scene/Standard/DX11/Shader/5/PostEffect/lumOperatorTAB.ps.inc"
};

//CgVtg -  _(PS)
static const UInt8 PS_LS_INIT___5[] =
{
	#include "Mix/Class/Scene/Standard/DX11/Shader/5/PostEffect/lightShaftsInit_.ps.inc"
};

//CgVtg -  A(PS)
static const UInt8 PS_LS_INIT_A_5[] =
{
	#include "Mix/Class/Scene/Standard/DX11/Shader/5/PostEffect/lightShaftsInitA.ps.inc"
};

//CgVtg - u[ LOW(PS)
static const UInt8 PS_LS_BLUR_L_5[] =
{
	#include "Mix/Class/Scene/Standard/DX11/Shader/5/PostEffect/lightShaftsBlurM.ps.inc"
};

//CgVtg - u[ MIDDLE(PS)
static const UInt8 PS_LS_BLUR_M_5[] =
{
	#include "Mix/Class/Scene/Standard/DX11/Shader/5/PostEffect/lightShaftsBlurH.ps.inc"
};

//CgVtg - u[ HIGH(PS)
static const UInt8 PS_LS_BLUR_H_5[] =
{
	#include "Mix/Class/Scene/Standard/DX11/Shader/5/PostEffect/lightShaftsBlurL.ps.inc"
};

//YtA - C[W - __(PS)
static const UInt8 PS_LF_IMAGE____5[] =
{
	#include "Mix/Class/Scene/Standard/DX11/Shader/5/PostEffect/lensFlareImage__.ps.inc"
};

//YtA - C[W - _H(PS)
static const UInt8 PS_LF_IMAGE__H_5[] =
{
	#include "Mix/Class/Scene/Standard/DX11/Shader/5/PostEffect/lensFlareImage_H.ps.inc"
};

//YtA - C[W - G_(PS)
static const UInt8 PS_LF_IMAGE_G__5[] =
{
	#include "Mix/Class/Scene/Standard/DX11/Shader/5/PostEffect/lensFlareImageG_.ps.inc"
};

//YtA - C[W - GH(PS)
static const UInt8 PS_LF_IMAGE_GH_5[] =
{
	#include "Mix/Class/Scene/Standard/DX11/Shader/5/PostEffect/lensFlareImageGH.ps.inc"
};

//YtA - fBt@C - __(PS)
static const UInt8 PS_LF_MODIFY____5[] =
{
	#include "Mix/Class/Scene/Standard/DX11/Shader/5/PostEffect/lensFlareModify__.ps.inc"
};

//YtA - fBt@C - D_(PS)
static const UInt8 PS_LF_MODIFY_D__5[] =
{
	#include "Mix/Class/Scene/Standard/DX11/Shader/5/PostEffect/lensFlareModifyD_.ps.inc"
};

//YtA - fBt@C - _B(PS)
static const UInt8 PS_LF_MODIFY__B_5[] =
{
	#include "Mix/Class/Scene/Standard/DX11/Shader/5/PostEffect/lensFlareModify_B.ps.inc"
};

//YtA - fBt@C - DB(PS)
static const UInt8 PS_LF_MODIFY_DB_5[] =
{
	#include "Mix/Class/Scene/Standard/DX11/Shader/5/PostEffect/lensFlareModifyDB.ps.inc"
};

//tB~bN - Jim Hejl( PS )
static const UInt8 PS_FILMIC_HEJL_5[] =
{
	#include "Mix/Class/Scene/Standard/DX11/Shader/5/PostEffect/filmicHejl.ps.inc"
};

//tB~bN - John Hable( PS )
static const UInt8 PS_FILMIC_HABLE_5[] =
{
	#include "Mix/Class/Scene/Standard/DX11/Shader/5/PostEffect/filmicHable.ps.inc"
};

//K}␳(PS)
static const UInt8 PS_GAMMA_5[] =
{
	#include "Mix/Class/Scene/Standard/DX11/Shader/5/PostEffect/gamma.ps.inc"
};

//F - C[W _ (PS)
static const UInt8 PS_CA_IMAGE___5[] =
{
	#include "Mix/Class/Scene/Standard/DX11/Shader/5/PostEffect/caImage_.ps.inc"
};

//F - C[W D (PS)
static const UInt8 PS_CA_IMAGE_K_5[] =
{
	#include "Mix/Class/Scene/Standard/DX11/Shader/5/PostEffect/caImageK.ps.inc"
};

//F - tBjbV _ (PS)
static const UInt8 PS_CA_FINISH___5[] =
{
	#include "Mix/Class/Scene/Standard/DX11/Shader/5/PostEffect/caFinish_.ps.inc"
};

//F - tBjbV D (PS)
static const UInt8 PS_CA_FINISH_D_5[] =
{
	#include "Mix/Class/Scene/Standard/DX11/Shader/5/PostEffect/caFinishD.ps.inc"
};

//ʊE[x (PS)
static const UInt8 PS_DOF_5[] =
{
	#include "Mix/Class/Scene/Standard/DX11/Shader/5/PostEffect/depthOfField.ps.inc"
};

//YfBXg[V - __(PS)
static const UInt8 PS_LENS_DIST___5[] =
{
	#include "Mix/Class/Scene/Standard/DX11/Shader/5/PostEffect/lensDistortion_.ps.inc"
};

//YfBXg[V - K_(PS)
static const UInt8 PS_LENS_DIST_K_5[] =
{
	#include "Mix/Class/Scene/Standard/DX11/Shader/5/PostEffect/lensDistortionK.ps.inc"
};

//Blbg(PS)
static const UInt8 PS_VIGNETTE_5[] =
{
	#include "Mix/Class/Scene/Standard/DX11/Shader/5/PostEffect/vignette.ps.inc"
};

//FXAA (PS)
static const UInt8 PS_FXAA_5[] =
{
	#include "Mix/Class/Scene/Standard/DX11/Shader/5/PostEffect/fxaa.ps.inc"
};

////////////////////////////////////////////////////////////////////////////////////////////////////
// Factory
////////////////////////////////////////////////////////////////////////////////////////////////////

Factory* Factory::CreateInstance( void )
{
	return new Factory();
}

Factory::Factory()
{
}

Factory::~Factory( void )
{
}

void Factory::GetShaderBinary( Factory::SHADER_TYPES type, Factory::SHADER_BINARY& out )
{
	switch( type )
	{
	// Misc //

	case Factory::SHADER_SAMPLING_VS:
		::wcscpy_s( out.name, Factory::SHADER_BINARY::NAME_SIZE, L"Sampling(DX11_5)" );
		out.pData = &( VS_SAMPLING_5[0] );
		out.dataSize = sizeof( VS_SAMPLING_5 );
		break;
	case Factory::SHADER_SAMPLING_COPY_PS:
		::wcscpy_s( out.name, Factory::SHADER_BINARY::NAME_SIZE, L"SamplingCopy(DX11_5)" );
		out.pData = &( PS_SAMPLING_COPY_5[0] );
		out.dataSize = sizeof( PS_SAMPLING_COPY_5 );
		break;
	case Factory::SHADER_SAMPLING_DOWN2X_PS:
		::wcscpy_s( out.name, Factory::SHADER_BINARY::NAME_SIZE, L"SamplingDown2x(DX11_5)" );
		out.pData = &( PS_SAMPLING_DOWN2X_5[0] );
		out.dataSize = sizeof( PS_SAMPLING_DOWN2X_5 );
		break;
	case Factory::SHADER_SAMPLING_DOWN4X_PS:
		::wcscpy_s( out.name, Factory::SHADER_BINARY::NAME_SIZE, L"SamplingDown4x(DX11_5)" );
		out.pData = &( PS_SAMPLING_DOWN4X_5[0] );
		out.dataSize = sizeof( PS_SAMPLING_DOWN4X_5 );
		break;

	case Factory::SHADER_BLUR3X_X_PS:
		::wcscpy_s( out.name, Factory::SHADER_BINARY::NAME_SIZE, L"Blur3x_X(DX11_5)" );
		out.pData = &( PS_BLUR3X_X_5[0] );
		out.dataSize = sizeof( PS_BLUR3X_X_5 );
		break;
	case Factory::SHADER_BLUR3X_Y_PS:
		::wcscpy_s( out.name, Factory::SHADER_BINARY::NAME_SIZE, L"Blur3x_Y(DX11_5)" );
		out.pData = &( PS_BLUR3X_Y_5[0] );
		out.dataSize = sizeof( PS_BLUR3X_Y_5 );
		break;

	case Factory::SHADER_BLUR5X_X_PS:
		::wcscpy_s( out.name, Factory::SHADER_BINARY::NAME_SIZE, L"Blur5x_X(DX11_5)" );
		out.pData = &( PS_BLUR5X_X_5[0] );
		out.dataSize = sizeof( PS_BLUR5X_X_5 );
		break;
	case Factory::SHADER_BLUR5X_Y_PS:
		::wcscpy_s( out.name, Factory::SHADER_BINARY::NAME_SIZE, L"Blur5x_Y(DX11_5)" );
		out.pData = &( PS_BLUR5X_Y_5[0] );
		out.dataSize = sizeof( PS_BLUR5X_Y_5 );
		break;

	case Factory::SHADER_GAUSSIAN_BLUR_X_VS:
		::wcscpy_s( out.name, Factory::SHADER_BINARY::NAME_SIZE, L"GaussianBlur_X(DX11_5)" );
		out.pData = &( VS_GAUSSIAN_BLUR_X_5[0] );
		out.dataSize = sizeof( VS_GAUSSIAN_BLUR_X_5 );
		break;
	case Factory::SHADER_GAUSSIAN_BLUR_X_PS:
		::wcscpy_s( out.name, Factory::SHADER_BINARY::NAME_SIZE, L"GaussianBlur_X(DX11_5)" );
		out.pData = &( PS_GAUSSIAN_BLUR_X_5[0] );
		out.dataSize = sizeof( PS_GAUSSIAN_BLUR_X_5 );
		break;
	case Factory::SHADER_GAUSSIAN_BLUR_Y_VS:
		::wcscpy_s( out.name, Factory::SHADER_BINARY::NAME_SIZE, L"GaussianBlur_Y(DX11_5)" );
		out.pData = &( VS_GAUSSIAN_BLUR_Y_5[0] );
		out.dataSize = sizeof( VS_GAUSSIAN_BLUR_Y_5 );
		break;
	case Factory::SHADER_GAUSSIAN_BLUR_Y_PS:
		::wcscpy_s( out.name, Factory::SHADER_BINARY::NAME_SIZE, L"GaussianBlur_Y(DX11_5)" );
		out.pData = &( PS_GAUSSIAN_BLUR_Y_5[0] );
		out.dataSize = sizeof( PS_GAUSSIAN_BLUR_Y_5 );
		break;

	case Factory::SHADER_GAUSSIAN_BLUR_EX_PS:
		::wcscpy_s( out.name, Factory::SHADER_BINARY::NAME_SIZE, L"GaussianBlurEx(DX11_5)" );
		out.pData = &( PS_GAUSSIAN_BLUR_EX_5[0] );
		out.dataSize = sizeof( PS_GAUSSIAN_BLUR_EX_5 );
		break;

	case Factory::SHADER_BP____PS:
		::wcscpy_s( out.name, Factory::SHADER_BINARY::NAME_SIZE, L"BrightPass__(DX11_5)" );
		out.pData = &( PS_BRIGHTPASS____5[0] );
		out.dataSize = sizeof( PS_BRIGHTPASS____5 );
		break;
	case Factory::SHADER_BP_L__PS:
		::wcscpy_s( out.name, Factory::SHADER_BINARY::NAME_SIZE, L"BrightPassL_(DX11_5)" );
		out.pData = &( PS_BRIGHTPASS_L__5[0] );
		out.dataSize = sizeof( PS_BRIGHTPASS_L__5 );
		break;
	case Factory::SHADER_BP_LA_PS:
		::wcscpy_s( out.name, Factory::SHADER_BINARY::NAME_SIZE, L"BrightPassLA(DX11_5)" );
		out.pData = &( PS_BRIGHTPASS_LA_5[0] );
		out.dataSize = sizeof( PS_BRIGHTPASS_LA_5 );
		break;

	// SkyDome //

	case Factory::SHADER_SKYDOME_DEFAULT_VS:
		::wcscpy_s( out.name, Factory::SHADER_BINARY::NAME_SIZE, L"SkyDome - Default ---- (DX11_5)" );
		out.pData = &( VS_SKYDOME_DEFAULT_5[0] );
		out.dataSize = sizeof( VS_SKYDOME_DEFAULT_5 );
		break;
	case Factory::SHADER_SKYDOME_DEFAULT______PS:
		::wcscpy_s( out.name, Factory::SHADER_BINARY::NAME_SIZE, L"SkyDome - Default ---- (DX11_5)" );
		out.pData = &( PS_SKYDOME_DEFAULT______5[0] );
		out.dataSize = sizeof( PS_SKYDOME_DEFAULT______5 );
		break;
	case Factory::SHADER_SKYDOME_DEFAULT__C___PS:
		::wcscpy_s( out.name, Factory::SHADER_BINARY::NAME_SIZE, L"SkyDome - Default -C--- (DX11_5)" );
		out.pData = &( PS_SKYDOME_DEFAULT__C___5[0] );
		out.dataSize = sizeof( PS_SKYDOME_DEFAULT__C___5 );
		break;
	case Factory::SHADER_SKYDOME_DEFAULT__C2__PS:
		::wcscpy_s( out.name, Factory::SHADER_BINARY::NAME_SIZE, L"SkyDome - Default -C2- (DX11_5)" );
		out.pData = &( PS_SKYDOME_DEFAULT__C2__5[0] );
		out.dataSize = sizeof( PS_SKYDOME_DEFAULT__C2__5 );
		break;
	case Factory::SHADER_SKYDOME_DEFAULT_B____PS:
		::wcscpy_s( out.name, Factory::SHADER_BINARY::NAME_SIZE, L"SkyDome - Default B--- (DX11_5)" );
		out.pData = &( PS_SKYDOME_DEFAULT_B____5[0] );
		out.dataSize = sizeof( PS_SKYDOME_DEFAULT_B____5 );
		break;
	case Factory::SHADER_SKYDOME_DEFAULT_BC___PS:
		::wcscpy_s( out.name, Factory::SHADER_BINARY::NAME_SIZE, L"SkyDome - Default BC-- (DX11_5)" );
		out.pData = &( PS_SKYDOME_DEFAULT_BC___5[0] );
		out.dataSize = sizeof( PS_SKYDOME_DEFAULT_BC___5 );
		break;
	case Factory::SHADER_SKYDOME_DEFAULT_BC2__PS:
		::wcscpy_s( out.name, Factory::SHADER_BINARY::NAME_SIZE, L"SkyDome - Default BC2- (DX11_5)" );
		out.pData = &( PS_SKYDOME_DEFAULT_BC2__5[0] );
		out.dataSize = sizeof( PS_SKYDOME_DEFAULT_BC2__5 );
		break;

	case Factory::SHADER_SKYDOME_ATMOSPHERE_VS:
		::wcscpy_s( out.name, Factory::SHADER_BINARY::NAME_SIZE, L"SkyDome - Atmosphere ---- (DX11_5)" );
		out.pData = &( VS_SKYDOME_ATMOSPHERE_5[0] );
		out.dataSize = sizeof( VS_SKYDOME_ATMOSPHERE_5 );
		break;
	case Factory::SHADER_SKYDOME_ATMOSPHERE______PS:
		::wcscpy_s( out.name, Factory::SHADER_BINARY::NAME_SIZE, L"SkyDome - Atmosphere ---- (DX11_5)" );
		out.pData = &( PS_SKYDOME_ATMOSPHERE______5[0] );
		out.dataSize = sizeof( PS_SKYDOME_ATMOSPHERE______5 );
		break;
	case Factory::SHADER_SKYDOME_ATMOSPHERE__C___PS:
		::wcscpy_s( out.name, Factory::SHADER_BINARY::NAME_SIZE, L"SkyDome - Atmosphere -C--- (DX11_5)" );
		out.pData = &( PS_SKYDOME_ATMOSPHERE__C___5[0] );
		out.dataSize = sizeof( PS_SKYDOME_ATMOSPHERE__C___5 );
		break;
	case Factory::SHADER_SKYDOME_ATMOSPHERE__C_L_PS:
		::wcscpy_s( out.name, Factory::SHADER_BINARY::NAME_SIZE, L"SkyDome - Atmosphere -C--L (DX11_5)" );
		out.pData = &( PS_SKYDOME_ATMOSPHERE__C_L_5[0] );
		out.dataSize = sizeof( PS_SKYDOME_ATMOSPHERE__C_L_5 );
		break;
	case Factory::SHADER_SKYDOME_ATMOSPHERE__C2__PS:
		::wcscpy_s( out.name, Factory::SHADER_BINARY::NAME_SIZE, L"SkyDome - Atmosphere -C2- (DX11_5)" );
		out.pData = &( PS_SKYDOME_ATMOSPHERE__C2__5[0] );
		out.dataSize = sizeof( PS_SKYDOME_ATMOSPHERE__C2__5 );
		break;
	case Factory::SHADER_SKYDOME_ATMOSPHERE__C2L_PS:
		::wcscpy_s( out.name, Factory::SHADER_BINARY::NAME_SIZE, L"SkyDome - Atmosphere -C2L (DX11_5)" );
		out.pData = &( PS_SKYDOME_ATMOSPHERE__C2L_5[0] );
		out.dataSize = sizeof( PS_SKYDOME_ATMOSPHERE__C2L_5 );
		break;
	case Factory::SHADER_SKYDOME_ATMOSPHERE_B____PS:
		::wcscpy_s( out.name, Factory::SHADER_BINARY::NAME_SIZE, L"SkyDome - Atmosphere B--- (DX11_5)" );
		out.pData = &( PS_SKYDOME_ATMOSPHERE_B____5[0] );
		out.dataSize = sizeof( PS_SKYDOME_ATMOSPHERE_B____5 );
		break;
	case Factory::SHADER_SKYDOME_ATMOSPHERE_BC___PS:
		::wcscpy_s( out.name, Factory::SHADER_BINARY::NAME_SIZE, L"SkyDome - Atmosphere BC-- (DX11_5)" );
		out.pData = &( PS_SKYDOME_ATMOSPHERE_BC___5[0] );
		out.dataSize = sizeof( PS_SKYDOME_ATMOSPHERE_BC___5 );
		break;
	case Factory::SHADER_SKYDOME_ATMOSPHERE_BC_L_PS:
		::wcscpy_s( out.name, Factory::SHADER_BINARY::NAME_SIZE, L"SkyDome - Atmosphere BC-L (DX11_5)" );
		out.pData = &( PS_SKYDOME_ATMOSPHERE_BC_L_5[0] );
		out.dataSize = sizeof( PS_SKYDOME_ATMOSPHERE_BC_L_5 );
		break;
	case Factory::SHADER_SKYDOME_ATMOSPHERE_BC2__PS:
		::wcscpy_s( out.name, Factory::SHADER_BINARY::NAME_SIZE, L"SkyDome - Atmosphere BC2- (DX11_5)" );
		out.pData = &( PS_SKYDOME_ATMOSPHERE_BC2__5[0] );
		out.dataSize = sizeof( PS_SKYDOME_ATMOSPHERE_BC2__5 );
		break;
	case Factory::SHADER_SKYDOME_ATMOSPHERE_BC2L_PS:
		::wcscpy_s( out.name, Factory::SHADER_BINARY::NAME_SIZE, L"SkyDome - Atmosphere BC2L (DX11_5)" );
		out.pData = &( PS_SKYDOME_ATMOSPHERE_BC2L_5[0] );
		out.dataSize = sizeof( PS_SKYDOME_ATMOSPHERE_BC2L_5 );
		break;

	case Factory::SHADER_SKYDOME_PANORAMA_VS:
		::wcscpy_s( out.name, Factory::SHADER_BINARY::NAME_SIZE, L"SkyDome - Panorama -- (DX11_5)" );
		out.pData = &( VS_SKYDOME_PANORAMA_5[0] );
		out.dataSize = sizeof( VS_SKYDOME_PANORAMA_5 );
		break;
	case Factory::SHADER_SKYDOME_PANORAMA_FA_VS:
		::wcscpy_s( out.name, Factory::SHADER_BINARY::NAME_SIZE, L"SkyDome - Panorama FA (DX11_5)" );
		out.pData = &( VS_SKYDOME_PANORAMA_FA_5[0] );
		out.dataSize = sizeof( VS_SKYDOME_PANORAMA_FA_5 );
		break;
	case Factory::SHADER_SKYDOME_PANORAMA_PS:
		::wcscpy_s( out.name, Factory::SHADER_BINARY::NAME_SIZE, L"SkyDome - Panorama -- (DX11_5)" );
		out.pData = &( PS_SKYDOME_PANORAMA_5[0] );
		out.dataSize = sizeof( PS_SKYDOME_PANORAMA_5 );
		break;
	case Factory::SHADER_SKYDOME_PANORAMA_FD_PS:
		::wcscpy_s( out.name, Factory::SHADER_BINARY::NAME_SIZE, L"SkyDome - Panorama FD (DX11_5)" );
		out.pData = &( PS_SKYDOME_PANORAMA_FD_5[0] );
		out.dataSize = sizeof( PS_SKYDOME_PANORAMA_FD_5 );
		break;
	case Factory::SHADER_SKYDOME_PANORAMA_FA_PS:
		::wcscpy_s( out.name, Factory::SHADER_BINARY::NAME_SIZE, L"SkyDome - Panorama FA (DX11_5)" );
		out.pData = &( PS_SKYDOME_PANORAMA_FA_5[0] );
		out.dataSize = sizeof( PS_SKYDOME_PANORAMA_FA_5 );
		break;

	// PostEffect //

	case Factory::SHADER_SM_DOWN2X_PS:
		::wcscpy_s( out.name, Factory::SHADER_BINARY::NAME_SIZE, L"SM_Down2X(DX11_5)" );
		out.pData = &( PS_SM_DOWN2X_5[0] );
		out.dataSize = sizeof( PS_SM_DOWN2X_5 );
		break;
	case Factory::SHADER_SM_DOWN4X_PS:
		::wcscpy_s( out.name, Factory::SHADER_BINARY::NAME_SIZE, L"SM_Down4X(DX11_5)" );
		out.pData = &( PS_SM_DOWN4X_5[0] );
		out.dataSize = sizeof( PS_SM_DOWN4X_5 );
		break;
	case Factory::SHADER_SM_FINISH_PS:
		::wcscpy_s( out.name, Factory::SHADER_BINARY::NAME_SIZE, L"SM_Finish(DX11_5)" );
		out.pData = &( PS_SM_FINISH_5[0] );
		out.dataSize = sizeof( PS_SM_FINISH_5 );
		break;

	case Factory::SHADER_SSAO_PS:
		::wcscpy_s( out.name, Factory::SHADER_BINARY::NAME_SIZE, L"SSAO(DX11_5)" );
		out.pData = &( PS_SSAO_5[0] );
		out.dataSize = sizeof( PS_SSAO_5 );
		break;
	case Factory::SHADER_SSAO_TEX_PS:
		::wcscpy_s( out.name, Factory::SHADER_BINARY::NAME_SIZE, L"SSAO_Tex(DX11_5)" );
		out.pData = &( PS_SSAO_TEX_5[0] );
		out.dataSize = sizeof( PS_SSAO_TEX_5 );
		break;

	case Factory::SHADER_UNDER_WATER_PS:
		::wcscpy_s( out.name, Factory::SHADER_BINARY::NAME_SIZE, L"UnderWater(DX11_5)" );
		out.pData = &( PS_UNDER_WATER_5[0] );
		out.dataSize = sizeof( PS_UNDER_WATER_5 );
		break;

	case Factory::SHADER_LUM_TRANSFORM_INITAL_PS:
		::wcscpy_s( out.name, Factory::SHADER_BINARY::NAME_SIZE, L"LumTransform_Inital(DX11_5)" );
		out.pData = &( PS_LUM_TRANSFORM_INITAL_5[0] );
		out.dataSize = sizeof( PS_LUM_TRANSFORM_INITAL_5 );
		break;
	case Factory::SHADER_LUM_TRANSFORM_ITERATE_PS:
		::wcscpy_s( out.name, Factory::SHADER_BINARY::NAME_SIZE, L"LumTransform_Iterate(DX11_5)" );
		out.pData = &( PS_LUM_TRANSFORM_ITERATE_5[0] );
		out.dataSize = sizeof( PS_LUM_TRANSFORM_ITERATE_5 );
		break;
	case Factory::SHADER_LUM_TRANSFORM_FINAL_PS:
		::wcscpy_s( out.name, Factory::SHADER_BINARY::NAME_SIZE, L"LumTransform_Final(DX11_5)" );
		out.pData = &( PS_LUM_TRANSFORM_FINAL_5[0] );
		out.dataSize = sizeof( PS_LUM_TRANSFORM_FINAL_5 );
		break;
	case Factory::SHADER_LUM_ADAPTED_PS:
		::wcscpy_s( out.name, Factory::SHADER_BINARY::NAME_SIZE, L"LumAdapted(DX11_5)" );
		out.pData = &( PS_LUM_ADAPTED_5[0] );
		out.dataSize = sizeof( PS_LUM_ADAPTED_5 );
		break;
	case Factory::SHADER_LUM_OPERATOR___B_PS:
		::wcscpy_s( out.name, Factory::SHADER_BINARY::NAME_SIZE, L"LumOperator__B(DX11_5)" );
		out.pData = &( PS_LUM_OPERATOR___B_5[0] );
		out.dataSize = sizeof( PS_LUM_OPERATOR___B_5 );
		break;
	case Factory::SHADER_LUM_OPERATOR_T___PS:
		::wcscpy_s( out.name, Factory::SHADER_BINARY::NAME_SIZE, L"LumOperatorT__(DX11_5)" );
		out.pData = &( PS_LUM_OPERATOR_T___5[0] );
		out.dataSize = sizeof( PS_LUM_OPERATOR_T___5 );
		break;
	case Factory::SHADER_LUM_OPERATOR_T_B_PS:
		::wcscpy_s( out.name, Factory::SHADER_BINARY::NAME_SIZE, L"LumOperatorT_B(DX11_5)" );
		out.pData = &( PS_LUM_OPERATOR_T_B_5[0] );
		out.dataSize = sizeof( PS_LUM_OPERATOR_T_B_5 );
		break;
	case Factory::SHADER_LUM_OPERATOR_TA__PS:
		::wcscpy_s( out.name, Factory::SHADER_BINARY::NAME_SIZE, L"LumOperatorTA_(DX11_5)" );
		out.pData = &( PS_LUM_OPERATOR_TA__5[0] );
		out.dataSize = sizeof( PS_LUM_OPERATOR_TA__5 );
		break;
	case Factory::SHADER_LUM_OPERATOR_TAB_PS:
		::wcscpy_s( out.name, Factory::SHADER_BINARY::NAME_SIZE, L"LumOperatorTAB(DX11_5)" );
		out.pData = &( PS_LUM_OPERATOR_TAB_5[0] );
		out.dataSize = sizeof( PS_LUM_OPERATOR_TAB_5 );
		break;

	case Factory::SHADER_LS_INIT___PS:
		::wcscpy_s( out.name, Factory::SHADER_BINARY::NAME_SIZE, L"LightShaftsInit_(DX11_5)" );
		out.pData = &( PS_LS_INIT___5[0] );
		out.dataSize = sizeof( PS_LS_INIT___5 );
		break;
	case Factory::SHADER_LS_INIT_A_PS:
		::wcscpy_s( out.name, Factory::SHADER_BINARY::NAME_SIZE, L"LightShaftsInitA(DX11_5)" );
		out.pData = &( PS_LS_INIT_A_5[0] );
		out.dataSize = sizeof( PS_LS_INIT_A_5 );
		break;
	case Factory::SHADER_LS_BLUR_L_PS:
		::wcscpy_s( out.name, Factory::SHADER_BINARY::NAME_SIZE, L"LightShaftsBlur_Low(DX11_5)" );
		out.pData = &( PS_LS_BLUR_L_5[0] );
		out.dataSize = sizeof( PS_LS_BLUR_L_5 );
		break;
	case Factory::SHADER_LS_BLUR_M_PS:
		::wcscpy_s( out.name, Factory::SHADER_BINARY::NAME_SIZE, L"LightShaftsBlur_Middle(DX11_5)" );
		out.pData = &( PS_LS_BLUR_M_5[0] );
		out.dataSize = sizeof( PS_LS_BLUR_M_5 );
		break;
	case Factory::SHADER_LS_BLUR_H_PS:
		::wcscpy_s( out.name, Factory::SHADER_BINARY::NAME_SIZE, L"LightShaftsBlur_High(DX11_5)" );
		out.pData = &( PS_LS_BLUR_H_5[0] );
		out.dataSize = sizeof( PS_LS_BLUR_H_5 );
		break;

	case Factory::SHADER_LF_IMAGE____PS:
		::wcscpy_s( out.name, Factory::SHADER_BINARY::NAME_SIZE, L"LensFlare_Image___(DX11_5)" );
		out.pData = &( PS_LF_IMAGE____5[0] );
		out.dataSize = sizeof( PS_LF_IMAGE____5 );
		break;
	case Factory::SHADER_LF_IMAGE__H_PS:
		::wcscpy_s( out.name, Factory::SHADER_BINARY::NAME_SIZE, L"LensFlare_Image_H(DX11_5)" );
		out.pData = &( PS_LF_IMAGE__H_5[0] );
		out.dataSize = sizeof( PS_LF_IMAGE__H_5 );
		break;
	case Factory::SHADER_LF_IMAGE_G__PS:
		::wcscpy_s( out.name, Factory::SHADER_BINARY::NAME_SIZE, L"LensFlare_Image_G_(DX11_5)" );
		out.pData = &( PS_LF_IMAGE_G__5[0] );
		out.dataSize = sizeof( PS_LF_IMAGE_G__5 );
		break;
	case Factory::SHADER_LF_IMAGE_GH_PS:
		::wcscpy_s( out.name, Factory::SHADER_BINARY::NAME_SIZE, L"LensFlare_ImageGH(DX11_5)" );
		out.pData = &( PS_LF_IMAGE_GH_5[0] );
		out.dataSize = sizeof( PS_LF_IMAGE_GH_5 );
		break;
	case Factory::SHADER_LF_MODIFY____PS:
		::wcscpy_s( out.name, Factory::SHADER_BINARY::NAME_SIZE, L"LensFlare_Modify__(DX11_5)" );
		out.pData = &( PS_LF_MODIFY____5[0] );
		out.dataSize = sizeof( PS_LF_MODIFY____5 );
		break;
	case Factory::SHADER_LF_MODIFY_D__PS:
		::wcscpy_s( out.name, Factory::SHADER_BINARY::NAME_SIZE, L"LensFlare_ModifyD_(DX11_5)" );
		out.pData = &( PS_LF_MODIFY_D__5[0] );
		out.dataSize = sizeof( PS_LF_MODIFY_D__5 );
		break;
	case Factory::SHADER_LF_MODIFY__B_PS:
		::wcscpy_s( out.name, Factory::SHADER_BINARY::NAME_SIZE, L"LensFlare_Modify_B(DX11_5)" );
		out.pData = &( PS_LF_MODIFY__B_5[0] );
		out.dataSize = sizeof( PS_LF_MODIFY__B_5 );
		break;
	case Factory::SHADER_LF_MODIFY_DB_PS:
		::wcscpy_s( out.name, Factory::SHADER_BINARY::NAME_SIZE, L"LensFlare_ModifyDB(DX11_5)" );
		out.pData = &( PS_LF_MODIFY_DB_5[0] );
		out.dataSize = sizeof( PS_LF_MODIFY_DB_5 );
		break;

	case Factory::SHADER_FI_HEJL_PS:
		::wcscpy_s( out.name, Factory::SHADER_BINARY::NAME_SIZE, L"FilmicHejl(DX11_5)" );
		out.pData = &( PS_FILMIC_HEJL_5[0] );
		out.dataSize = sizeof( PS_FILMIC_HEJL_5 );
		break;
	case Factory::SHADER_FI_HABLE_PS:
		::wcscpy_s( out.name, Factory::SHADER_BINARY::NAME_SIZE, L"FilmicHable(DX11_5)" );
		out.pData = &( PS_FILMIC_HABLE_5[0] );
		out.dataSize = sizeof( PS_FILMIC_HABLE_5 );
		break;

	case Factory::SHADER_GAMMA_PS:
		::wcscpy_s( out.name, Factory::SHADER_BINARY::NAME_SIZE, L"Gamma(DX11_5)" );
		out.pData = &( PS_GAMMA_5[0] );
		out.dataSize = sizeof( PS_GAMMA_5 );
		break;

	case Factory::SHADER_CA_IMAGE___PS:
		::wcscpy_s( out.name, Factory::SHADER_BINARY::NAME_SIZE, L"Chromatism_Image_(DX11_5)" );
		out.pData = &( PS_CA_IMAGE___5[0] );
		out.dataSize = sizeof( PS_CA_IMAGE___5 );
		break;
	case Factory::SHADER_CA_IMAGE_K_PS:
		::wcscpy_s( out.name, Factory::SHADER_BINARY::NAME_SIZE, L"Chromatism_ImageK(DX11_5)" );
		out.pData = &( PS_CA_IMAGE_K_5[0] );
		out.dataSize = sizeof( PS_CA_IMAGE_K_5 );
		break;
	case Factory::SHADER_CA_FINISH___PS:
		::wcscpy_s( out.name, Factory::SHADER_BINARY::NAME_SIZE, L"Chromatism_Finish_(DX11_5)" );
		out.pData = &( PS_CA_FINISH___5[0] );
		out.dataSize = sizeof( PS_CA_FINISH___5 );
		break;
	case Factory::SHADER_CA_FINISH_D_PS:
		::wcscpy_s( out.name, Factory::SHADER_BINARY::NAME_SIZE, L"Chromatism_FinishD(DX11_5)" );
		out.pData = &( PS_CA_FINISH_D_5[0] );
		out.dataSize = sizeof( PS_CA_FINISH_D_5 );
		break;

	case Factory::SHADER_DOF_PS:
		::wcscpy_s( out.name, Factory::SHADER_BINARY::NAME_SIZE, L"DepthOfField(DX11_5)" );
		out.pData = &( PS_DOF_5[0] );
		out.dataSize = sizeof( PS_DOF_5 );
		break;

	case Factory::SHADER_LENS_DIST___PS:
		::wcscpy_s( out.name, Factory::SHADER_BINARY::NAME_SIZE, L"LensDistortion_(DX11_5)" );
		out.pData = &( PS_LENS_DIST___5[0] );
		out.dataSize = sizeof( PS_LENS_DIST___5 );
		break;
	case Factory::SHADER_LENS_DIST_K_PS:
		::wcscpy_s( out.name, Factory::SHADER_BINARY::NAME_SIZE, L"LensDistortionK(DX11_5)" );
		out.pData = &( PS_LENS_DIST_K_5[0] );
		out.dataSize = sizeof( PS_LENS_DIST_K_5 );
		break;

	case Factory::SHADER_VIGNETTE_PS:
		::wcscpy_s( out.name, Factory::SHADER_BINARY::NAME_SIZE, L"Vignette(DX11_5)" );
		out.pData = &( PS_VIGNETTE_5[0] );
		out.dataSize = sizeof( PS_VIGNETTE_5 );
		break;

	case Factory::SHADER_AA_FXAA_PS:
		::wcscpy_s( out.name, Factory::SHADER_BINARY::NAME_SIZE, L"FXAA(DX11_5)" );
		out.pData = &( PS_FXAA_5[0] );
		out.dataSize = sizeof( PS_FXAA_5 );
		break;

	default:
		MIX_ERROR_W( L"w肳ꂽ풓VF[_[݂͑܂(SM5)" );
	}
}

Mix::Scene::IRenderer* Factory::CreateRenderer( const Mix::Scene::RENDERER_CONFIG& config, const wchar_t* pName )
{
	Mix::Scene::Standard::DX11::Renderer* pRenderer = NULL;

	pRenderer = Mix::Scene::Standard::DX11::Renderer::CreateInstance( this, MIX_SAFE_NAME( pName ) );
	if( pRenderer != NULL )
	{
		if( pRenderer->Initialize( config, NULL ) == False )
		{
			MIX_RELEASE( pRenderer );
		}
	}
	else
	{
		MIX_LOG_ERROR( Mix::STR_OUTOFMEMORY );
	}

	return pRenderer;
}

Mix::Scene::IMaterial* Factory::CreateDefaultMaterial(	const wchar_t* pNameLabel,
														const wchar_t* pName,
														Boolean bWithMagicNumber,
														Mix::File::IReader* pReader,
														Mix::Scene::Common::Factory* pFactory,
														Mix::Graphics::IDevice* pDevice )
{
	return Mix::Scene::Standard::DX11::DefaultMaterial::CreateInstance( pNameLabel, pName, bWithMagicNumber, pReader, pFactory, pDevice );
}

}}}}
